/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.information.metadata.OMRServerContext;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.text.Message;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import java.io.BufferedInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ContentHelper {
    protected static final String XML_FILE_PREFIX = "<?xml version=\"";
    protected static final String SBIP_URL_PREFIX = "\"SBIP://";
    protected static final String SBIP_URL_SUFFIX = "\"";
    protected static final String SBIP_URL_REGEX = "SBIP://|sbip://";
    public static final String UTF8 = "UTF-8";
    private static final int BUFFER_SIZE = 4096;
    protected byte[] _dataBuffer = new byte[4096];
    protected List _tempFiles = new ArrayList();
    protected Log _log = Log.getInstance(ContentHelper.class.getName());

    public static WsAppServer openAppServerConnection(PromotionInterface operation, ServerContext server) throws WsAppServerFailException {
        OMRServerContext serverContext;
        String name = null;
        try {
            name = server.getName();
            serverContext = (OMRServerContext)PromotionUtil.getSmartObject(operation, (CMetadata)server);
        }
        catch (Exception e) {
            throw new WsAppServerFailException(Message.format((ResourceBundle)RB.getResources(), (String)"ContentHelper.ServerNotFound.fmt.txt", (Object)name));
        }
        return ContentHelper.openAppServerConnection(operation, serverContext);
    }

    public static WsAppServer openAppServerConnection(PromotionInterface operation, OMRServerContext server) throws WsAppServerFailException {
        if (operation.isBatchProcess()) {
            try {
                WsAppServer.setUserContext((UserContextInterface)operation.getUserContext());
            }
            catch (Exception e) {
                throw new WsAppServerFailException(e.getMessage());
            }
        }
        WsAppServer appServer = WsAppServer.createAppServer((ServerContextInterface)server);
        boolean promptForCredentials = !operation.isBatchProcess();
        appServer.open(promptForCredentials);
        return appServer;
    }

    public static WsAppServer openAppServerConnectionWithoutPrompting(PromotionInterface operation, ServerContext server) throws WsAppServerFailException {
        OMRServerContext serverContext;
        String name = null;
        try {
            name = server.getName();
            serverContext = (OMRServerContext)PromotionUtil.getSmartObject(operation, (CMetadata)server);
        }
        catch (Exception e) {
            throw new WsAppServerFailException(Message.format((ResourceBundle)RB.getResources(), (String)"ContentHelper.ServerNotFound.fmt.txt", (Object)name));
        }
        if (operation.isBatchProcess()) {
            try {
                WsAppServer.setUserContext((UserContextInterface)operation.getUserContext());
            }
            catch (Exception e) {
                throw new WsAppServerFailException(e.getMessage());
            }
        }
        WsAppServer appServer = WsAppServer.createAppServer((ServerContextInterface)serverContext);
        appServer.open(false);
        return appServer;
    }

    public static String getDestinationPath() throws IOException {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir == null) {
            File f = File.createTempFile("tmp", ".tmp");
            tmpDir = f.getParent();
            f.delete();
        }
        return tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveContentFromPackage(OutputStream oStream, File tempFile) throws FileNotFoundException, IOException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Retrieving content from " + tempFile.getName());
        }
        this._tempFiles.add(tempFile);
        BufferedInputStream iStream = new BufferedInputStream(new FileInputStream(tempFile));
        try {
            int bytesRead = iStream.read(this._dataBuffer);
            while (bytesRead > 0) {
                oStream.write(this._dataBuffer, 0, bytesRead);
                bytesRead = iStream.read(this._dataBuffer);
            }
        }
        finally {
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (IOException bytesRead) {}
            }
            if (oStream != null) {
                try {
                    oStream.close();
                }
                catch (IOException e) {
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)"Failed on repository write/close", e);
                    }
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToOutputStream(InputStream inStream, OutputStream outStream) throws IOException {
        BufferedInputStream iStream = new BufferedInputStream(inStream);
        try {
            int bytesRead = iStream.read(this._dataBuffer);
            while (bytesRead > 0) {
                outStream.write(this._dataBuffer, 0, bytesRead);
                bytesRead = iStream.read(this._dataBuffer);
            }
        }
        finally {
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (IOException bytesRead) {}
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)"Failed on repository write/close", e);
                    }
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List retrieveListOfUrls(InputStream is) throws IOException {
        try {
            XMLReader r = XMLReaderFactory.createXMLReader();
            FindReportUrlsContentHandler cHandler = new FindReportUrlsContentHandler();
            r.setContentHandler(cHandler);
            r.setErrorHandler(new QuietErrorHandler());
            r.parse(new InputSource(is));
            List list = cHandler.getListOfReportUrls();
            return list;
        }
        catch (Exception e) {
            this._log.debug("XML exception reading document - " + e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List retrieveListOfSBIPUrls(InputStream is) throws IOException {
        ArrayList<String> urlList = new ArrayList<String>();
        BufferedInputStream stream = new BufferedInputStream(is);
        try {
            boolean findSBIP = false;
            int prefixLength = XML_FILE_PREFIX.length();
            int bytesRead = stream.read(this._dataBuffer, 0, prefixLength);
            String startOfFile = null;
            if (bytesRead == prefixLength) {
                startOfFile = new String(this._dataBuffer, 0, bytesRead, UTF8);
                findSBIP = XML_FILE_PREFIX.equals(startOfFile);
            }
            if (findSBIP) {
                StringBuffer buf = new StringBuffer();
                buf.append(startOfFile);
                InputStreamReader isr = new InputStreamReader((InputStream)stream, UTF8);
                char[] charBuf = new char[4096];
                int charsRead = isr.read(charBuf);
                while (charsRead > 0) {
                    buf.append(charBuf, 0, charsRead);
                    charsRead = isr.read(charBuf);
                }
                Pattern p = Pattern.compile(SBIP_URL_REGEX);
                Matcher m = p.matcher(buf);
                String endString = SBIP_URL_SUFFIX;
                while (m.find()) {
                    int end;
                    int start = m.start();
                    if (buf.charAt(start - 1) == '>') {
                        endString = "<";
                    } else if (buf.charAt(start - 1) == '\"') {
                        endString = SBIP_URL_SUFFIX;
                    }
                    if ((end = buf.indexOf(endString, start)) <= start) continue;
                    String url = buf.substring(start, end);
                    urlList.add(url);
                }
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return urlList;
    }

    public void deleteTemporaryFiles() {
        for (File f : this._tempFiles) {
            try {
                f.delete();
            }
            catch (Exception e) {
                if (!this._log.isDebugEnabled()) continue;
                this._log.debug((Object)"Attempt to delete temporary file failed", e);
            }
        }
        this._tempFiles.clear();
    }

    class QuietErrorHandler
    implements ErrorHandler {
        QuietErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }
    }

    class FindReportUrlsContentHandler
    implements ContentHandler {
        private List urlList = new ArrayList();
        private boolean isUrlValue = false;
        CharArrayWriter text = new CharArrayWriter();

        FindReportUrlsContentHandler() {
        }

        public List getListOfReportUrls() throws IOException {
            return this.urlList;
        }

        private void completeTextNode() throws SAXException {
            this.text.reset();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.text.write(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) {
            this.text.write(ch, start, length);
        }

        @Override
        public void endDocument() throws SAXException {
            this.completeTextNode();
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.isUrlValue) {
                this.urlList.add(this.text.toString());
                ContentHelper.this._log.debug("<URLValue>" + this.text.toString());
                this.isUrlValue = false;
            }
            this.completeTextNode();
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.completeTextNode();
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.completeTextNode();
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.completeTextNode();
        }

        @Override
        public void startDocument() throws SAXException {
            this.completeTextNode();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String attr;
            this.completeTextNode();
            this.isUrlValue = false;
            if ("URLValue".equals(localName)) {
                this.isUrlValue = true;
            }
            if ("InformationMap".equals(localName)) {
                attr = atts.getValue("absolutePathLocation");
                if (attr != null) {
                    this.urlList.add(attr);
                    ContentHelper.this._log.debug("<InformationMap absolutePathLocation=" + attr.toString());
                }
                if ((attr = atts.getValue("location")) != null) {
                    this.urlList.add(attr);
                    ContentHelper.this._log.debug("<InformationMap location=" + attr.toString());
                }
            }
            if ("Image".equals(localName) && (attr = atts.getValue("file")) != null) {
                this.urlList.add(attr);
                ContentHelper.this._log.debug("<Image file=" + attr.toString());
            }
            if ("Graph".equals(localName) && (attr = atts.getValue("altImage")) != null) {
                this.urlList.add(attr);
                ContentHelper.this._log.debug("<Graph altImage=" + attr.toString());
            }
            if ("SASProcessSection".equals(localName) && (attr = atts.getValue("file")) != null) {
                this.urlList.add(attr);
                ContentHelper.this._log.debug("<SASProcessSection file=" + attr.toString());
            }
            if ("SASProcessContainer".equals(localName) && (attr = atts.getValue("file")) != null) {
                this.urlList.add(attr);
                ContentHelper.this._log.debug("<SASProcessContainer file=" + attr.toString());
            }
            if ("BusinessModelReferenceInformation".equals(localName) && (attr = atts.getValue("location")) != null) {
                this.urlList.add(attr);
                ContentHelper.this._log.debug("<BusinessModelReferenceInformation location=" + attr.toString());
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.completeTextNode();
        }
    }
}

