/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.promotion.AbstractConnectionType;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPoint;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.ConnectionValidationException;
import com.sas.metadata.promotion.ConnectionValidatorInterface;
import com.sas.metadata.promotion.DependentConnectionMapping;
import com.sas.metadata.promotion.DependentConnectionTypeInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ImportHandler;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportListener;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.ImportUtil;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.ObjectMoveManager;
import com.sas.metadata.promotion.ObjectsSelectedListener;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.promotion.SearchCriteria;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.ValidationResponse;
import com.sas.metadata.promotion.XMLUtil;
import com.sas.metadata.promotion.connections.SecurityConnectionType;
import com.sas.metadata.promotion.model.ImportFolderUtil;
import com.sas.metadata.promotion.persistence.ImportMetadataManagementInterface;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.deployment.CorePlatformServices;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

@SASScope
public class ConnectionManager
implements ConnectionManagerInterface,
ObjectsSelectedListener {
    private static Map<PromotionInterface, ConnectionManagerInterface> _instanceCache = new HashMap<PromotionInterface, ConnectionManagerInterface>(3);
    private static final String UNKNOWN_ID = "_UNKNOWN_";
    private int _unknownCounter = 0;
    private int _promotionType;
    private PromotionInterface _operation;
    private Map<String, ConnectionPointInterface> _connectionPointMap;
    private Map<ConnectionPointInterface, SourceConnectionInterface> _sourceConnectionCache;
    private Map<String, ConnectionValidatorInterface[]> _validatorsMap;
    private int _mappingReturnCode = 0;

    public ConnectionManager(int promotionType) {
        this._promotionType = promotionType;
        this._connectionPointMap = new LinkedHashMap<String, ConnectionPointInterface>();
    }

    private ConnectionManager(PromotionInterface operation) {
        this._operation = operation;
        this._promotionType = operation.getPromotionType();
        this._connectionPointMap = new LinkedHashMap<String, ConnectionPointInterface>();
    }

    public static ConnectionManagerInterface getInstance(PromotionInterface operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Invalid operation");
        }
        if (_instanceCache.containsKey(operation)) {
            return _instanceCache.get(operation);
        }
        ConnectionManager instance = new ConnectionManager(operation);
        _instanceCache.put(operation, instance);
        return instance;
    }

    public static ConnectionManagerInterface getNewInstance(PromotionInterface operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Invalid operation");
        }
        ConnectionManager instance = new ConnectionManager(operation);
        _instanceCache.put(operation, instance);
        return instance;
    }

    public void dispose() {
        _instanceCache.remove(this._operation);
        if (this._connectionPointMap != null) {
            this._connectionPointMap.clear();
            this._connectionPointMap = null;
        }
        if (this._sourceConnectionCache != null) {
            this._sourceConnectionCache.clear();
            this._sourceConnectionCache = null;
        }
    }

    @Override
    public boolean containsConnection(String sourceID) {
        return this._connectionPointMap.containsKey(sourceID);
    }

    @Override
    public ConnectionPointInterface createConnection(String metadataType, String id, String name) {
        if (this._connectionPointMap.containsKey(id)) {
            return this._connectionPointMap.get(id);
        }
        ConnectionPoint pt = new ConnectionPoint(name, metadataType, id);
        this._connectionPointMap.put(id, pt);
        return pt;
    }

    @Override
    public ConnectionPointInterface createUnknownConnection(String metadataType, String name) {
        String id = this.generateUniqueID();
        ConnectionPoint pt = (ConnectionPoint)this.createConnection(metadataType, id, name);
        pt.setUnknownConnection(true);
        return pt;
    }

    @Override
    public ConnectionPointInterface getConnection(String sourceID) {
        return this._connectionPointMap.get(sourceID);
    }

    @Override
    public List<ConnectionPointInterface> getConnections() {
        return this.getConnections(false);
    }

    @Override
    public List<ConnectionPointInterface> getConnections(boolean includeInactiveConnections) {
        if (includeInactiveConnections) {
            return new ArrayList<ConnectionPointInterface>(this._connectionPointMap.values());
        }
        ArrayList<ConnectionPointInterface> connections = new ArrayList<ConnectionPointInterface>();
        for (ConnectionPointInterface pt : this._connectionPointMap.values()) {
            if (!pt.isActive() || pt.isAutoMapped() || !this.isConnectionAssociatedToLiveObject(pt)) continue;
            connections.add(pt);
        }
        return connections;
    }

    @Override
    public List<ConnectionPointInterface> getConnections(ConnectionObjectType type, String typeValue) {
        return this.getConnections(type, typeValue, false);
    }

    @Override
    public List<ConnectionPointInterface> getConnections(ConnectionObjectType type, String typeValue, boolean includeInactiveConnections) {
        ArrayList<ConnectionPointInterface> connections;
        block7: {
            block6: {
                if (typeValue == null) {
                    return new ArrayList<ConnectionPointInterface>();
                }
                connections = new ArrayList<ConnectionPointInterface>();
                if (!type.isPublicType()) break block6;
                boolean isSearchingForSubType = typeValue.indexOf(46) > -1;
                for (ConnectionPointInterface pt : this._connectionPointMap.values()) {
                    String publicType = pt.getPublicType();
                    if (publicType == null) continue;
                    int index = publicType.indexOf(46);
                    if (!isSearchingForSubType && index > 0) {
                        publicType = publicType.substring(0, index);
                    }
                    if (!typeValue.equalsIgnoreCase(publicType)) continue;
                    if (includeInactiveConnections) {
                        connections.add(pt);
                        continue;
                    }
                    if (!pt.isActive() || pt.isAutoMapped() || !this.isConnectionAssociatedToLiveObject(pt)) continue;
                    connections.add(pt);
                }
                break block7;
            }
            if (!type.isMetadataType()) break block7;
            for (ConnectionPointInterface pt : this._connectionPointMap.values()) {
                if (!typeValue.equalsIgnoreCase(pt.getMetadataType())) continue;
                if (includeInactiveConnections) {
                    connections.add(pt);
                    continue;
                }
                if (!pt.isActive() || pt.isAutoMapped() || !this.isConnectionAssociatedToLiveObject(pt)) continue;
                connections.add(pt);
            }
        }
        return connections;
    }

    @Override
    public ConnectionPointInterface getConnectionByPath(ConnectionObjectType type, String typeValue, String path) {
        List<ConnectionPointInterface> connectionsByType = this.getConnections(type, typeValue, true);
        if (connectionsByType.size() == 0 || path == null) {
            return null;
        }
        for (ConnectionPointInterface pt : connectionsByType) {
            if (!path.equals(pt.getSourcePath())) continue;
            return pt;
        }
        return null;
    }

    @Override
    public ConnectionPointInterface getConnectionBySearchString(ConnectionObjectType type, String typeValue, String searchString) {
        List<ConnectionPointInterface> connectionsByType = this.getConnections(type, typeValue, true);
        if (connectionsByType.size() == 0 || searchString == null) {
            return null;
        }
        for (ConnectionPointInterface pt : connectionsByType) {
            List<String> searchList = pt.getSourceSearchList();
            if (!searchList.contains(searchString)) continue;
            return pt;
        }
        return null;
    }

    @Override
    public ConnectionPointInterface getMatchingConnectionPoint(PromotionItemInterface promotionItem) {
        String sourceID;
        String string = sourceID = promotionItem == null ? null : promotionItem.getID();
        if (sourceID != null) {
            return this.getConnection(sourceID);
        }
        return null;
    }

    @Override
    public void removeConnection(ConnectionPointInterface conn) {
        if (conn != null) {
            this._connectionPointMap.remove(conn.getSourceID());
            if (conn instanceof ConnectionPoint) {
                List<PromotionItemInterface> objects = conn.getAssociatedObjects();
                for (PromotionItemInterface item : objects) {
                    ((ConnectionPoint)conn).removeAssociatedObject(item);
                }
            }
        }
    }

    @Override
    public List<ConnectionPointInterface> getDirectConnections() {
        ArrayList<ConnectionPointInterface> directConnections = new ArrayList<ConnectionPointInterface>();
        for (ConnectionPointInterface pt : this._connectionPointMap.values()) {
            if (!pt.isDirectConnection()) continue;
            directConnections.add(pt);
        }
        return directConnections;
    }

    @Override
    public List<ConnectionPointInterface> getUnknownConnections() {
        ArrayList<ConnectionPointInterface> unknownConnections = new ArrayList<ConnectionPointInterface>();
        for (ConnectionPointInterface pt : this._connectionPointMap.values()) {
            if (!pt.isUnknown()) continue;
            unknownConnections.add(pt);
        }
        return unknownConnections;
    }

    protected void resetReturnCode() {
        this._mappingReturnCode = 0;
    }

    protected int resolveConnections(ImportOperationInterface operation, int autoMapState) throws MetadataPromotionException, ServiceException, RemoteException {
        SecurityConnectionType securityType;
        PublicObjectContainerInterface targetContainer;
        operation.getLogger().info(RB.getStringResource("ConnectionManager.Resolving.txt"));
        PublicObjectContainerInterface targetFolder = null;
        if (!operation.importIntoRoot()) {
            targetContainer = operation.getTargetContainer();
            if (PromotionUtil.isFolder((PublicObjectInterface)targetContainer)) {
                targetFolder = targetContainer;
            }
        } else {
            targetContainer = operation.getTargetContainer();
            if (PromotionUtil.isRootFolder((PublicObjectInterface)targetContainer)) {
                targetFolder = targetContainer;
            }
        }
        if (autoMapState == 1 || autoMapState == 2) {
            this.initializeSourceConnections(operation);
            operation.getLogger().info(RB.getStringResource("ConnectionManager.DefaultSettings.txt"));
        }
        if (autoMapState != 1 && (securityType = ((ImportHandler)this._operation).getSecurityConnectionType()) != null && SecurityConnectionType.isConnectionMappingNeeded(this._operation)) {
            securityType.mapConnections();
        }
        if (operation.isPreservingPaths()) {
            this.preserveFolderStructure(operation);
        }
        List<ConnectionPointInterface> connections = this.getConnections(true);
        for (ConnectionPointInterface pt : connections) {
            if (!pt.isActive() && ConnectionManager.isFolderConnectionPoint(pt, operation)) {
                ImportMetadataManagementInterface mgr;
                String sourceID = pt.getSourceID();
                ImportItemInterface importItem = (ImportItemInterface)operation.getPromotionItem(sourceID);
                if (importItem != null && importItem.getTargetID() != null) {
                    pt.setActive(true);
                    pt.setTargetID(importItem.getTargetID());
                    continue;
                }
                if (importItem == null && this._operation.getPackageFileVersion() < 9300 && (importItem = (ImportItemInterface)(mgr = (ImportMetadataManagementInterface)this._operation.getMetadataManager()).getPromotionItem(sourceID)) != null && importItem.getImportState() == 0 && this.isConnectionAssociatedToLiveObject(pt)) {
                    pt.addUserDefinedProperty("FRAMEWORK_CP_OVERRIDE", Boolean.TRUE.toString());
                }
            }
            if (!pt.isActive() || pt.getTargetID() != null) continue;
            if (ConnectionManager.isFolderConnectionPoint(pt, operation)) {
                if (operation.importIntoRoot() && !operation.isPreservingPaths()) {
                    this.updateFolderConnections(targetFolder, pt);
                    continue;
                }
                if (targetFolder == null) continue;
                pt.setTargetID(targetFolder.getIdentifier());
                if (!operation.getLogger().isDebugEnabled()) continue;
                operation.getLogger().debug("Setting folder cp to target folder: " + pt.getSourceID() + " --> " + pt.getTargetID());
                continue;
            }
            if (ConnectionManager.isBIPServiceConnectionPoint(pt)) {
                if (!operation.importIntoRoot()) {
                    this.updateFolderConnections(targetFolder, pt);
                    continue;
                }
                this.autoMapConnectionPoint(operation, pt, 2);
                continue;
            }
            if (!this.canAutoMapConnection(operation, pt, autoMapState)) continue;
            this.autoMapConnectionPoint(operation, pt, autoMapState);
        }
        return this._mappingReturnCode;
    }

    private void updateFolderConnections(PublicObjectContainerInterface targetFolder, ConnectionPointInterface pt) throws ServiceException, RemoteException {
        if (targetFolder != null) {
            Log log = this._operation.getLogger();
            if (log.isDebugEnabled()) {
                log.debug("Updating folder connection points.");
            }
            ObjectMoveManager moveManager = ObjectMoveManager.getInstance((ImportOperationInterface)this._operation);
            for (PromotionItemInterface item : pt.getAssociatedObjects()) {
                if (!BIPTreeUtil.isFolder(item) || moveManager.isTargetPathModified(item.getID())) continue;
                moveManager.setCustomTargetPath(item.getID(), item.getName(), item.getTypeInterface().getPublicType(), targetFolder.getPathUrl());
            }
            if (pt.getTargetID() == null && this._operation.getPackageFileVersion() < 9300 && this.isConnectionAssociatedToLiveObject(pt)) {
                pt.addUserDefinedProperty("FRAMEWORK_CP_OVERRIDE", Boolean.TRUE.toString());
            }
        }
    }

    private boolean canAutoMapConnection(ImportOperationInterface operation, ConnectionPointInterface pt, int autoMapState) {
        boolean autoMapped;
        boolean bl = autoMapped = pt.isAutoMapped() || autoMapState == 1 || autoMapState == 2;
        if (!autoMapped && pt.getTargetID() == null && pt instanceof ConnectionPoint && ((ConnectionPoint)pt).hasConflict()) {
            operation.getLogger().debug("Found unset conflicting connection point - " + pt);
            ((ConnectionPoint)pt).setAutoMapped(true);
            autoMapped = true;
        }
        return autoMapped && this.isConnectionAssociatedToLiveObject(pt);
    }

    private boolean isConnectionUpdateAllowed(ConnectionPointInterface pt, ImportItemInterface importItem, Set<ConnectionPointInterface> cache) {
        if (pt == null || cache.contains(pt)) {
            return false;
        }
        String type = importItem.getTypeInterface().getPublicType();
        if ("Folder".equalsIgnoreCase(type)) {
            return true;
        }
        return this.isConnectionAssociatedToLiveObject(pt);
    }

    private void preserveFolderStructure(ImportOperationInterface operation) throws MetadataPromotionException, RemoteException {
        ObjectMoveManager manager = ObjectMoveManager.getInstance(operation);
        List<String> items = manager.getObjectsToPreserve();
        if (items != null && !items.isEmpty()) {
            Log logger = operation.getLogger();
            try {
                logger.info(RB.getStringResource("ConnectionManager.PreservingFolders.txt"));
                HashSet<ConnectionPointInterface> cpCache = new HashSet<ConnectionPointInterface>();
                for (String id : items) {
                    String targetID;
                    ImportItemInterface importItem = operation.getImportItem(id);
                    if (importItem == null) continue;
                    String[] folderPath = importItem.getTargetPath();
                    ConnectionPointInterface folderConnection = this.getFolderConnection(importItem);
                    if (!this.isConnectionUpdateAllowed(folderConnection, importItem, cpCache) || (targetID = folderConnection.getTargetID()) != null) continue;
                    FolderInterface targetFolder = ImportFolderUtil.searchForFolder(operation, folderPath);
                    if (targetFolder != null) {
                        folderConnection.setTargetID(targetFolder.getIdentifier());
                        cpCache.add(folderConnection);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Setting folder cp to existing target folder: " + folderConnection.getSourceID() + " --> " + folderConnection.getTargetID());
                        continue;
                    }
                    FolderInterface parentFolder = null;
                    int len = folderPath.length;
                    for (int index = 0; index < len; ++index) {
                        CMetadata meta;
                        String folderName = folderPath[index];
                        String[] thisPath = new String[index + 1];
                        System.arraycopy(folderPath, 0, thisPath, 0, index + 1);
                        FolderInterface thisFolder = null;
                        if (index == 0) {
                            thisFolder = ImportFolderUtil.searchForFolder(operation, thisPath);
                        } else if (parentFolder != null && (meta = (CMetadata)parentFolder.getRepositoryEntity()) != null && !meta.isNewObject()) {
                            thisFolder = ImportFolderUtil.searchForFolder(operation, thisPath);
                        }
                        if (thisFolder == null) {
                            InformationServiceInterface informationSvc;
                            ServerInterface server = operation.getServer();
                            OMIRepositoryInterface repos = null;
                            if (operation.isProjectRepository()) {
                                repos = (OMIRepositoryInterface)server.getRepository(operation.getRepositoryName());
                                if (repos == null || !"PROJECT".equalsIgnoreCase(repos.getRepositoryType())) {
                                    throw new IllegalStateException(RB.getStringResource("ConnectionManager.InvalidRepos.txt"));
                                }
                            } else {
                                repos = (OMIRepositoryInterface)(parentFolder == null ? server.getFoundationRepository() : parentFolder.getRepository());
                            }
                            if ((informationSvc = CorePlatformServices.getInformationService()) != null) {
                                Tree tree;
                                String type = parentFolder == null ? "Folder" : parentFolder.getTypeDescriptor().getTypeName();
                                thisFolder = (FolderInterface)informationSvc.newMetadata(repos.getDefaultRepositoryId(), folderName, (RepositoryInterface)repos, type);
                                if (thisFolder == null) {
                                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionManager.FolderCreateError.fmt.txt", (Object)folderName);
                                    throw new ServiceException(msg);
                                }
                                if (!type.equalsIgnoreCase("Folder")) {
                                    tree = (Tree)thisFolder.getRepositoryEntity();
                                    tree.setPublicType(type);
                                }
                                if (parentFolder == null) {
                                    tree = (Tree)thisFolder.getRepositoryEntity();
                                    tree.getSoftwareComponents().add(server.getRootFolder().getRepositoryEntity());
                                } else {
                                    boolean isAuthorized;
                                    if (parentFolder.getState() != 1 && !(isAuthorized = ImportUtil.isFolderWriteAuthorized((PublicObjectInterface)parentFolder, server))) {
                                        String message = Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionManager.NotAuthorized.fmt.txt", (Object)parentFolder.getPathUrl().getDisplayPath());
                                        throw new ServiceException(message);
                                    }
                                    tree = (Tree)thisFolder.getRepositoryEntity();
                                    tree.setParentTree((Tree)parentFolder.getRepositoryEntity());
                                }
                                logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionManager.CreateNewFolder.fmt.txt", (Object)thisFolder.getPathUrl().getDisplayPath()));
                            }
                        }
                        parentFolder = thisFolder;
                    }
                    if (parentFolder == null) continue;
                    parentFolder.update();
                    folderConnection.setTargetID(parentFolder.getIdentifier());
                    cpCache.add(folderConnection);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Setting folder cp to new target folder: " + folderConnection.getSourceID() + " --> " + folderConnection.getTargetID());
                }
            }
            catch (Exception e) {
                logger.error(RB.getStringResource("ConnectionManager.PreserveError.txt"));
                throw new MetadataPromotionException(e);
            }
        }
    }

    @Override
    public ConnectionPointInterface getFolderConnection(PromotionItemInterface promotionItem) {
        PromotionInterface operation = null;
        if (promotionItem instanceof ImportItemInterface) {
            operation = ((ImportItemInterface)promotionItem).getImportOperation();
        } else if (promotionItem instanceof ExportItemInterface) {
            operation = ((ExportItemInterface)promotionItem).getExportOperation();
        }
        List<ConnectionPointInterface> connections = promotionItem.getConnectionPoints();
        for (ConnectionPointInterface pt : connections) {
            if (!ConnectionManager.isFolderConnectionPoint(pt, operation)) continue;
            return pt;
        }
        return null;
    }

    protected static boolean isBIPServiceConnectionPoint(ConnectionPointInterface pt) {
        String search;
        String publicType = pt.getPublicType();
        if ("RootFolder".equalsIgnoreCase(publicType)) {
            return true;
        }
        return publicType == null && "SoftwareComponent".equalsIgnoreCase(pt.getMetadataType()) && (search = pt.getSourceSearchString()).indexOf("E5F27790-2149-11D6-8828-AA0004006D06") > -1;
    }

    protected static boolean isFolderConnectionPoint(ConnectionPointInterface pt) {
        String publicType = pt.getPublicType();
        if ("Folder".equalsIgnoreCase(publicType)) {
            return true;
        }
        return publicType == null && "Tree".equalsIgnoreCase(pt.getMetadataType());
    }

    protected static boolean isFolderConnectionPoint(ConnectionPointInterface pt, PromotionInterface operation) {
        String publicType = pt.getPublicType();
        if (FolderUtil.isFolder((String)publicType)) {
            return true;
        }
        return operation.getPromotionType() == 1 && (publicType == null || publicType.length() == 0) && "Tree".equalsIgnoreCase(pt.getMetadataType()) && operation.getPackageFileVersion() < 9200;
    }

    @Override
    public void autoMapConnectionPoint(ImportOperationInterface operation, ConnectionPointInterface pt, int autoMapState) throws MetadataPromotionException {
        if (autoMapState == 1) {
            SourceConnectionInterface sourceConnection;
            Map<ConnectionPointInterface, SourceConnectionInterface> connectionCache;
            if (pt.getTargetID() == null) {
                pt.setTargetID(pt.getSourceID());
            }
            if (!pt.isAutoMapped() && (connectionCache = this.getSourceConnectionCache()) != null && connectionCache.containsKey(pt) && (sourceConnection = connectionCache.get(pt)) != null) {
                this.validateConnectionNoReturn(operation, sourceConnection);
            }
        } else if (pt.isAutoMapped() || autoMapState == 2) {
            String path = null;
            String displayType = null;
            try {
                MdFactory factory = operation.getMetadataFactory();
                String reposID = operation.getRepositoryID();
                List<String> searchList = pt.getSourceSearchList();
                if (searchList == null || searchList.size() == 0) {
                    throw new IllegalStateException(RB.getStringResource("ConnectionManager.MissingSearch.txt"));
                }
                String search = searchList.get(0);
                String options = "<XMLSelect search=\"" + XMLUtil.cleanStringForXML(search) + "\"/>";
                int flags = 8320;
                String metadataType = pt.getMetadataType();
                List objects = factory.getOMIUtil().getMetadataObjectsNoCache(metadataType, reposID, options, flags);
                if (objects.size() == 0) {
                    String msg = null;
                    String name = pt.getName();
                    displayType = pt.getPublicType();
                    path = pt.getSourcePath();
                    Map<ConnectionPointInterface, SourceConnectionInterface> connectionCache = this.getSourceConnectionCache();
                    if (connectionCache != null && connectionCache.containsKey(pt)) {
                        SourceConnectionInterface sourceConnection = connectionCache.get(pt);
                        ConnectionTypeInterface type = sourceConnection.getConnectionType();
                        displayType = type.getLocalizedTypeName();
                        name = sourceConnection.getDisplayName();
                        if (type.isConnectionRequired(sourceConnection) && pt.getConnectionAction() != 2) {
                            ((ConnectionPoint)pt).setConnectionAction(2);
                        }
                    }
                    msg = displayType != null && path != null ? Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionManager.RequiredConnectionNotFound.fmt.txt", (Object)displayType, (Object)path) : (displayType != null ? Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionManager.RequiredConnectionNotFound.fmt.txt", (Object)displayType, (Object)name) : Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionManager.RequiredConnectionNotFound.fmt.txt", (Object)pt.getMetadataType(), (Object)name));
                    throw new MetadataPromotionException(msg);
                }
                Map map = (Map)objects.get(0);
                String id = (String)map.get("Id");
                pt.setTargetID(id);
                Map<ConnectionPointInterface, SourceConnectionInterface> connectionCache = this.getSourceConnectionCache();
                if (connectionCache != null && connectionCache.containsKey(pt)) {
                    CMetadata meta;
                    SourceConnectionInterface sourceConnection = connectionCache.get(pt);
                    ConnectionTypeInterface type = sourceConnection.getConnectionType();
                    TargetConnectionInterface targetConnection = ((AbstractConnectionType)type).createTargetConnection(id, metadataType, sourceConnection.getDisplayName());
                    type.addConnectionMapping(sourceConnection, targetConnection);
                    if (pt.getPublicType() != null && (meta = targetConnection.getMetadataObject()) instanceof PrimaryType) {
                        ((PrimaryType)meta).setPublicType(pt.getPublicType(), 1);
                    }
                    this.validateConnectionNoReturn(operation, sourceConnection);
                }
            }
            catch (ConnectionValidationException e) {
                throw e;
            }
            catch (Exception e) {
                Log log = operation.getLogger();
                if (pt.getConnectionAction() == 2) {
                    if (e instanceof MetadataPromotionException) {
                        throw (MetadataPromotionException)((Object)e);
                    }
                    log.debug((Object)"Connection Failed", e);
                    throw new MetadataPromotionException(e);
                }
                if (pt.getConnectionAction() == 1) {
                    this._mappingReturnCode |= 4;
                    log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionManager.ConnectionPointWarn.fmt.txt", (Object)(displayType == null ? pt.getMetadataType() : displayType), (Object)(path == null ? pt.getName() : path)));
                }
                log.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionManager.ConnectionPointWarn.fmt.txt", (Object)(displayType == null ? pt.getMetadataType() : displayType), (Object)(path == null ? pt.getName() : path)));
            }
        }
    }

    private void initializeSourceConnections(ImportOperationInterface operation) {
        this._sourceConnectionCache = new LinkedHashMap<ConnectionPointInterface, SourceConnectionInterface>();
        try {
            List<ConnectionTypeInterface> connectionTypes = operation.getConnectionTypes();
            if (connectionTypes != null && connectionTypes.size() > 0) {
                for (ConnectionTypeInterface type : connectionTypes) {
                    List<SourceConnectionInterface> sourceConnections = type.getSourceConnections();
                    if (sourceConnections == null || sourceConnections.size() <= 0) continue;
                    for (SourceConnectionInterface sourceConnection : sourceConnections) {
                        ConnectionPointInterface pt = sourceConnection.getConnectionPoint();
                        if (this._sourceConnectionCache.containsKey(pt)) continue;
                        this._sourceConnectionCache.put(pt, sourceConnection);
                    }
                }
            }
        }
        catch (MetadataPromotionException e) {
            operation.getLogger().debug("Unable to retrieve connection types.");
        }
    }

    private Map<ConnectionPointInterface, SourceConnectionInterface> getSourceConnectionCache() {
        return this._sourceConnectionCache;
    }

    @Override
    public void mapConnectionTargetNotFound(ConnectionTypeInterface connectionType, SourceConnectionInterface source, String targetValue) throws MetadataPromotionException {
        if (connectionType.isConnectionRequired(source)) {
            TargetConnectionInterface parentTarget;
            DependentConnectionTypeInterface depType;
            DependentConnectionMapping mapping;
            SourceConnectionInterface parentSource;
            String msg = null;
            msg = connectionType instanceof DependentConnectionTypeInterface ? ((parentSource = (mapping = (depType = (DependentConnectionTypeInterface)connectionType).getDependentConnectionMapping()).getDependentConnection(source)) != null ? ((parentTarget = depType.getDependentType().getTargetConnection(parentSource)) != null ? Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionManager.TargetNotFoundParent.fmt.txt", (Object)connectionType.getLocalizedTypeName(), (Object)parentTarget.getDisplayName(), (Object)targetValue) : Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionManager.TargetNotFound.fmt.txt", (Object)connectionType.getLocalizedTypeName(), (Object)targetValue)) : Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionManager.TargetNotFound.fmt.txt", (Object)connectionType.getLocalizedTypeName(), (Object)targetValue)) : Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionManager.TargetNotFound.fmt.txt", (Object)connectionType.getLocalizedTypeName(), (Object)targetValue);
            throw new MetadataPromotionException(msg);
        }
        connectionType.addConnectionMapping(source, null);
    }

    @Override
    public void mapConnectionByTargetValue(ImportOperationInterface operation, ConnectionTypeInterface connectionType, SourceConnectionInterface source, TargetConnectionInterface target) throws MetadataPromotionException {
        if (target == null) {
            this.handleNullTargetValues(connectionType, source);
        } else {
            try {
                this.mapConnection(connectionType, source, target);
            }
            catch (Exception e) {
                this.handleMappingFailure(operation, connectionType, source, e);
            }
        }
    }

    @Override
    public void mapConnectionByPath(ImportOperationInterface operation, ConnectionTypeInterface connectionType, SourceConnectionInterface source, String targetPath) throws MetadataPromotionException {
        if (targetPath == null || targetPath.length() == 0) {
            this.handleNullTargetValues(connectionType, source);
        } else {
            try {
                CMetadata meta = null;
                MetadataInterface smartObject = PromotionUtil.getObjectFromPath(operation.getServer(), targetPath);
                if (smartObject != null) {
                    meta = (CMetadata)smartObject.getRepositoryEntity();
                }
                if (meta == null) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionManager.TargetNotFound.fmt.txt", (Object)connectionType.getLocalizedTypeName(), (Object)targetPath);
                    throw new MetadataPromotionException(msg);
                }
                TargetConnectionInterface target = ((AbstractConnectionType)connectionType).createTargetConnection(meta, meta.getName());
                this.mapConnection(connectionType, source, target, targetPath);
            }
            catch (Exception e) {
                this.handleMappingFailure(operation, connectionType, source, e);
            }
        }
    }

    @Override
    public void mapConnectionByDefaultValue(ImportOperationInterface operation, ConnectionTypeInterface connectionType, SourceConnectionInterface source) throws MetadataPromotionException {
        try {
            TargetConnectionInterface target = null;
            List<ConnectionPointInterface> connectionPoints = source.getConnectionPoints();
            if (connectionPoints == null) {
                return;
            }
            for (ConnectionPointInterface pt : connectionPoints) {
                CMetadata meta = null;
                String search = pt.getSourceSearchString();
                if (search != null && search.length() > 0) {
                    MdFactory factory = operation.getMetadataFactory();
                    String reposID = operation.getRepositoryID();
                    String options = "<XMLSelect search=\"" + XMLUtil.cleanStringForXML(pt.getSourceSearchString()) + "\"/>";
                    int flags = 8584;
                    List objects = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), reposID, pt.getMetadataType(), flags, options);
                    if (objects != null && objects.size() > 0) {
                        meta = (CMetadata)objects.get(0);
                    }
                } else if (pt.getSourcePath() != null) {
                    MetadataInterface smartObject = PromotionUtil.getObjectFromPath(operation.getServer(), pt.getSourcePath());
                    if (smartObject != null) {
                        meta = (CMetadata)smartObject.getRepositoryEntity();
                    }
                } else {
                    if (!operation.getLogger().isDebugEnabled()) continue;
                    operation.getLogger().debug("Found connection point with no source information: " + source.getDisplayName());
                    continue;
                }
                if (meta != null) {
                    if (target == null) {
                        target = ((AbstractConnectionType)connectionType).createTargetConnection(meta, source.getDisplayName());
                    }
                    this.mapConnection(connectionType, source, target);
                    continue;
                }
                String displayName = pt.getSourcePath() == null ? source.getDisplayName() : source.getSourcePath();
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionManager.TargetNotFound.fmt.txt", (Object)connectionType.getLocalizedTypeName(), (Object)displayName);
                throw new MetadataPromotionException(msg);
            }
        }
        catch (Exception e) {
            this.handleMappingFailure(operation, connectionType, source, e);
        }
    }

    private void handleNullTargetValues(ConnectionTypeInterface connectionType, SourceConnectionInterface source) throws MetadataPromotionException {
        if (connectionType.isConnectionRequired(source)) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionManager.ConnectionRequired.fmt.txt", (Object)connectionType.getLocalizedTypeName(), (Object)source.getDisplayName());
            throw new MetadataPromotionException(msg);
        }
        connectionType.addConnectionMapping(source, null);
    }

    private void mapConnection(ConnectionTypeInterface connectionType, SourceConnectionInterface source, TargetConnectionInterface target) throws RemoteException, MdException {
        this.mapConnection(connectionType, source, target, null);
    }

    private void mapConnection(ConnectionTypeInterface connectionType, SourceConnectionInterface source, TargetConnectionInterface target, String targetPath) throws RemoteException, MdException {
        boolean mapped = false;
        List<ConnectionPointInterface> connectionsList = source.getConnectionPoints();
        if (connectionsList != null) {
            for (ConnectionPointInterface pt : connectionsList) {
                String targetID;
                if (pt.getTargetID() == null && (targetID = connectionType.getTargetConnectionID(pt, target)) != null) {
                    pt.setTargetID(targetID);
                    mapped = true;
                }
                if (targetPath == null || pt.getTargetPath() != null) continue;
                pt.setTargetPath(targetPath);
            }
        }
        if (mapped) {
            connectionType.addConnectionMapping(source, target);
        }
    }

    private void handleMappingFailure(ImportOperationInterface operation, ConnectionTypeInterface connectionType, SourceConnectionInterface source, Exception e) throws MetadataPromotionException {
        Log log = operation.getLogger();
        if (connectionType.isConnectionRequired(source)) {
            if (e instanceof MetadataPromotionException) {
                throw (MetadataPromotionException)((Object)e);
            }
            log.debug((Object)"Connection Failed", e);
            throw new MetadataPromotionException(e);
        }
        connectionType.addConnectionMapping(source, null);
        log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionManager.MappingWarningNoTarget.fmt.txt", (Object)connectionType.getLocalizedTypeName(), (Object)source.getDisplayName()));
        this._mappingReturnCode |= 4;
    }

    @Override
    public TargetConnectionInterface searchForTargetConnection(ImportOperationInterface operation, SearchCriteria criteria) throws MetadataPromotionException {
        if (criteria == null) {
            return null;
        }
        TargetConnectionInterface target = null;
        CMetadata meta = null;
        SourceConnectionInterface source = criteria.getSourceConnection();
        ConnectionTypeInterface type = source.getConnectionType();
        try {
            MetadataInterface smartObject;
            String path;
            if (criteria.isSearchingByPath() && (path = source.getSourcePath()) != null && (smartObject = PromotionUtil.getObjectFromPath(operation.getServer(), path)) != null) {
                meta = (CMetadata)smartObject.getRepositoryEntity();
            }
            if (meta == null && criteria.isSearchingByXMLSelect()) {
                MdFactory factory;
                List objects;
                String metadataType = criteria.getMetadataType();
                String searchString = criteria.getSearchString();
                if (metadataType == null || searchString == null || searchString.length() == 0) {
                    return target;
                }
                String xmlSelect = "<XMLSelect search=\"" + XMLUtil.cleanStringForXML(searchString) + "\"/>";
                int flags = 8328;
                if (criteria.isIncludingSubTypes()) {
                    flags |= 0x10;
                }
                if ((objects = (factory = operation.getMetadataFactory()).getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), metadataType, flags, xmlSelect)) != null && objects.size() > 0) {
                    meta = (CMetadata)objects.get(0);
                }
            }
            if (meta != null) {
                target = ((AbstractConnectionType)type).createTargetConnection(meta, meta.getName());
            }
        }
        catch (Exception e) {
            throw new MetadataPromotionException(e);
        }
        return target;
    }

    @Override
    public ValidationResponse validateConnection(ImportOperationInterface operation, SourceConnectionInterface connection) throws MdException, RemoteException {
        ValidationResponse response = new ValidationResponse();
        ValidationResponse tempResponse = null;
        ConnectionTypeInterface type = connection.getConnectionType();
        type.validate(response, operation, connection);
        int rc = response.getReturnCode();
        if (rc == 2) {
            return response;
        }
        Map<String, ConnectionValidatorInterface[]> map = this.getConnectionValidators(operation);
        if (map.size() > 0) {
            for (Map.Entry<String, ConnectionValidatorInterface[]> entry : map.entrySet()) {
                List<ConnectionPointInterface> connectionPoints;
                ConnectionValidatorInterface[] validators = entry.getValue();
                if (validators == null) continue;
                String publicType = entry.getKey();
                String connectionTypeName = type.getClass().getName();
                ConnectionValidatorInterface validator = this.getConnectionValidator(validators, connectionTypeName);
                if (validator == null || (connectionPoints = connection.getConnectionPoints()) == null) continue;
                for (ConnectionPointInterface pt : connectionPoints) {
                    if (!pt.isConnectionForImportType(publicType)) continue;
                    validator.validate(response, operation, pt);
                    if (((rc |= response.getReturnCode()) & 2) > 0) {
                        return response;
                    }
                    if ((rc & 2) <= 0) continue;
                    tempResponse = response;
                }
            }
        }
        return tempResponse == null ? response : tempResponse;
    }

    private void validateConnectionNoReturn(ImportOperationInterface operation, SourceConnectionInterface sourceConnection) throws MetadataPromotionException, ConnectionValidationException {
        ValidationResponse response = null;
        try {
            response = this.validateConnection(operation, sourceConnection);
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionPropertiesHandler.ValidateFailure.fmt.txt", (Object)sourceConnection.getDisplayName());
            throw new MetadataPromotionException(e, msg);
        }
        switch (response.getReturnCode()) {
            case 0: {
                break;
            }
            case 1: {
                String warning = Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionPropertiesHandler.ValidationWarning.fmt.txt", (Object)response.getMessage());
                operation.getLogger().warn(warning);
                this._mappingReturnCode |= 4;
                break;
            }
            case 2: {
                String error = Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionPropertiesHandler.ValidationError.fmt.txt", (Object)response.getMessage());
                this._mappingReturnCode |= 8;
                throw new ConnectionValidationException(error);
            }
        }
    }

    public ConnectionValidatorInterface getConnectionValidator(ConnectionValidatorInterface[] validators, String connectionTypeName) {
        if (validators != null) {
            for (int i = 0; i < validators.length; ++i) {
                ConnectionValidatorInterface validator = validators[i];
                if (!connectionTypeName.equals(validator.getConnectionTypeName())) continue;
                return validator;
            }
        }
        return null;
    }

    private Map<String, ConnectionValidatorInterface[]> getConnectionValidators(ImportOperationInterface operation) {
        if (this._validatorsMap == null) {
            this._validatorsMap = new HashMap<String, ConnectionValidatorInterface[]>();
            Map importItems = operation.getImportItems();
            if (importItems != null) {
                for (String publicType : importItems.keySet()) {
                    ImportListener listener = operation.getImportListener(publicType);
                    if (listener == null) continue;
                    ConnectionValidatorInterface[] validators = listener.getConnectionValidatorInterfaces();
                    this._validatorsMap.put(publicType, validators);
                }
            }
        }
        return this._validatorsMap;
    }

    @Override
    public boolean isConnectionAssociatedToLiveObject(ConnectionPointInterface pt) {
        if (this._promotionType == 1) {
            List<PromotionItemInterface> items = pt.getAssociatedObjects();
            for (PromotionItemInterface item : items) {
                ImportItemInterface importItem;
                if (!(item instanceof ImportItemInterface) || (importItem = (ImportItemInterface)item).getImportState() == 0) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private synchronized String generateUniqueID() {
        return UNKNOWN_ID + this._unknownCounter++;
    }

    @Override
    public void objectsSelected(Map selectedItems) {
        if (this._validatorsMap != null) {
            this._validatorsMap.clear();
            this._validatorsMap = null;
        }
    }
}

