/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.DateParser;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.AbstractPromotionDriver;
import com.sas.metadata.promotion.BatchExporterOptions;
import com.sas.metadata.promotion.DateFilter;
import com.sas.metadata.promotion.ExportHandler;
import com.sas.metadata.promotion.ExportHelper;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ExportSummaryInterface;
import com.sas.metadata.promotion.ImportHandler;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.LoggingUtil;
import com.sas.metadata.promotion.MetadataFilterInterface;
import com.sas.metadata.promotion.NoObjectsToExportException;
import com.sas.metadata.promotion.ObjectConverter;
import com.sas.metadata.promotion.ObjectNameFilter;
import com.sas.metadata.promotion.ObjectTypeFilter;
import com.sas.metadata.promotion.PromotionConfiguration;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.promotion.model.ExportFolderModelInterface;
import com.sas.metadata.promotion.model.ExportModelConfiguration;
import com.sas.metadata.promotion.model.ModelFactory;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.search.DateFilter;
import com.sas.services.information.search.ExtendedAttributesFilter;
import com.sas.services.information.search.KeywordFilter;
import com.sas.services.information.search.NotesFilter;
import com.sas.services.information.search.PublicTypeFilter;
import com.sas.services.information.search.ResponsibilitiesFilter;
import com.sas.services.information.search.SearchFilter;
import com.sas.services.information.search.SearchOperator;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.text.Message;
import com.sas.util.DatePeriod;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@SASScope
public class BatchExporter
extends AbstractPromotionDriver {
    private List<MetadataFilterInterface> _filterList = null;
    private List<SearchFilter> _filters;
    private boolean _generateLocalizableProperties = false;
    private boolean _generateExternalSubstitutionProperties = false;
    private boolean _includeDependencies = false;
    private boolean _includeEmptyFolders = false;
    private boolean _repackage = false;
    private boolean _includeNewObjects = false;
    private String[] _objectPaths = null;
    private ExportSummaryInterface _summary;
    private ExportHandler _exportOperation;
    private int _exportMode = 0;
    private PublicObjectInterface[] _selectedObjects = null;

    public BatchExporter() {
        this.setLogFilePrefix("Export");
    }

    public BatchExporter(String host, String port, String user, String password) {
        this();
        this.setConnection(host, port);
        this.setCredential(user, password);
    }

    public BatchExporter(SessionContextInterface session) throws ServiceException, RemoteException {
        this();
        this.setConnection(session);
    }

    public void setGenerateLocalizableProperties(boolean generateLocalizableProperties) {
        this._generateLocalizableProperties = generateLocalizableProperties;
    }

    public void setGenerateExternalSubstitutionProperties(boolean generateExternalSubstitutionProperties) {
        this._generateExternalSubstitutionProperties = generateExternalSubstitutionProperties;
    }

    public void setIncludeDependencies(boolean includeDependencies) {
        this._includeDependencies = includeDependencies;
    }

    public void setIncludeEmptyFolders(boolean includeEmptyFolders) {
        this._includeEmptyFolders = includeEmptyFolders;
    }

    public void setObjectPath(String objectPath) {
        this._objectPaths = new String[]{objectPath};
    }

    public void setObjectPaths(String[] objectPaths) {
        this._objectPaths = objectPaths;
    }

    public void addSearchFilter(SearchFilter filter) {
        if (this._filters == null) {
            this._filters = new ArrayList<SearchFilter>(2);
        }
        this._filters.add(filter);
    }

    public List<SearchFilter> getSearchFilters() {
        if (this._filters == null) {
            return Collections.emptyList();
        }
        return new ArrayList<SearchFilter>(this._filters);
    }

    public void addFilter(MetadataFilterInterface filter) {
        ObjectTypeFilter oldFilter;
        TypeInterface[] types;
        if (this._filterList == null) {
            this._filterList = new ArrayList<MetadataFilterInterface>(2);
        }
        this._filterList.add(filter);
        if (filter instanceof ObjectNameFilter) {
            ObjectNameFilter oldFilter2 = (ObjectNameFilter)filter;
            this.addSearchFilter((SearchFilter)new com.sas.services.information.search.ObjectNameFilter(oldFilter2.getName(), oldFilter2.isIncludingDescription()));
        } else if (filter instanceof DateFilter) {
            DateFilter oldFilter3 = (DateFilter)filter;
            Date beginDate = oldFilter3.getBeginDate();
            Date endDate = oldFilter3.getEndDate();
            DateFilter.DateType type = oldFilter3.getType() == 0 ? DateFilter.DateType.CREATED_DATE : DateFilter.DateType.MODIFIED_DATE;
            this.addSearchFilter((SearchFilter)new com.sas.services.information.search.DateFilter(type, beginDate, endDate));
        } else if (filter instanceof ObjectTypeFilter && (types = (oldFilter = (ObjectTypeFilter)filter).getTypes()) != null) {
            ArrayList<String> supportedTypes = new ArrayList<String>();
            for (int index = 0; index < types.length; ++index) {
                supportedTypes.add(types[index].getPublicType());
            }
            this.addSearchFilter((SearchFilter)new PublicTypeFilter(supportedTypes));
        }
    }

    public MetadataFilterInterface[] getFilters() {
        if (this._filterList != null) {
            return this._filterList.toArray(new MetadataFilterInterface[this._filterList.size()]);
        }
        return null;
    }

    protected void setExportMode(int mode) {
        if (mode != 0 && mode != 2) {
            throw new IllegalArgumentException("Invalid export mode");
        }
        this._exportMode = mode;
    }

    protected void setSelectedObjects(SimpleLogicalObjectInterface[] selectedObjects) {
        if (selectedObjects != null) {
            try {
                ObjectConverter converter = ObjectConverter.getInstance();
                this.setSelectedObjects(converter.convertToPublicObjects(selectedObjects, this._server));
            }
            catch (Exception e) {
                throw new RuntimeException("Error converting to public objects");
            }
        }
    }

    protected void setSelectedObjects(PublicObjectInterface[] selectedObjects) {
        this._selectedObjects = selectedObjects;
    }

    public ExportSummaryInterface getExportSummary() {
        return this._summary;
    }

    @Override
    protected void parse(String[] args) throws ParseException, MissingOptionException {
        String respUserName;
        String extName;
        String[] notes;
        String[] keywords;
        String name;
        this._options = new BatchExporterOptions();
        if (args == null || args.length == 0) {
            this._help = true;
            return;
        }
        super.parse(args);
        if (this._help) {
            return;
        }
        this._objectPaths = this._commandLine.getOptionValues("objects");
        this._repackage = this._commandLine.hasOption("repackage");
        if (this._repackage) {
            String param = this._commandLine.getOptionValue("repackage");
            if ("full".equalsIgnoreCase(param)) {
                this._includeNewObjects = true;
            }
        } else if (this._objectPaths == null) {
            this._help = true;
            return;
        }
        String sinceDate = this._commandLine.getOptionValue("since");
        String beforeDate = this._commandLine.getOptionValue("before");
        if (sinceDate != null || beforeDate != null) {
            com.sas.services.information.search.DateFilter filter;
            boolean createdDate = this._commandLine.hasOption("created");
            boolean modifiedDate = this._commandLine.hasOption("modified");
            if (modifiedDate || !modifiedDate && !createdDate) {
                filter = BatchExporter.createDateFilter(DateFilter.DateType.MODIFIED_DATE, sinceDate, beforeDate);
                this.addSearchFilter((SearchFilter)filter);
            } else if (createdDate) {
                filter = BatchExporter.createDateFilter(DateFilter.DateType.CREATED_DATE, sinceDate, beforeDate);
                this.addSearchFilter((SearchFilter)filter);
            }
        }
        if ((name = this._commandLine.getOptionValue("name")) != null && name.length() > 0) {
            boolean includeDescription = this._commandLine.hasOption("includeDesc");
            SearchOperator operator = null;
            String operatorValue = this._commandLine.getOptionValue("nameMatchType");
            if (operatorValue != null && operatorValue.length() > 0) {
                operator = SearchOperator.getSearchOperatorForValue((String)operatorValue);
            }
            if (operator == null) {
                operator = com.sas.services.information.search.ObjectNameFilter.getDefaultOperator();
            }
            this.addSearchFilter((SearchFilter)new com.sas.services.information.search.ObjectNameFilter(name, includeDescription, operator));
        }
        if ((keywords = this._commandLine.getOptionValues("keywords")) != null && keywords.length > 0) {
            List<String> keywordList = BatchExporter.getValuesAsList(keywords);
            this.addSearchFilter((SearchFilter)new KeywordFilter(keywordList));
        }
        if ((notes = this._commandLine.getOptionValues("notes")) != null && notes.length > 0) {
            List<String> noteList = BatchExporter.getValuesAsList(notes);
            this.addSearchFilter((SearchFilter)new NotesFilter(noteList));
        }
        if ((extName = this._commandLine.getOptionValue("extName")) != null && extName.length() > 0) {
            String value = this._commandLine.getOptionValue("extValue");
            HashMap<String, String> attrs = new HashMap<String, String>(1);
            attrs.put(extName, value);
            this.addSearchFilter((SearchFilter)new ExtendedAttributesFilter(attrs));
        }
        if ((respUserName = this._commandLine.getOptionValue("respName")) != null && respUserName.length() > 0) {
            String role = this._commandLine.getOptionValue("respRole");
            this.addSearchFilter((SearchFilter)new ResponsibilitiesFilter(name, role));
        }
        this._includeDependencies = this._commandLine.hasOption("includeDep");
        this._includeEmptyFolders = this._commandLine.hasOption("includeEmptyFolders");
        this._generateLocalizableProperties = this._commandLine.hasOption("locprop");
        this._generateExternalSubstitutionProperties = this._commandLine.hasOption("subprop");
    }

    public int exportPackage(String object, String packageFileName) throws Exception {
        this.setObjectPath(object);
        this.setPackageFileName(packageFileName);
        return this.exportPackage();
    }

    public int exportPackage(String[] objects, String packageFileName) throws Exception {
        this.setObjectPaths(objects);
        this.setPackageFileName(packageFileName);
        return this.exportPackage();
    }

    @Override
    public void initialize() throws ServiceException, LogicalTypeException, RemoteException {
        if (this._initialized) {
            return;
        }
        super.initialize();
        this._exportOperation = new ExportHandler(null, this._exportMode);
        this._exportOperation.setSessionContext(this._session, !this._privateServicesDeployment);
    }

    public int exportPackage() throws Exception {
        try {
            List<String> supportedTypes;
            this.initialize();
            this.validateSetup();
            if (this._exportMode == 0) {
                String fileName = null;
                if (this._packageFile != null) {
                    fileName = this._packageFile.getAbsolutePath();
                }
                PromotionUtil.validatePackageFileName(fileName, true);
            }
            this._exportOperation.setExportFile(this._packageFile);
            this._summary = this._exportOperation.getExportSummary();
            PromotionConfiguration config = this._exportOperation.getPromotionConfiguration();
            config.setBatchProcess(true);
            config.setInstallProcess(this._install);
            this._logFileName = this._exportOperation.getLogger().getLogFileName();
            LoggingUtil.logServerInformation(this._user, this._exportOperation.getLogger(), true);
            if (this._repackage) {
                if (this._objectPaths != null) {
                    this._exportOperation.getLogger().warn(RB.getStringResource("BatchExporter.ObjectsOptionIgnored.txt"));
                }
                if (this._includeNewObjects) {
                    this._exportOperation.getLogger().info(RB.getStringResource("BatchExporter.FullRepackageMode.txt"));
                } else {
                    this._exportOperation.getLogger().info(RB.getStringResource("BatchExporter.RegularRepackageMode.txt"));
                }
                this._rc |= this.readExportPackage();
            }
            if (this._generateLocalizableProperties) {
                this._exportOperation.getPropertiesManager().setProcessLocalizableProperties(true, true);
            }
            if (this._generateExternalSubstitutionProperties) {
                this._exportOperation.getPropertiesManager().setProcessSubstitutionProperties(true, true);
            }
            if ((supportedTypes = this.getFilteredTypes()) != null && !supportedTypes.isEmpty()) {
                boolean typeFilterExists = false;
                if (this._filters != null) {
                    for (SearchFilter filter : this._filters) {
                        if (!(filter instanceof PublicTypeFilter)) continue;
                        typeFilterExists = true;
                        break;
                    }
                }
                if (!typeFilterExists) {
                    PublicTypeFilter typeFilter = new PublicTypeFilter(supportedTypes, this._includeSubTypes);
                    typeFilter.setServer(this._server);
                    this.addSearchFilter((SearchFilter)typeFilter);
                }
            }
            this._exportOperation.setIncludeDependencies(this._includeDependencies);
            PublicObjectInterface[] objects = this._selectedObjects == null ? this.getSelectedItems(this._exportOperation, this._objectPaths) : this._selectedObjects;
            this._exportOperation.setSelectedObjects(Arrays.asList(objects));
            ExportFolderModelInterface model = ModelFactory.createExportFolderModel(this._exportOperation);
            ExportModelConfiguration modelConfig = (ExportModelConfiguration)model.getConfiguration();
            if (this._exportMode == 0) {
                modelConfig.setIncludeDependencies(this._includeDependencies);
                modelConfig.setDisplayEmptyFolders(this._includeEmptyFolders);
                modelConfig.setAllowFolderExport(true);
            } else {
                modelConfig.setDisplayEmptyFolders(true);
                modelConfig.setDisplayUnknownObjects(false);
                modelConfig.setAllowFolderExport(false);
            }
            ArrayList<SearchFilter> searchFilters = new ArrayList<SearchFilter>();
            if (this._filters != null) {
                searchFilters.addAll(this._filters);
            }
            this._exportOperation.loadObjectsToExport(objects, searchFilters, model);
            if (this._noExecute) {
                String str = LoggingUtil.displayExportedObjects(this._exportOperation.getExportItems(), this._exportOperation.getServer(), true);
                this._exportOperation.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"ExportHandler.ExportingObjects.Log.txt", (Object)str));
                this._exportOperation.getLogger().info(RB.getStringResource("BatchExporter.NoExecuteMode.txt"));
                int n = this._rc;
                return n;
            }
            this._rc |= this._exportOperation.runExport();
        }
        catch (NoObjectsToExportException e) {
            if (this._exportOperation != null) {
                this._exportOperation.getLogger().info(e.getLocalizedMessage());
            }
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"BatchExporter.ExportFailed.fmt.txt", (Object)e.getLocalizedMessage());
            this._rc |= 8;
            if (this._exportOperation != null) {
                this._exportOperation.getLogger().error(msg);
                this._exportOperation.getLogger().debug((Object)"Batch Export Process Failed", e);
            }
            throw e;
        }
        finally {
            if (this._exportOperation != null) {
                Log log = this._exportOperation.getLogger();
                if (log != null && log.isInfoEnabled()) {
                    if ((this._rc & 8) > 0) {
                        log.info(RB.getStringResource("BatchExporter.FinishedError.Log.txt"));
                    } else if ((this._rc & 4) > 0) {
                        log.info(RB.getStringResource("BatchExporter.FinishedWarning.Log.txt"));
                    } else {
                        log.info(RB.getStringResource("BatchExporter.FinishedSuccess.Log.txt"));
                    }
                }
                this._exportOperation.dispose();
            }
            this.terminate();
        }
        return this._rc;
    }

    private PublicObjectInterface[] getSelectedItems(ExportOperationInterface operation, String[] paths) throws ServiceException, RemoteException {
        if (paths == null || paths.length == 0) {
            throw new ServiceException(RB.getStringResource("BatchExporter.NoObjects.txt"));
        }
        ServerInterface server = operation.getServer();
        ArrayList<Object> objectList = new ArrayList<Object>();
        if (paths.length == 1 && paths[0].equalsIgnoreCase(String.valueOf('/'))) {
            RootFolderInterface rootFolder = server.getRootFolder();
            if (rootFolder != null) {
                objectList.add(rootFolder);
            }
        } else {
            for (String path : paths) {
                MetadataInterface mi;
                PathUrl url = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)path);
                if (url.getType() == null) {
                    url.setType("Folder");
                }
                if ((mi = server.getObjectByPath(url)) == null) {
                    this._exportOperation.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"BatchExporter.ObjectNotFound.fmt.txt", (Object)path));
                    this._rc |= 4;
                    continue;
                }
                TypeDescriptorInterface type = mi.getTypeDescriptor();
                if (type == null) continue;
                if (operation.isTypeSupported(type.getTypeName())) {
                    objectList.add(mi);
                    continue;
                }
                if (this._exportMode != 0) continue;
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"BatchExporter.ObjectNotSupported.fmt.txt", (Object)type.getType(), (Object)url.getDisplayPath());
                this._exportOperation.getLogger().warn(msg);
                this._rc |= 4;
            }
        }
        return objectList.toArray(new PublicObjectInterface[objectList.size()]);
    }

    private static com.sas.services.information.search.DateFilter createDateFilter(DateFilter.DateType type, String sinceDate, String beforeDate) throws IllegalArgumentException {
        DateParser parser = DateParser.getInstance();
        Date beginDate = parser.parseDate(sinceDate);
        Date endDate = parser.parseDate(beforeDate);
        if (beginDate != null && endDate != null && endDate.before(beginDate)) {
            throw new IllegalArgumentException(RB.getStringResource("BatchExporter.InvalidDateRange.txt"));
        }
        return new com.sas.services.information.search.DateFilter(type, beginDate, endDate);
    }

    private static String getUsage(HelpFormatter help) {
        String NEW_LINE = help.getNewLine();
        StringBuffer usage = new StringBuffer();
        String sUsage = "ExportPackage -package packageFile -objects objectPath [options...]";
        usage.append(sUsage);
        usage.append(NEW_LINE).append(NEW_LINE);
        usage.append(RB.getStringResource("BatchExporter.HelpExample1.txt"));
        usage.append(NEW_LINE).append("ExportPackage -package data.spk -objects \"/Shared Data\"");
        usage.append(NEW_LINE).append(NEW_LINE);
        usage.append(RB.getStringResource("BatchExporter.HelpExample2.txt"));
        usage.append(NEW_LINE).append("ExportPackage -package all.spk -objects \"/\"");
        usage.append(NEW_LINE).append(NEW_LINE);
        usage.append(RB.getStringResource("BatchExporter.HelpExample3.txt"));
        usage.append(NEW_LINE).append("ExportPackage -package mypkg.spk -objects \"/Shared Data\" \"/Users/MyFolder\" \"/Tables/Shared Tables/Test Table(Table)\"");
        usage.append(NEW_LINE).append(NEW_LINE);
        usage.append(RB.getStringResource("BatchExporter.HelpExample4.txt"));
        usage.append(NEW_LINE).append("ExportPackage -package filtering.spk -objects \"/\" -name \"orion\" -types \"Library\" -modified -since \"Year to date\"");
        usage.append(NEW_LINE);
        usage.append(NEW_LINE).append(NEW_LINE);
        usage.append(RB.getStringResource("BatchExporter.HelpExample5.txt"));
        usage.append(NEW_LINE).append("ExportPackage -package all.spk -repackage");
        usage.append(NEW_LINE);
        return usage.toString();
    }

    public static String generateBatchCommand(ExportOperationInterface operation) {
        List filters;
        String packageName;
        ExportFolderModelInterface exportModel = operation.getExportModel();
        if (exportModel == null) {
            return null;
        }
        String profile = BatchExporter.getDisplayableProfileName(operation);
        if (profile == null) {
            return null;
        }
        String string = packageName = operation.getPackageFile() == null ? null : operation.getPackageFile().getAbsolutePath();
        if (packageName == null) {
            return null;
        }
        List<String> objectPaths = null;
        try {
            objectPaths = BatchExporter.getExportedObjectPaths(exportModel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (objectPaths == null || objectPaths.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(150);
        sb.append("ExportPackage ");
        BatchExporter.addOptionAndValue(sb, "profile", profile);
        BatchExporter.addOptionAndValue(sb, "package", packageName);
        BatchExporter.addOptionAndValues(sb, "objects", objectPaths);
        BatchExporter.addOptionAndValue(sb, "subprop", null);
        if (operation.isIncludingDependencies()) {
            BatchExporter.addOptionAndValue(sb, "includeDep", null);
        }
        if (exportModel.getConfiguration().isDisplayingEmptyFolders()) {
            BatchExporter.addOptionAndValue(sb, "includeEmptyFolders", null);
        }
        if ((filters = exportModel.getSearchFilters()) != null && filters.size() > 0) {
            String name;
            ResponsibilitiesFilter respFilter;
            List notes;
            NotesFilter noteFilter;
            List keywords;
            KeywordFilter keyFilter;
            com.sas.services.information.search.DateFilter dateFilter;
            List types;
            PublicTypeFilter typeFilter;
            String name2;
            com.sas.services.information.search.ObjectNameFilter nameFilter = (com.sas.services.information.search.ObjectNameFilter)BatchExporter.getFilter(filters, com.sas.services.information.search.ObjectNameFilter.class);
            if (nameFilter != null && (name2 = nameFilter.getName()) != null && name2.length() > 0) {
                BatchExporter.addOptionAndValue(sb, "name", name2);
                if (nameFilter.getSearchOperator() != com.sas.services.information.search.ObjectNameFilter.getDefaultOperator()) {
                    BatchExporter.addOptionAndValue(sb, "nameMatchType", nameFilter.getSearchOperator().getOperatorName());
                }
            }
            if ((typeFilter = (PublicTypeFilter)BatchExporter.getFilter(filters, PublicTypeFilter.class)) != null && (types = typeFilter.getTypes()) != null && types.size() > 0) {
                String typeNames = BatchExporter.addValuesToString(types);
                BatchExporter.addOptionAndValue(sb, "types", typeNames);
            }
            if ((dateFilter = (com.sas.services.information.search.DateFilter)BatchExporter.getFilter(filters, com.sas.services.information.search.DateFilter.class)) != null) {
                switch (dateFilter.getType()) {
                    case MODIFIED_DATE: {
                        BatchExporter.addOptionAndValue(sb, "modified", null);
                        break;
                    }
                    case CREATED_DATE: {
                        BatchExporter.addOptionAndValue(sb, "created", null);
                    }
                }
                String rangeLabel = dateFilter.getDateRangeLabel();
                if (rangeLabel != null) {
                    BatchExporter.addOptionAndValue(sb, "since", rangeLabel);
                } else {
                    DatePeriod beforeDate;
                    DatePeriod sinceDate = dateFilter.getBeginDatePeriod();
                    if (sinceDate != null) {
                        String relativeDate = DateParser.getInstance().getRelativeDateLabel((Date)sinceDate);
                        if (relativeDate == null) {
                            BatchExporter.addOptionAndValue(sb, "since", DateParser.formatDate((Date)sinceDate, (DateFormat)DateParser.DATE_FORMAT_SHORT));
                        } else {
                            BatchExporter.addOptionAndValue(sb, "since", relativeDate);
                        }
                    }
                    if ((beforeDate = dateFilter.getEndDatePeriod()) != null) {
                        String relativeDate = DateParser.getInstance().getRelativeDateLabel((Date)beforeDate);
                        if (relativeDate == null) {
                            BatchExporter.addOptionAndValue(sb, "before", DateParser.formatDate((Date)beforeDate, (DateFormat)DateParser.DATE_FORMAT_SHORT));
                        } else {
                            BatchExporter.addOptionAndValue(sb, "before", relativeDate);
                        }
                    }
                }
            }
            if ((keyFilter = (KeywordFilter)BatchExporter.getFilter(filters, KeywordFilter.class)) != null && (keywords = keyFilter.getKeywords()) != null && keywords.size() > 0) {
                BatchExporter.addOptionAndValues(sb, "keywords", keywords);
            }
            if ((noteFilter = (NotesFilter)BatchExporter.getFilter(filters, NotesFilter.class)) != null && (notes = noteFilter.getNotes()) != null && notes.size() > 0) {
                BatchExporter.addOptionAndValues(sb, "notes", notes);
            }
            if ((respFilter = (ResponsibilitiesFilter)BatchExporter.getFilter(filters, ResponsibilitiesFilter.class)) != null && (name = respFilter.getReponsiblePartyName()) != null && name.length() > 0) {
                BatchExporter.addOptionAndValue(sb, "respName", name);
                String role = respFilter.getReponsiblePartyRole();
                if (role != null && role.length() > 0) {
                    BatchExporter.addOptionAndValue(sb, "respRole", role);
                }
            }
        }
        return sb.toString();
    }

    private static List<String> getExportedObjectPaths(ExportFolderModelInterface model) throws ServiceException, RemoteException {
        List<PublicObjectNodeInterface> exportedNodes = model.getExportedNodes();
        if (exportedNodes != null && !exportedNodes.isEmpty()) {
            ArrayList<String> pathList = new ArrayList<String>(exportedNodes.size());
            for (PublicObjectNodeInterface node : exportedNodes) {
                pathList.add(node.getAbsolutePath());
            }
            return pathList;
        }
        return null;
    }

    private static SearchFilter getFilter(List<SearchFilter> filters, Class<?> filterClass) {
        if (filters == null) {
            return null;
        }
        for (SearchFilter filter : filters) {
            if (!filter.getClass().equals(filterClass)) continue;
            return filter;
        }
        return null;
    }

    private int readExportPackage() throws Exception {
        try {
            RootFolderInterface rootFolder = this._server.getRootFolder();
            ImportHandler importOperation = new ImportHandler((PublicObjectContainerInterface)rootFolder, this.configureFilteredPublicTypes(), 1);
            PromotionConfiguration config = importOperation.getPromotionConfiguration();
            config.setBatchProcess(true);
            importOperation.setSessionContext(this._session);
            ExportHelper exportHelper = ExportHelper.getExportHelper(importOperation, this._exportOperation);
            this._rc |= exportHelper.loadPackage(this._packageFile);
            if (this._rc == 0) {
                if (this._includeNewObjects) {
                    this.setObjectPaths(exportHelper.getExportedItemsPath(1));
                } else {
                    this.setObjectPaths(exportHelper.getExportedItemsPath(2));
                }
                if (!this._noExecute) {
                    PromotionUtil.backUpPackageFile(this._packageFileName);
                }
            }
        }
        catch (Exception e) {
            this._exportOperation.getLogger().error(RB.getStringResource("BatchExporter.ErrorInReadingPackage.txt"));
            throw e;
        }
        return this._rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BatchExporter exporter = new BatchExporter();
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtRuntimeExceptionHandler(true, 8));
        int rc = 0;
        try {
            exporter.parse(args);
            if (exporter._help) {
                HelpFormatter help = new HelpFormatter();
                String[] exclusions = new String[]{"locprop", "debug", "install"};
                Options helpOptions = BatchExporter.getHelpOptions((Options)exporter._options, (String[])exclusions);
                help.printHelp(80, BatchExporter.getUsage(help), RB.getStringResource("AbstractPromotionDriverOptions.Options.txt"), helpOptions, null);
                return;
            }
            rc = exporter.exportPackage();
            System.out.println(RB.getStringResource("BatchExporter.ExportComplete.txt"));
        }
        catch (ParseException e) {
            System.err.println(RB.getStringResource("AbstractPromotionDriver.InvalidOptions.txt"));
            System.err.println(e.getLocalizedMessage());
            rc = 8;
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"BatchExporter.ExportFailed.fmt.txt", (Object)e.getLocalizedMessage());
            System.err.println(msg);
            rc = 8;
        }
        finally {
            if (exporter != null) {
                rc |= exporter.getReturnCode();
                String logFileName = exporter.getLogFileName();
                if (logFileName != null) {
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"BatchExporter.ViewLog.fmt.txt", (Object)logFileName));
                }
            }
        }
        System.exit(rc);
    }
}

