/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObject;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableType2Interface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.AbstractPromotionDriver;
import com.sas.metadata.promotion.BatchCopierOptions;
import com.sas.metadata.promotion.BatchExporter;
import com.sas.metadata.promotion.BatchImporter;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.VirtualFolderManager;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.search.PublicTypeFilter;
import com.sas.services.information.search.SearchFilter;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.text.Message;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@SASScope
public class BatchCopier
extends AbstractPromotionDriver {
    private List _copyList = new ArrayList();
    private Map _pastedObjectsMap;
    private String _targetFolder = null;
    private String[] _objectPaths = null;

    private BatchCopier() {
        this.setLogFilePrefix("CopyPaste");
        this.setLogFileTimestamp(false);
        this.setAppendToLogFile(false);
    }

    public BatchCopier(String host, String port, String user, String password) {
        this();
        this.setConnection(host, port);
        this.setCredential(user, password);
    }

    public BatchCopier(SessionContextInterface session) throws ServiceException, RemoteException {
        this();
        this.setConnection(session);
    }

    @Override
    public final void setPackageFileName(String fileName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(RB.getStringResource("BatchCopier.PackageFilesUnsupported.txt"));
    }

    @Override
    public final void setPackageFile(File packageFile) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(RB.getStringResource("BatchCopier.PackageFilesUnsupported.txt"));
    }

    @Override
    protected void parse(String[] args) throws ParseException, MissingOptionException {
        this._options = new BatchCopierOptions();
        if (args == null || args.length == 0) {
            this._help = true;
            return;
        }
        super.parse(args);
        if (this._help) {
            return;
        }
        if (this._commandLine.hasOption("objects") && this._commandLine.hasOption("target")) {
            this._objectPaths = this._commandLine.getOptionValues("objects");
            this._targetFolder = this._commandLine.getOptionValue("target");
        } else if (!this._commandLine.hasOption("objects") && !this._commandLine.hasOption("target")) {
            List remainingArgs = this._commandLine.getArgList();
            if (remainingArgs.size() < 2) {
                this._help = true;
                return;
            }
            this._objectPaths = remainingArgs.subList(0, remainingArgs.size() - 1).toArray(new String[0]);
            this._targetFolder = (String)remainingArgs.get(remainingArgs.size() - 1);
        } else {
            this._help = true;
            return;
        }
    }

    public boolean isCopyAllowed(SimpleLogicalObjectInterface[] logicalObjects) {
        if (logicalObjects == null || logicalObjects.length == 0) {
            return false;
        }
        for (SimpleLogicalObjectInterface item : logicalObjects) {
            if (item instanceof com.sas.metadata.logical.FolderInterface) continue;
            TypeInterface type = item.getTypeInterface();
            if (type == null) {
                return false;
            }
            if (type instanceof TransportableType2Interface && !((TransportableType2Interface)type).isCopyAllowed()) {
                return false;
            }
            if (type instanceof TransportableTypeInterface) continue;
            return false;
        }
        return true;
    }

    public boolean isPasteAllowed() {
        return this._copyList != null && this._copyList.size() > 0;
    }

    public List getCopyList() {
        return Collections.unmodifiableList(this._copyList);
    }

    public void clearCopyList() {
        this._copyList.clear();
    }

    public void removeItemFromCopyList(SimpleLogicalObjectInterface logicalObject) {
        if (this._copyList.contains(logicalObject)) {
            this._copyList.remove(logicalObject);
        }
    }

    public int getNumberOfObjectsPasted() {
        return this._pastedObjectsMap == null ? 0 : this._pastedObjectsMap.size();
    }

    public Map getObjectsPasted() {
        return this._pastedObjectsMap;
    }

    public void copy(SimpleLogicalObjectInterface[] logicalObjects) {
        if (this.isCopyAllowed(logicalObjects)) {
            this._copyList.clear();
            int length = logicalObjects.length;
            for (int i = 0; i < length; ++i) {
                this._copyList.add(logicalObjects[i]);
            }
        }
    }

    public int paste(com.sas.metadata.logical.FolderInterface targetFolder) throws MetadataPromotionException {
        int rc = 0;
        this._pastedObjectsMap = null;
        if (this.isPasteAllowed()) {
            File packageFile = null;
            if (targetFolder == null) {
                throw new IllegalArgumentException(RB.getStringResource("BatchCopier.MissingPath.txt"));
            }
            SimpleLogicalObjectInterface[] selectedObjects = this._copyList.toArray(new SimpleLogicalObjectInterface[0]);
            if (this.isPastingObjectsIntoRoot(targetFolder, selectedObjects)) {
                throw new MetadataPromotionException(RB.getStringResource("BatchCopier.ObjectsUnderRoot.txt"));
            }
            try {
                this.initialize();
                if (!(targetFolder.isRoot() || VirtualFolderManager.isVirtualFolderId((String)targetFolder.getID()) || PromotionUtil.isFolderWriteAuthorized(this._factory, targetFolder.getID(), false))) {
                    throw new MetadataPromotionException(Message.format((ResourceBundle)RB.getResources(), (String)"BatchCopier.NoPermission.fmt.txt", (Object)targetFolder.getName()));
                }
                packageFile = File.createTempFile("CopyPaste", ".spk");
                rc |= this.runExport(packageFile, selectedObjects);
                rc |= this.runImport(packageFile, targetFolder);
            }
            catch (Exception e) {
                if (e instanceof MetadataPromotionException) {
                    throw (MetadataPromotionException)((Object)e);
                }
                throw new MetadataPromotionException(e);
            }
            finally {
                if (packageFile != null) {
                    packageFile.delete();
                }
                try {
                    this.terminate();
                }
                catch (Exception e) {
                    throw new MetadataPromotionException(e);
                }
            }
        }
        return rc;
    }

    private int runExport(File packageFile, SimpleLogicalObjectInterface[] selectedObjects) throws Exception {
        BatchExporter exporter = new BatchExporter(this._session);
        exporter.setParent(this);
        exporter.setLogFile(null);
        exporter.setExportMode(2);
        exporter.setPackageFile(packageFile);
        exporter.setGenerateExternalSubstitutionProperties(false);
        exporter.setGenerateLocalizableProperties(false);
        exporter.initialize();
        exporter.setSelectedObjects(selectedObjects);
        List<String> supportedTypes = this.configureFilteredPublicTypes();
        if (supportedTypes != null) {
            exporter.addSearchFilter((SearchFilter)new PublicTypeFilter(supportedTypes));
        }
        int rc = exporter.exportPackage();
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runImport(File packageFile, com.sas.metadata.logical.FolderInterface targetFolder) throws Exception {
        int rc = 0;
        BatchImporter importer = new BatchImporter(this._session);
        try {
            importer.setParent(this);
            importer.setLogFile(null);
            importer.setImportMode(2);
            importer.setPackageFile(packageFile);
            importer.setLocalize(false);
            importer.setTargetFolder(targetFolder);
            importer.setIncludeSecurity(true);
            rc = importer.importPackage();
        }
        finally {
            this._pastedObjectsMap = importer.getObjectsImported();
        }
        return rc;
    }

    public boolean hasTargetFolderPermissions(com.sas.metadata.logical.FolderInterface targetFolder) throws MdException, RemoteException {
        if (targetFolder != null && !targetFolder.isRoot()) {
            return PromotionUtil.isFolderWriteAuthorized(this._factory, targetFolder.getID(), false);
        }
        return true;
    }

    private boolean isPastingObjectsIntoRoot(com.sas.metadata.logical.FolderInterface targetFolder, SimpleLogicalObjectInterface[] selectedObjects) {
        if (targetFolder.isRoot()) {
            for (SimpleLogicalObjectInterface logicalObject : selectedObjects) {
                String type = logicalObject.getTypeInterface().getPublicType();
                if ("Folder".equalsIgnoreCase(type)) continue;
                return true;
            }
        }
        return false;
    }

    private com.sas.metadata.logical.FolderInterface getFolder() throws ServiceException, RemoteException, LogicalTypeException {
        if (this._targetFolder == null) {
            throw new IllegalArgumentException(RB.getStringResource("BatchCopier.MissingPath.txt"));
        }
        PathUrl path = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this._server, (String)this._targetFolder);
        if (path == null) {
            throw new IllegalArgumentException(RB.getStringResource("BatchCopier.MissingPath.txt"));
        }
        if (path.getType() == null) {
            path.setType("Folder");
        }
        if (path.getPath() == null && String.valueOf('/').equals(path.getName())) {
            Factory factory = Factory.getInstance();
            return factory.getRootFolder();
        }
        MetadataInterface mi = this._server.getObjectByPath(path);
        if (mi == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"BatchCopier.FolderNotFound.fmt.txt", (Object)path.getDisplayPath()));
        }
        if (!(mi instanceof FolderInterface)) {
            throw new ServiceException(RB.getStringResource("BatchCopier.NotAFolder.txt"));
        }
        Tree tree = (Tree)mi.getRepositoryEntity();
        Factory factory = Factory.getInstance();
        return (com.sas.metadata.logical.FolderInterface)factory.getObject((Root)tree);
    }

    private SimpleLogicalObjectInterface[] getSelectedItems() throws ServiceException, RemoteException, LogicalTypeException {
        if (this._objectPaths == null || this._objectPaths.length == 0) {
            throw new IllegalArgumentException(RB.getStringResource("BatchCopier.NoObjects.txt"));
        }
        ArrayList<Object> objectList = new ArrayList<Object>();
        if (this._objectPaths.length == 1 && this._objectPaths[0].equalsIgnoreCase(String.valueOf('/'))) {
            Factory factory = Factory.getInstance();
            com.sas.metadata.logical.FolderInterface rootFolder = factory.getRootFolder();
            if (rootFolder != null) {
                objectList.add(rootFolder);
            }
        } else {
            for (String path : this._objectPaths) {
                SimpleLogicalObjectInterface logicalObject;
                MetadataInterface mi;
                PathUrl url = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this._server, (String)path);
                if (url.getType() == null) {
                    url.setType("Folder");
                }
                if ((mi = this._server.getObjectByPath(url)) == null || (logicalObject = this.getLogicalObject(mi)) == null) continue;
                objectList.add(logicalObject);
            }
        }
        return objectList.toArray(new SimpleLogicalObjectInterface[objectList.size()]);
    }

    private SimpleLogicalObjectInterface getLogicalObject(MetadataInterface mi) throws ServiceException, RemoteException, LogicalTypeException {
        TypeDescriptorInterface type = mi.getTypeDescriptor();
        if (type != null) {
            SimpleLogicalObjectInterface logicalObject = this.createSimpleLogicalObject(mi.getName(), mi.getIdentifier(), type.getTypeName());
            return logicalObject;
        }
        return null;
    }

    private SimpleLogicalObjectInterface createSimpleLogicalObject(String name, String id, String type) throws RemoteException, LogicalTypeException {
        Factory factory = Factory.getInstance();
        TypeInterface ti = factory.getTypeInterface(type);
        return ti != null && ti instanceof TransportableTypeInterface ? new SimpleLogicalObject(name, id, ti) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BatchCopier copier = new BatchCopier();
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtRuntimeExceptionHandler(true, 8));
        int rc = 0;
        try {
            copier.parse(args);
            if (copier._help) {
                HelpFormatter help = new HelpFormatter();
                String[] exclusions = new String[]{"debug"};
                Options helpOptions = BatchCopier.getHelpOptions((Options)copier._options, (String[])exclusions);
                help.printHelp(80, BatchCopier.getUsage(help), RB.getStringResource("AbstractPromotionDriverOptions.Options.txt"), helpOptions, null);
                return;
            }
            copier.initialize();
            copier.validateSetup();
            SimpleLogicalObjectInterface[] objectsToCopy = copier.getSelectedItems();
            copier.copy(objectsToCopy);
            com.sas.metadata.logical.FolderInterface folder = copier.getFolder();
            rc = copier.paste(folder);
            System.out.println(RB.getStringResource("BatchCopier.Complete.txt"));
        }
        catch (ParseException e) {
            System.err.println(RB.getStringResource("AbstractPromotionDriver.InvalidOptions.txt"));
            System.err.println(e.getLocalizedMessage());
            rc = 8;
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"BatchCopier.Failed.fmt.txt", (Object)e.getLocalizedMessage());
            System.err.println(msg);
            rc = 8;
        }
        finally {
            if (copier != null) {
                rc |= copier.getReturnCode();
                String logFileName = copier.getLogFileName();
                if (logFileName != null) {
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"BatchCopier.ViewLog.fmt.txt", (Object)logFileName));
                }
            }
        }
        System.exit(rc);
    }

    private static String getUsage(HelpFormatter help) {
        String NEW_LINE = help.getNewLine();
        StringBuffer usage = new StringBuffer();
        usage.append("CopyObjects [options...] -objects objectPath ... -target folderPath");
        usage.append(NEW_LINE).append("CopyObjects [options...] objectPath ... folderPath");
        usage.append(NEW_LINE).append(NEW_LINE);
        usage.append(RB.getStringResource("BatchCopier.HelpExample1.txt"));
        usage.append(NEW_LINE).append("CopyObjects -profile \"Default\" \"/Shared Data\" \"/Target Folder\"");
        usage.append(NEW_LINE);
        return usage.toString();
    }
}

