/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.MetadataFilterInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.XMLUtil;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.util.Strings;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class BIPTreeUtil {
    public static final String OMR_NAME_BIP_SERVICE = "BIP Service";
    public static final String BIP_SERVICE_CLASSID = "E5F27790-2149-11D6-8828-AA0004006D06";
    public static final String BIPTREE_TYPE = "BIP Folder";
    public static final String BIPTREE = "BIPTree";
    public static final String FOLDER = "Folder";
    public static final char TREEPATH_SEPARATOR = '/';

    public static String buildPublicTypeXMLSelect(String publicType) {
        if (publicType == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(55);
        int index = publicType.indexOf(46);
        if (index > -1) {
            sb.append("@PublicType=:'").append(publicType.substring(0, index)).append("'");
        } else {
            sb.append("(@PublicType='").append(publicType).append("' OR @PublicType=:'").append(publicType).append(".')");
        }
        return sb.toString();
    }

    public static Tree getRootFolder(Tree childFolder) throws MdException, RemoteException {
        Tree parent = childFolder;
        while (parent.getParentTree() != null) {
            parent = parent.getParentTree();
        }
        return parent;
    }

    public static List<String> getParentTreePath(Tree tree) throws MdException, RemoteException {
        ArrayList<String> path = new ArrayList<String>();
        while (tree != null) {
            path.add(tree.getName());
            tree = tree.getParentTree();
        }
        Collections.reverse(path);
        return path;
    }

    public static List<String> getParentTreePathNoServer(Tree tree) throws MdException, RemoteException {
        ArrayList<String> path = new ArrayList<String>();
        while (tree != null) {
            path.add(tree.getName());
            AssociationList trees = tree.getParentTrees(false);
            if (trees == null || trees.size() == 0) {
                if (tree.getSoftwareComponents(false).size() > 0) break;
                return null;
            }
            tree = (Tree)trees.get(0);
        }
        Collections.reverse(path);
        return path;
    }

    public static List<String> getParentOnlyTreePath(Tree tree) throws MdException, RemoteException {
        ArrayList<String> path = new ArrayList<String>();
        for (tree = tree.getParentTree(); tree != null; tree = tree.getParentTree()) {
            path.add(tree.getName());
        }
        Collections.reverse(path);
        return path;
    }

    public static String getTreePathToDisplay(Tree tree) throws RemoteException {
        try {
            List<String> path = BIPTreeUtil.getParentTreePath(tree);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < path.size(); ++i) {
                sb.append('/');
                sb.append(path.get(i));
            }
            return sb.toString();
        }
        catch (MdException e) {
            return tree.getName();
        }
    }

    public static String buildXMLSelectForFolder(MdFactory factory, String[] path) throws MdException, RemoteException {
        if (path == null || path.length == 0) {
            return "";
        }
        Map rootFoldersMap = BIPTreeUtil.loadRootFolders(factory);
        List rootFolders = (List)rootFoldersMap.get("SoftwareTrees");
        if (rootFolders != null) {
            String rootFolderName = path[0];
            String rootFolderID = null;
            for (Map rootFolder : rootFolders) {
                String name = (String)rootFolder.get("Name");
                if (!rootFolderName.equalsIgnoreCase(name)) continue;
                rootFolderID = (String)rootFolder.get("Id");
                break;
            }
            if (rootFolderID != null) {
                return BIPTreeUtil.buildXMLSelectForFolder(path, rootFolderID);
            }
        }
        return "";
    }

    public static String buildXMLSelectForRootFolder(String rootFolderName, String bipServiceID) {
        StringBuffer sb = new StringBuffer();
        sb.append("<XMLSelect search=\"*[@Name='");
        sb.append(XMLUtil.cleanStringForXML(rootFolderName));
        sb.append("' and @PublicType='Folder'][");
        sb.append("SoftwareComponents/SoftwareComponent[@Id='" + bipServiceID + "']]");
        sb.append("\"/>");
        return sb.toString();
    }

    public static String buildXMLSelectForFolder(String[] path, String rootFolderID) {
        if (path == null || path.length == 0 || rootFolderID == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int length = path.length;
        if (length == 1) {
            sb.append("<XMLSelect search=\"*[@Id='");
            sb.append(rootFolderID);
            sb.append("']\"/>");
        } else {
            String folderName = path[length - 1];
            sb.append("<XMLSelect search=\"*[@Name='");
            sb.append(XMLUtil.cleanStringForXML(folderName));
            sb.append("' and @PublicType='Folder'][");
            if (length > 1) {
                for (int i = length - 2; i > 0; --i) {
                    if (i != length - 2) {
                        sb.append("/");
                    }
                    String name = path[i];
                    sb.append("ParentTree/Tree[@Name='");
                    sb.append(XMLUtil.cleanStringForXML(name));
                    sb.append("' and @PublicType='Folder']");
                    if (i != 0) continue;
                    sb.append("/");
                }
            }
            sb.append("ParentTree/Tree[@Id='" + rootFolderID + "']]");
            sb.append("\"/>");
        }
        return sb.toString();
    }

    public static String buildXMLSelectForVirtualFolderMember(String name, String publicType) {
        StringBuffer sb = new StringBuffer();
        sb.append("<XMLSelect search=\"*[@Name='");
        sb.append(XMLUtil.cleanStringForXML(name));
        sb.append("' and ");
        sb.append(BIPTreeUtil.buildPublicTypeXMLSelect(publicType));
        sb.append("]\"/>");
        return sb.toString();
    }

    public static String buildXMLSelectForObject(String[] path, String publicType, String rootFolderID) {
        if (path == null || path.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int length = path.length;
        if (length == 1) {
            throw new IllegalArgumentException("Invalid object path: " + BIPTreeUtil.pathToString(path));
        }
        String folderName = path[length - 1];
        sb.append("<XMLSelect search=\"*[@Name='");
        sb.append(XMLUtil.cleanStringForXML(folderName));
        sb.append("' and ");
        sb.append(BIPTreeUtil.buildPublicTypeXMLSelect(publicType));
        sb.append("][");
        if (length == 2) {
            sb.append("Trees/Tree[@Id='" + rootFolderID + "']]");
        } else {
            for (int i = length - 2; i > 0; --i) {
                String name = path[i];
                if (i != length - 2) {
                    sb.append("/ParentTree/Tree[@Name='");
                } else {
                    sb.append("Trees/Tree[@Name='");
                }
                sb.append(XMLUtil.cleanStringForXML(name));
                sb.append("' and (@PublicType='Folder' or @PublicType=:'Folder.')]");
                if (i != 0) continue;
                sb.append("/");
            }
            sb.append("/ParentTree/Tree[@Id='" + rootFolderID + "']]");
        }
        sb.append("\"/>");
        return sb.toString();
    }

    public static Map getMapOfParentFolder(MdFactory factory, String reposID, String[] path, boolean includeMembers, boolean includeSubtrees) throws MdException, RemoteException {
        if (reposID == null) {
            reposID = factory.getOMIUtil().getFoundationReposID();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<Templates><Tree Name=\"\" PublicType=\"\">");
        if (includeMembers) {
            sb.append("<Members/>");
        }
        if (includeSubtrees) {
            sb.append("<Subtrees search=\"@PublicType='Folder'\"/>");
        }
        sb.append("</Tree><Root Name=\"\" PublicType=\"\" /></Templates>");
        sb.append(BIPTreeUtil.buildXMLSelectForFolder(factory, path));
        int flags = 404;
        List items = factory.getOMIUtil().getMetadataObjectsNoCache("Tree", reposID, sb.toString(), flags);
        if (items != null && items.size() > 0) {
            Map folder = (Map)items.get(0);
            return folder;
        }
        return null;
    }

    public static Map getMapOfParentFolder(MdFactory factory, String reposID, String rootFolderID, String[] path, boolean includeMembers, boolean includeSubtrees) throws MdException, RemoteException {
        if (reposID == null) {
            reposID = rootFolderID != null && rootFolderID.length() > 0 ? "A0000001." + rootFolderID.substring(0, 8) : factory.getOMIUtil().getFoundationReposID();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<Templates><Tree Name=\"\" PublicType=\"\">");
        if (includeMembers) {
            sb.append("<Members/>");
        }
        if (includeSubtrees) {
            sb.append("<Subtrees search=\"@PublicType='Folder'\"/>");
        }
        sb.append("</Tree><Root Name=\"\" PublicType=\"\" /></Templates>");
        sb.append(BIPTreeUtil.buildXMLSelectForFolder(path, rootFolderID));
        int flags = 404;
        List items = factory.getOMIUtil().getMetadataObjectsNoCache("Tree", reposID, sb.toString(), flags);
        if (items != null && items.size() > 0) {
            Map folder = (Map)items.get(0);
            return folder;
        }
        return null;
    }

    public static Map loadObjectsUnderFolder(MdFactory factory, String folderID, TypeInterface[] supportedTypes) throws MdException, RemoteException {
        return BIPTreeUtil.loadObjectsUnderFolder(factory, folderID, supportedTypes, true);
    }

    public static Map loadObjectsUnderFolder(MdFactory factory, String folderID, TypeInterface[] supportedTypes, boolean recursive) throws MdException, RemoteException {
        return BIPTreeUtil.loadObjectsUnderFolder(factory, folderID, supportedTypes, recursive, 0);
    }

    public static Map loadObjectsUnderFolderProjectOnly(MdFactory factory, String folderID, TypeInterface[] supportedTypes, boolean recursive) throws MdException, RemoteException {
        String reposID = folderID.substring(0, 8);
        StringBuffer templateBuffer = new StringBuffer();
        templateBuffer.append("<Templates><Tree Name=\"\" TreeType=\"\" PublicType=\"\" >");
        if (recursive) {
            templateBuffer.append("<SubTrees search=\"@Id=:'" + reposID + "' and @PublicType='Folder'\"/>");
        }
        if (supportedTypes == null || supportedTypes.length == 0) {
            templateBuffer.append("<Members search=\"@Id=:'" + reposID + "'/>");
        } else {
            templateBuffer.append("<Members search=\"");
            templateBuffer.append("@Id=:'" + reposID + "' and (");
            int length = supportedTypes.length;
            for (int i = 0; i < length; ++i) {
                String publicType = supportedTypes[i].getPublicType();
                templateBuffer.append(BIPTreeUtil.buildPublicTypeXMLSelect(publicType));
                if (i == length - 1) continue;
                templateBuffer.append(" OR ");
            }
            templateBuffer.append(")\"/>");
        }
        templateBuffer.append("</Tree>");
        templateBuffer.append("<Root Name=\"\" PublicType=\"\" />");
        templateBuffer.append("</Templates>");
        int flags = 404;
        Map treeMap = factory.getOMIUtil().getMetadataNoCache("Tree", folderID, templateBuffer.toString(), flags);
        return treeMap;
    }

    public static Map loadObjectsUnderFolder(MdFactory factory, String folderID, TypeInterface[] supportedTypes, boolean recursive, int additionalFlags) throws MdException, RemoteException {
        StringBuffer templateBuffer = new StringBuffer();
        templateBuffer.append("<Templates><Tree Name=\"\" TreeType=\"\" PublicType=\"\" >");
        if (recursive) {
            templateBuffer.append("<SubTrees search=\"@PublicType='Folder'\"/>");
        }
        if (supportedTypes == null || supportedTypes.length == 0) {
            templateBuffer.append("<Members/>");
        } else {
            templateBuffer.append("<Members search=\"");
            int length = supportedTypes.length;
            for (int i = 0; i < length; ++i) {
                String publicType = supportedTypes[i].getPublicType();
                templateBuffer.append(BIPTreeUtil.buildPublicTypeXMLSelect(publicType));
                if (i == length - 1) continue;
                templateBuffer.append(" OR ");
            }
            templateBuffer.append("\"/>");
        }
        templateBuffer.append("</Tree>");
        templateBuffer.append("<Root Name=\"\" PublicType=\"\" />");
        templateBuffer.append("</Templates>");
        int flags = 404;
        if (additionalFlags > 0) {
            flags |= additionalFlags;
        }
        Map treeMap = factory.getOMIUtil().getMetadataNoCache("Tree", folderID, templateBuffer.toString(), flags);
        return treeMap;
    }

    public static Map loadObjectsUnderFolder(MdFactory factory, String folderID, MetadataFilterInterface[] filters) throws MdException, RemoteException {
        StringBuffer templateBuffer = new StringBuffer();
        templateBuffer.append("<Templates><Tree Name=\"\" TreeType=\"\" PublicType=\"\" ><SubTrees search=\"@PublicType='Folder'\"/>");
        if (filters == null || filters.length == 0) {
            templateBuffer.append("<Members/>");
        } else {
            int numFiltersApplied = 0;
            templateBuffer.append("<Members search=\"");
            for (MetadataFilterInterface filter : filters) {
                String filterString = filter.getFilterString();
                if (filterString == null || filterString.length() <= 0) continue;
                if (numFiltersApplied > 0) {
                    templateBuffer.append(" AND ");
                }
                templateBuffer.append("(");
                templateBuffer.append(filterString);
                templateBuffer.append(")");
                ++numFiltersApplied;
            }
            templateBuffer.append("\"/>");
        }
        templateBuffer.append("</Tree>");
        templateBuffer.append("<Root Name=\"\" PublicType=\"\" />");
        templateBuffer.append("</Templates>");
        int flags = 404;
        Map treeMap = factory.getOMIUtil().getMetadataNoCache("Tree", folderID, templateBuffer.toString(), flags);
        return treeMap;
    }

    public static Map searchForFolder(MdFactory factory, String xmlSelect, String reposID, boolean includeMembers, TypeInterface[] supportedTypes, boolean recursive) throws MdException, RemoteException {
        return BIPTreeUtil.searchForFolder(factory, xmlSelect, reposID, supportedTypes, false);
    }

    public static Map searchForFolder(MdFactory factory, String xmlSelect, String reposID, TypeInterface[] supportedTypes, boolean isProjectRepos) throws MdException, RemoteException {
        List folderList;
        StringBuffer templateBuffer = new StringBuffer();
        templateBuffer.append(xmlSelect);
        templateBuffer.append("<Templates><Tree Name=\"\" TreeType=\"\" PublicType=\"\" >");
        if (supportedTypes == null || supportedTypes.length == 0) {
            templateBuffer.append("<Members/>");
        } else {
            templateBuffer.append("<Members search=\"");
            int length = supportedTypes.length;
            for (int i = 0; i < length; ++i) {
                String publicType = supportedTypes[i].getPublicType();
                templateBuffer.append(BIPTreeUtil.buildPublicTypeXMLSelect(publicType));
                if (i == length - 1) continue;
                templateBuffer.append(" OR ");
            }
            templateBuffer.append("\"/>");
        }
        templateBuffer.append("</Tree>");
        templateBuffer.append("<Root Name=\"\" PublicType=\"\" />");
        templateBuffer.append("</Templates>");
        int flags = 404;
        if (isProjectRepos) {
            flags |= 0x2000;
        }
        if ((folderList = factory.getOMIUtil().getMetadataObjectsNoCache("Tree", reposID, templateBuffer.toString(), flags)) != null && folderList.size() > 0) {
            return (Map)folderList.get(0);
        }
        return null;
    }

    public static Map searchForObject(MdFactory factory, String xmlSelect, String reposID, String metadataType) throws MdException, RemoteException {
        return BIPTreeUtil.searchForObject(factory, xmlSelect, reposID, metadataType, false);
    }

    public static Map searchForObject(MdFactory factory, String xmlSelect, String reposID, String metadataType, boolean isProjectRepos) throws MdException, RemoteException {
        List objectList;
        StringBuffer templateBuffer = new StringBuffer();
        templateBuffer.append(xmlSelect);
        templateBuffer.append("<Templates><Root Name=\"\" PublicType=\"\" /></Templates>");
        int flags = 404;
        if (isProjectRepos) {
            flags |= 0x2000;
        }
        if ((objectList = factory.getOMIUtil().getMetadataObjectsNoCache(metadataType, reposID, templateBuffer.toString(), flags)) != null && objectList.size() > 0) {
            return (Map)objectList.get(0);
        }
        return null;
    }

    public static Map loadRootFolders(MdFactory factory, String bipServiceID) throws MdException, RemoteException {
        String template = "<Templates><SoftwareComponent><SoftwareTrees search=\"@PublicType='Folder'\"/></SoftwareComponent><Tree Name=\"\" TreeType=\"\" PublicType=\"\" /></Templates>";
        int flags = 260;
        Map treeMap = factory.getOMIUtil().getMetadataNoCache("SoftwareComponent", bipServiceID, template, flags);
        return treeMap;
    }

    public static Map loadRootFolders(MdFactory factory) throws MdException, RemoteException {
        int flags = 384;
        StringBuffer sb = new StringBuffer();
        sb.append("<XMLSelect search=\"*[@Name='").append(OMR_NAME_BIP_SERVICE);
        sb.append("' and @ClassIdentifier='").append(BIP_SERVICE_CLASSID);
        sb.append("']\"/>");
        String reposID = factory.getOMIUtil().getFoundationReposID();
        List objects = factory.getOMIUtil().getMetadataObjectsNoCache("SoftwareComponent", reposID, sb.toString(), flags);
        if (objects.size() == 0) {
            throw new MdException("Software Component does not exist in target repository");
        }
        Map sc = (Map)objects.get(0);
        String bipServiceID = (String)sc.get("Id");
        return BIPTreeUtil.loadRootFolders(factory, bipServiceID);
    }

    public static Map getMapOfRootFolders(MdFactory factory) throws MdException, RemoteException {
        List softwareTrees;
        Map map = BIPTreeUtil.loadRootFolders(factory);
        if (map != null && (softwareTrees = (List)map.get("SoftwareTrees")) != null) {
            HashMap<String, String> rootFolderMap = new HashMap<String, String>(softwareTrees.size());
            for (Map folder : softwareTrees) {
                String id = (String)folder.get("Id");
                String name = (String)folder.get("Name");
                rootFolderMap.put(id, name);
            }
            return rootFolderMap;
        }
        return null;
    }

    private static List<String> getTreeList(String search, int startPos) {
        ArrayList<String> trees = new ArrayList<String>();
        if (startPos > -1) {
            String s = search.substring(startPos == 0 ? 0 : startPos + 7);
            int index = -1;
            startPos = 0;
            while ((index = s.indexOf("@Name", startPos)) > -1) {
                int end = s.indexOf("'][", index + 7);
                if (end == -1) {
                    end = s.indexOf("']", index + 7);
                }
                if (end == -1) continue;
                String treeName = s.substring(index + 7, end);
                trees.add(treeName);
                startPos = end;
            }
            Collections.reverse(trees);
        }
        return trees;
    }

    public static List<String> getParentFolderList(String search, boolean isFolder) {
        int startIndex = isFolder ? search.indexOf("[ParentTree/") : search.indexOf("[Trees/");
        return BIPTreeUtil.getTreeList(search, startIndex);
    }

    public static SoftwareComponent getBIPService(MdFactory factory, MdObjectStore store, String reposID) throws MdException, RemoteException {
        return BIPTreeUtil.getBIPService(factory, store, reposID, false);
    }

    public static SoftwareComponent getBIPService(MdFactory factory, MdObjectStore store, String reposID, boolean includeFolders) throws MdException, RemoteException {
        List objects;
        int flags = 392;
        StringBuffer sb = new StringBuffer();
        sb.append("<XMLSelect search=\"*[@Name='").append(OMR_NAME_BIP_SERVICE);
        sb.append("' and @ClassIdentifier='").append(BIP_SERVICE_CLASSID);
        sb.append("']\"/>");
        if (includeFolders) {
            sb.append("<Templates><SoftwareComponent><SoftwareTrees search=\"@PublicType='Folder'\"/></SoftwareComponent></Templates>");
            flags |= 4;
        }
        if ((objects = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, reposID, "SoftwareComponent", flags, sb.toString(), false)).size() == 0) {
            throw new MdException("Software Component does not exist in target repository");
        }
        return (SoftwareComponent)objects.get(0);
    }

    public static Tree getFolder(MdFactory factory, MdObjectStore store, String folderID) throws MdException, RemoteException {
        int flags = 264;
        Tree tree = (Tree)factory.getOMIUtil().getMetadataAllDepths((MdStore)store, "Tree", folderID, null, null, "", flags);
        return tree;
    }

    public static Tree getFolder(MdFactory factory, MdObjectStore store, String reposID, String[] path) throws MdException, RemoteException {
        return BIPTreeUtil.getFolder(factory, store, reposID, null, path);
    }

    public static Tree getFolder(MdFactory factory, MdObjectStore store, String reposID, String rootFolderID, String[] path) throws MdException, RemoteException {
        String xmlSelect = null;
        xmlSelect = rootFolderID == null ? BIPTreeUtil.buildXMLSelectForFolder(factory, path) : BIPTreeUtil.buildXMLSelectForFolder(path, rootFolderID);
        if (xmlSelect == null || xmlSelect.length() == 0) {
            return null;
        }
        StringBuffer templateBuffer = new StringBuffer();
        templateBuffer.append("<Templates><Tree Name=\"\" TreeType=\"\" PublicType=\"\" ></Tree></Templates>");
        templateBuffer.append(xmlSelect);
        int flags = 404;
        List folderList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, reposID, "Tree", flags, templateBuffer.toString());
        if (folderList != null && folderList.size() > 0) {
            return (Tree)folderList.get(0);
        }
        return null;
    }

    public static String getTopLevelFolderID(SoftwareComponent sc, String topLevelFolderName) throws RemoteException, MdException {
        AssociationList folders = sc.getSoftwareTrees();
        for (Tree meta : folders) {
            if (!FOLDER.equals(meta.getPublicType()) || !meta.getName().equalsIgnoreCase(topLevelFolderName)) continue;
            return meta.getId();
        }
        return null;
    }

    public static List<String> pathToList(String[] path) {
        ArrayList<String> list = new ArrayList<String>(path.length);
        for (int i = 0; i < path.length; ++i) {
            list.add(path[i]);
        }
        return list;
    }

    public static String pathToString(List<String> path) {
        StringBuffer sb = new StringBuffer();
        int len = path.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append('/');
            }
            sb.append(path.get(i));
        }
        return sb.toString();
    }

    public static String pathToString(String[] path) {
        return BIPTreeUtil.pathToString(path, null, null);
    }

    public static String pathToString(String[] path, String objectName) {
        return BIPTreeUtil.pathToString(path, objectName, null);
    }

    public static String pathToString(String[] path, String objectName, String publicType) {
        int length;
        StringBuffer sb = new StringBuffer();
        int n = length = path == null ? 0 : path.length;
        if (length == 0) {
            sb.append('/');
        } else {
            for (int i = 0; i < length; ++i) {
                sb.append('/');
                sb.append(path[i]);
            }
        }
        if (objectName != null) {
            if (sb.charAt(sb.length() - 1) != '/') {
                sb.append('/');
            }
            sb.append(objectName);
            if (publicType != null) {
                int index = publicType.indexOf(46);
                if (index > -1) {
                    publicType = publicType.substring(0, index);
                }
                sb.append("(");
                sb.append(publicType);
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public static String[] getObjectPathFromServer(MdObjectStore store, String id, String type) throws MdException, RemoteException {
        Root meta = (Root)store.getObject(id, true);
        if (meta != null) {
            Tree parentTree;
            List<String> path;
            AssociationList trees;
            AssociationList associationList = trees = meta.getCMetadataType().equalsIgnoreCase("Tree") ? ((Tree)meta).getParentTrees(false) : meta.getTrees(false);
            if (trees != null && trees.size() > 0 && (path = BIPTreeUtil.getParentTreePathNoServer(parentTree = (Tree)trees.get(0))) != null) {
                return path.toArray(new String[0]);
            }
        }
        StringBuffer sb = new StringBuffer();
        if (type.equalsIgnoreCase("Tree")) {
            sb.append("<Templates><Tree Name=\"\"><ParentTree/></Tree></Templates>");
        } else {
            sb.append("<Templates><");
            sb.append(type);
            sb.append("><Trees/></");
            sb.append(type);
            sb.append("><Tree Name=\"\"><ParentTree/><SoftwareComponents/></Tree>");
            sb.append("</Templates>");
        }
        int flags = 260;
        MdFactory factory = store.getFactory();
        meta = (Root)factory.getOMIUtil().getMetadataAllDepths((MdStore)store, type, id, null, null, sb.toString(), flags);
        if (meta instanceof Tree) {
            Tree tree = (Tree)meta;
            List<String> path = BIPTreeUtil.getParentOnlyTreePath(tree);
            return path.toArray(new String[0]);
        }
        AssociationList list = meta.getTrees();
        if (list.size() > 0) {
            List<String> path = BIPTreeUtil.getParentTreePath((Tree)list.get(0));
            return path.toArray(new String[0]);
        }
        return new String[0];
    }

    public static Tree getFolderObject(FolderInterface parentFolder, MdObjectStore store) throws RemoteException {
        MdFactory factory = store.getFactory();
        Tree tree = (Tree)factory.createComplexMetadataObject(store, parentFolder.getName(), "Tree", parentFolder.getID());
        return tree;
    }

    public static SoftwareComponent getBIPServiceObject(FolderInterface rootFolder, MdObjectStore store) throws RemoteException {
        if (!rootFolder.isRoot()) {
            throw new IllegalArgumentException("The folder argument is not the root folder.");
        }
        MdFactory factory = store.getFactory();
        SoftwareComponent sc = (SoftwareComponent)factory.createComplexMetadataObject(store, rootFolder.getName(), "SoftwareComponent", rootFolder.getID());
        return sc;
    }

    public static FolderInterface getRootFolder(MdObjectStore store) throws MdException, LogicalTypeException, RemoteException {
        MdFactory factory = store.getFactory();
        String reposID = factory.getOMIUtil().getFoundationReposID();
        SoftwareComponent sc = BIPTreeUtil.getBIPService(store.getFactory(), store, reposID);
        return (FolderInterface)Factory.getInstance().getObject((Root)sc);
    }

    public static boolean isFolder(PromotionItemInterface item) {
        String publicType = item.getTypeInterface().getPublicType();
        return FOLDER.equalsIgnoreCase(publicType);
    }

    public static String[] getFolderPathWithName(String folderName, String[] parentPath) {
        int newLength = parentPath.length + 1;
        String[] newPath = new String[newLength];
        System.arraycopy(parentPath, 0, newPath, 0, parentPath.length);
        newPath[newLength - 1] = folderName;
        return newPath;
    }

    public static String getFolderPath(MdObjectStore store, SimpleLogicalObjectInterface folder) throws MdException, RemoteException {
        String[] path = BIPTreeUtil.getObjectPathFromServer(store, folder.getID(), "Tree");
        return BIPTreeUtil.pathToString(path, folder.getName());
    }

    public static List<String> getFolderPathAsList(String folder) {
        StringTokenizer st = new StringTokenizer(folder, String.valueOf('/'));
        ArrayList<String> pathList = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            pathList.add(token);
        }
        return pathList;
    }

    public static List getUniqueParentFolders(List folderPaths) {
        if (folderPaths == null || folderPaths.size() <= 1) {
            return folderPaths;
        }
        BIPTreeUtil.sortFolderPathsByLevel(folderPaths);
        ArrayList<String> parentFolders = new ArrayList<String>();
        for (String path : folderPaths) {
            if (BIPTreeUtil.isChildFolder(path, parentFolders)) continue;
            parentFolders.add(path);
        }
        return parentFolders;
    }

    private static boolean isChildFolder(String folderPath, List paths) {
        if (paths.size() > 0) {
            for (String parentPath : paths) {
                if (parentPath.charAt(parentPath.length() - 1) != '/') {
                    parentPath = parentPath + '/';
                }
                if (!folderPath.contains(parentPath)) continue;
                return true;
            }
        }
        return false;
    }

    public static void sortFolderPathsByLevel(List folderPaths) {
        Comparator levelSorter = new Comparator(){

            public int compare(Object obj1, Object obj2) {
                if (obj1 == obj2) {
                    return 0;
                }
                if (obj1 == null || !(obj1 instanceof String)) {
                    return -1;
                }
                if (obj2 == null || !(obj2 instanceof String)) {
                    return 1;
                }
                return this.runCompare((String)obj1, (String)obj2);
            }

            private int runCompare(String path1, String path2) {
                int numLevels2;
                int numLevels1 = Strings.count((String)path1, (int)0, (int)(path1.length() - 1), (char)'/');
                if (numLevels1 == (numLevels2 = Strings.count((String)path2, (int)0, (int)(path2.length() - 1), (char)'/'))) {
                    return 0;
                }
                if (numLevels1 < numLevels2) {
                    return -1;
                }
                return 1;
            }
        };
        Collections.sort(folderPaths, levelSorter);
    }
}

