/*
 * Decompiled with CFR 0.152.
 */
package com.sas.filter.model;

import com.sas.filter.model.FilterRule;
import com.sas.filter.model.FilterSelector;
import com.sas.workspace.WorkspaceFile;
import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FilterUtil {
    private static final ResourceBundle m_bundle = FilterUtil.getMyResourceBundle(FilterUtil.class);
    public static final String OMR_DATEFORMAT = "ddMMMyyyy:HH:mm:ss";
    public static final String ALLRULE = m_bundle.getString("FilterUtil.Filter.All.txt");
    public static final String NONERULE = m_bundle.getString("FilterUtil.Filter.None.txt");

    public static ResourceBundle getMyResourceBundle(Class<?> source) {
        Locale locale = Locale.getDefault();
        String strClassName = source.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        try {
            return ResourceBundle.getBundle(strBundlePath, locale);
        }
        catch (Throwable e) {
            try {
                return PropertyResourceBundle.getBundle(strBundlePath, locale);
            }
            catch (Throwable e2) {
                return null;
            }
        }
    }

    public static Document parseXML(String strXML) throws ParserConfigurationException, SAXException, IOException {
        StringReader strReader = new StringReader(strXML);
        Document doc = null;
        DocumentBuilder docBld = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        doc = docBld.parse(new InputSource(strReader));
        return doc;
    }

    private static String buildKey(String tag, String name) {
        if (name == null) {
            return tag;
        }
        return tag + "_" + name;
    }

    private static String parsePropName(String tag, String key) {
        return key.substring(tag.length() + 1);
    }

    public static String getFilePath(String product, String version, String myfile) {
        String pathsep = System.getProperty("file.separator");
        String OS = System.getProperty("os.name").toLowerCase();
        String appData = null;
        appData = OS.indexOf("windows") > -1 ? System.getenv("APPDATA") + pathsep + "SAS" : System.getProperty("user.home") + pathsep + ".SASAppData";
        return appData + pathsep + product + pathsep + version + pathsep + myfile;
    }

    public static FilterSelector getFilter(WorkspaceFile work, String filterName, String tag) {
        String content = work.getPropertyString(FilterUtil.buildKey(tag, filterName), "");
        FilterSelector filter = new FilterSelector(filterName);
        filter.initFromDefinition(content, true);
        return filter;
    }

    public static boolean updateFilter(WorkspaceFile work, FilterSelector filter, String tag) {
        String newcontent = filter.generateDefinition();
        String filterName = filter.toString();
        if (filterName.compareTo(ALLRULE) == 0 || filterName.compareTo(NONERULE) == 0) {
            return true;
        }
        String filterKey = FilterUtil.buildKey(tag, filterName);
        String oldcontent = work.getPropertyString(filterKey, "");
        if (oldcontent.compareTo(newcontent) != 0) {
            work.setPropertyString(filterKey, newcontent);
            return work.saveExisting();
        }
        return true;
    }

    public static boolean writeFilter(WorkspaceFile work, FilterSelector filter, String tag) {
        String filterName = filter.toString();
        if (filterName.compareTo(ALLRULE) == 0 || filterName.compareTo(NONERULE) == 0) {
            return false;
        }
        String content = filter.generateDefinition();
        String filterKey = FilterUtil.buildKey(tag, filterName);
        work.setPropertyString(filterKey, content);
        String mainKey = FilterUtil.buildKey(tag, null);
        String mainProp = work.getPropertyString(mainKey, "");
        if (mainProp.length() > 0) {
            if (mainProp.indexOf(filterName) == -1) {
                mainProp = mainProp + ":" + filterName;
                work.setPropertyString(mainKey, mainProp);
            }
        } else {
            work.setPropertyString(mainKey, filterName);
        }
        work.saveExisting();
        return true;
    }

    public static boolean removeFilter(WorkspaceFile work, FilterSelector filter, String tag) {
        if (filter == null) {
            return true;
        }
        String filterKey = FilterUtil.buildKey(tag, filter.toString());
        work.removeProperty(filterKey);
        String filterName = FilterUtil.parsePropName(tag, filterKey);
        String mainKey = FilterUtil.buildKey(tag, null);
        String mainProp = work.getPropertyString(mainKey, "");
        int start = mainProp.indexOf(filterName);
        if (start != -1) {
            String temp;
            int end = mainProp.indexOf(58, start);
            mainProp = end == -1 ? (start == 0 ? "" : mainProp.substring(0, start - 1)) : (temp = mainProp.substring(0, start) + mainProp.substring(end));
            if (mainProp.length() > 0 && mainProp.charAt(0) == ':') {
                mainProp = mainProp.substring(1);
            }
            work.setPropertyString(mainKey, mainProp);
        }
        work.saveExisting();
        return true;
    }

    public static FilterSelector getNoRule() {
        FilterRule noFlows = new FilterRule(m_bundle.getString("FilterSelector.ColumnHeader.Name.txt"), 0, "");
        return new FilterSelector(NONERULE, noFlows);
    }

    public static FilterSelector getAllRule() {
        FilterRule anyFlow = new FilterRule(m_bundle.getString("FilterSelector.ColumnHeader.Name.txt"), 1, "");
        return new FilterSelector(ALLRULE, anyFlow);
    }
}

