/*
 * Decompiled with CFR 0.152.
 */
package com.sas.filter.model;

import com.sas.filter.model.FilterUtil;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FilterRule {
    private static final ResourceBundle m_bundle = FilterUtil.getMyResourceBundle(FilterRule.class);
    public static final int EQUALS = 0;
    public static final int STARTSWITH = 1;
    public static final int ENDSWITH = 2;
    public static final int CONTAINS = 3;
    public static final int GT = 4;
    public static final int LT = 5;
    public static final int EQ = 6;
    public static final int NE = 7;
    public static final int MEMBEROF = 8;
    public static final String MEMBEROF_DELIMITOR = ";";
    private String m_columnName;
    private int m_condition;
    private String m_value;

    public FilterRule() {
    }

    public FilterRule(String columnName, int condition, String value) {
        this.m_columnName = columnName;
        this.m_condition = condition;
        this.m_value = value;
    }

    public String getColumnName() {
        return this.m_columnName;
    }

    public void setColumnName(String name) {
        this.m_columnName = name;
    }

    public int getCondition() {
        return this.m_condition;
    }

    public static int getCondition(String name) {
        if (name == null) {
            return -1;
        }
        if (name.compareTo(m_bundle.getString("FilterRule.Condition.Equals.txt")) == 0) {
            return 0;
        }
        if (name.compareTo(m_bundle.getString("FilterRule.Condition.StartsWith.txt")) == 0) {
            return 1;
        }
        if (name.compareTo(m_bundle.getString("FilterRule.Condition.EndsWith.txt")) == 0) {
            return 2;
        }
        if (name.compareTo(m_bundle.getString("FilterRule.Condition.Contains.txt")) == 0) {
            return 3;
        }
        if (name.compareTo(m_bundle.getString("FilterRule.Condition.MemberOf.txt")) == 0) {
            return 8;
        }
        if (name.compareTo(m_bundle.getString("FilterRule.Condition.GT.txt")) == 0) {
            return 4;
        }
        if (name.compareTo(m_bundle.getString("FilterRule.Condition.LT.txt")) == 0) {
            return 5;
        }
        if (name.compareTo(m_bundle.getString("FilterRule.Condition.EQ.txt")) == 0) {
            return 6;
        }
        if (name.compareTo(m_bundle.getString("FilterRule.Condition.NE.txt")) == 0) {
            return 7;
        }
        return -1;
    }

    public static String getConditionName(int condition) {
        switch (condition) {
            case 0: {
                return m_bundle.getString("FilterRule.Condition.Equals.txt");
            }
            case 1: {
                return m_bundle.getString("FilterRule.Condition.StartsWith.txt");
            }
            case 2: {
                return m_bundle.getString("FilterRule.Condition.EndsWith.txt");
            }
            case 3: {
                return m_bundle.getString("FilterRule.Condition.Contains.txt");
            }
            case 8: {
                return m_bundle.getString("FilterRule.Condition.MemberOf.txt");
            }
            case 4: {
                return m_bundle.getString("FilterRule.Condition.GT.txt");
            }
            case 5: {
                return m_bundle.getString("FilterRule.Condition.LT.txt");
            }
            case 6: {
                return m_bundle.getString("FilterRule.Condition.EQ.txt");
            }
            case 7: {
                return m_bundle.getString("FilterRule.Condition.NE.txt");
            }
        }
        return null;
    }

    public void setCondition(int condition) {
        this.m_condition = condition;
    }

    public String getValue() {
        return this.m_value;
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    public String generateXML() {
        StringBuffer ruleXML = new StringBuffer();
        ruleXML.append("<Rule>");
        ruleXML.append("<Column Name=\"" + this.m_columnName + "\"/>");
        ruleXML.append("<Condition Operator=\"" + FilterRule.getConditionName(this.m_condition) + "\" Value=\"" + this.m_value + "\"/>");
        ruleXML.append("</Rule>");
        return ruleXML.toString();
    }

    public boolean initFromNode(Node node) {
        return this._init(node);
    }

    public boolean initFromDefinition(String xml) {
        if (xml == null) {
            return false;
        }
        boolean isRule = xml.startsWith("<Rule>");
        if (!isRule) {
            return false;
        }
        try {
            Document doc = FilterUtil.parseXML(xml);
            NodeList nodes = doc.getElementsByTagName("Rule");
            Node node = nodes.item(0);
            return this._init(node);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean _init(Node node) {
        try {
            NodeList nodes = node.getChildNodes();
            int numNodes = nodes.getLength();
            for (int x = 0; x < numNodes; ++x) {
                Node node2;
                Node node1;
                NamedNodeMap map;
                Node cnode = nodes.item(x);
                String cname = cnode.getNodeName();
                if (cname.compareTo("Column") == 0) {
                    map = cnode.getAttributes();
                    node1 = map.getNamedItem("Name");
                    if (node1 == null) continue;
                    this.m_columnName = node1.getNodeValue();
                    continue;
                }
                if (cname.compareTo("Condition") != 0) continue;
                map = cnode.getAttributes();
                node1 = map.getNamedItem("Operator");
                if (node1 != null) {
                    this.m_condition = FilterRule.getCondition(node1.getNodeValue());
                }
                if ((node2 = map.getNamedItem("Value")) == null) continue;
                this.m_value = node2.getNodeValue();
            }
            return true;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }
}

