/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webapp.lifecycle;

import com.sas.services.webapp.lifecycle.Disposer;
import com.sas.services.webapp.lifecycle.DisposerEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RemoteObjectDisposer {
    private Map _disposers = null;
    private static RemoteObjectDisposer _instance = new RemoteObjectDisposer();

    private RemoteObjectDisposer() {
    }

    public static RemoteObjectDisposer getInstance() {
        return _instance;
    }

    public void init(Map disposers) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this._disposers = new HashMap(disposers);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (DisposerEntry entry : disposers.values()) {
            Class<?> klass = cl.loadClass(entry.disposerClass);
            try {
                entry.disposerInstance = (Disposer)klass.newInstance();
            }
            catch (Throwable t) {
                t.printStackTrace();
                entry.disposerInstance = null;
            }
        }
    }

    private Disposer findDisposers(Class clazz) {
        DisposerEntry entry;
        Disposer retval = null;
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int x = 0; x < interfaces.length; ++x) {
            String className = interfaces[x].getName();
            DisposerEntry entry2 = (DisposerEntry)this._disposers.get(className);
            if (entry2 == null) continue;
            retval = entry2.disposerInstance;
            break;
        }
        if (retval == null && (entry = (DisposerEntry)this._disposers.get(clazz.getName())) != null) {
            retval = entry.disposerInstance;
        }
        return retval;
    }

    private int findDisposerOrder(Class clazz) {
        DisposerEntry entry;
        int retval = -1;
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int x = 0; x < interfaces.length; ++x) {
            DisposerEntry entry2 = (DisposerEntry)this._disposers.get(interfaces[x].getName());
            if (entry2 == null) continue;
            retval = entry2.order;
            break;
        }
        if (retval == -1 && (entry = (DisposerEntry)this._disposers.get(clazz.getName())) != null) {
            retval = entry.order;
        }
        return retval;
    }

    public boolean isDisposable(Object o) {
        boolean retval = false;
        if (o != null) {
            retval = this.findDisposers(o.getClass()) != null;
        }
        return retval;
    }

    public void disposeSession(Collection values) {
        int i = 0;
        while (values.size() > 0) {
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                int order = this.findDisposerOrder(o.getClass());
                if (order != i) continue;
                this.dispose(o);
                iter.remove();
            }
            ++i;
        }
    }

    public void dispose(Object o) {
        Disposer disposer = this.findDisposers(o.getClass());
        if (disposer == null) {
            return;
        }
        disposer.dispose(o, this);
    }
}

