/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webapp.lifecycle;

import com.sas.services.webapp.lifecycle.DisposerEntry;
import com.sas.services.webapp.lifecycle.RemoteObjectDisposer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class ObjectTrackerFilter
implements Filter,
HttpSessionListener,
HttpSessionAttributeListener {
    private static Map SESSIONS = new Hashtable();

    public void init(FilterConfig config) throws ServletException {
        if (config != null) {
            // empty if block
        }
        HashMap disposers = new HashMap();
        try {
            this.load(disposers, this.getClass().getClassLoader().getResourceAsStream("disposers.config"));
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        try {
            RemoteObjectDisposer.getInstance().init(disposers);
        }
        catch (ClassNotFoundException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
    }

    public void destroy() {
        for (Object key : SESSIONS.keySet()) {
            Map sessionValues = (Map)SESSIONS.remove(key);
            this.cleanUpSession(sessionValues);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        SESSIONS.put(event.getSession().getId(), new Hashtable());
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        Map sessionValues = (Map)SESSIONS.remove(event.getSession().getId());
        if (sessionValues != null) {
            this.cleanUpSession(sessionValues);
        }
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        String sessionId;
        Map remoteObjects;
        if (RemoteObjectDisposer.getInstance().isDisposable(event.getValue()) && (remoteObjects = (Map)SESSIONS.get(sessionId = event.getSession().getId())) != null) {
            remoteObjects.put(event.getName(), event.getValue());
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        String sessionId;
        Map remoteObjects;
        if (RemoteObjectDisposer.getInstance().isDisposable(event.getValue()) && (remoteObjects = (Map)SESSIONS.get(sessionId = event.getSession().getId())) != null) {
            try {
                Object target = remoteObjects.remove(event.getName());
                RemoteObjectDisposer.getInstance().dispose(target);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        if (event != null) {
            // empty if block
        }
    }

    private void cleanUpSession(Map sessionContents) {
        RemoteObjectDisposer.getInstance().disposeSession(sessionContents.values());
        sessionContents.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(Map disposerMap, InputStream in) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            String name = null;
            String value = null;
            String line = null;
            int count = 0;
            while ((line = reader.readLine()) != null) {
                int breakpos = line.indexOf("=");
                if (breakpos == -1) {
                    breakpos = line.indexOf(" ");
                }
                if (breakpos == -1) continue;
                name = line.substring(0, breakpos);
                value = line.substring(breakpos + 1);
                DisposerEntry entry = new DisposerEntry();
                entry.name = name;
                entry.disposerClass = value;
                entry.order = count++;
                disposerMap.put(entry.name, entry);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            } else if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

