/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webapp;

import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceAttributeInterface;
import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.IsRemotelyAccessibleAttribute;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.ServiceNotAvailableException;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.events.broker.EventBrokerServiceInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.security.AuthenticationServiceInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.storedprocess.StoredProcessServiceInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.webapp.Bootstrap;
import com.sas.services.webapp.SessionHelper;
import java.rmi.RemoteException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ServicesFacade {
    private static final String _loggingContext = ServicesFacade.class.getName();
    private static final Class USER_SERVICE_INTERFACE_CLASS = UserServiceInterface.class;
    private static final Class SESSION_SERVICE_INTERFACE_CLASS = SessionServiceInterface.class;
    private static final Class INFORMATION_SERVICE_INTERFACE_CLASS = InformationServiceInterface.class;
    private static final Class AUTHENTICATION_SERVICE_INTERFACE_CLASS = AuthenticationServiceInterface.class;
    private static final Class STOREDPROCESS_SERVICE_INTERFACE_CLASS = StoredProcessServiceInterface.class;
    private static final Class[] USER_SERVICE = new Class[]{USER_SERVICE_INTERFACE_CLASS};
    private static final Class[] SESSION_SERVICE = new Class[]{SESSION_SERVICE_INTERFACE_CLASS};
    private static final Class[] INFORMATION_SERVICE = new Class[]{INFORMATION_SERVICE_INTERFACE_CLASS};
    private static final Class[] AUTHENTICATION_SERVICE = new Class[]{AUTHENTICATION_SERVICE_INTERFACE_CLASS};
    private static final Class[] STOREDPROCESS_SERVICE = new Class[]{STOREDPROCESS_SERVICE_INTERFACE_CLASS};
    private static LocalDiscoveryServiceInterface _dsi = DiscoveryService.defaultInstance();

    private ServicesFacade() {
    }

    public static void setDiscoveryService(LocalDiscoveryServiceInterface dsi) {
        _dsi = dsi;
    }

    public static DiscoveryServiceInterface getDiscoveryService() {
        return _dsi;
    }

    public static UserServiceInterface getUserService() throws RemoteException, InitializationException, ServiceException {
        return (UserServiceInterface)ServicesFacade.getLocalServiceInterface(USER_SERVICE);
    }

    public static SessionServiceInterface getSessionService() throws RemoteException, InitializationException, ServiceException {
        return (SessionServiceInterface)ServicesFacade.getLocalServiceInterface(SESSION_SERVICE);
    }

    public static InformationServiceInterface getInformationService() throws RemoteException, InitializationException, ServiceException {
        return (InformationServiceInterface)ServicesFacade.getLocalServiceInterface(INFORMATION_SERVICE);
    }

    public static AuthenticationServiceInterface getAuthenticationService() throws RemoteException, InitializationException, ServiceException {
        return (AuthenticationServiceInterface)ServicesFacade.getLocalServiceInterface(AUTHENTICATION_SERVICE);
    }

    public static StoredProcessServiceInterface getStoredProcessService() throws RemoteException, InitializationException, ServiceException {
        return (StoredProcessServiceInterface)ServicesFacade.getLocalServiceInterface(STOREDPROCESS_SERVICE);
    }

    public static Logger getLogger(String loggingContext) {
        return LogManager.getLogger((String)loggingContext);
    }

    public static SessionServiceInterface getRemoteSessionService() throws RemoteException, InitializationException, ServiceException {
        return (SessionServiceInterface)ServicesFacade.getRemoteServiceInterface(SESSION_SERVICE);
    }

    public static UserServiceInterface getRemoteUserService() throws RemoteException, InitializationException, ServiceException {
        return (UserServiceInterface)ServicesFacade.getRemoteServiceInterface(USER_SERVICE);
    }

    public static InformationServiceInterface getRemoteInformationService() throws RemoteException, InitializationException, ServiceException {
        return (InformationServiceInterface)ServicesFacade.getRemoteServiceInterface(INFORMATION_SERVICE);
    }

    public static EventBrokerServiceInterface getRemoteEventBrokerService() throws RemoteException, InitializationException, ServiceException {
        RemoteServiceInterface retval = null;
        Class<EventBrokerServiceInterface> EVENTBROKER_SERVICE_INTERFACE_CLASS = EventBrokerServiceInterface.class;
        Class[] EVENTBROKER_SERVICE = new Class[]{EVENTBROKER_SERVICE_INTERFACE_CLASS};
        retval = ServicesFacade.getRemoteServiceInterface(EVENTBROKER_SERVICE);
        if (retval != null) {
            return (EventBrokerServiceInterface)retval;
        }
        return null;
    }

    public static IntelligentQueryMetadataServiceInterface newIQService() throws ServiceException, MetadataException {
        return IntelligentQueryMetadataServiceFactory.newService();
    }

    private static RemoteServiceInterface getLocalServiceInterface(Class[] desiredClass) throws RemoteException, InitializationException, ServiceException {
        RemoteServiceInterface rsi = null;
        Bootstrap bootstrap = Bootstrap.getInstance();
        if (bootstrap.isInitialized()) {
            try {
                rsi = _dsi.findService(new ServiceTemplate(desiredClass, bootstrap.getLocalServiceAttributes()));
            }
            catch (ServiceNotAvailableException e) {
                throw new ServiceException(e.toString());
            }
        } else {
            rsi = ServicesFacade.getServiceInterface(desiredClass);
        }
        RemoteServiceInterface retval = rsi.getServiceProxy();
        if (retval == null) {
            retval = rsi;
        }
        return retval;
    }

    private static RemoteServiceInterface getRemoteServiceInterface(Class[] desiredClass) throws RemoteException, InitializationException, ServiceException {
        RemoteServiceInterface retval = null;
        Bootstrap bootstrap = Bootstrap.getInstance();
        if (bootstrap.isInitialized()) {
            bootstrap.bindRemoteIfNeeded();
            ServiceTemplate serviceTemplate = new ServiceTemplate(desiredClass, new ServiceAttributeInterface[]{new IsRemotelyAccessibleAttribute(Boolean.TRUE)});
            retval = _dsi.findService(serviceTemplate);
        } else {
            retval = ServicesFacade.getServiceInterface(desiredClass);
        }
        return retval;
    }

    private static RemoteServiceInterface getServiceInterface(Class[] desiredClass) throws RemoteException, InitializationException, ServiceException {
        RemoteServiceInterface serviceInterface = DiscoveryService.defaultInstance().findService(new ServiceTemplate(desiredClass));
        return serviceInterface;
    }

    public static SessionContextInterface newSessionContext(SessionContextInterface sourceSession, UserServiceInterface userService, SessionServiceInterface sessionService, InformationServiceInterface infoService) throws ServiceException, RemoteException {
        if (infoService != null) {
            // empty if block
        }
        return new SessionHelper().newSession(sourceSession, userService, sessionService);
    }

    public static SessionContextInterface newSessionContext(SessionContextInterface sourceSession, UserServiceInterface userService, SessionServiceInterface sessionService) throws ServiceException, RemoteException {
        return new SessionHelper().newSession(sourceSession, userService, sessionService);
    }
}

