/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webapp;

import com.sas.services.webapp.Bootstrap;
import com.sas.services.webapp.InitParamBean;
import com.sas.services.webapp.res.RB;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BootstrapServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String INIT_MS_PROPS_LOCAL = "localPropsFile";
    private static final String INIT_MS_PROPS_REMOTE = "remotePropsFile";
    private static final String INIT_LOGGING_URL = "loggingURL";
    private static final String INIT_IS_REMOTE_BOUND = "isRemoteBound";
    private static final String RB_GENERIC_MESSAGE = "genericMessage.txt";
    private static final Bootstrap _bootstrap = Bootstrap.getInstance();

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request != null) {
            // empty if block
        }
        response.setContentType("text/html");
        ServletOutputStream out = response.getOutputStream();
        String genericMessage = RB.getStringResource(RB_GENERIC_MESSAGE);
        out.print("<h3>" + genericMessage + "</h3>");
        out.print(_bootstrap.toString());
        out.close();
    }

    private String loadFromInitialConfig(ServletConfig initialConfig, String valueToRead) {
        return this.loadFromInitialConfig(initialConfig, valueToRead, true);
    }

    private String loadFromInitialConfig(ServletConfig initialConfig, String valueToRead, boolean flagMissing) {
        String retval = initialConfig.getInitParameter(valueToRead);
        if (flagMissing && retval == null) {
            System.out.println("\t\tMissing value for \"" + valueToRead + "\" from web.xml");
        }
        return retval;
    }

    public void init(ServletConfig initialConfig) throws ServletException {
        super.init(initialConfig);
        try {
            String partLocalPropName = initialConfig.getInitParameter(INIT_MS_PROPS_LOCAL);
            Properties localProps = null;
            if (partLocalPropName != null) {
                String localPropName = "/WEB-INF/conf/" + partLocalPropName;
                localProps = this.loadProps(localPropName);
            }
            if (localProps != null) {
                System.out.println("\tSuccessfully loaded local properties from file");
                String partRemotePropName = initialConfig.getInitParameter(INIT_MS_PROPS_REMOTE);
                Properties remoteProps = null;
                if (partRemotePropName != null) {
                    String remotePropName = "/WEB-INF/conf/" + partRemotePropName;
                    remoteProps = this.loadProps(remotePropName);
                }
                String remoteBoundStr = initialConfig.getInitParameter(INIT_IS_REMOTE_BOUND);
                boolean remoteBound = new Boolean(remoteBoundStr);
                _bootstrap.execute(localProps, remoteProps, remoteBound);
            } else {
                System.out.println("\tLocal file not found - loading properties from web.xml file");
                InitParamBean localParams = this.populateInitParamBean(initialConfig, InitParamBean.LOCAL_PREFIX);
                InitParamBean remoteParams = this.populateInitParamBean(initialConfig, InitParamBean.REMOTE_PREFIX);
                System.out.println("Attempting connection to:");
                System.out.println(localParams.toString());
                System.out.println(remoteParams.toString());
                _bootstrap.execute(localParams, remoteParams);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private InitParamBean populateInitParamBean(ServletConfig initialConfig, String prefix) {
        InitParamBean retval = new InitParamBean();
        String softwareComponentStr = this.loadFromInitialConfig(initialConfig, prefix + "software_component");
        String deploymentGroup1Str = this.loadFromInitialConfig(initialConfig, prefix + "deployment_group_1");
        String deploymentGroup2Str = this.loadFromInitialConfig(initialConfig, prefix + "deployment_group_2", false);
        String omrHostStr = this.loadFromInitialConfig(initialConfig, "omr_host");
        String omrPortStr = this.loadFromInitialConfig(initialConfig, "omr_port");
        String omrUserStr = this.loadFromInitialConfig(initialConfig, "omr_user");
        String omrPasswordStr = this.loadFromInitialConfig(initialConfig, "omr_password");
        String omrReposStr = this.loadFromInitialConfig(initialConfig, "omr_repository");
        retval.setSoftwareComponent(softwareComponentStr);
        retval.setDeploymentGroup1(deploymentGroup1Str);
        retval.setDeploymentGroup2(deploymentGroup2Str);
        retval.setOmrHost(omrHostStr);
        retval.setOmrPort(omrPortStr);
        retval.setOmrUser(omrUserStr);
        retval.setOmrPassword(omrPasswordStr);
        retval.setOmrRepository(omrReposStr);
        return retval;
    }

    protected void handleException(Exception e) {
        e.printStackTrace();
    }

    private synchronized Properties loadProps(String relativeFile) {
        Properties props = new Properties();
        try {
            InputStream is = this.getServletContext().getResourceAsStream(relativeFile);
            props.load(is);
            is.close();
        }
        catch (Exception e) {
            props = null;
        }
        return props;
    }

    public void destroy() {
        _bootstrap.destroy();
    }
}

