/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webapp;

import com.sas.common.components.OmrConnectionInfoComponent;
import com.sas.common.components.SpringComponentFacade;
import com.sas.services.InitializationException;
import com.sas.services.webapp.Bootstrap;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class BootstrapContextListener
implements ServletContextListener {
    private static final Bootstrap _bootstrap = Bootstrap.getInstance();
    private static final String PFS_PROPS_FILE = "/WEB-INF/conf/sas_metadata_source.properties";
    private static final String OMR_USER = "omr_user";
    private static final String OMR_PASSWORD = "omr_password";
    private static final String OMR_HOST = "omr_host";
    private static final String OMR_PORT = "omr_port";
    private static final String OMR_REPOSITORY = "omr_repository";
    private static final String OMR_SOFTWARECOMPONENT = "software_component";

    public void contextInitialized(ServletContextEvent ctxEvent) {
        ServletContext ctx = ctxEvent.getServletContext();
        try {
            Properties localProps = this.loadProps(ctx, PFS_PROPS_FILE);
            if (localProps == null) {
                throw new IllegalStateException("Could not load: /WEB-INF/conf/sas_metadata_source.properties");
            }
            String softwareComponent = localProps.getProperty(OMR_SOFTWARECOMPONENT);
            if (this.deprecatedPropertyValues(localProps)) {
                System.out.println("***DEVELOPER WARNING: SEE DEFECT S0486717*** /WEB-INF/conf/sas_metadata_source.properties containing " + softwareComponent + " has deprecated values");
                System.out.println("The values [omr_host,omr_port,omr_repository,omr_user,omr_password] SHOULD BE REMOVED");
            }
            try {
                SpringComponentFacade.getInstance();
                this.populateInfoFromPublishedObject(localProps);
            }
            catch (IllegalStateException e) {
                System.out.println("***DEVELOPER WARNING: SEE DEFECT S0486717***: SpringComponentFacade must be configured in web.xml for webapp using " + softwareComponent + " to enable the reading of OMR connection values from RemoteServices");
            }
            _bootstrap.execute(localProps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean deprecatedPropertyValues(Properties localProps) {
        boolean retval = false;
        if (localProps.getProperty(OMR_USER) != null || localProps.getProperty(OMR_PASSWORD) != null || localProps.getProperty(OMR_HOST) != null || localProps.getProperty(OMR_PORT) != null || localProps.getProperty(OMR_REPOSITORY) != null) {
            retval = true;
        }
        return retval;
    }

    private void populateInfoFromPublishedObject(Properties localProps) throws InitializationException {
        OmrConnectionInfoComponent connectionInfo = SpringComponentFacade.getInstance().getOmrConnectionInfoComponent();
        if (connectionInfo == null) {
            throw new InitializationException("OmrConnectionInfoComponent is null - check infrastructure-config.xml for the jps-config.xml import entry");
        }
        String omrUser = connectionInfo.getAdminUserId();
        String omrPassword = connectionInfo.getAdminPassword();
        String omrPort = connectionInfo.getPort();
        String omrHost = connectionInfo.getHost();
        String omrRepository = connectionInfo.getRepository();
        localProps.setProperty(OMR_USER, omrUser);
        localProps.setProperty(OMR_PASSWORD, omrPassword);
        localProps.setProperty(OMR_HOST, omrHost);
        localProps.setProperty(OMR_PORT, omrPort);
        localProps.setProperty(OMR_REPOSITORY, omrRepository);
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        _bootstrap.destroy();
    }

    private synchronized Properties loadProps(ServletContext ctx, String relativeFile) {
        Properties props = new Properties();
        try {
            InputStream is = ctx.getResourceAsStream(relativeFile);
            props.load(is);
            is.close();
        }
        catch (Exception e) {
            props = null;
        }
        return props;
    }
}

