/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webapp;

import com.sas.services.InitializationException;
import com.sas.services.ServiceAttributeInterface;
import com.sas.services.ServiceException;
import com.sas.services.deployment.MetadataSourceFactory;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.OMRMetadataSource;
import com.sas.services.deployment.ServiceLoader;
import com.sas.services.deployment.ServiceLookupFailedException;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.MetadataAttribute;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.RepositoryDef;
import com.sas.services.webapp.InitParamBean;
import com.sas.services.webapp.res.RB;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.servlet.ServletContext;

public class Bootstrap {
    private static final String RB_REMOTE_DEPLOY = "remote_deploy.txt";
    private static final String RB_REMOTE_NOT_AVAILABLE = "remote_not_available.txt";
    private static final String RB_REMOTE_BIND = "remote_bind.txt";
    private static final String RB_REMOTE_BOUND = "remote_bound.txt";
    private static final String RB_LOCAL_METADATASOURCE_NOT_LOADED = "local_metadatasource_not_loaded.txt";
    private static final String PROP_SOFTWARECOMPONENT = "software_component";
    private static DiscoveryServiceInterface _discoveryService = DiscoveryService.defaultInstance();
    private static final Bootstrap _bootstrap = new Bootstrap();
    private boolean _isInitialized;
    private Properties _localProps;
    private Properties _remoteProps;
    private MetadataSourceInterface _localMS;
    private boolean _isRemoteBound;
    private ServiceAttributeInterface[] _localServiceAttributes;
    private StringBuffer _sbStats = new StringBuffer();
    private InitParamBean _localParams;
    private InitParamBean _remoteParams;

    public static synchronized Bootstrap getInstance() {
        return _bootstrap;
    }

    public void reset() {
        this.destroy();
        _discoveryService = DiscoveryService.defaultInstance();
    }

    public synchronized void execute(Properties localProps, Properties remoteProps) throws Exception {
        this.execute(localProps, remoteProps, false);
    }

    public synchronized void execute(Properties localProps, Properties remoteProps, boolean isRemoteBound) throws Exception {
        if (this._isInitialized) {
            return;
        }
        if (localProps == null) {
            throw new InitializationException("localProps is null");
        }
        this._localProps = localProps;
        this._remoteProps = remoteProps;
        this._isRemoteBound = isRemoteBound;
        this.printProperties();
        this.init();
    }

    public synchronized void execute(InitParamBean localParams, InitParamBean remoteParams) throws Exception {
        this.execute(localParams, remoteParams, false);
    }

    public synchronized void execute(Properties localProps) throws Exception {
        this.execute(localProps, null, true);
    }

    public synchronized void execute(InitParamBean localParams, InitParamBean remoteParams, boolean isRemoteBound) throws Exception {
        if (this._isInitialized) {
            return;
        }
        if (localParams == null) {
            throw new InitializationException("localParams is null");
        }
        this._localParams = localParams;
        this._remoteParams = remoteParams;
        this._isRemoteBound = isRemoteBound;
        this.init();
    }

    public boolean isInitialized() {
        return this._isInitialized;
    }

    private void init() throws ServiceException, InitializationException {
        if (this._isInitialized) {
            return;
        }
        this.deployLocalServices();
        this.setLocalServiceAttributes();
        this._isInitialized = true;
        try {
            this.printLocalInfo();
            this._localMS.destroy();
            this._localMS = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private MetadataSourceInterface loadRemoteMetadataSource() throws ServiceException, InitializationException {
        MetadataSourceInterface retval = null;
        if (this._remoteProps == null && this._remoteParams == null) {
            return retval;
        }
        if (this._remoteProps != null) {
            retval = MetadataSourceFactory.newMetadataSource((Properties)this._remoteProps);
        } else if (this._remoteParams.getDeploymentGroup2() == null) {
            retval = new OMRMetadataSource(this._remoteParams.getOmrHost(), this._remoteParams.getOmrPort(), this._remoteParams.getOmrUser(), this._remoteParams.getOmrPassword(), this._remoteParams.getOmrRepository(), this._remoteParams.getSoftwareComponent(), this._remoteParams.getDeploymentGroup1());
        } else {
            HashSet<String> x = new HashSet<String>();
            x.add(this._remoteParams.getDeploymentGroup1());
            x.add(this._remoteParams.getDeploymentGroup2());
            retval = new OMRMetadataSource(this._remoteParams.getOmrHost(), this._remoteParams.getOmrPort(), this._remoteParams.getOmrUser(), this._remoteParams.getOmrPassword(), this._remoteParams.getOmrRepository(), this._remoteParams.getSoftwareComponent(), x);
        }
        try {
            System.out.println(RB.getStringResource(RB_REMOTE_DEPLOY));
        }
        catch (MissingResourceException mre) {
            System.out.println(mre.getMessage());
        }
        return retval;
    }

    private void deployLocalServices() throws ServiceException, InitializationException {
        if (this._localProps != null) {
            this._localMS = MetadataSourceFactory.newMetadataSource((Properties)this._localProps);
        } else if (this._localParams.getDeploymentGroup2() == null) {
            this._localMS = new OMRMetadataSource(this._localParams.getOmrHost(), this._localParams.getOmrPort(), this._localParams.getOmrUser(), this._localParams.getOmrPassword(), this._localParams.getOmrRepository(), this._localParams.getSoftwareComponent(), this._localParams.getDeploymentGroup1());
        } else {
            HashSet<String> x = new HashSet<String>();
            x.add(this._localParams.getDeploymentGroup1());
            x.add(this._localParams.getDeploymentGroup2());
            this._localMS = new OMRMetadataSource(this._localParams.getOmrHost(), this._localParams.getOmrPort(), this._localParams.getOmrUser(), this._localParams.getOmrPassword(), this._localParams.getOmrRepository(), this._localParams.getSoftwareComponent(), x);
        }
        ServiceLoader.deployServices((MetadataSourceInterface)this._localMS, (DiscoveryServiceInterface)_discoveryService);
    }

    private void bindRemote() throws InitializationException, ServiceException {
        if (!this._isRemoteBound) {
            try {
                System.out.println(RB.getStringResource(RB_REMOTE_BIND));
                MetadataSourceInterface remoteMetadataSource = this.loadRemoteMetadataSource();
                ServiceLoader.lookupRemoteDiscoveryServices((MetadataSourceInterface)remoteMetadataSource, (DiscoveryServiceInterface)_discoveryService);
                remoteMetadataSource.destroy();
                System.out.println(RB.getStringResource(RB_REMOTE_BOUND));
                this._isRemoteBound = true;
            }
            catch (ServiceLookupFailedException sfe) {
                this._isRemoteBound = false;
                System.out.println(RB.getStringResource(RB_REMOTE_NOT_AVAILABLE));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(e.getMessage());
            }
        }
    }

    ServiceAttributeInterface[] getLocalServiceAttributes() {
        return this._localServiceAttributes;
    }

    void bindRemoteIfNeeded() throws InitializationException, ServiceException {
        if (!this._isRemoteBound) {
            this.bindRemote();
        }
    }

    private void setLocalServiceAttributes() throws InitializationException, ServiceException {
        if (this._localProps == null && this._localParams == null) {
            throw new ServiceException(RB.getStringResource(RB_LOCAL_METADATASOURCE_NOT_LOADED));
        }
        if (this._localServiceAttributes == null) {
            String softwareComponent = null;
            softwareComponent = this._localProps != null ? this._localProps.getProperty(PROP_SOFTWARECOMPONENT) : this._localParams.getSoftwareComponent();
            this._localServiceAttributes = new ServiceAttributeInterface[]{new MetadataAttribute(null, softwareComponent, "SoftwareComponent", null)};
        }
    }

    public void printLocalInfo() {
        System.out.println();
        System.out.println("--- Foundation Services information ---");
        try {
            Iterator it = _discoveryService.getLocalServices();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof InformationServiceInterface)) continue;
                this.printInformationServiceDetails((InformationServiceInterface)o);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void printProperties() {
        System.out.println();
        System.out.println("Local Services properties: [");
        this.printProperties(this._localProps);
        if (this._remoteProps != null) {
            System.out.println("Remote Services properties: [");
            this.printProperties(this._remoteProps);
        }
    }

    private void printProperties(Properties props) {
        Enumeration<Object> keys = props.keys();
        ArrayList<String> l = new ArrayList<String>(props.size());
        while (keys.hasMoreElements()) {
            String next = (String)keys.nextElement();
            l.add(next);
        }
        Collections.sort(l);
        for (String next : l) {
            String value = props.getProperty(next);
            if (next.indexOf("password") != -1) {
                value = "******";
            }
            System.out.println("\t" + next + "=" + value);
        }
        System.out.println("]");
    }

    private void printInformationServiceDetails(InformationServiceInterface o) throws RemoteException {
        System.out.println(InformationServiceInterface.class.getName() + "[ ");
        InformationServiceInterface info = o;
        List l = info.getReposDefs();
        for (RepositoryDef def : l) {
            System.out.println("\tRepositoryDef: [");
            System.out.println("\t  name=" + def.getName());
            System.out.println("\t  base=" + def.getBase());
            System.out.println("\t  host=" + def.getHost());
            System.out.println("\t  port=" + def.getPort());
            System.out.println("\t  type=" + def.getProtocol());
            System.out.println("\t  auto=" + def.getAuto());
            System.out.println("\t]");
        }
        System.out.println("]");
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this._sbStats.toString()).append("\n\n<pre>").append(_discoveryService).append("</pre>\n").append("<hr>\n");
        sbuf.append("localProps: ").append(this.propsToStrWOPasswd(this._localProps)).append("<br>\n").append("remoteProps: ");
        sbuf.append(this.propsToStrWOPasswd(this._remoteProps)).append("<hr>\n").append("RemoteBound: ").append(this._isRemoteBound);
        sbuf.append("<br>\n");
        return sbuf.toString();
    }

    public void destroy() {
        try {
            _discoveryService.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            _discoveryService = null;
            this._localProps = null;
            this._remoteProps = null;
            this._isRemoteBound = false;
            this._localServiceAttributes = null;
            this._isInitialized = false;
            this._localServiceAttributes = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadProperties(String fileName) {
        Properties retval = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(fileName);
            retval = new Properties();
            retval.load(in);
        }
        catch (IOException e) {
            retval = null;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
        return retval;
    }

    public void enableSystemProps(ServletContext context, List systemPropFileList) {
        System.out.println("USE OF system_properties.config  HAS BEEN DEPRECATED AND HAS NOT BEEN READ -- PLEASE REMOVE the call to deprecated method " + this.getClass() + " enableSystemProps()\n System level properties should be set at the application server level ");
    }

    private String propsToStrWOPasswd(Map props) {
        if (props == null) {
            return "";
        }
        StringBuffer rval = new StringBuffer(80);
        try {
            for (Map.Entry entry : props.entrySet()) {
                rval.append(entry.getKey()).append('=');
                if (entry.getKey().toString().indexOf("assword") == -1) {
                    rval.append(entry.getValue());
                } else {
                    rval.append(" -suppressed-");
                }
                rval.append(", ");
            }
            if (rval.length() > 2) {
                rval.setLength(rval.length() - 2);
            }
        }
        catch (RuntimeException e) {
            rval.append("unexpected exception in diagnostic: ").append(e);
        }
        return rval.toString();
    }

    public static void main(String[] argv) throws Exception {
        Bootstrap bootstrap = Bootstrap.getInstance();
        Properties localProps = null;
        Properties remoteProps = null;
        localProps = Bootstrap.loadProperties(argv[0]);
        if (argv.length > 1) {
            remoteProps = Bootstrap.loadProperties(argv[1]);
        }
        bootstrap.execute(localProps, remoteProps);
    }
}

