/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.helper;

import com.sas.services.user.SubjectAuthenticator;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import com.sas.svcs.authentication.helper.PublicUserHelper;
import com.sas.svcs.authentication.helper.TrustedAuthenticationException;
import com.sas.svcs.authentication.helper.TrustedSubjectFactory;
import com.sas.svcs.config.client.ConfigurationServiceInterface;
import javax.security.auth.Subject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class TrustedUserFactory {
    private static final Logger LOGGER = LogManager.getLogger(TrustedUserFactory.class);
    UserServiceInterface userService;
    ConfigurationServiceInterface configurationService;
    TrustedSubjectFactory subjectFactory = new TrustedSubjectFactory("DefaultAuth", "SASTRUSTED");

    public TrustedUserFactory(UserServiceInterface userService) {
        this.userService = userService;
    }

    public void setLoginContextName(String loginContextName) {
        this.subjectFactory.setLoginContextName(loginContextName);
    }

    public void setDomain(String domain) {
        this.subjectFactory.setDomain(domain);
    }

    @Autowired(required=false)
    public void setConfigurationService(ConfigurationServiceInterface configurationService) {
        this.configurationService = configurationService;
    }

    public void test(String userid) throws TrustedAuthenticationException {
        UserContextInterface user = this.create(userid);
        try {
            user.destroy();
        }
        catch (Exception e) {
            LOGGER.info("Failure destroying test user...", (Throwable)e);
        }
    }

    public UserContextInterface create(String userid) throws TrustedAuthenticationException {
        try {
            Subject s = this.subjectFactory.create(userid);
            UserContextInterface created = SubjectAuthenticator.newAuthenticatedUser((UserServiceInterface)this.userService, (Subject)s);
            created.enableLocalAdminMode(this.subjectFactory.getDomain());
            return created;
        }
        catch (UserInitializationException e) {
            return PublicUserHelper.handlePublicUser(e, this.configurationService, this.subjectFactory.getDomain());
        }
        catch (Exception e) {
            throw new TrustedAuthenticationException(e);
        }
    }
}

