/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.helper;

import com.sas.services.user.UserContextInterface;
import com.sas.svcs.authentication.helper.UserContextGetSessionInterceptor;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.aop.Advisor;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.NameMatchMethodPointcutAdvisor;

public class SessionContextGetUserInterceptor
implements MethodInterceptor {
    private static final Logger LOGGER = LogManager.getLogger(SessionContextGetUserInterceptor.class);
    private ConcurrentMap<Object, Object> _userProxyMap = new ConcurrentHashMap<Object, Object>();
    private String[] _proxiedUserContextGetSessionMethods;

    public void setProxiedUserContextGetSessionMethodNames(String[] names) {
        this._proxiedUserContextGetSessionMethods = names;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        if (this._proxiedUserContextGetSessionMethods == null) {
            throw new IllegalStateException("proxiedUserContextGetSessionMethodNames not set");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Procesing intercepted method " + mi.toString());
        }
        Object retVal = mi.proceed();
        if (!(mi instanceof ProxyMethodInvocation)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Interceptor was not invoked from a Spring proxy.");
            }
            return retVal;
        }
        Object userProxy = this._userProxyMap.get(retVal);
        if (userProxy == null) {
            if (LOGGER.isDebugEnabled()) {
                List<String> nameLst = Arrays.asList(this._proxiedUserContextGetSessionMethods);
                LOGGER.debug("Wrapping user context in a proxy with special behavior for method(s): " + nameLst);
            }
            Object sessionProxy = ((ProxyMethodInvocation)mi).getProxy();
            Object session = mi.getThis();
            UserContextGetSessionInterceptor userAdvice = new UserContextGetSessionInterceptor(sessionProxy, session);
            NameMatchMethodPointcutAdvisor userAdvisor = new NameMatchMethodPointcutAdvisor((Advice)userAdvice);
            userAdvisor.setMappedNames(this._proxiedUserContextGetSessionMethods);
            ProxyFactory userProxyFactory = new ProxyFactory(retVal);
            Class[] proxyIfaceArr = new Class[]{UserContextInterface.class};
            userProxyFactory.setInterfaces(proxyIfaceArr);
            userProxyFactory.addAdvisor((Advisor)userAdvisor);
            userProxyFactory.setFrozen(true);
            userProxy = userProxyFactory.getProxy();
            Object existingUserProxy = this._userProxyMap.putIfAbsent(retVal, userProxy);
            if (existingUserProxy != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("A proxy for this user context already exists.");
                }
                userProxy = existingUserProxy;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Substituting proxy for user context: " + System.identityHashCode(userProxy));
        }
        return userProxy;
    }
}

