/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.helper;

import com.sas.services.session.SessionContextInterface;
import com.sas.svcs.authentication.client.SecurityContext;
import com.sas.svcs.authentication.helper.RemoteToLocalContextConverterInterface;
import com.sas.svcs.authentication.helper.SecurityContextFactory;
import com.sas.svcs.authentication.helper.UserSessionFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteToLocalContextConverter
implements RemoteToLocalContextConverterInterface {
    private static final Logger logger = LogManager.getLogger(RemoteToLocalContextConverter.class);
    UserSessionFactory userSessionFactory;

    @Autowired
    public void setUserSessionFactory(UserSessionFactory userSessionFactory) {
        this.userSessionFactory = userSessionFactory;
    }

    @Override
    public SecurityContext convert(SecurityContext context) {
        try {
            SessionContextInterface sessionContext = this.userSessionFactory.getLocalSession();
            return SecurityContextFactory.newSecurityContext(sessionContext);
        }
        catch (Exception e) {
            logger.error("Failed to generate local security context due to exception.", (Throwable)e);
            return null;
        }
    }
}

