/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.helper;

import com.sas.framework.commons.util.HttpClientResponseRetriever;
import com.sas.framework.commons.util.ResponseRetriever;
import com.sas.iom.orb.AuthenticationTicketFactory;
import com.sas.services.connection.PasswordCredential;
import com.sas.svcs.config.client.UrlGeneratorInterface;
import com.sas.util.BASE64;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PasswordRecoveryUtil
implements InitializingBean {
    public static final String SECURITY_ENCRYPT = "encrypt";
    public static final String SECURITY_ENCODE = "encode";
    public static final String SECURITY_NONE = "none";
    public static final String DEFAULT_SECURITY = "encrypt";
    public static final String DEFAULT_PRNG_ALGORITHM = "SHA1PRNG";
    public static final String DEFAULT_ENCODING = "sas002";
    public static final String DEFAULT_PKCS_ALGORITHM = "RSA";
    public static final int DEFAULT_PKCS_KEY_SIZE = 2048;
    public static final String DEFAULT_CIPHER_TRANSFORM = "RSA/ECB/OAEPWithSHA-1AndMGF1Padding";
    public static final String DEFAULT_CLEAR_PASS_URL_SUFFIX = "/clearPass";
    private static final String _clearPassFailure = "cas:clearPassFailure";
    private static final String _clearPassUser = "cas:user";
    private static final String _clearPassCredentials = "cas:credentials";
    private static final String _clearPassEncryptTag = "{sas-clearpass-encrypt}";
    private static final Logger _logger = LogManager.getLogger(PasswordRecoveryUtil.class);
    private static final Charset _utf8 = Charset.forName("utf8");
    private ResponseRetriever _responseRetriever = new HttpClientResponseRetriever();
    private UrlGeneratorInterface _urlGenerator;
    private String _clearPassSuffix = "/clearPass";
    private String _clearPassUrl;
    private String _security;
    private String _prngAlgorithm;
    private String _encoding;
    private String _pkcsAlgorithm;
    private Integer _pkcsKeySize;
    private String _cipherTransform;
    private SecureRandom _prng;
    private KeyPair _keyPair;

    @Autowired(required=false)
    public void setUrlGenerator(UrlGeneratorInterface urlGenerator) {
        this._urlGenerator = urlGenerator;
    }

    public void setClearPassSuffix(String clearPassSuffix) {
        this._clearPassSuffix = clearPassSuffix;
    }

    public void setClearPassUrl(String clearPassUrl) {
        this._clearPassUrl = clearPassUrl;
    }

    public void setResponseRetriever(ResponseRetriever responseRetriever) {
        this._responseRetriever = responseRetriever;
    }

    public void setSecurity(String security) {
        this._security = security;
    }

    public void setPrngAlgorithm(String prngAlgorithm) {
        this._prngAlgorithm = prngAlgorithm;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void setPkcsAlgorithm(String pkcsAlgorithm) {
        this._pkcsAlgorithm = pkcsAlgorithm;
    }

    public void setPkcsKeySize(int pkcsKeySize) {
        this._pkcsKeySize = pkcsKeySize;
    }

    public void setCipherTransform(String cipherTransform) {
        this._cipherTransform = cipherTransform;
    }

    public void setPrng(SecureRandom prng) {
        this._prng = prng;
    }

    public void setKeyPair(KeyPair keyPair) {
        this._keyPair = keyPair;
    }

    public void afterPropertiesSet() throws Exception {
        String security = this.getSecurity();
        if (!SECURITY_NONE.equals(security)) {
            this.getRandomNumberGenerator();
            if (SECURITY_ENCODE.equals(security)) {
                this.getEncoding();
            } else if ("encrypt".equals(security)) {
                this.getKeyPair();
                this.getCipherTransform();
            } else {
                throw new IllegalArgumentException("security attribute value " + security + " is not supported");
            }
        }
    }

    @Deprecated
    public String recoverPassword() {
        SecurityContext ctx = SecurityContextHolder.getContext();
        if (ctx == null || ctx.getAuthentication() == null) {
            throw new IllegalStateException("SecurityContextHolder is not populated. There must be a SecurityContext for the user in order to retrieve the user's password.");
        }
        return this.recoverPassword(ctx);
    }

    @Deprecated
    public String recoverPassword(SecurityContext ctx) {
        PasswordCredential cred = this.recoverUserNameAndPassword(ctx);
        return cred != null ? cred.getPassword() : null;
    }

    public PasswordCredential recoverUserNameAndPassword(SecurityContext ctx) {
        Authentication token = ctx.getAuthentication();
        String name = token.getName();
        if (!(token instanceof CasAuthenticationToken)) {
            _logger.debug("Cannot recover password for " + name + ". Authentication token type is not supported: " + token.getClass().getName());
            return null;
        }
        CasAuthenticationTokenTicketFactory ticketFactory = new CasAuthenticationTokenTicketFactory((CasAuthenticationToken)token);
        return this.recoverUserNameAndPassword(ticketFactory, name);
    }

    @Deprecated
    protected String recoverPassword(AuthenticationTicketFactory ticketFactory, String name) {
        PasswordCredential cred = this.recoverUserNameAndPassword(ticketFactory, name);
        return cred != null ? cred.getPassword() : null;
    }

    protected PasswordCredential recoverUserNameAndPassword(AuthenticationTicketFactory ticketFactory, String name) {
        _logger.debug("Attempting to recover password for " + name);
        String salt = this.getSalt();
        String param = this.getSecurityParameters(salt);
        int paramL = param.length();
        String clearPassUrl = this._clearPassUrl != null ? this._clearPassUrl : this._urlGenerator.generateInternalUrl("Logon Manager 9.4", this._clearPassSuffix, param);
        String ticket = ticketFactory.acquireServiceTicket(clearPassUrl);
        if (ticket == null) {
            _logger.debug("Cannot generate a proxy ticket for " + name);
            return null;
        }
        String request = clearPassUrl + (paramL > 0 ? "&" : "?") + "ticket=" + PasswordRecoveryUtil.urlEncode(ticket);
        String body = null;
        try {
            _logger.debug("Sending password recovery request for " + name + " to " + clearPassUrl);
            URL requestUrl = new URL(request);
            body = this._responseRetriever.getResponseFromServer(requestUrl);
        }
        catch (IOException ioe) {
            _logger.debug("Failed to recover password for " + name, (Throwable)ioe);
            throw new IllegalStateException(ioe);
        }
        return this.revealCredential(this.parseClearPassResponse(body, name), salt);
    }

    private PasswordCredential parseClearPassResponse(String body, String name) {
        if (body == null || body.trim().length() == 0) {
            _logger.debug("Attempt to recover password for " + name + " got empty response.");
            return null;
        }
        DocumentBuilder docBuilder = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            _logger.debug("Failed to recover password for " + name, (Throwable)e);
            throw new IllegalStateException(e);
        }
        StringReader reader = new StringReader(body);
        InputSource input = new InputSource(reader);
        Document doc = null;
        try {
            doc = docBuilder.parse(input);
        }
        catch (SAXException saxe) {
            _logger.debug("Failed to recover password for " + name, (Throwable)saxe);
            throw new IllegalStateException(saxe);
        }
        catch (IOException ioe) {
            _logger.debug("Failed to recover password for " + name, (Throwable)ioe);
            throw new IllegalStateException(ioe);
        }
        Element root = doc.getDocumentElement();
        String userName = this.extractNode(root, name, _clearPassUser);
        String password = this.extractNode(root, name, _clearPassCredentials);
        if (userName == null || password == null) {
            String msg = "Failed to recover user name and password for " + name;
            _logger.debug(msg + "\n" + body);
            throw new IllegalStateException(msg);
        }
        return userName.trim().length() > 0 || password.trim().length() > 0 ? new PasswordCredential(userName, password) : null;
    }

    private String extractNode(Node node, String name, String element) {
        String nodeName = node.getNodeName();
        if (element.equals(nodeName)) {
            return node.getTextContent();
        }
        if (_clearPassFailure.equals(nodeName)) {
            String msg = "Failed to recover password for " + name + ". " + node.getTextContent();
            _logger.debug(msg);
            throw new IllegalStateException(msg);
        }
        NodeList childNodeList = node.getChildNodes();
        int childNodeListL = childNodeList.getLength();
        for (int i = 0; i < childNodeListL; ++i) {
            Node childNode = childNodeList.item(i);
            String content = this.extractNode(childNode, name, element);
            if (content == null) continue;
            return content;
        }
        return null;
    }

    private synchronized SecureRandom getRandomNumberGenerator() {
        if (this._prng == null) {
            String prngAlgorithm = this.getPrngAlgorithm();
            if (_logger.isDebugEnabled()) {
                _logger.debug("creating random number generator for algorithm " + prngAlgorithm);
            }
            try {
                this._prng = SecureRandom.getInstance(prngAlgorithm);
            }
            catch (GeneralSecurityException gse) {
                _logger.error("random number generator algorithm " + prngAlgorithm + " is not supported", (Throwable)gse);
                throw new IllegalArgumentException(gse);
            }
            this._prng.nextInt();
            if (_logger.isDebugEnabled()) {
                _logger.debug("random number generator created");
            }
        }
        return this._prng;
    }

    private synchronized KeyPair getKeyPair() {
        if (this._keyPair == null) {
            SecureRandom prng = this.getRandomNumberGenerator();
            String pkcsAlgorithm = this.getPkcsAlgorithm();
            int pkcsKeySize = this.getPkcsKeySize();
            if (_logger.isDebugEnabled()) {
                _logger.debug("generating key pair of size " + pkcsKeySize + " for algorithm " + pkcsAlgorithm);
            }
            try {
                KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(pkcsAlgorithm);
                keyPairGen.initialize(pkcsKeySize, prng);
                this._keyPair = keyPairGen.generateKeyPair();
            }
            catch (GeneralSecurityException gse) {
                _logger.error("key pair algorithm " + pkcsAlgorithm + " is not supported", (Throwable)gse);
                throw new IllegalArgumentException(gse);
            }
            if (_logger.isDebugEnabled()) {
                PublicKey pubKey = this._keyPair.getPublic();
                String encodingFormat = pubKey.getFormat();
                _logger.debug("key pair generated - public key encoding format is " + encodingFormat);
            }
        }
        return this._keyPair;
    }

    private synchronized String getPkcsAlgorithm() {
        if (this._pkcsAlgorithm == null) {
            String key = this.getClass().getName() + ".pkcsAlgorithm";
            this._pkcsAlgorithm = System.getProperty(key, DEFAULT_PKCS_ALGORITHM);
            if (_logger.isDebugEnabled()) {
                _logger.debug("setting pkcsAlgorithm to " + this._pkcsAlgorithm);
            }
        }
        return this._pkcsAlgorithm;
    }

    private synchronized int getPkcsKeySize() {
        if (this._pkcsKeySize == null) {
            String key = this.getClass().getName() + ".pkcsKeySize";
            this._pkcsKeySize = Integer.parseInt(System.getProperty(key, Integer.toString(2048)));
            if (_logger.isDebugEnabled()) {
                _logger.debug("setting pkcsKeySize to " + this._pkcsKeySize);
            }
        }
        return this._pkcsKeySize;
    }

    private synchronized String getCipherTransform() {
        if (this._cipherTransform == null) {
            String key = this.getClass().getName() + ".cipherTransform";
            this._cipherTransform = System.getProperty(key, DEFAULT_CIPHER_TRANSFORM);
            if (_logger.isDebugEnabled()) {
                _logger.debug("setting cipherTransform to " + this._cipherTransform);
            }
        }
        return this._cipherTransform;
    }

    private synchronized String getSecurity() {
        if (this._security == null) {
            String key = this.getClass().getName() + ".security";
            this._security = System.getProperty(key, "encrypt");
            if (_logger.isDebugEnabled()) {
                _logger.debug("setting security to " + this._security);
            }
        }
        return this._security;
    }

    private synchronized String getPrngAlgorithm() {
        if (this._prngAlgorithm == null) {
            String key = this.getClass().getName() + ".prngAlgorithm";
            this._prngAlgorithm = System.getProperty(key, DEFAULT_PRNG_ALGORITHM);
            if (_logger.isDebugEnabled()) {
                _logger.debug("setting prngAlgorithm to " + this._prngAlgorithm);
            }
        }
        return this._prngAlgorithm;
    }

    private synchronized String getEncoding() {
        if (this._encoding == null) {
            String key = this.getClass().getName() + ".encoding";
            this._encoding = System.getProperty(key, DEFAULT_ENCODING);
            if (_logger.isDebugEnabled()) {
                _logger.debug("setting encoding to " + this._encoding);
            }
        }
        return this._encoding;
    }

    private String getSecurityParameters(String salt) {
        String security = this.getSecurity();
        if (SECURITY_NONE.equals(security)) {
            return "";
        }
        StringBuffer paramBuf = new StringBuffer();
        paramBuf.append("security=").append(PasswordRecoveryUtil.urlEncode(security));
        paramBuf.append("&salt=").append(PasswordRecoveryUtil.urlEncode(salt));
        if (SECURITY_ENCODE.equals(security)) {
            String encoding = this.getEncoding();
            paramBuf.append("&encoding=").append(PasswordRecoveryUtil.urlEncode(encoding));
        } else if ("encrypt".equals(security)) {
            String key = this.getEncodedPublicKey();
            String pkcsAlgorithm = this.getPkcsAlgorithm();
            String cipherTransform = this.getCipherTransform();
            paramBuf.append("&key=").append(PasswordRecoveryUtil.urlEncode(key));
            paramBuf.append("&algorithm=").append(PasswordRecoveryUtil.urlEncode(pkcsAlgorithm));
            paramBuf.append("&transform=").append(PasswordRecoveryUtil.urlEncode(cipherTransform));
        } else {
            throw new IllegalStateException("unexpected security attribute value " + security);
        }
        return paramBuf.toString();
    }

    private String getEncodedPublicKey() {
        KeyPair keyPair = this.getKeyPair();
        PublicKey pubKey = keyPair.getPublic();
        byte[] encodedPubKey = pubKey.getEncoded();
        return BASE64.encode((byte[])encodedPubKey);
    }

    private Cipher getCipher() {
        KeyPair keyPair = this.getKeyPair();
        PrivateKey privKey = keyPair.getPrivate();
        String cipherTransform = this.getCipherTransform();
        try {
            Cipher cipher = Cipher.getInstance(cipherTransform);
            cipher.init(2, privKey);
            return cipher;
        }
        catch (GeneralSecurityException gse) {
            _logger.error("cipher transform " + cipherTransform + " is not supported", (Throwable)gse);
            throw new IllegalArgumentException(gse);
        }
    }

    private String getSalt() {
        SecureRandom prng = this.getRandomNumberGenerator();
        int r = prng.nextInt();
        String s = Integer.toHexString(r);
        StringBuffer b = new StringBuffer(9);
        b.append("x");
        for (int i = 0; i < 8 - s.length(); ++i) {
            b.append("0");
        }
        b.append(s);
        return b.toString();
    }

    private PasswordCredential revealCredential(PasswordCredential protectedCredential, String salt) {
        if (protectedCredential == null) {
            return null;
        }
        String security = this.getSecurity();
        if (SECURITY_NONE.equals(security)) {
            _logger.debug("ClearPass response is not encoded or encrypted.");
            return protectedCredential;
        }
        String protectedName = protectedCredential.getUserName();
        String protectedPass = protectedCredential.getPassword();
        String saltedName = null;
        String saltedPass = null;
        if (SECURITY_ENCODE.equals(security)) {
            _logger.debug("decoding ClearPass response");
            saltedName = this.decodeString(protectedName);
            saltedPass = this.decodeString(protectedPass);
        } else if ("encrypt".equals(security)) {
            _logger.debug("decrypting ClearPass response");
            saltedName = this.decryptString(protectedName);
            saltedPass = this.decryptString(protectedPass);
        } else {
            throw new IllegalStateException("unexpected security attribute value " + security);
        }
        String user = PasswordRecoveryUtil.removeSalt(saltedName, salt);
        String pass = PasswordRecoveryUtil.removeSalt(saltedPass, PasswordRecoveryUtil.reverse(salt));
        return new PasswordCredential(user, pass);
    }

    private String decodeString(String code) {
        try {
            return SasPasswordString.decode((String)code);
        }
        catch (SasPasswordEncodingException spee) {
            throw new IllegalStateException(spee);
        }
    }

    private String decryptString(String code) {
        if (!code.startsWith(_clearPassEncryptTag)) {
            _logger.warn("encrypted string does not begin with the right tag - returning string unchanged");
            return code;
        }
        int tagL = _clearPassEncryptTag.length();
        byte[] encryptedData = BASE64.decode((String)code.substring(tagL));
        if (encryptedData == null) {
            _logger.warn("encrypted string is not base64 encoded - returning string unchanged");
            return code;
        }
        Cipher cipher = this.getCipher();
        try {
            byte[] data = cipher.doFinal(encryptedData);
            return new String(data, _utf8);
        }
        catch (GeneralSecurityException gse) {
            _logger.warn("encrypted string could not be decrypted - returning string unchanged", (Throwable)gse);
            return code;
        }
    }

    private static String removeSalt(String s, String salt) {
        if (!s.startsWith(salt)) {
            _logger.warn("encoded/encrypted string does not begin with salt - return string unchanged");
            return s;
        }
        int saltL = salt.length();
        return s.substring(saltL);
    }

    private static String reverse(String s) {
        int sL = s.length();
        StringBuffer b = new StringBuffer(sL);
        for (int i = sL - 1; i >= 0; --i) {
            b.append(s.charAt(i));
        }
        return b.toString();
    }

    private static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "utf8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(uee);
        }
    }

    private static final class CasAuthenticationTokenTicketFactory
    implements AuthenticationTicketFactory {
        private final CasAuthenticationToken _token;

        private CasAuthenticationTokenTicketFactory(CasAuthenticationToken token) {
            this._token = token;
        }

        public String acquireServiceTicket(String serviceUrl) {
            Assertion assertion = this._token.getAssertion();
            AttributePrincipal principal = assertion.getPrincipal();
            return principal.getProxyTicketFor(serviceUrl);
        }
    }
}

