/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.helper;

import com.sas.framework.commons.holders.ClientApplicationNameHolder;
import com.sas.services.ServiceException;
import com.sas.services.user.SimpleUserIdentity;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.svcs.authentication.client.LoginPreservingAuthenticationToken;
import com.sas.svcs.authentication.helper.SpringSecurityContextFactory;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.cas.web.authentication.ServiceAuthenticationDetails;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;

class LazySpringSecurityContext
implements SecurityContext,
Serializable {
    private static final Logger logger = LogManager.getLogger(LazySpringSecurityContext.class);
    private static final long serialVersionUID = 1L;
    SecurityContext sc;
    private final String loginId;
    private String password;
    private UserDetailsService userDetailsService;
    private AuthenticationManager authenticationManager;
    private AuthenticationDetailsSource<HttpServletRequest, ServiceAuthenticationDetails> authenticationDetailsSource;
    private boolean initializing;
    private long lastAccessed;
    private long intervalCheck;
    private UserContextInterface trustedUserContext;

    @Deprecated
    LazySpringSecurityContext(AuthenticationDetailsSource<HttpServletRequest, ServiceAuthenticationDetails> authenticationDetailsSource, String loginId, UserDetailsService userDetailsService) {
        String appName = ClientApplicationNameHolder.get();
        String message = "Creating a lazy non-CAS SecurityContext.";
        if (null != appName) {
            message = message + " Offending application appears to be '" + appName + "'.";
        }
        logger.warn(message);
        this.loginId = loginId;
        this.userDetailsService = userDetailsService;
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    LazySpringSecurityContext(AuthenticationDetailsSource<HttpServletRequest, ServiceAuthenticationDetails> authenticationDetailsSource, String loginId, String password, AuthenticationManager authenticationManager, long intervalCheck) {
        this.loginId = loginId;
        this.password = password;
        this.authenticationManager = authenticationManager;
        this.intervalCheck = intervalCheck;
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    LazySpringSecurityContext(AuthenticationDetailsSource<HttpServletRequest, ServiceAuthenticationDetails> authenticationDetailsSource, String loginId, UserContextInterface trustedUserContext, AuthenticationManager authenticationManager, long intervalCheck, UserDetailsService userDetailsService) {
        this(authenticationDetailsSource, loginId, null, authenticationManager, intervalCheck);
        this.trustedUserContext = trustedUserContext;
        this.userDetailsService = userDetailsService;
    }

    private UserIdentityInterface getCredential() {
        if (null == this.loginId) {
            throw new NullPointerException("Login ID cannot be null");
        }
        if (null != this.password) {
            return new SimpleUserIdentity(this.loginId, this.password, null);
        }
        if (null != this.trustedUserContext) {
            try {
                return this.trustedUserContext.getAuthServer().generatePassword(this.loginId);
            }
            catch (ServiceException e) {
                logger.warn("Could not generate OTP for " + this.loginId, (Throwable)e);
            }
            catch (RemoteException e) {
                logger.warn("Could not generate OTP for " + this.loginId, (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized SecurityContext getSecurityContextWithAuthManager() {
        Authentication existingToken;
        long elapsed;
        if (this.initializing) {
            return null;
        }
        if (this.sc != null && (elapsed = System.currentTimeMillis() - this.lastAccessed) > this.intervalCheck && (existingToken = this.sc.getAuthentication()) instanceof CasAuthenticationToken) {
            CasAuthenticationToken token = (CasAuthenticationToken)existingToken;
            if (token.getAssertion().getPrincipal().getProxyTicketFor("http://LazySecurityContext") == null) {
                this.sc = null;
            }
            this.lastAccessed = System.currentTimeMillis();
        }
        if (this.sc == null) {
            UserIdentityInterface user = this.getCredential();
            if (null == user) {
                if (null != this.userDetailsService) {
                    logger.warn("Username and password not provided and could not obtain OTP, falling back to deprecated non-CAS authentication");
                    return this.getSecurityContextWithUserDetailsService();
                }
                throw new IllegalStateException("Username and password not provided, could not obtain OTP, and UserDetailsService not provided.");
            }
            this.initializing = true;
            try {
                this.sc = SpringSecurityContextFactory.newAuthenticatedSecurityContext(user.getPrincipal().toString(), user.getCredential().toString(), this.authenticationManager, this.authenticationDetailsSource);
                this.lastAccessed = System.currentTimeMillis();
            }
            finally {
                this.initializing = false;
            }
        }
        return this.sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized SecurityContext getSecurityContextWithUserDetailsService() {
        UserDetails userDetails;
        if (this.sc != null) {
            return this.sc;
        }
        String credentials = UUID.randomUUID().toString();
        UsernamePasswordAuthenticationToken preAuthToken = new UsernamePasswordAuthenticationToken((Object)this.loginId, (Object)credentials, Collections.emptySet());
        SecurityContext scBefore = SecurityContextHolder.getContext();
        SecurityContextImpl preAuthSC = new SecurityContextImpl();
        preAuthSC.setAuthentication((Authentication)preAuthToken);
        SecurityContextHolder.setContext((SecurityContext)preAuthSC);
        try {
            userDetails = this.userDetailsService.loadUserByUsername(this.loginId);
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)scBefore);
        }
        LoginPreservingAuthenticationToken authToken = new LoginPreservingAuthenticationToken((Object)userDetails, (Object)credentials, userDetails.getAuthorities(), this.loginId);
        this.sc = new SecurityContextImpl();
        this.sc.setAuthentication((Authentication)authToken);
        return this.sc;
    }

    private synchronized SecurityContext getSecurityContext() {
        if (this.authenticationManager != null) {
            return this.getSecurityContextWithAuthManager();
        }
        return this.getSecurityContextWithUserDetailsService();
    }

    public Authentication getAuthentication() {
        SecurityContext sc = this.getSecurityContext();
        return sc == null ? null : sc.getAuthentication();
    }

    public void setAuthentication(Authentication authentication) {
        SecurityContext sc = this.getSecurityContext();
        if (null == sc) {
            throw new RuntimeException("LazySecurityContext is being initialized.  Can't set the Authentication object on it.");
        }
        sc.setAuthentication(authentication);
    }

    private Object writeReplace() throws ObjectStreamException {
        return this.sc;
    }
}

