/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.codepolicy.SASScope;
import com.sas.net.sharenet.ShareLocalizedError;
import com.sas.net.sharenet.ShareNetException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Hashtable;

@SASScope
public class Xvec {
    int magic;
    int hdrl;
    byte[] reqv;
    byte[] capv;
    private String characterEncoding;
    private static final Byte iso = 1;
    private static final Byte ebcdic = 2;
    private static final Byte ansi = 4;
    private static final Byte oem = 8;
    private static final Byte mac = 16;
    private static Hashtable<String, Byte> charFormatTable = null;
    protected static final byte WZX_TRANSCODE_NONE = 1;

    public Xvec() {
        OutputStreamWriter writer = new OutputStreamWriter(new ByteArrayOutputStream());
        this.characterEncoding = writer.getEncoding();
        Byte charFormat = charFormatTable.get(this.characterEncoding);
        if (charFormat == null) {
            charFormat = iso;
        }
        this.magic = 56077261;
        this.hdrl = 56;
        this.reqv = new byte[24];
        this.reqv[0] = 24;
        this.reqv[1] = 0;
        this.reqv[2] = 16;
        this.reqv[3] = 16;
        this.reqv[4] = 48;
        this.reqv[5] = 32;
        this.reqv[6] = 0;
        this.reqv[7] = 48;
        this.reqv[8] = 0;
        this.reqv[9] = 0;
        this.reqv[10] = 2;
        this.reqv[11] = -128;
        this.reqv[12] = charFormat;
        this.reqv[13] = 0;
        this.reqv[14] = 0;
        this.reqv[15] = 0;
        this.reqv[16] = 0;
        this.reqv[17] = 0;
        this.reqv[18] = 0;
        this.reqv[19] = 0;
        this.reqv[20] = 0;
        this.reqv[21] = 0;
        this.reqv[22] = 3;
        this.reqv[23] = 0;
        this.capv = new byte[24];
    }

    public synchronized void write(DataOutputStream stream) throws ShareNetException {
        try {
            stream.writeInt(this.magic);
            stream.writeInt(this.hdrl);
            stream.write(this.reqv, 0, 24);
            stream.write(this.capv, 0, 24);
            stream.flush();
        }
        catch (IOException e) {
            String messageIndex = "Sharenet.S301.ex.txt";
            Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
    }

    public synchronized void read(DataInputStream stream) throws ShareNetException {
        try {
            this.magic = stream.readInt();
            this.hdrl = stream.readInt();
            stream.readFully(this.reqv, 0, 24);
            stream.readFully(this.capv, 0, 24);
        }
        catch (IOException e) {
            String messageIndex = "Sharenet.S302.ex.txt";
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1}", new Object[]{messageIndex, e.getMessage()}));
        }
        if (this.magic != 56077261) {
            String messageIndex = "Sharenet.S303.ex.txt";
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Invalid response from server.", new Object[]{messageIndex}));
        }
        if (this.hdrl != 56) {
            String messageIndex = "Sharenet.S304.ex.txt";
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1}", new Object[]{messageIndex}));
        }
    }

    protected synchronized void setCharacterEncoding(String encoding) {
        Byte charFormat = charFormatTable.get(encoding);
        if (charFormat != null) {
            this.reqv[12] = charFormat;
            this.characterEncoding = encoding;
        }
    }

    protected synchronized String getCharacterEncoding() {
        return this.characterEncoding;
    }

    protected void setTranscode(byte transcode) {
        this.reqv[20] = transcode;
    }

    static {
        charFormatTable = new Hashtable();
        charFormatTable.put("ASCII", iso);
        charFormatTable.put("ISO8859_1", iso);
        charFormatTable.put("ISO8859_2", iso);
        charFormatTable.put("ISO8859_3", iso);
        charFormatTable.put("ISO8859_4", iso);
        charFormatTable.put("ISO8859_5", iso);
        charFormatTable.put("ISO8859_6", iso);
        charFormatTable.put("ISO8859_7", iso);
        charFormatTable.put("ISO8859_8", iso);
        charFormatTable.put("ISO8859_9", iso);
        charFormatTable.put("ISO8859_15_FDIS", iso);
        charFormatTable.put("Big5", ansi);
        charFormatTable.put("Cp037", ebcdic);
        charFormatTable.put("Cp1006", iso);
        charFormatTable.put("Cp1025", ebcdic);
        charFormatTable.put("Cp1026", ebcdic);
        charFormatTable.put("Cp1046", ebcdic);
        charFormatTable.put("Cp1047", ebcdic);
        charFormatTable.put("Cp1097", ebcdic);
        charFormatTable.put("Cp1098", oem);
        charFormatTable.put("Cp1112", ebcdic);
        charFormatTable.put("Cp1122", ebcdic);
        charFormatTable.put("Cp1123", ebcdic);
        charFormatTable.put("Cp1124", iso);
        charFormatTable.put("Cp1140", ebcdic);
        charFormatTable.put("Cp1141", ebcdic);
        charFormatTable.put("Cp1142", ebcdic);
        charFormatTable.put("Cp1143", ebcdic);
        charFormatTable.put("Cp1144", ebcdic);
        charFormatTable.put("Cp1145", ebcdic);
        charFormatTable.put("Cp1146", ebcdic);
        charFormatTable.put("Cp1147", ebcdic);
        charFormatTable.put("Cp1148", ebcdic);
        charFormatTable.put("Cp1149", ebcdic);
        charFormatTable.put("Cp1250", ansi);
        charFormatTable.put("Cp1251", ansi);
        charFormatTable.put("Cp1252", ansi);
        charFormatTable.put("Cp1253", ansi);
        charFormatTable.put("Cp1254", ansi);
        charFormatTable.put("Cp1255", ansi);
        charFormatTable.put("Cp1256", ansi);
        charFormatTable.put("Cp1257", ansi);
        charFormatTable.put("Cp1258", ansi);
        charFormatTable.put("Cp1381", oem);
        charFormatTable.put("Cp1383", iso);
        charFormatTable.put("Cp273", ebcdic);
        charFormatTable.put("Cp277", ebcdic);
        charFormatTable.put("Cp278", ebcdic);
        charFormatTable.put("Cp280", ebcdic);
        charFormatTable.put("Cp284", ebcdic);
        charFormatTable.put("Cp285", ebcdic);
        charFormatTable.put("Cp297", ebcdic);
        charFormatTable.put("Cp33722", iso);
        charFormatTable.put("Cp420", ebcdic);
        charFormatTable.put("Cp437", oem);
        charFormatTable.put("Cp500", ebcdic);
        charFormatTable.put("Cp737", oem);
        charFormatTable.put("Cp775", oem);
        charFormatTable.put("Cp838", ebcdic);
        charFormatTable.put("Cp850", oem);
        charFormatTable.put("Cp852", oem);
        charFormatTable.put("Cp855", oem);
        charFormatTable.put("Cp857", oem);
        charFormatTable.put("Cp858", oem);
        charFormatTable.put("Cp860", oem);
        charFormatTable.put("Cp861", oem);
        charFormatTable.put("Cp862", oem);
        charFormatTable.put("Cp863", oem);
        charFormatTable.put("Cp864", oem);
        charFormatTable.put("Cp865", oem);
        charFormatTable.put("Cp866", oem);
        charFormatTable.put("Cp868", oem);
        charFormatTable.put("Cp869", oem);
        charFormatTable.put("Cp870", ebcdic);
        charFormatTable.put("Cp871", ebcdic);
        charFormatTable.put("Cp874", ebcdic);
        charFormatTable.put("Cp875", ebcdic);
        charFormatTable.put("Cp918", ebcdic);
        charFormatTable.put("Cp921", oem);
        charFormatTable.put("Cp922", oem);
        charFormatTable.put("Cp930", ebcdic);
        charFormatTable.put("Cp933", ebcdic);
        charFormatTable.put("Cp935", ebcdic);
        charFormatTable.put("Cp937", ebcdic);
        charFormatTable.put("Cp939", ebcdic);
        charFormatTable.put("Cp942", oem);
        charFormatTable.put("Cp948", oem);
        charFormatTable.put("Cp949", oem);
        charFormatTable.put("Cp950", oem);
        charFormatTable.put("Cp964", iso);
        charFormatTable.put("Cp970", iso);
        charFormatTable.put("EUC_CN", iso);
        charFormatTable.put("EUC_JP", iso);
        charFormatTable.put("EUC_KR", iso);
        charFormatTable.put("EUC_TW", iso);
        charFormatTable.put("ISO2022CN", iso);
        charFormatTable.put("ISO2022CN_CNS", iso);
        charFormatTable.put("ISO2022CN_GB", iso);
        charFormatTable.put("ISO2022JP", iso);
        charFormatTable.put("ISO2022KR", iso);
        charFormatTable.put("JIS0201", oem);
        charFormatTable.put("JIS0208", oem);
        charFormatTable.put("JIS0212", oem);
        charFormatTable.put("MS874", ansi);
        charFormatTable.put("MacArabic", mac);
        charFormatTable.put("MacCentralEurope", mac);
        charFormatTable.put("MacCroatian", mac);
        charFormatTable.put("MacCyrillic", mac);
        charFormatTable.put("MacDingbat", mac);
        charFormatTable.put("MacGreek", mac);
        charFormatTable.put("MacHebrew", mac);
        charFormatTable.put("MacIceland", mac);
        charFormatTable.put("MacRoman", mac);
        charFormatTable.put("MacRomania", mac);
        charFormatTable.put("MacSymbol", mac);
        charFormatTable.put("MacThai", mac);
        charFormatTable.put("MacTurkish", mac);
        charFormatTable.put("MacUkraine", mac);
        charFormatTable.put("SJIS", ansi);
    }
}

