/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.codepolicy.SASScope;
import com.sas.io.Encoder;
import com.sas.io.EncoderInterface;
import com.sas.net.sharenet.ShareLocalizedError;
import com.sas.net.sharenet.ShareNetException;
import com.sas.net.sharenet.Wqecon;
import com.sas.net.sharenet.Wqemseg;
import com.sas.net.sharenet.Xhrscm1V6;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

@SASScope
public class Xhrscm1
extends Xhrscm1V6 {
    int sqpversion = 1;
    String dbms = "";
    String options_txt = "";
    String pt2dbpw = "";
    byte[] ept2dbpw = new byte[4];
    private Wqecon con = null;

    public Xhrscm1(Wqecon con) {
        super(con);
        this.con = con;
        this.len = 1071;
    }

    @Override
    public synchronized void setoptions(String opt) {
        this.options_txt = opt;
    }

    public synchronized void setdbms(String dbms) {
        this.dbms = dbms;
    }

    @Override
    public synchronized void write(DataOutputStream stream, int i) throws ShareNetException {
        String shareEncoding = this.con.getShareEncoding();
        EncoderInterface encoder = null;
        try {
            encoder = Encoder.getInstance((String)shareEncoding);
        }
        catch (UnsupportedEncodingException e) {
            String messageIndex = "Sharenet.S463.ex.txt";
            Object[] messageArg = new Object[]{messageIndex, shareEncoding};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Unsupported character encoding: {1}", messageArg));
        }
        byte[] dbmsData = encoder.toByteArray(this.dbms, 0, this.dbms.length());
        int dLen = Math.min(dbmsData.length, 32);
        try {
            stream.writeInt(this.sqpversion);
            stream.writeShort((short)dLen);
            stream.write(dbmsData, 0, dLen);
            if (dLen < 32) {
                byte[] blank = encoder.toByteArray(" ", 0, 1);
                int x = dLen;
                while (x + blank.length <= 32) {
                    stream.write(blank);
                    x += blank.length;
                }
                while (x < 32) {
                    stream.write(0);
                    ++x;
                }
            }
            int oLen = Wqemseg.writeStringAndPad(stream, this.options_txt, 1025, encoder);
            stream.writeInt(oLen);
            stream.write(this.ept2dbpw, 0, 4);
        }
        catch (IOException e) {
            Encoder.returnInstance((EncoderInterface)encoder);
            String messageIndex = "Sharenet.S298.ex.txt";
            Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
        Encoder.returnInstance((EncoderInterface)encoder);
    }
}

