/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.codepolicy.SASScope;
import com.sas.io.Encoder;
import com.sas.io.EncoderInterface;
import com.sas.net.crypto.CipherInterface;
import com.sas.net.crypto.Crypto;
import com.sas.net.crypto.CryptoException;
import com.sas.net.sharenet.Ans1;
import com.sas.net.sharenet.Crypt;
import com.sas.net.sharenet.HTTPConnection;
import com.sas.net.sharenet.Hello;
import com.sas.net.sharenet.Rcmsg;
import com.sas.net.sharenet.ShareLocalizedError;
import com.sas.net.sharenet.ShareNetConnection;
import com.sas.net.sharenet.ShareNetException;
import com.sas.net.sharenet.Tcpmsg;
import com.sas.net.sharenet.WqeUserPass;
import com.sas.net.sharenet.Wqefcb;
import com.sas.net.sharenet.Xvec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

@SASScope
public class Wqecon {
    public static short WQCINIT = (short)8;
    public static short WQCACPT = (short)9;
    public static short WQCTERM = (short)11;
    public static short WQSEND = (short)12;
    private static final String cryptoPolicyNone = "none";
    private static final String cryptoPolicyRequired = "required";
    private static final String cryptoPolicyOptional = "optional";
    private static final String cryptoPolicyDefault = "none";
    private static final int DECRYPTSIZEUSERPASS = 128;
    private static final int ENCRYPTSIZEUSERPASS = 176;
    protected static final int FEATURE_CODEPAGJ = 512;
    protected static final int FEATURE_94PWDSD = 16384;
    public byte tempByte;
    Socket socket = null;
    HTTPConnection httpcon = null;
    DataOutputStream sockOutput = null;
    DataInputStream sockInput = null;
    DataOutputStream sockOut = null;
    DataInputStream sockIn = null;
    ByteArrayInputStream inByteStream = null;
    ByteArrayOutputStream outByteStream = null;
    byte[] inbuffer = new byte[33000];
    int inbufferLen = 33000;
    int alignment = 0;
    boolean connect = false;
    short fcode = 0;
    int nseg = 0;
    int curseg = 0;
    Tcpmsg msg = null;
    public String userpass = "";
    private WqeUserPass userpass94 = new WqeUserPass();
    byte[] padding = null;
    Properties info = null;
    boolean useTunneledSocket = false;
    private String messageIndex;
    private Crypto crypto = null;
    private CipherInterface cipher = null;
    private byte[] codeBuffer = null;
    private ByteArrayOutputStream cipherByteStream = null;
    private DataOutputStream cipherDataStream = null;
    private boolean socketOwner = true;
    private boolean cipherOwner = true;
    protected Vector<Wqefcb> destroyQueue = new Vector();
    private String shareEncoding = null;
    private String serverVersion = null;

    public Wqecon(Properties info) {
        this.info = info;
    }

    public Wqecon(Properties info, HTTPConnection con) {
        this(info);
        this.httpcon = con;
    }

    public void setUserPass(WqeUserPass upobj) {
        this.userpass94 = upobj;
    }

    public Tcpmsg open(String host, int port, Wqefcb fcb) throws ShareNetException {
        return this.openCommon(host, port, null, fcb);
    }

    public Tcpmsg open(Socket sock, CipherInterface cipher, Wqefcb fcb) throws ShareNetException {
        if (cipher != null) {
            this.cipher = cipher;
            this.cipherOwner = false;
        }
        return this.openCommon(null, 0, sock, fcb);
    }

    private synchronized Tcpmsg openCommon(String host, int port, Socket sock, Wqefcb fcb) throws ShareNetException {
        InputStream is;
        int i = 0;
        this.msg = new Tcpmsg();
        Hello hello = new Hello();
        Xvec xvec = new Xvec();
        this.tempByte = xvec.reqv[22];
        byte[] randnum = new byte[8];
        String temp = null;
        String cryptoPolicy = "none";
        String cryptoAlgorithms = null;
        if (!this.userpass94.containsCredentials()) {
            this.userpass94.setPre94UserPass(this.userpass);
        }
        if (this.info != null) {
            temp = this.info.getProperty("routerUrl");
            if (this.cipher == null) {
                String cryptoTarget = this.info.getProperty("encryptionTarget");
                if (cryptoTarget != null && cryptoTarget.equals("telnet")) {
                    cryptoPolicy = "none";
                } else {
                    cryptoPolicy = this.info.getProperty("encryptionPolicy", "none");
                    if (!(cryptoPolicy.equals("none") || cryptoPolicy.equals(cryptoPolicyRequired) || cryptoPolicy.equals(cryptoPolicyOptional))) {
                        this.messageIndex = "Sharenet.S318.ex.txt";
                        Object[] messageArg = new Object[]{this.messageIndex, cryptoPolicy};
                        throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Invalid encryption policy specified: {1}.", messageArg));
                    }
                    cryptoAlgorithms = this.info.getProperty("encryptionAlgorithms");
                }
            }
        }
        if (temp == null || temp.length() == 0) {
            try {
                if (sock == null) {
                    this.socket = new Socket(host, port);
                } else {
                    this.socket = sock;
                    this.socketOwner = false;
                }
                this.sockOutput = new DataOutputStream(this.socket.getOutputStream());
                this.sockInput = new DataInputStream(this.socket.getInputStream());
            }
            catch (IOException e) {
                this.messageIndex = "Sharenet.S273.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex, host, String.valueOf(port), e.getMessage()};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Driver could not open socket. Server: {1} port: {2}. {3}", messageArg));
            }
        }
        if (cryptoPolicy.equals(cryptoPolicyOptional)) {
            cryptoPolicy = "none";
        }
        if ((temp = this.info.getProperty("useTunneledSocket")) != null) {
            try {
                Boolean btemp = Boolean.valueOf(temp);
                this.useTunneledSocket = btemp;
            }
            catch (Exception e) {
                this.messageIndex = "Sharenet.S274.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Invalid value for useTunneledSocket property.", messageArg));
            }
        }
        if (this.httpcon == null) {
            this.httpcon = new HTTPConnection(host, port, this.info);
        } else {
            port = this.httpcon.getPort();
        }
        this.sockOutput = new DataOutputStream(this.httpcon.getOutputStream());
        this.connect = true;
        this.msg.pname = port;
        hello.feature_set_src |= 8;
        if (!cryptoPolicy.equals("none") && this.cipher == null && sock == null) {
            hello.feature_set_src |= 2;
        }
        hello.feature_set_src |= 0x200;
        hello.feature_set_src = this.userpass94.hasEmbeddedPeriodInUserName() ? (hello.feature_set_src |= 0x4000) : (hello.feature_set_src &= 0xFFFFBFFF);
        if (this.userpass94.hasEmbeddedBlankInPassword()) {
            hello.feature_set_src |= 0x4000;
        }
        try {
            hello.write(this.sockOutput);
        }
        catch (ShareNetException se) {
            this.destroy();
            throw se;
        }
        if (this.httpcon != null) {
            is = this.httpcon.sendInit();
            this.sockInput = new DataInputStream(is);
        }
        try {
            hello.read(this.sockInput);
            if (cryptoPolicy.equals(cryptoPolicyRequired)) {
                this.messageIndex = "Sharenet.S319.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: The server does not support encryption.", messageArg));
            }
            if (this.cipher != null) {
                this.cipherByteStream = new ByteArrayOutputStream();
                this.cipherDataStream = new DataOutputStream(this.cipherByteStream);
            }
        }
        catch (ShareNetException se) {
            int code = se.getErrorCode();
            if (code != 70 && code != 60 && code != 80 && code != 81) {
                this.messageIndex = "Sharenet.S275.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex, se.getMessage()};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
            }
            if (cryptoPolicy.equals(cryptoPolicyRequired) && (code == 70 || code == 60)) {
                this.messageIndex = "Sharenet.S320.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: The server does not support encryption.", messageArg));
            }
            if (code == 70) {
                try {
                    this.sockInput.readFully(randnum, 0, 8);
                    Crypt crypt = new Crypt();
                    int cryptlen = 0;
                    byte[] cryptbuf = new byte[176];
                    cryptlen = crypt.zscode(randnum, 8, cryptbuf, cryptlen);
                    this.sockOutput.writeInt(cryptlen);
                    this.sockOutput.write(cryptbuf, 0, cryptlen);
                    byte[] tuserpass = new byte[128];
                    byte[] tbytes = this.userpass94.getAuthByteArray();
                    if (tbytes.length > 128) {
                        this.messageIndex = "Sharenet.S583.ex.txt";
                        Object[] messageArg = new Object[]{this.messageIndex, Integer.toString(tbytes.length), Integer.toString(127)};
                        throw new ShareNetException(ShareLocalizedError.getLocalizedError("The server does not support a Userid + Password length of {1} bytes. {2} bytes total is the maximum limit", messageArg));
                    }
                    System.arraycopy(tbytes, 0, tuserpass, 0, tbytes.length);
                    for (i = tbytes.length; i < 128; ++i) {
                        tuserpass[i] = 32;
                    }
                    cryptlen = crypt.zscode(tuserpass, 128, cryptbuf, cryptlen);
                    this.sockOutput.writeInt(cryptlen);
                    this.sockOutput.write(cryptbuf, 0, cryptlen);
                    if (this.httpcon != null) {
                        InputStream is2 = this.httpcon.sendEncrypt();
                        this.sockInput = new DataInputStream(is2);
                    }
                    this.sockInput.readFully(cryptbuf, 0, 4);
                    for (i = 0; i < 4; ++i) {
                        if (cryptbuf[i] == 0) continue;
                        this.destroy();
                        hello.reason = 60;
                        this.messageIndex = "Sharenet.S276.ex.txt";
                        Object[] messageArg = new Object[]{this.messageIndex};
                        throw new ShareNetException(-1019, ShareLocalizedError.getLocalizedError("Userid/Password not accepted by server", messageArg));
                    }
                }
                catch (IOException se2) {
                    this.destroy();
                    hello.reason = 60;
                    this.messageIndex = "Sharenet.S277.ex.txt";
                    Object[] messageArg = new Object[]{this.messageIndex};
                    throw new ShareNetException(-1019, ShareLocalizedError.getLocalizedError("Userid/Password not accepted by server", messageArg));
                }
            }
            if (code == 60) {
                this.destroy();
                if (temp == null) {
                    try {
                        if (sock == null) {
                            this.socket = new Socket(host, port);
                        }
                        this.sockOutput = new DataOutputStream(this.socket.getOutputStream());
                        this.sockInput = new DataInputStream(this.socket.getInputStream());
                    }
                    catch (IOException e) {
                        this.messageIndex = "Sharenet.S278.ex.txt";
                        Object[] messageArg = new Object[]{this.messageIndex, host, String.valueOf(port), e.getMessage()};
                        throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Driver could not open socket. Server: {1} port: {2}. {3}", messageArg));
                    }
                } else {
                    this.httpcon = new HTTPConnection(host, port, this.info);
                    this.sockOutput = new DataOutputStream(this.httpcon.getOutputStream());
                }
                this.connect = true;
                hello = new Hello();
                hello.userpass = this.userpass94.getHelloString();
                try {
                    hello.write(this.sockOutput);
                    if (this.httpcon != null) {
                        InputStream is3 = this.httpcon.sendInit();
                        this.sockInput = new DataInputStream(is3);
                    }
                    hello.read(this.sockInput);
                }
                catch (ShareNetException ie) {
                    this.destroy();
                    this.messageIndex = "Sharenet.S279.ex.txt";
                    Object[] messageArg = new Object[]{this.messageIndex, ie.getMessage()};
                    throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
                }
            }
            if (code == 80 || code == 81) {
                if (this.httpcon != null) {
                    this.destroy();
                    this.messageIndex = "Sharenet.S316.ex.txt";
                    Object[] messageArg = new Object[]{this.messageIndex};
                    throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: The Tunnel feature does not support encryption.", messageArg));
                }
                try {
                    int nameLen = this.sockInput.readInt();
                    String serverAlgs = null;
                    if (nameLen > 0) {
                        byte[] nameBuf = new byte[nameLen];
                        this.sockInput.readFully(nameBuf, 0, nameLen);
                        serverAlgs = Wqecon.byteToChar8859_1(nameBuf, 0, nameLen).trim();
                    }
                    String[] serverAlgList = null;
                    if (serverAlgs != null && serverAlgs.length() > 0) {
                        StringTokenizer serverTokens = new StringTokenizer(serverAlgs, "\u0000");
                        int serverTokenCount = serverTokens.countTokens();
                        serverAlgList = new String[serverTokenCount];
                        for (int stci = 0; stci < serverTokenCount; ++stci) {
                            serverAlgList[stci] = serverTokens.nextToken().trim();
                        }
                    }
                    if (serverAlgList != null && serverAlgList.length > 0) {
                        StringTokenizer clientTokens = null;
                        clientTokens = cryptoAlgorithms != null && cryptoAlgorithms.length() > 0 ? new StringTokenizer(cryptoAlgorithms.trim(), ",") : new StringTokenizer(serverAlgs, "\u0000");
                        String algName = null;
                        while (true) {
                            if (clientTokens.hasMoreTokens()) {
                                int sali;
                                algName = clientTokens.nextToken().trim();
                                for (sali = 0; sali < serverAlgList.length && !algName.equalsIgnoreCase(serverAlgList[sali]); ++sali) {
                                }
                                if (sali >= serverAlgList.length) continue;
                            }
                            if (algName != null && algName.length() > 0) {
                                this.crypto = Crypto.getCrypto((String)algName, (Properties)this.info);
                            }
                            if (this.crypto != null || !clientTokens.hasMoreTokens()) break;
                        }
                    }
                    this.codeBuffer = new byte[44];
                    if (this.crypto != null) {
                        String algName = this.crypto.getName();
                        int l = algName.length();
                        for (int zzz = 0; zzz < l && zzz < 32; ++zzz) {
                            this.codeBuffer[zzz] = (byte)algName.charAt(zzz);
                        }
                        if (l < 32) {
                            this.codeBuffer[l] = 0;
                        }
                    } else {
                        this.codeBuffer[0] = 0;
                    }
                    this.sockOutput.write(this.codeBuffer, 0, 32);
                    if (this.crypto == null) {
                        this.destroy();
                        if (cryptoPolicy.equals(cryptoPolicyRequired) || code == 81) {
                            this.messageIndex = "Sharenet.S306.ex.txt";
                            Object[] messageArg = new Object[]{this.messageIndex};
                            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Encryption algorithm negotiation failed.", messageArg));
                        }
                        cryptoPolicy = "none";
                        if (sock == null) {
                            this.socket = new Socket(host, port);
                        }
                        this.sockOutput = new DataOutputStream(this.socket.getOutputStream());
                        this.sockInput = new DataInputStream(this.socket.getInputStream());
                        this.connect = true;
                        hello = new Hello();
                        hello.userpass = this.userpass94.getHelloString();
                        hello.write(this.sockOutput);
                        hello.read(this.sockInput);
                    } else {
                        this.cipher = this.crypto.openCipher();
                        this.cipher.keyExchange((InputStream)this.sockInput, (OutputStream)this.sockOutput);
                        for (int zzz = 0; zzz < 44; ++zzz) {
                            this.codeBuffer[zzz] = 0;
                        }
                        this.codeBuffer[3] = 44;
                        this.codeBuffer[7] = 1;
                        int upLen = this.userpass94.getHelloStringLength();
                        if (upLen <= 36) {
                            for (int zzz = 0; zzz < upLen; ++zzz) {
                                this.codeBuffer[zzz + 8] = (byte)this.userpass94.charInHelloString(zzz);
                            }
                        }
                        int cipherTextLength = this.cipher.encrypt(this.codeBuffer, 0, 44, (OutputStream)this.sockOutput);
                        this.cipher.decrypt((InputStream)this.sockInput, cipherTextLength, this.codeBuffer, 0);
                        if (this.codeBuffer[7] != 2) {
                            this.destroy();
                            this.messageIndex = "Sharenet.S305.ex.txt";
                            Object[] messageArg = new Object[]{this.messageIndex};
                            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Userid/Password not accepted by server.", messageArg));
                        }
                        this.cipherByteStream = new ByteArrayOutputStream();
                        this.cipherDataStream = new DataOutputStream(this.cipherByteStream);
                    }
                }
                catch (IOException e) {
                    this.destroy();
                    this.messageIndex = "Sharenet.S278.ex.txt";
                    Object[] messageArg = new Object[]{this.messageIndex, host, String.valueOf(port), e.getMessage()};
                    throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Driver could not open socket. Server: {1} port: {2}. {3}", messageArg));
                }
                catch (CryptoException c) {
                    this.destroy();
                    this.messageIndex = "Sharenet.S309.ex.txt";
                    Object[] messageArg = new Object[]{this.messageIndex, c.getMessage()};
                    throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Cryptography utility initialization failed due to the following reason: {1}", messageArg));
                }
            }
            this.messageIndex = "Sharenet.S280.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, se.getMessage()};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
        if ((hello.feature_set_tgt & 0x200) != 0) {
            this.shareEncoding = hello.userpass.trim();
            xvec.setTranscode((byte)1);
        } else if (this.info != null) {
            String textTransportFormat = this.info.getProperty("textTransportFormat");
            if (textTransportFormat != null && textTransportFormat.length() > 0) {
                this.shareEncoding = textTransportFormat;
                xvec.setCharacterEncoding(this.shareEncoding);
            } else {
                this.shareEncoding = xvec.getCharacterEncoding();
            }
        } else {
            this.shareEncoding = xvec.getCharacterEncoding();
        }
        try {
            EncoderInterface encoder = Encoder.getInstance((String)this.shareEncoding);
            Encoder.returnInstance((EncoderInterface)encoder);
        }
        catch (UnsupportedEncodingException e) {
            this.destroy();
            this.messageIndex = "Sharenet.S458.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, this.shareEncoding};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Unsupported character encoding: {1}", messageArg));
        }
        this.serverVersion = hello.supver;
        try {
            xvec.write(this.sockOutput);
            if (this.httpcon != null) {
                is = this.httpcon.sendEndInit();
                this.sockInput = new DataInputStream(is);
            }
            xvec.read(this.sockInput);
        }
        catch (ShareNetException ie) {
            this.destroy();
            this.messageIndex = "Sharenet.S281.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, ie.getMessage()};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
        this.alignment = this.tempByte > xvec.reqv[22] ? (int)this.tempByte : xvec.reqv[22];
        this.alignment = 1 << this.alignment;
        this.padding = new byte[this.alignment];
        if (this.httpcon != null && this.useTunneledSocket) {
            try {
                this.socket = new Socket(this.httpcon.getShrHost(), this.httpcon.getShrPort());
                this.sockOutput = new DataOutputStream(this.socket.getOutputStream());
                this.sockInput = new DataInputStream(this.socket.getInputStream());
                int type = 77;
                this.sockOutput.writeByte(type);
            }
            catch (IOException e) {
                this.messageIndex = "Sharenet.S282.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex, host, String.valueOf(port), e.getMessage()};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Driver could not open socket. Server: {1} port: {2}. {3}", messageArg));
            }
        }
        this.inByteStream = new ByteArrayInputStream(this.inbuffer);
        this.outByteStream = new ByteArrayOutputStream(this.inbufferLen);
        this.sockIn = new DataInputStream(this.inByteStream);
        this.sockOut = new DataOutputStream(this.outByteStream);
        this.fcode = WQCINIT;
        fcb.setWQCINIT();
        this.sendrecv(fcb);
        return this.msg;
    }

    public synchronized Tcpmsg sendFirst(String host, int port, Wqefcb fcb) throws ShareNetException {
        this.msg = new Tcpmsg();
        this.msg.pname = 1112098374;
        this.fcode = WQCINIT;
        fcb.setWQCINIT();
        this.sendrecv(fcb);
        return this.msg;
    }

    public synchronized void destroy() {
        try {
            this.sockOutput.flush();
            if (this.cipher != null && this.cipherOwner) {
                try {
                    this.cipher.close();
                    this.cipher = null;
                    this.crypto = null;
                    this.codeBuffer = null;
                    this.cipherByteStream = null;
                    this.cipherDataStream = null;
                }
                catch (CryptoException cryptoException) {
                    // empty catch block
                }
            }
            if (this.httpcon != null) {
                if (this.useTunneledSocket) {
                    this.socket.close();
                }
                this.httpcon.close();
            } else if (this.socketOwner) {
                this.socket.close();
            }
            this.connect = false;
        }
        catch (IOException e) {
            this.connect = false;
        }
        catch (ShareNetException e) {
            this.connect = false;
        }
    }

    public synchronized void sendrecv(Wqefcb fcb) throws ShareNetException {
        int i = 0;
        int pad = 0;
        int align = 0;
        int minfol = 0;
        this.sendmsg(fcb);
        if (this.msg.fcode == 1025) {
            return;
        }
        try {
            this.inByteStream.reset();
            this.sockInput.readFully(this.inbuffer, 0, 48);
            this.msg.read(this.sockIn);
            int count = this.msg.minfol + this.msg.msglen;
            if (count > this.inbufferLen - 48) {
                this.inbuffer = new byte[count + 48];
                this.inByteStream = new ByteArrayInputStream(this.inbuffer);
                this.sockIn = new DataInputStream(this.inByteStream);
                this.sockInput.readFully(this.inbuffer, 0, count);
            } else {
                this.sockInput.readFully(this.inbuffer, 48, count);
            }
        }
        catch (IOException e) {
            this.messageIndex = "Sharenet.S283.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, e.getMessage()};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
        if (this.msg.fcode == 1025) {
            try {
                this.connect = false;
                this.sockOutput.flush();
                if (this.cipher != null && this.cipherOwner) {
                    try {
                        this.cipher.close();
                        this.cipher = null;
                        this.crypto = null;
                        this.codeBuffer = null;
                        this.cipherByteStream = null;
                        this.cipherDataStream = null;
                    }
                    catch (CryptoException e) {
                        // empty catch block
                    }
                }
                if (this.httpcon != null) {
                    if (this.useTunneledSocket) {
                        this.socket.close();
                    }
                    this.httpcon.close();
                } else if (this.socketOwner) {
                    this.socket.close();
                }
                this.messageIndex = "Sharenet.S284.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Server would not accept message.", messageArg));
            }
            catch (IOException e) {
                this.messageIndex = "Sharenet.S285.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Server would not accept message.", messageArg));
            }
        }
        if (this.fcode == WQCINIT && this.msg.fcode != WQCACPT) {
            try {
                this.connect = false;
                this.sockOutput.flush();
                if (this.cipher != null && this.cipherOwner) {
                    try {
                        this.cipher.close();
                        this.cipher = null;
                        this.crypto = null;
                        this.codeBuffer = null;
                        this.cipherByteStream = null;
                        this.cipherDataStream = null;
                    }
                    catch (CryptoException e) {
                        // empty catch block
                    }
                }
                if (this.httpcon != null) {
                    if (this.useTunneledSocket) {
                        this.socket.close();
                    }
                    this.httpcon.close();
                } else if (this.socketOwner) {
                    this.socket.close();
                }
                minfol = this.msg.minfol - this.msg.length;
                fcb.minfo.readMinfo(this.sockIn, minfol / 4);
                align = this.msg.minfol;
                if (this.alignment != 0) {
                    for (i = 0; i < this.nseg; ++i) {
                        if (fcb.waseg[i].len == 0) continue;
                        fcb.waseg[i].read(this.sockIn, fcb.waseg[i].len);
                        align += fcb.waseg[i].len;
                    }
                }
                Ans1 answer = (Ans1)fcb.waseg[0];
                String firstpart = "";
                if (answer.buf != null) {
                    String ansmsg = "";
                    ansmsg = new String(answer.buf, 0, answer.len);
                    StringTokenizer nullStripper = new StringTokenizer(ansmsg, "\u0000");
                    firstpart = nullStripper.nextToken();
                }
                this.messageIndex = "Sharenet.S286.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex, firstpart};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Server would not accept connection: {1}.", messageArg));
            }
            catch (IOException e) {
                this.messageIndex = "Sharenet.S287.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Server would not accept connection.", messageArg));
            }
        }
        minfol = this.msg.minfol - this.msg.length;
        fcb.minfo.readMinfo(this.sockIn, minfol / 4);
        align = this.msg.minfol;
        if (this.alignment != 0) {
            pad = (align + this.alignment - 1) / this.alignment * this.alignment;
            if ((pad -= align) != 0) {
                try {
                    this.sockIn.readFully(this.padding, 0, pad);
                }
                catch (IOException e) {
                    this.messageIndex = "Sharenet.S288.ex.txt";
                    Object[] messageArg = new Object[]{this.messageIndex, e.getMessage()};
                    throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
                }
                align += pad;
            }
        }
        try {
            if (this.cipher != null && this.msg.msglen > 0) {
                int maxPlainTextLen = this.cipher.getMaxPlainTextLength(this.msg.msglen);
                if (this.codeBuffer == null || this.codeBuffer.length < maxPlainTextLen) {
                    this.codeBuffer = new byte[maxPlainTextLen];
                }
                int plainTextLen = this.cipher.decrypt((InputStream)this.sockIn, this.msg.msglen, this.codeBuffer, 0);
                for (int zzz = 0; zzz < plainTextLen; ++zzz) {
                    this.inbuffer[zzz] = this.codeBuffer[zzz];
                }
                this.inByteStream.reset();
                this.msg.msglen = plainTextLen;
            }
            for (i = 0; i < this.nseg; ++i) {
                if (fcb.waseg[i].len != 0) {
                    fcb.waseg[i].read(this.sockIn, fcb.waseg[i].len);
                    align += fcb.waseg[i].len;
                }
                if (this.alignment == 0) continue;
                pad = (align + this.alignment - 1) / this.alignment * this.alignment;
                if ((pad -= align) == 0) continue;
                this.sockIn.readFully(this.padding, 0, pad);
                align += pad;
            }
        }
        catch (IOException e) {
            this.messageIndex = "Sharenet.S289.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, e.getMessage()};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
        catch (CryptoException c) {
            this.messageIndex = "Sharenet.S310.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, c.getMessage()};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Data decryption failed due to the following reason: {1}", messageArg));
        }
    }

    public synchronized void sendmsg(Wqefcb fcb) throws ShareNetException {
        int i = 0;
        int l = 0;
        int align = 0;
        int pad = 0;
        int minfol = 0;
        int msgoff = 0;
        this.outByteStream.reset();
        minfol = fcb.minfo.length + 8 * fcb.nseg + fcb.minfo.mhdrl;
        msgoff = 8 * fcb.nseg;
        this.msg.minfol = minfol;
        this.nseg = fcb.calcNseg();
        l = 0;
        for (i = 0; i < this.nseg; ++i) {
            l += fcb.wmseg[i].len;
            if (this.alignment == 0) continue;
            l = (l + this.alignment - 1) / this.alignment * this.alignment;
        }
        if (this.cipher != null && l > 0) {
            l = this.cipher.getCipherTextLength(l);
        }
        this.msg.msglen = l;
        this.msg.fcode = this.fcode;
        this.msg.nseg = (short)this.nseg;
        this.msg.aname = fcb.aname;
        this.msg.write(this.sockOut);
        fcb.writeMinfo(this.sockOut);
        if (this.msg.fcode == WQCTERM) {
            this.msg.fcode = (short)1025;
            this.msg.nseg = 0;
            fcb.minfo.msegcnt = 0;
            this.msg.write(this.sockOut);
            try {
                this.outByteStream.writeTo(this.sockOutput);
                this.sockOutput.flush();
                this.connect = false;
                if (this.cipher != null && this.cipherOwner) {
                    try {
                        this.cipher.close();
                        this.cipher = null;
                        this.crypto = null;
                        this.codeBuffer = null;
                        this.cipherByteStream = null;
                        this.cipherDataStream = null;
                    }
                    catch (CryptoException cryptoException) {
                        // empty catch block
                    }
                }
                if (this.httpcon != null) {
                    if (this.useTunneledSocket) {
                        this.socket.close();
                    }
                    this.httpcon.close();
                } else if (this.socketOwner) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        try {
            align = this.msg.length + fcb.minfo.length + msgoff + fcb.minfo.mhdrl;
            if (this.alignment != 0) {
                pad = (align + this.alignment - 1) / this.alignment * this.alignment;
                if ((pad -= align) != 0) {
                    this.sockOut.write(this.padding, 0, pad);
                    align += pad;
                }
            }
            if (this.cipher != null) {
                this.cipherByteStream.reset();
                for (i = 0; i < this.nseg; ++i) {
                    l = fcb.wmseg[i].len;
                    if (l > 0) {
                        fcb.wmseg[i].write(this.cipherDataStream, l);
                    }
                    align += l;
                    if (this.alignment == 0) continue;
                    pad = (align + this.alignment - 1) / this.alignment * this.alignment;
                    if ((pad -= align) == 0) continue;
                    this.cipherDataStream.write(this.padding, 0, pad);
                    align += pad;
                }
                byte[] payload = this.cipherByteStream.toByteArray();
                int payloadLength = this.cipherByteStream.size();
                if (payloadLength > 0) {
                    this.cipher.encrypt(payload, 0, payloadLength, (OutputStream)this.sockOut);
                }
            } else {
                for (i = 0; i < this.nseg; ++i) {
                    l = fcb.wmseg[i].len;
                    if (l > 0) {
                        fcb.wmseg[i].write(this.sockOut, l);
                    }
                    align += l;
                    if (this.alignment == 0) continue;
                    pad = (align + this.alignment - 1) / this.alignment * this.alignment;
                    if ((pad -= align) == 0) continue;
                    this.sockOut.write(this.padding, 0, pad);
                    align += pad;
                }
            }
            this.outByteStream.writeTo(this.sockOutput);
            this.sockOutput.flush();
            if (this.httpcon != null && !this.useTunneledSocket) {
                InputStream is = this.httpcon.send();
                this.sockInput = new DataInputStream(is);
            }
        }
        catch (IOException e) {
            this.messageIndex = "Sharenet.S290.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, e.getMessage()};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
        catch (CryptoException c) {
            this.messageIndex = "Sharenet.S311.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, c.getMessage()};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Data encryption failed due to the following reason: {1}", messageArg));
        }
    }

    public synchronized void wqesndm(Wqefcb fcb, Tcpmsg msg) throws ShareNetException {
        this.msg = msg;
        if (!this.connect) {
            this.messageIndex = "Sharenet.S291.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: No connection to server.", messageArg));
        }
        this.fcode = WQSEND;
        while (!this.destroyQueue.isEmpty()) {
            Wqefcb destroyFcb = this.destroyQueue.elementAt(0);
            this.sendrecv(destroyFcb);
            this.destroyQueue.removeElement(destroyFcb);
            Rcmsg rcmsg = (Rcmsg)destroyFcb.waseg[1];
            Ans1 ans1 = (Ans1)destroyFcb.waseg[0];
            if (destroyFcb.acc >= 0) continue;
            String tempMsg = ShareNetConnection.formatMsg(destroyFcb.acc, ans1, rcmsg);
            this.messageIndex = "Sharenet.S457.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, String.valueOf(destroyFcb.acc), tempMsg};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1} {2}", messageArg));
        }
        this.sendrecv(fcb);
    }

    public synchronized void wqeclos(Tcpmsg msg) throws ShareNetException {
        this.msg = msg;
        Wqefcb fcb = new Wqefcb();
        if (this.connect) {
            this.fcode = WQCTERM;
            this.sendrecv(fcb);
            this.connect = false;
        }
    }

    public String getShareEncoding() {
        return this.shareEncoding;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    private static byte[] charToByte8859_1(String s) {
        int len = s.length();
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            b[i] = (byte)s.charAt(i);
        }
        return b;
    }

    private static String byteToChar8859_1(byte[] b, int o, int l) {
        char[] c = new char[l];
        int i = 0;
        int x = o;
        while (i < l) {
            byte t = b[x];
            c[i++] = t >= 0 ? (char)t : (char)(t + 256);
            ++x;
        }
        return new String(c, 0, l);
    }

    private static void printBuffer(byte[] byteArray, int length) {
        int i;
        StringBuffer textLine = new StringBuffer("                ");
        System.out.print("; 00000000: ");
        for (i = 0; i < length; ++i) {
            if (i % 16 == 0 && i != 0) {
                System.out.println("[" + textLine + "]");
                System.out.print("; ");
                Wqecon.hexPrint(i, 8);
                System.out.print(": ");
                for (int j = 0; j < 16; ++j) {
                    textLine.setCharAt(j, ' ');
                }
            }
            Wqecon.hexPrint(byteArray[i], 2);
            System.out.print(" ");
            if (byteArray[i] < 32 || (byteArray[i] & 0xFF) > 127) {
                textLine.setCharAt(i % 16, '.');
                continue;
            }
            textLine.setCharAt(i % 16, (char)byteArray[i]);
        }
        if (length % 16 != 0 || length == 0) {
            for (i = 0; i < 16 - length % 16; ++i) {
                System.out.print("   ");
            }
        }
        System.out.println("[" + textLine + "]");
    }

    private static void hexPrint(int value, int padding) {
        String hexString = "0123456789ABCDEF";
        for (int i = padding - 1; i >= 0; --i) {
            System.out.print(hexString.charAt(value >> i * 4 & 0xF));
        }
    }
}

