/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.codepolicy.SASScope;
import com.sas.net.crypto.SealedString;
import java.nio.CharBuffer;
import java.util.Arrays;

@SASScope
public class WqeUserPass {
    private String userName = "";
    private SealedString passwordAsSealedString = new SealedString("");
    private String separationChar = ".";
    private boolean initialized = false;

    public void setUserName(String u) {
        this.initialized = true;
        if (u != null) {
            this.userName = u;
        }
    }

    public void setPassword(String p) {
        this.initialized = true;
        if (p != null) {
            this.passwordAsSealedString = new SealedString(p);
        }
    }

    public void setPasswordAsChars(char[] p) {
        this.initialized = true;
        if (p != null) {
            this.passwordAsSealedString = new SealedString(p);
        }
    }

    public void setPre94UserPass(String up) {
        this.initialized = true;
        if (up == null) {
            return;
        }
        if (up.isEmpty()) {
            return;
        }
        if (up.contains(".")) {
            String[] parts = up.split("\\.");
            if (parts.length >= 1) {
                this.setUserName(parts[0]);
            }
            if (parts.length >= 2) {
                this.setPassword(parts[1]);
            }
        } else {
            this.setUserName(up);
        }
    }

    public boolean containsCredentials() {
        return this.initialized;
    }

    public String getHelloString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.userName);
        buf.append(".");
        char[] passwordAsChars = this.getPasswordAsChars();
        buf.append(passwordAsChars);
        Arrays.fill(passwordAsChars, '\u0000');
        String result = buf.toString();
        this.clearStringBuffer(buf);
        return result;
    }

    public int getHelloStringLength() {
        return this.getHelloString().length();
    }

    public char charInHelloString(int i) {
        if (i > this.getHelloStringLength() || i < 0) {
            return '\u0000';
        }
        String combo = this.getHelloString();
        return combo.charAt(i);
    }

    public byte[] getAuthByteArray() {
        boolean addNullTerminator = false;
        if (this.hasEmbeddedPeriodInUserName()) {
            this.separationChar = "\u0000";
            addNullTerminator = true;
        }
        if (this.hasEmbeddedBlankInPassword()) {
            this.separationChar = "\u0000";
            addNullTerminator = true;
        }
        byte[] user = this.stringToByteArray(this.userName);
        char[] passwordAsChars = this.getPasswordAsChars();
        CharBuffer passwordAsCharBuf = CharBuffer.wrap(passwordAsChars);
        byte[] pass = this.stringToByteArray(passwordAsCharBuf);
        Arrays.fill(passwordAsChars, '\u0000');
        byte[] sep = this.stringToByteArray(this.separationChar);
        byte[] userpass = new byte[user.length + sep.length + pass.length + 1];
        System.arraycopy(user, 0, userpass, 0, user.length);
        System.arraycopy(sep, 0, userpass, user.length, sep.length);
        System.arraycopy(pass, 0, userpass, user.length + sep.length, pass.length);
        userpass[user.length + sep.length + pass.length] = addNullTerminator ? 0 : 32;
        Arrays.fill(pass, (byte)0);
        return userpass;
    }

    public boolean hasEmbeddedPeriodInUserName() {
        return this.userName.contains(".");
    }

    public boolean hasEmbeddedBlankInPassword() {
        char[] passwordAsChars = this.getPasswordAsChars();
        int passwordL = passwordAsChars.length;
        StringBuffer passwordBuf = new StringBuffer(passwordL);
        passwordBuf.append(passwordAsChars);
        Arrays.fill(passwordAsChars, '\u0000');
        boolean result = passwordBuf.indexOf(" ") >= 0;
        this.clearStringBuffer(passwordBuf);
        return result;
    }

    private byte[] stringToByteArray(CharSequence s) {
        int len = s.length();
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            b[i] = (byte)s.charAt(i);
        }
        return b;
    }

    private char[] getPasswordAsChars() {
        return this.passwordAsSealedString.getCharacters();
    }

    private void clearStringBuffer(StringBuffer buf) {
        int bufL = buf.length();
        for (int i = 0; i < bufL; ++i) {
            buf.setCharAt(i, '\u0000');
        }
    }
}

