/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.codepolicy.SASScope;
import com.sas.net.sharenet.ShareLocalizedError;
import com.sas.net.sharenet.ShareNetException;
import com.sas.net.sharenet.SqlFieldArray;
import com.sas.net.sharenet.SqlValue;
import com.sas.net.sharenet.SqpCharacterValue;
import com.sas.net.sharenet.SqpDateTimeValue;
import com.sas.net.sharenet.SqpNumericValue;
import com.sas.net.sharenet.Wqeaseg;
import java.io.DataInputStream;
import java.io.IOException;

@SASScope
public class SqlValueArray
extends Wqeaseg {
    int temp;
    boolean v6 = true;
    private String messageIndex;
    private int fetchSize;
    private String shareEncoding = null;
    SqlValue[][] array;
    SqlFieldArray variables;
    static final int XHRSQPGOTREC = 2;
    static final int XHRSQPTRUNC = 1;
    static final int XHRSQPEOF = 0;

    public SqlValueArray() {
        this.temp = 0;
    }

    public SqlValueArray(boolean v6) {
        this.temp = 0;
        this.v6 = v6;
    }

    public SqlValueArray(SqlFieldArray v) {
        this.array = new SqlValue[10][v.length()];
        this.variables = v;
    }

    public SqlValueArray(SqlFieldArray v, boolean v6, int fetchSize, String shareEncoding) {
        this.v6 = v6;
        this.fetchSize = fetchSize;
        this.shareEncoding = shareEncoding;
        this.array = new SqlValue[fetchSize][v.length()];
        this.variables = v;
        this.len = this.calculateLength();
    }

    public SqlValueArray(int rows, SqlFieldArray v) {
        this.array = new SqlValue[rows][v.length()];
        this.variables = v;
        this.len = this.calculateLength();
    }

    public SqlValueArray(int rows, SqlFieldArray v, boolean v6) {
        this.v6 = v6;
        this.array = new SqlValue[rows][v.length()];
        this.variables = v;
        this.len = this.calculateLength();
    }

    @Override
    public void read(DataInputStream stream, int i) throws ShareNetException {
        try {
            int count = (int)stream.readLong();
            for (int blockIndex = 0; blockIndex < this.fetchSize; ++blockIndex) {
                block8: for (int varIndex = 0; varIndex < this.variables.array.length; ++varIndex) {
                    if (this.variables.array[varIndex].type != 1) continue;
                    switch (this.variables.array[varIndex].subtype) {
                        case 1: {
                            this.array[blockIndex][varIndex] = new SqpDateTimeValue(this.variables.array[varIndex], true, false);
                            this.array[blockIndex][varIndex].read(stream);
                            continue block8;
                        }
                        case 2: {
                            this.array[blockIndex][varIndex] = new SqpDateTimeValue(this.variables.array[varIndex], false, true);
                            this.array[blockIndex][varIndex].read(stream);
                            continue block8;
                        }
                        case 3: {
                            this.array[blockIndex][varIndex] = new SqpDateTimeValue(this.variables.array[varIndex], true, true);
                            this.array[blockIndex][varIndex].read(stream);
                            continue block8;
                        }
                        default: {
                            this.array[blockIndex][varIndex] = new SqpNumericValue(this.variables.array[varIndex]);
                            this.array[blockIndex][varIndex].read(stream);
                        }
                    }
                }
            }
            count = (int)stream.readLong();
            int numCvars = count / this.fetchSize - 1;
            byte[] flags = new byte[count];
            stream.readFully(flags);
            for (int blockIndex = 0; blockIndex < this.fetchSize; ++blockIndex) {
                int varIndex;
                int flagOffset = 0;
                if (flags[blockIndex * (numCvars + 1)] == 0) {
                    ++flagOffset;
                    for (varIndex = 0; varIndex < this.variables.array.length; ++varIndex) {
                        if (this.variables.array[varIndex].type != 2) continue;
                        this.array[blockIndex][varIndex] = new SqpCharacterValue(this.variables.array[varIndex], flags[blockIndex * (numCvars + 1) + flagOffset] == 1, this.shareEncoding);
                        ++flagOffset;
                        this.array[blockIndex][varIndex].read(stream);
                    }
                    this.array[blockIndex] = null;
                    continue;
                }
                ++flagOffset;
                for (varIndex = 0; varIndex < this.variables.array.length; ++varIndex) {
                    if (this.variables.array[varIndex].type != 2) continue;
                    this.array[blockIndex][varIndex] = new SqpCharacterValue(this.variables.array[varIndex], flags[blockIndex * (numCvars + 1) + flagOffset] == 1, this.shareEncoding);
                    ++flagOffset;
                    this.array[blockIndex][varIndex].read(stream);
                }
            }
        }
        catch (IOException e) {
            this.messageIndex = "Sharenet.S265.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, e.getMessage()};
            throw new ShareNetException(-1, ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
    }

    private int calculateLength() {
        int l1 = 0;
        int l2 = 0;
        int l3 = 0;
        int l4 = 0;
        int l5 = 0;
        int lnvalues = 0;
        int lcvalues = 0;
        int nnvalues = 0;
        int ncvalues = 0;
        int i = 0;
        for (i = 0; i < this.variables.array.length; ++i) {
            if (this.variables.array[i].type == 1) {
                ++nnvalues;
                lnvalues += this.variables.array[i].len;
                continue;
            }
            ++ncvalues;
            lcvalues += this.variables.array[i].len;
        }
        l1 = this.U_ALIGNB(8);
        l2 = this.U_ALIGNB(l1 + lnvalues * this.fetchSize);
        l3 = l2 + 8;
        l4 = l3 + (ncvalues + 1) * this.fetchSize;
        l5 = l4 + lcvalues * this.fetchSize;
        return l5;
    }

    private int U_ALIGNB(int a) {
        return a + 3 & 0xFFFFFFFC;
    }
}

