/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.codepolicy.SASScope;
import com.sas.io.Encoder;
import com.sas.io.EncoderInterface;
import com.sas.net.sharenet.Column;
import com.sas.net.sharenet.ShareLocalizedError;
import com.sas.net.sharenet.ShareNetException;
import com.sas.net.sharenet.Sqpformat;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

@SASScope
public class SqlField {
    public static final int MAYBE_INTEGER = 5;
    public static final int INTEGER = 4;
    public static final int DATETIME = 3;
    public static final int TIME = 2;
    public static final int DATE = 1;
    public static final int NOSUBTYPE = 0;
    public static final int CHARACTER = 2;
    public static final int NUMERIC = 1;
    static final int MAXLEN = Short.MAX_VALUE;
    boolean v6 = true;
    private String shareEncoding = null;
    int type;
    int len;
    long flags;
    int subtype;
    int sqltype;
    short sname_len;
    String sname;
    short dname_len;
    String dname;
    short label_len;
    String label;
    Sqpformat format;
    Sqpformat informat;
    int engine;
    int symno;
    long offset;
    long trunc_count;
    int data;
    int trunc;
    long[] free701 = new long[2];

    static char toChar(byte b) {
        if (b < 32 || (b & 0xFF) == 255) {
            return '.';
        }
        return (char)(b & 0xFF);
    }

    static String toHex(byte b) {
        String[] hexChars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        return hexChars[(b & 0xF0) >> 4] + hexChars[b & 0xF];
    }

    static void dump(String label, byte[] array, int len) {
        StringBuilder hex = new StringBuilder();
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            hex.append(SqlField.toHex(array[i]));
            hex.append(" ");
            text.append(SqlField.toChar(array[i]));
        }
        System.err.println(label + " Hex> " + hex.toString());
        System.err.println(label + " Text> " + text.toString());
    }

    public SqlField() {
    }

    public SqlField(boolean v6, String shareEncoding) {
        this.v6 = v6;
        this.shareEncoding = shareEncoding;
    }

    public SqlField(int type, boolean v6) {
        this.v6 = v6;
        this.sqltype = type;
        this.sname = "";
        this.dname = "";
        this.label = "";
    }

    public SqlField(Column c) {
        this.sqltype = c.getSqlType();
        this.sname = c.getName();
        this.dname = c.getName();
        this.label = c.getLabel();
        this.len = c.getLength();
        this.format = new Sqpformat();
        this.format.name = c.getFormatName();
        this.format.name_len = c.getFormatLength();
        this.format.wid = c.getFormatWidth();
        this.format.ndec = c.getFormatDecimal();
    }

    public int getLength() {
        return this.len;
    }

    public int getSQLType() {
        return this.sqltype;
    }

    public String getName() {
        return this.sname;
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void read(DataInputStream stream) throws ShareNetException {
        EncoderInterface encoder = null;
        try {
            encoder = Encoder.getInstance((String)this.shareEncoding);
        }
        catch (UnsupportedEncodingException e) {
            String messageIndex = "Sharenet.S460.ex.txt";
            Object[] messageArg = new Object[]{messageIndex, this.shareEncoding};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Unsupported character encoding: {1}", messageArg));
        }
        if (!this.v6) {
            try {
                this.type = stream.readInt();
                this.len = stream.readInt();
                this.flags = stream.readLong();
                this.sname_len = stream.readShort();
                byte[] buf = new byte[256];
                stream.readFully(buf, 0, 32);
                this.sname = encoder.toString(buf, 0, 32).trim();
                this.dname_len = stream.readShort();
                stream.readFully(buf, 0, 32);
                this.dname = encoder.toString(buf, 0, 32).trim();
                if (this.dname.length() != 0) {
                    this.sname = this.dname;
                    this.sname_len = this.dname_len;
                }
                this.label_len = stream.readShort();
                stream.readFully(buf, 0, 256);
                this.label = encoder.toString(buf, 0, 256).trim();
                this.format = new Sqpformat(this.v6, encoder);
                this.format.read(stream);
                this.informat = new Sqpformat(this.v6, encoder);
                this.informat.read(stream);
                this.symno = stream.readInt();
                this.offset = stream.readLong();
                this.trunc_count = stream.readLong();
                this.trunc = stream.readInt();
                this.free701[0] = stream.readLong();
                this.free701[1] = stream.readLong();
                if (this.type == 1) {
                    this.subtype = this.format.findFormat(this.format.name);
                    switch (this.subtype) {
                        case 1: {
                            this.sqltype = 91;
                            break;
                        }
                        case 2: {
                            this.sqltype = 92;
                            break;
                        }
                        case 3: {
                            this.sqltype = 93;
                            break;
                        }
                        case 4: {
                            this.sqltype = 4;
                            break;
                        }
                        default: {
                            this.sqltype = 8;
                            break;
                        }
                    }
                }
                this.sqltype = 12;
            }
            catch (IOException e) {
                Encoder.returnInstance((EncoderInterface)encoder);
                String messageIndex = "Sharenet.S255.ex.txt";
                Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
                throw new ShareNetException(-1, ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
            }
        } else {
            try {
                this.type = stream.readInt();
                this.len = stream.readInt();
                byte[] buf = new byte[40];
                stream.readFully(buf, 0, 8);
                this.sname = encoder.toString(buf, 0, 8).trim();
                stream.readFully(buf, 0, 40);
                this.dname = encoder.toString(buf, 0, 40).trim();
                if (this.dname.length() != 0) {
                    this.sname = this.dname;
                }
                stream.readFully(buf, 0, 40);
                this.label = encoder.toString(buf, 0, 40).trim();
                this.format = new Sqpformat(this.v6, encoder);
                this.format.read(stream);
                this.informat = new Sqpformat(this.v6, encoder);
                this.informat.read(stream);
                this.symno = stream.readInt();
                this.offset = stream.readLong();
                this.trunc_count = stream.readLong();
                this.trunc = stream.readInt();
                if (this.type == 1) {
                    this.subtype = this.format.findFormat(this.format.name);
                    switch (this.subtype) {
                        case 1: {
                            this.sqltype = 91;
                            break;
                        }
                        case 2: {
                            this.sqltype = 92;
                            break;
                        }
                        case 3: {
                            this.sqltype = 93;
                            break;
                        }
                        case 4: {
                            this.sqltype = 4;
                            break;
                        }
                        default: {
                            this.sqltype = 8;
                            break;
                        }
                    }
                } else {
                    this.sqltype = 12;
                }
            }
            catch (IOException e) {
                Encoder.returnInstance((EncoderInterface)encoder);
                String messageIndex = "Sharenet.S256.ex.txt";
                Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
                throw new ShareNetException(-1, ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
            }
        }
        Encoder.returnInstance((EncoderInterface)encoder);
    }

    void print(PrintStream stream) {
        System.err.println("type=" + this.type + " len=" + this.len + " sname='" + this.sname + "' dname='" + this.dname + "' label='" + this.label + "'");
    }
}

