/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.codepolicy.SASScope;
import com.sas.net.sharenet.Ans1;
import com.sas.net.sharenet.Msegexe;
import com.sas.net.sharenet.Rcmsg;
import com.sas.net.sharenet.ShareLocalizedError;
import com.sas.net.sharenet.ShareNetConnection;
import com.sas.net.sharenet.ShareNetException;
import com.sas.net.sharenet.ShareNetResultSet;
import com.sas.net.sharenet.ShareNetSQLFeatureNotSupportedException;
import com.sas.net.sharenet.ShareNetWarning;
import com.sas.net.sharenet.SqlFieldArray;
import com.sas.net.sharenet.Tcpmsg;
import com.sas.net.sharenet.Wqecon;
import com.sas.net.sharenet.Wqefcb;
import com.sas.net.sharenet.Xhrspa3;
import com.sas.net.sharenet.funcEntry;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.StringTokenizer;

@SASScope(value="ALL")
public class ShareNetStatement
implements Statement {
    private static final int d = 1;
    private static final int t = 2;
    private static final int ts = 3;
    private static final int fn = 4;
    private static final int oj = 5;
    private static final int escape = 6;
    private static Hashtable<String, funcEntry> sasfns = new Hashtable();
    protected static String[] months = new String[13];
    private int maxRows = 0;
    private SqlFieldArray vars;
    private int timeout = 0;
    private int updateCount = -1;
    private SQLWarning warnings = null;
    private ShareNetWarning shareWarning = null;
    protected int fetchSize = 10;
    private Wqecon con = null;
    private Xhrspa3 ans = null;
    private int nvars;
    protected Tcpmsg msg = null;
    protected int maxFieldSize = 200;
    protected ShareNetResultSet snresultset = null;
    protected ShareNetConnection connection;
    protected boolean describe;
    private int resultSetType;
    private int resultSetConcurrency;
    protected boolean closed = false;
    protected boolean closeOnCompletion = false;

    @SASScope
    public ShareNetStatement(ShareNetConnection connection) {
        this.connection = connection;
        this.con = connection.con;
        this.msg = connection.msg;
        this.resultSetType = connection.resultSetType;
        this.resultSetConcurrency = connection.resultSetConcurrency;
        this.maxFieldSize = connection.xher1.share_rel >= 41 ? Short.MAX_VALUE : 200;
    }

    @Override
    public synchronized ResultSet executeQuery(String query) throws SQLException {
        String tempQuery;
        this.checkClosed();
        if (this.snresultset != null) {
            this.snresultset.close();
            this.snresultset = null;
        }
        this.updateCount = -1;
        this.clearWarnings();
        if (query != null) {
            tempQuery = this.sasify(query);
            String temp = tempQuery.toUpperCase();
            if ((temp = temp.trim()).indexOf("SELECT ") != 0) {
                int vendorCode = 205;
                String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                Object[] messageArg = new Object[]{messageIndex};
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Query is not a select statement.", messageArg), null, vendorCode);
            }
            try {
                this.prepareDescribe(tempQuery);
            }
            catch (ShareNetException ex) {
                int vendorCode = 206;
                String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                Object[] messageArg = new Object[]{messageIndex, ex.getMessage()};
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg), null, vendorCode);
            }
        } else {
            int vendorCode = 207;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Cannot create result set.", messageArg), null, vendorCode);
        }
        this.snresultset = new ShareNetResultSet(this, tempQuery);
        return this.snresultset;
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        this.checkClosed();
        if (this.snresultset != null) {
            this.snresultset.close();
            this.snresultset = null;
        }
        this.updateCount = 0;
        this.clearWarnings();
        if (sql == null || sql.length() == 0) {
            int vendorCode = 209;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: No statement to execute.", new Object[]{messageIndex}), null, vendorCode);
        }
        try {
            String tempSql = this.sasify(sql);
            String temp = tempSql.toUpperCase();
            if (temp.indexOf("SELECT ") == 0) {
                int vendorCode = 210;
                String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                Object[] messageArg = new Object[]{messageIndex};
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Cannot execute a select statement.", messageArg), null, vendorCode);
            }
            this.updateCount = this.connection.execute(tempSql);
            if (this.connection.shareWarning.warning.length() != 0) {
                SQLWarning warning = new SQLWarning(this.connection.shareWarning.warning);
                this.addWarning(warning);
            }
        }
        catch (ShareNetException e) {
            int vendorCode = 211;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg), null, vendorCode);
        }
        return this.updateCount;
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        try {
            if (this.snresultset != null) {
                this.snresultset.close();
                this.snresultset = null;
            }
        }
        catch (SQLException e) {
            this.snresultset = null;
        }
        if (this.connection != null) {
            this.connection.deleteStatement(this);
        }
    }

    @Override
    public synchronized int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return this.maxFieldSize;
    }

    @Override
    public synchronized void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            int vendorCode = 212;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Cannot set maxFields to a value less than 0.", messageArg), null, vendorCode);
        }
        this.maxFieldSize = max;
    }

    @Override
    public synchronized int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    @Override
    public synchronized void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            int vendorCode = 213;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Cannot set maxRows to a value less than 0.", messageArg), null, vendorCode);
        }
        this.maxRows = max;
        if (this.maxRows < this.fetchSize && this.maxRows != 0 && this.connection.xher1.share_rel >= 41) {
            this.fetchSize = this.maxRows;
        }
    }

    @Override
    public synchronized void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
        if (enable) {
            throw new ShareNetSQLFeatureNotSupportedException();
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.timeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        SQLWarning w = new SQLWarning("setQueryTimeout not supported");
        this.addWarning(w);
    }

    @Override
    public synchronized void cancel() throws SQLException {
        this.checkClosed();
        this.close();
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warnings = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        String tempSql;
        this.checkClosed();
        if (this.snresultset != null) {
            this.snresultset.close();
            this.snresultset = null;
        }
        this.clearWarnings();
        this.snresultset = null;
        this.updateCount = -1;
        if (sql != null) {
            tempSql = this.sasify(sql);
            String temp = tempSql.toUpperCase();
            if ((temp = temp.trim()).indexOf("SELECT ") != 0) {
                try {
                    this.updateCount = this.connection.execute(tempSql);
                    if (this.connection.shareWarning.warning.length() != 0) {
                        SQLWarning warning = new SQLWarning(this.connection.shareWarning.warning);
                        this.addWarning(warning);
                    }
                    return false;
                }
                catch (ShareNetException e) {
                    int vendorCode = 218;
                    String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                    Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg), null, vendorCode);
                }
            }
            try {
                this.prepareDescribe(tempSql);
            }
            catch (ShareNetException ex) {
                int vendorCode = 206;
                String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                Object[] messageArg = new Object[]{messageIndex, ex.getMessage()};
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg), null, vendorCode);
            }
        } else {
            int vendorCode = 219;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Cannot create result set.", messageArg), null, vendorCode);
        }
        this.snresultset = new ShareNetResultSet(this, tempSql);
        return true;
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.snresultset;
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        this.checkClosed();
        return this.updateCount;
    }

    protected synchronized void setDescribe(boolean describe) throws SQLException {
        this.describe = describe;
    }

    protected synchronized boolean isDescribe() throws SQLException {
        return this.describe;
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        this.checkClosed();
        if (this.snresultset != null) {
            this.snresultset.close();
            this.snresultset = null;
        }
        this.updateCount = -1;
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (direction != 1000) {
            int vendorCode = 420;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Invalid fetch direction.", messageArg), null, vendorCode);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (this.connection.xher1.share_rel < 41) {
            return;
        }
        if (rows == 0) {
            this.fetchSize = 10;
            return;
        }
        if (rows < 0 || this.getMaxRows() != 0 && rows > this.getMaxRows()) {
            int vendorCode = 214;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Invalid fetch size.", messageArg), null, vendorCode);
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return this.resultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    public synchronized void addWarning(SQLWarning warning) {
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            this.warnings.setNextWarning(warning);
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    private String sasify(String stmt) throws SQLException {
        int i;
        int l;
        Integer temp = 0;
        int monthIndex = 0;
        String sub1 = "";
        String sub2 = "";
        String sub3 = "";
        String temps = "";
        int b = 0;
        int c = 0;
        int e = 0;
        int type = 0;
        stmt = stmt.trim();
        block21: while ((l = this.findLastString(stmt, "{")) > 0) {
            String messageIndex;
            int vendorCode;
            int nested = 0;
            i = 0;
            char c2 = '\uffffffff';
            b = l;
            int endloc = this.findFirstString(stmt, "}", b);
            if (endloc == -1) {
                vendorCode = 220;
                messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                Object[] messageArg = new Object[]{messageIndex};
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed SQL statement. Unmatched curly brackets.", messageArg), null, vendorCode);
            }
            e = endloc;
            sub1 = stmt.substring(0, b);
            sub1 = sub1.trim();
            sub2 = stmt.substring(b + 1, e);
            sub2 = sub2.trim();
            if (e + 1 < stmt.length()) {
                sub3 = stmt.substring(e + 1);
                sub3 = sub3.trim();
            } else {
                sub3 = "";
            }
            temps = sub2.toLowerCase();
            type = 0;
            if (temps.length() >= 2) {
                if (temps.charAt(0) == 't' && temps.charAt(1) == 's') {
                    type = 3;
                }
                if (temps.charAt(0) == 'f' && temps.charAt(1) == 'n') {
                    type = 4;
                }
                if (temps.charAt(0) == 't' && temps.charAt(1) != 's') {
                    type = 2;
                }
                if (temps.charAt(0) == 'd') {
                    type = 1;
                }
                if (temps.charAt(0) == 'o' && temps.charAt(1) == 'j') {
                    type = 5;
                }
                if (temps.startsWith("escape ", 0)) {
                    type = 6;
                }
            }
            switch (type) {
                case 2: {
                    sub2 = sub2.substring(1);
                    sub2 = sub2.trim();
                    if (sub2.length() < 10) {
                        vendorCode = 221;
                        messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                        Object[] messageArg = new Object[]{messageIndex, "time"};
                        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} value.", messageArg), null, vendorCode);
                    }
                    if (sub2.charAt(0) != '\'' || sub2.charAt(9) != '\'') {
                        vendorCode = 222;
                        messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                        Object[] messageArg = new Object[]{messageIndex, "time"};
                        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} value.", messageArg), null, vendorCode);
                    }
                    stmt = sub1 + " " + sub2.substring(0) + "t " + sub3;
                    continue block21;
                }
                case 1: {
                    sub2 = sub2.substring(1);
                    sub2 = sub2.trim();
                    if (sub2.length() < 12) {
                        vendorCode = 223;
                        messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                        Object[] messageArg = new Object[]{messageIndex, "date"};
                        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} value.", messageArg), null, vendorCode);
                    }
                    if (sub2.charAt(0) != '\'' || sub2.charAt(11) != '\'') {
                        vendorCode = 224;
                        messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                        Object[] messageArg = new Object[]{messageIndex, "date"};
                        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} value.", messageArg), null, vendorCode);
                    }
                    temp = Integer.valueOf(sub2.substring(6, 8));
                    monthIndex = temp;
                    if (monthIndex < 1 || monthIndex > 12) {
                        vendorCode = 225;
                        messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                        Object[] messageArg = new Object[]{messageIndex, "date"};
                        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} value.", messageArg), null, vendorCode);
                    }
                    stmt = sub1 + " '" + sub2.substring(9, 11) + months[monthIndex] + sub2.substring(1, 5) + "'d " + sub3;
                    continue block21;
                }
                case 3: {
                    sub2 = sub2.substring(2);
                    sub2 = sub2.trim();
                    if (sub2.length() < 21) {
                        vendorCode = 226;
                        messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                        Object[] messageArg = new Object[]{messageIndex, "timestamp"};
                        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} value.", messageArg), null, vendorCode);
                    }
                    if (sub2.charAt(0) != '\'') {
                        vendorCode = 227;
                        messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                        Object[] messageArg = new Object[]{messageIndex, "timestamp"};
                        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} value.", messageArg), null, vendorCode);
                    }
                    int k = sub2.indexOf(39, 1);
                    if (k < 20) {
                        vendorCode = 228;
                        messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                        Object[] messageArg = new Object[]{messageIndex, "timestamp"};
                        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} value.", messageArg), null, vendorCode);
                    }
                    temp = Integer.valueOf(sub2.substring(6, 8));
                    monthIndex = temp;
                    if (monthIndex < 1 || monthIndex > 12) {
                        vendorCode = 229;
                        messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                        Object[] messageArg = new Object[]{messageIndex, "timestamp"};
                        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} value.", messageArg), null, vendorCode);
                    }
                    stmt = sub1 + " '" + sub2.substring(9, 11) + months[monthIndex] + sub2.substring(1, 5) + ":" + sub2.substring(12) + "dt " + sub3;
                    continue block21;
                }
                case 5: {
                    sub2 = sub2.substring(2);
                    sub2 = sub2.trim();
                    temps = sub2.toUpperCase();
                    b = this.findFirstString(temps, "OUTER", 0);
                    if (b == -1) {
                        vendorCode = 230;
                        messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                        Object[] messageArg = new Object[]{messageIndex};
                        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed Outer Join.", messageArg), null, vendorCode);
                    }
                    stmt = sub1 + " " + sub2.substring(0, b) + sub2.substring(b + 5) + " " + sub3;
                    continue block21;
                }
                case 6: {
                    b = sub2.indexOf(39);
                    if (b == -1 || sub2.length() < b + 2 || sub2.charAt(b + 2) != '\'') {
                        vendorCode = 231;
                        messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                        Object[] messageArg = new Object[]{messageIndex};
                        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed escape clause.", messageArg), null, vendorCode);
                    }
                    char escapeChar = sub2.charAt(b + 1);
                    temps = sub1 + " " + sub3;
                    String newStmt = "";
                    int length = temps.length();
                    int curEscape = -2;
                    c2 = '\uffffffff';
                    for (i = 0; i < length; ++i) {
                        if (temps.charAt(i) == '\'' || temps.charAt(i) == '\"') {
                            if (c2 == '\uffffffff') {
                                c2 = temps.charAt(i);
                            } else if (c2 == temps.charAt(i)) {
                                c2 = '\uffffffff';
                            }
                        }
                        if (c2 != '\uffffffff' && temps.charAt(i) == escapeChar && i != curEscape + 1) {
                            curEscape = i;
                            continue;
                        }
                        newStmt = newStmt + temps.charAt(i);
                    }
                    stmt = newStmt.trim();
                    continue block21;
                }
                case 4: {
                    int length;
                    sub2 = sub2.substring(2);
                    sub2 = sub2.trim();
                    b = this.findFirstString(sub2, "(", 0);
                    if (b == -1) {
                        int vendorCode2 = 232;
                        String messageIndex3 = "Sharenet.S" + vendorCode2 + ".ex.txt";
                        Object[] messageArg = new Object[]{messageIndex3};
                        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed function.", messageArg), null, vendorCode2);
                    }
                    temps = sub2.substring(0, b);
                    funcEntry tempfunc = sasfns.get(temps = temps.toUpperCase());
                    if (tempfunc == null || tempfunc.sasFn == null) {
                        int vendorCode3 = 233;
                        String messageIndex2 = "Sharenet.S" + vendorCode3 + ".ex.txt";
                        Object[] messageArg = new Object[]{messageIndex2};
                        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Function not defined.", messageArg), null, vendorCode3);
                    }
                    sub2 = tempfunc.sasFn + sub2.substring(b);
                    if (tempfunc.specialHandling != 0) {
                        switch (tempfunc.specialHandling) {
                            case 1: {
                                String messageIndex2;
                                b = this.findFirstString(sub2, "(", 0);
                                if (b == -1) {
                                    int vendorCode4 = 234;
                                    messageIndex2 = "Sharenet.S" + vendorCode4 + ".ex.txt";
                                    Object[] messageArg = new Object[]{messageIndex2, "concat"};
                                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} function.", messageArg), null, vendorCode4);
                                }
                                c = -1;
                                c2 = '\uffffffff';
                                nested = 0;
                                length = sub2.length();
                                for (i = b + 1; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ',' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    int vendorCode5 = 235;
                                    messageIndex2 = "Sharenet.S" + vendorCode5 + ".ex.txt";
                                    Object[] messageArg = new Object[]{messageIndex2, "concat"};
                                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} function.", messageArg), null, vendorCode5);
                                }
                                String temp1 = new String(sub2.substring(b + 1, c) + " || ");
                                b = this.findLastString(sub2.substring(c + 1), ")");
                                if (b == -1) {
                                    int vendorCode6 = 236;
                                    String messageIndex4 = "Sharenet.S" + vendorCode6 + ".ex.txt";
                                    Object[] messageArg = new Object[]{messageIndex4, "concat"};
                                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} function.", messageArg), null, vendorCode6);
                                }
                                b = this.findLastString(sub2, ")");
                                String temp2 = new String(sub2.substring(c + 1, b));
                                if (temp2.equals("")) {
                                    int vendorCode7 = 317;
                                    String messageIndex5 = "Sharenet.S" + vendorCode7 + ".ex.txt";
                                    Object[] messageArg = new Object[]{messageIndex5, "concat"};
                                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} function.", messageArg), null, vendorCode7);
                                }
                                sub2 = new String(temp1 + temp2);
                                break;
                            }
                            case 2: {
                                b = 0;
                                c = -1;
                                c2 = '\uffffffff';
                                nested = -1;
                                length = sub2.length();
                                for (i = 0; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ',' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    int vendorCode8 = 237;
                                    String messageIndex6 = "Sharenet.S" + vendorCode8 + ".ex.txt";
                                    Object[] messageArg = new Object[]{messageIndex6, "left"};
                                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} function.", messageArg), null, vendorCode8);
                                }
                                sub2 = new String(sub2.substring(0, c) + ",1" + sub2.substring(c));
                                break;
                            }
                            case 3: {
                                sub2 = new String(sub2 + ")");
                                break;
                            }
                            case 4: {
                                b = 0;
                                c = -1;
                                c2 = '\uffffffff';
                                nested = 0;
                                length = sub2.length();
                                for (i = 0; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ')' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    int vendorCode9 = 238;
                                    String messageIndex7 = "Sharenet.S" + vendorCode9 + ".ex.txt";
                                    Object[] messageArg = new Object[]{messageIndex7, "repeat"};
                                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} function.", messageArg), null, vendorCode9);
                                }
                                sub2 = new String(sub2.substring(0, c) + "-1" + sub2.substring(c));
                                break;
                            }
                            case 5: {
                                b = this.findFirstString(sub2, "(", 0);
                                if (b == -1) {
                                    int vendorCode10 = 239;
                                    String messageIndex8 = "Sharenet.S" + vendorCode10 + ".ex.txt";
                                    Object[] messageArg = new Object[]{messageIndex8, "space"};
                                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} function.", messageArg), null, vendorCode10);
                                }
                                sub2 = new String(sub2.substring(0, b + 1) + "' ',(" + sub2.substring(b + 1) + "-1)");
                                break;
                            }
                            case 6: {
                                b = 0;
                                c = -1;
                                c2 = '\uffffffff';
                                nested = -2;
                                length = sub2.length();
                                for (i = 0; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ',' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    int vendorCode11 = 240;
                                    String messageIndex9 = "Sharenet.S" + vendorCode11 + ".ex.txt";
                                    Object[] messageArg = new Object[]{messageIndex9, "power"};
                                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} function.", messageArg), null, vendorCode11);
                                }
                                sub2 = new String(sub2.substring(0, c) + ")**(" + sub2.substring(c + 1) + ")");
                                break;
                            }
                            case 7: {
                                b = this.findFirstString(sub2, "(", 0);
                                if (b == -1) {
                                    int vendorCode12 = 241;
                                    String messageIndex10 = "Sharenet.S" + vendorCode12 + ".ex.txt";
                                    Object[] messageArg = new Object[]{messageIndex10, "rand"};
                                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} function.", messageArg), null, vendorCode12);
                                }
                                c = this.findLastString(sub2, ")");
                                if (c == -1) {
                                    int vendorCode13 = 242;
                                    String messageIndex11 = "Sharenet.S" + vendorCode13 + ".ex.txt";
                                    Object[] messageArg = new Object[]{messageIndex11, "rand"};
                                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} function.", messageArg), null, vendorCode13);
                                }
                                if (c - b != 1) break;
                                sub2 = new String(sub2.substring(0, b + 1) + "0" + sub2.substring(b + 1));
                                break;
                            }
                            case 8: {
                                b = 0;
                                c = -1;
                                c2 = '\uffffffff';
                                nested = -1;
                                length = sub2.length();
                                for (i = 0; i < length; ++i) {
                                    if (sub2.charAt(i) == '(') {
                                        ++nested;
                                    }
                                    if (sub2.charAt(i) == ')') {
                                        --nested;
                                    }
                                    if (sub2.charAt(i) == '\'' || sub2.charAt(i) == '\"') {
                                        if (c2 == '\uffffffff') {
                                            c2 = sub2.charAt(i);
                                        } else if (c2 == sub2.charAt(i)) {
                                            c2 = '\uffffffff';
                                        }
                                    }
                                    if (sub2.charAt(i) != ',' || c2 != -1 || nested != 0) continue;
                                    c = i;
                                    break;
                                }
                                if (c == -1) {
                                    int vendorCode14 = 243;
                                    String messageIndex12 = "Sharenet.S" + vendorCode14 + ".ex.txt";
                                    Object[] messageArg = new Object[]{messageIndex12, "round"};
                                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} function.", messageArg), null, vendorCode14);
                                }
                                sub2 = new String(sub2.substring(0, c + 1) + "10**-(" + sub2.substring(c + 1) + ")");
                                break;
                            }
                            case 9: {
                                b = this.findLastString(sub2, ")");
                                if (b == -1) {
                                    int vendorCode15 = 244;
                                    String messageIndex13 = "Sharenet.S" + vendorCode15 + ".ex.txt";
                                    Object[] messageArg = new Object[]{messageIndex13, "dayname"};
                                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} function.", messageArg), null, vendorCode15);
                                }
                                sub2 = new String(sub2.substring(0, b) + ", DowName.)" + sub2.substring(b));
                                break;
                            }
                            case 10: {
                                b = this.findLastString(sub2, ")");
                                if (b == -1) {
                                    int vendorCode16 = 245;
                                    String messageIndex14 = "Sharenet.S" + vendorCode16 + ".ex.txt";
                                    Object[] messageArg = new Object[]{messageIndex14, "dayofyear"};
                                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} function.", messageArg), null, vendorCode16);
                                }
                                sub2 = new String(sub2 + ", 1000)");
                                break;
                            }
                            case 11: {
                                b = this.findLastString(sub2, ")");
                                if (b == -1) {
                                    int vendorCode17 = 246;
                                    String messageIndex15 = "Sharenet.S" + vendorCode17 + ".ex.txt";
                                    Object[] messageArg = new Object[]{messageIndex15, "monthname"};
                                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Malformed {1} function.", messageArg), null, vendorCode17);
                                }
                                sub2 = new String(sub2.substring(0, b) + ", MonName.)" + sub2.substring(b));
                                break;
                            }
                            default: {
                                int vendorCode18 = 247;
                                String messageIndex16 = "Sharenet.S" + vendorCode18 + ".ex.txt";
                                Object[] messageArg = new Object[]{messageIndex16};
                                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Function not defined.", messageArg), null, vendorCode18);
                            }
                        }
                    }
                    stmt = new String(sub1 + " " + sub2 + " " + sub3);
                    stmt = stmt.trim();
                    continue block21;
                }
            }
            return stmt;
        }
        boolean scanStmt = false;
        temps = stmt.toUpperCase();
        StringTokenizer stringTokenizer = new StringTokenizer(temps, " ");
        if (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (token.equals("CREATE") && stringTokenizer.hasMoreTokens()) {
                token = stringTokenizer.nextToken();
                if (token.equals("TABLE")) {
                    scanStmt = true;
                }
            } else if (token.equals("ALTER") && stringTokenizer.hasMoreTokens() && (token = stringTokenizer.nextToken()).equals("TABLE")) {
                while (stringTokenizer.hasMoreTokens()) {
                    token = stringTokenizer.nextToken();
                    if (!token.equals("ADD") && !token.equals("MODIFY") || !stringTokenizer.hasMoreTokens()) continue;
                    scanStmt = true;
                    token = stringTokenizer.nextToken();
                    if (!token.equals("COLUMN")) continue;
                }
            }
        }
        b = 0;
        i = 0;
        c = -1;
        boolean state = false;
        int dots = 0;
        int dot1 = 0;
        int inquotes = -1;
        int edge = 0;
        if (stmt.indexOf(".") != -1) {
            String tempStmt;
            StringTokenizer sqlParse = new StringTokenizer(stmt, "'\"", true);
            StringBuffer mungedStmt = new StringBuffer();
            boolean quoted = false;
            boolean isDouble = false;
            boolean isSingle = false;
            while (sqlParse.hasMoreTokens()) {
                String x = sqlParse.nextToken();
                if (x.equals("'") || x.equals("\"")) {
                    if (!quoted) {
                        if (x.equals("'")) {
                            isSingle = true;
                            isDouble = false;
                            quoted = true;
                        } else {
                            isDouble = true;
                            isSingle = false;
                            quoted = true;
                        }
                    } else if (isSingle) {
                        if (x.equals("'")) {
                            isSingle = false;
                            quoted = false;
                        }
                    } else if (isDouble && x.equals("\"")) {
                        isDouble = false;
                        quoted = false;
                    }
                }
                if (!quoted) {
                    while ((i = x.indexOf(" .", i)) != -1) {
                        int dotidx = x.indexOf(".", i);
                        if (dotidx + 1 >= x.length() || x.charAt(dotidx + 1) == ' ') {
                            ++i;
                            continue;
                        }
                        tempStmt = x;
                        x = tempStmt.substring(0, i) + tempStmt.substring(i + 1);
                    }
                }
                mungedStmt.append(x);
            }
            stmt = mungedStmt.toString();
            int curChar = 32;
            for (i = 0; i < stmt.length(); ++i) {
                curChar = stmt.charAt(i);
                if (curChar == 39 || curChar == 34) {
                    if (inquotes == -1) {
                        inquotes = curChar;
                    } else if (inquotes == curChar) {
                        inquotes = -1;
                    }
                }
                if ((Character.isLetterOrDigit((char)curChar) || curChar == 95 || curChar == 46) && inquotes == -1) {
                    if (!state) {
                        dots = 0;
                        edge = i;
                        state = true;
                        continue;
                    }
                    if (curChar != 46 || ++dots != 1) continue;
                    dot1 = i;
                    continue;
                }
                if (!state) continue;
                if (dots > 1) {
                    tempStmt = stmt;
                    stmt = tempStmt.substring(0, edge) + tempStmt.substring(dot1 + 1);
                    state = false;
                    i = 0;
                    continue;
                }
                state = false;
            }
            if (state && dots > 1) {
                tempStmt = stmt;
                stmt = tempStmt.substring(0, edge) + tempStmt.substring(dot1 + 1);
                state = false;
                i = 0;
            }
        }
        if (!scanStmt) {
            return stmt;
        }
        b = 0;
        while ((i = this.findFirstString(stmt, "INTEGER", b)) != -1 || (i = this.findFirstString(stmt, "integer", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 7 && (Character.isWhitespace(stmt.charAt(b + 7)) || stmt.charAt(b + 7) == ',' || stmt.charAt(b + 7) == ')')) {
                stmt = new String(stmt.substring(0, b) + " num format=11.0 " + stmt.substring(b + 7));
                b += 7;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 7) {
                stmt = new String(stmt.substring(0, b) + " num format=11.0 ");
                b += 7;
                continue;
            }
            b += 7;
        }
        b = 0;
        while ((i = this.findFirstString(stmt, "LONG", b)) != -1 || (i = this.findFirstString(stmt, "long", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 4 && (Character.isWhitespace(stmt.charAt(b + 4)) || stmt.charAt(b + 4) == ',' || stmt.charAt(b + 4) == ')')) {
                stmt = new String(stmt.substring(0, b) + " num format=11.0 " + stmt.substring(b + 4));
                b += 4;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 4) {
                stmt = new String(stmt.substring(0, b) + " num format=11.0 ");
                b += 4;
                continue;
            }
            b += 4;
        }
        b = 0;
        while ((i = this.findFirstString(stmt, "TIME", b)) != -1 || (i = this.findFirstString(stmt, "time", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 4 && (Character.isWhitespace(stmt.charAt(b + 4)) || stmt.charAt(b + 4) == ',' || stmt.charAt(b + 4) == ')')) {
                stmt = new String(stmt.substring(0, b) + " num format=time8. " + stmt.substring(b + 4));
                b += 4;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 4) {
                stmt = new String(stmt.substring(0, b) + " num format=time8. ");
                b += 4;
                continue;
            }
            b += 4;
        }
        b = 0;
        while ((i = this.findFirstString(stmt, "DATE", b)) != -1 || (i = this.findFirstString(stmt, "date", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 4 && (Character.isWhitespace(stmt.charAt(b + 4)) || stmt.charAt(b + 4) == ',' || stmt.charAt(b + 4) == ')')) {
                stmt = new String(stmt.substring(0, b) + " num format=date9. " + stmt.substring(b + 4));
                b += 4;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 4) {
                stmt = new String(stmt.substring(0, b) + " num format=date9. ");
                b += 4;
                continue;
            }
            b += 4;
        }
        b = 0;
        while ((i = this.findFirstString(stmt, "TIMESTAMP", b)) != -1 || (i = this.findFirstString(stmt, "timestamp", b)) != -1) {
            b = i;
            if ((Character.isWhitespace(stmt.charAt(b - 1)) || stmt.charAt(b - 1) == '(') && stmt.length() > b + 9 && (Character.isWhitespace(stmt.charAt(b + 9)) || stmt.charAt(b + 9) == ',' || stmt.charAt(b + 9) == ')')) {
                stmt = new String(stmt.substring(0, b) + " num format=datetime19.2 " + stmt.substring(b + 9));
                b += 9;
                continue;
            }
            if (Character.isWhitespace(stmt.charAt(b - 1)) && stmt.length() == b + 9) {
                stmt = new String(stmt.substring(0, b) + " num format=datetime19. ");
                b += 9;
                continue;
            }
            b += 9;
        }
        return stmt;
    }

    protected int findFirstString(String stmt, String token, int offset) {
        boolean singleQuote = false;
        boolean doubleQuote = false;
        int len = stmt.length();
        int tlen = token.length() - 1;
        for (int curoffset = offset; curoffset < len; ++curoffset) {
            int j;
            if (stmt.charAt(curoffset) == '\'') {
                singleQuote = !singleQuote;
            }
            if (stmt.charAt(curoffset) == '\"') {
                doubleQuote = !doubleQuote;
            }
            if (singleQuote || doubleQuote || stmt.charAt(curoffset) != token.charAt(0)) continue;
            for (j = 1; j <= tlen; ++j) {
                if (curoffset + j > len - 1) {
                    return -1;
                }
                if (stmt.charAt(curoffset + j) != token.charAt(j)) break;
            }
            if (j < tlen) continue;
            return curoffset;
        }
        return -1;
    }

    private int findLastString(String stmt, String token) {
        boolean singleQuote = false;
        boolean doubleQuote = false;
        int tlen = token.length() - 1;
        for (int curoffset = stmt.length() - 1; curoffset >= 0; --curoffset) {
            int j;
            if (stmt.charAt(curoffset) == '\'') {
                singleQuote = !singleQuote;
            }
            if (stmt.charAt(curoffset) == '\"') {
                doubleQuote = !doubleQuote;
            }
            if (singleQuote || doubleQuote || stmt.charAt(curoffset) != token.charAt(tlen)) continue;
            for (j = 1; j < tlen; ++j) {
                if (curoffset - j < 0) {
                    return -1;
                }
                if (stmt.charAt(curoffset - j) != token.charAt(tlen - j)) break;
            }
            if (j < tlen) continue;
            return curoffset - tlen;
        }
        return -1;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected synchronized void prepareDescribe(String statement) throws ShareNetException {
        try {
            if (this.connection.isClosed()) {
                String messageIndex = "Sharenet.S250.ex.txt";
                Object[] messageArg = new Object[]{messageIndex};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: No connection to server.", messageArg));
            }
            this.prepare(statement);
            try {
                this.describe();
            }
            catch (ShareNetException e) {
                this.destroy();
            }
        }
        catch (SQLException e) {
            String messageIndex = "Sharenet.S250.ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: No connection to server.", messageArg));
        }
    }

    protected synchronized void prepare(String statement) throws ShareNetException {
        this.shareWarning = new ShareNetWarning("");
        String temp = statement.trim();
        if (!(temp = temp.toUpperCase()).regionMatches(true, 0, "SELECT ", 0, 7)) {
            String messageIndex = "Sharenet.S251.ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new ShareNetException(-1, ShareLocalizedError.getLocalizedError("{0}: Query is not a select statement.", messageArg));
        }
        Wqefcb clientFcb = new Wqefcb(this.connection.sharenetType);
        clientFcb.minfo.sv[0] = 287;
        if (this.connection.xher1.share_rel >= 41) {
            clientFcb.minfo.sv[6] = this.connection.xher1.mr_indx;
            clientFcb.minfo.sv[7] = this.connection.xher1.en_indx;
        }
        clientFcb.nseg = 3;
        clientFcb.wmseg[0] = new Msegexe(statement, this.con.getShareEncoding());
        clientFcb.wmseg[1] = this.connection.defdes;
        clientFcb.waseg[1] = new Rcmsg();
        this.ans = new Xhrspa3();
        clientFcb.waseg[2] = this.ans;
        this.send(clientFcb);
        this.nvars = this.ans.nvars;
        Rcmsg rcmsg = (Rcmsg)clientFcb.waseg[1];
        Ans1 ans1 = (Ans1)clientFcb.waseg[0];
        String tempMsg = ShareNetConnection.formatMsg(clientFcb.acc, ans1, rcmsg);
        if (clientFcb.acc == 0) {
            this.shareWarning.warning = tempMsg + this.shareWarning.warning;
        } else {
            if (clientFcb.acc < 0) {
                String messageIndex = "Sharenet.S252.ex.txt";
                Object[] messageArg = new Object[]{messageIndex, String.valueOf(clientFcb.acc), tempMsg};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1} {2}", messageArg));
            }
            tempMsg = tempMsg + this.shareWarning.warning;
            this.shareWarning = new ShareNetWarning(clientFcb.acc, tempMsg);
        }
    }

    protected synchronized void describe() throws ShareNetException {
        this.shareWarning = new ShareNetWarning("");
        Wqefcb clientFcb = new Wqefcb(this.connection.sharenetType);
        clientFcb.minfo.sv[0] = 288;
        clientFcb.minfo.sv[1] = (short)this.ans.thissel;
        if (this.connection.xher1.share_rel >= 41) {
            clientFcb.minfo.sv[6] = this.connection.xher1.mr_indx;
            clientFcb.minfo.sv[7] = this.connection.xher1.en_indx;
        }
        clientFcb.nseg = 3;
        clientFcb.waseg[1] = new Rcmsg();
        if (this.connection.xher1.share_rel >= 41) {
            this.vars = new SqlFieldArray(this.ans.nvars, false, this.con.getShareEncoding());
            clientFcb.waseg[2] = this.vars;
        } else {
            this.vars = new SqlFieldArray(this.ans.nvars, true, this.con.getShareEncoding());
            clientFcb.waseg[2] = this.vars;
        }
        this.send(clientFcb);
        Rcmsg rcmsg = (Rcmsg)clientFcb.waseg[1];
        Ans1 ans1 = (Ans1)clientFcb.waseg[0];
        String tempMsg = ShareNetConnection.formatMsg(clientFcb.acc, ans1, rcmsg);
        if (clientFcb.acc == 0) {
            this.shareWarning.warning = tempMsg + this.shareWarning.warning;
        } else {
            if (clientFcb.acc < 0) {
                String messageIndex = "Sharenet.S262.ex.txt";
                Object[] messageArg = new Object[]{messageIndex, String.valueOf(clientFcb.acc), tempMsg};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1} {2}", messageArg));
            }
            tempMsg = tempMsg + this.shareWarning.warning;
            this.shareWarning = new ShareNetWarning(clientFcb.acc, tempMsg);
        }
    }

    protected synchronized void destroy() throws ShareNetException {
        try {
            if (this.connection.isClosed()) {
                String messageIndex = "Sharenet.S263.ex.txt";
                Object[] messageArg = new Object[]{messageIndex};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: No connection to server.", messageArg));
            }
        }
        catch (SQLException e) {
            String messageIndex = "Sharenet.S263.ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: No connection to server.", messageArg));
        }
        this.shareWarning = new ShareNetWarning("");
        Wqefcb clientFcb = new Wqefcb(this.connection.sharenetType);
        clientFcb.waseg[0] = new Ans1();
        clientFcb.wmseg[0] = this.connection.defdes;
        clientFcb.waseg[1] = new Rcmsg();
        clientFcb.minfo.sv[0] = 290;
        if (this.connection.xher1.share_rel >= 41) {
            clientFcb.minfo.sv[6] = this.connection.xher1.mr_indx;
            clientFcb.minfo.sv[7] = this.connection.xher1.en_indx;
        }
        clientFcb.minfo.sv[1] = (short)this.ans.thissel;
        clientFcb.nseg = 2;
        this.send(clientFcb);
        Rcmsg rcmsg = (Rcmsg)clientFcb.waseg[1];
        Ans1 ans1 = (Ans1)clientFcb.waseg[0];
        String tempMsg = ShareNetConnection.formatMsg(clientFcb.acc, ans1, rcmsg);
        if (clientFcb.acc == 0) {
            this.shareWarning.warning = tempMsg + this.shareWarning.warning;
        } else {
            if (clientFcb.acc < 0) {
                String messageIndex = "Sharenet.S264.ex.txt";
                Object[] messageArg = new Object[]{messageIndex, String.valueOf(clientFcb.acc), tempMsg};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1} {2}", messageArg));
            }
            tempMsg = tempMsg + this.shareWarning.warning;
            this.shareWarning = new ShareNetWarning(clientFcb.acc, tempMsg);
        }
        this.connection.defdes.def_destroys = 0;
    }

    synchronized void send(Wqefcb fcb) throws ShareNetException {
        fcb.waseg[0] = new Ans1();
        fcb.acc = 0;
        int i = 0;
        int j = 10;
        while (i < 3) {
            fcb.minfo.sv[j] = 34;
            ++i;
            ++j;
        }
        this.con.wqesndm(fcb, this.msg);
    }

    public int numFields() {
        return this.nvars;
    }

    public String[] fieldNames() {
        String[] result = new String[this.nvars];
        for (int i = 0; i < this.nvars; ++i) {
            result[i] = this.vars.array[i].sname;
        }
        return result;
    }

    public int fieldType(int i) {
        int result = this.vars.array[i].type;
        if (result == 1 && this.vars.array[i].subtype != 0) {
            result = this.vars.array[i].subtype;
        }
        return result;
    }

    public String fieldFormat(int i) {
        String result = this.vars.array[i].format.name;
        return result;
    }

    protected synchronized Xhrspa3 getAns() {
        return this.ans;
    }

    private synchronized void setAns(Xhrspa3 ans) {
        this.ans = ans;
    }

    protected SqlFieldArray getVars() {
        return this.vars;
    }

    protected void setVars(SqlFieldArray vars) {
        this.vars = vars;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: unwrap operation failed; input parameter is null.", new Object[]{"Sharenet.S586.ex.txt"}), null, 586);
        }
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException(ShareLocalizedError.getLocalizedError("unwrap operation failed; class {1} does not implement {2}", new Object[]{"Sharenet.S587.ex.txt", iface.getName(), this.getClass().getName()}), null, 587);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    void checkClosed() throws SQLException {
        if (this.closed) {
            int vendorCode = 591;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: The Statement is closed.", messageArg), null, vendorCode);
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkClosed();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletion;
    }

    static {
        funcEntry entry = new funcEntry("RANK", 0);
        sasfns.put("ASCII", entry);
        sasfns.put("ascii", entry);
        entry = new funcEntry("BYTE", 0);
        sasfns.put("CHAR", entry);
        sasfns.put("char", entry);
        entry = new funcEntry("", 1);
        sasfns.put("CONCAT", entry);
        sasfns.put("concat", entry);
        entry = new funcEntry(null, 0);
        sasfns.put("DIFFERENCE", entry);
        sasfns.put("difference", entry);
        entry = new funcEntry(null, 0);
        sasfns.put("INSERT", entry);
        sasfns.put("insert", entry);
        entry = new funcEntry("LOWCASE", 0);
        sasfns.put("LCASE", entry);
        sasfns.put("lcase", entry);
        entry = new funcEntry("SUBSTR", 2);
        sasfns.put("LEFT", entry);
        sasfns.put("left", entry);
        entry = new funcEntry(null, 0);
        sasfns.put("LENGTH", entry);
        sasfns.put("length", entry);
        entry = new funcEntry(null, 0);
        sasfns.put("LOCATE", entry);
        sasfns.put("locate", entry);
        entry = new funcEntry("TRIM(LEFT", 3);
        sasfns.put("LTRIM", entry);
        sasfns.put("ltrim", entry);
        entry = new funcEntry("REPEAT", 4);
        sasfns.put("REPEAT", entry);
        sasfns.put("repeat", entry);
        entry = new funcEntry("TRANWRD", 0);
        sasfns.put("REPLACE", entry);
        sasfns.put("replace", entry);
        entry = new funcEntry(null, 0);
        sasfns.put("RIGHT", entry);
        sasfns.put("right", entry);
        entry = new funcEntry("TRIMN", 0);
        sasfns.put("RTRIM", entry);
        sasfns.put("rtrim", entry);
        entry = new funcEntry("SOUNDEX", 0);
        sasfns.put("SOUNDEX", entry);
        sasfns.put("soundex", entry);
        entry = new funcEntry("REPEAT", 5);
        sasfns.put("SPACE", entry);
        sasfns.put("space", entry);
        entry = new funcEntry("SUBSTR", 0);
        sasfns.put("SUBSTRING", entry);
        sasfns.put("substring", entry);
        entry = new funcEntry("UPCASE", 0);
        sasfns.put("UCASE", entry);
        sasfns.put("ucase", entry);
        entry = new funcEntry("ABS", 0);
        sasfns.put("ABS", entry);
        sasfns.put("abs", entry);
        entry = new funcEntry("ARCOS", 0);
        sasfns.put("ACOS", entry);
        sasfns.put("acos", entry);
        entry = new funcEntry("ARSIN", 0);
        sasfns.put("ASIN", entry);
        sasfns.put("asin", entry);
        entry = new funcEntry("ATAN", 0);
        sasfns.put("ATAN", entry);
        sasfns.put("atan", entry);
        entry = new funcEntry(null, 0);
        sasfns.put("ATAN2", entry);
        sasfns.put("atan2", entry);
        entry = new funcEntry("CEIL", 0);
        sasfns.put("CEILING", entry);
        sasfns.put("ceiling", entry);
        entry = new funcEntry("COS", 0);
        sasfns.put("COS", entry);
        sasfns.put("cos", entry);
        entry = new funcEntry(null, 0);
        sasfns.put("COT", entry);
        sasfns.put("cot", entry);
        entry = new funcEntry(null, 0);
        sasfns.put("DEGREES", entry);
        sasfns.put("degrees", entry);
        entry = new funcEntry("EXP", 0);
        sasfns.put("EXP", entry);
        sasfns.put("exp", entry);
        entry = new funcEntry("FLOOR", 0);
        sasfns.put("FLOOR", entry);
        sasfns.put("floor", entry);
        entry = new funcEntry("LOG", 0);
        sasfns.put("LOG", entry);
        sasfns.put("log", entry);
        entry = new funcEntry("LOG10", 0);
        sasfns.put("LOG10", entry);
        sasfns.put("log10", entry);
        entry = new funcEntry("MOD", 0);
        sasfns.put("MOD", entry);
        sasfns.put("mod", entry);
        entry = new funcEntry(null, 0);
        sasfns.put("PI", entry);
        sasfns.put("pi", entry);
        entry = new funcEntry("  (", 6);
        sasfns.put("POWER", entry);
        sasfns.put("power", entry);
        entry = new funcEntry(null, 0);
        sasfns.put("RADIANS", entry);
        sasfns.put("radians", entry);
        entry = new funcEntry("RANUNI", 7);
        sasfns.put("RAND", entry);
        sasfns.put("rand", entry);
        entry = new funcEntry("ROUND", 8);
        sasfns.put("ROUND", entry);
        sasfns.put("round", entry);
        entry = new funcEntry("SIGN", 0);
        sasfns.put("SIGN", entry);
        sasfns.put("sign", entry);
        entry = new funcEntry("SIN", 0);
        sasfns.put("SIN", entry);
        sasfns.put("sin", entry);
        entry = new funcEntry("SQRT", 0);
        sasfns.put("SQRT", entry);
        sasfns.put("sqrt", entry);
        entry = new funcEntry("TAN", 0);
        sasfns.put("TAN", entry);
        sasfns.put("tan", entry);
        entry = new funcEntry(null, 0);
        sasfns.put("TRUNCATE", entry);
        sasfns.put("truncate", entry);
        entry = new funcEntry("DATE", 0);
        sasfns.put("CURDATE", entry);
        sasfns.put("curdate", entry);
        entry = new funcEntry("TIME", 0);
        sasfns.put("CURTIME", entry);
        sasfns.put("curtime", entry);
        entry = new funcEntry("LEFT(PUT", 9);
        sasfns.put("DAYNAME", entry);
        sasfns.put("dayname", entry);
        entry = new funcEntry("DAY", 0);
        sasfns.put("DAYOFMONTH", entry);
        sasfns.put("dayofmonth", entry);
        entry = new funcEntry("WEEKDAY", 0);
        sasfns.put("DAYOFWEEK", entry);
        sasfns.put("dayofweek", entry);
        entry = new funcEntry("MOD(JULDATE", 10);
        sasfns.put("DAYOFYEAR", entry);
        sasfns.put("dayofyear", entry);
        entry = new funcEntry("HOUR", 0);
        sasfns.put("HOUR", entry);
        sasfns.put("hour", entry);
        entry = new funcEntry("MINUTE", 0);
        sasfns.put("MINUTE", entry);
        sasfns.put("minute", entry);
        entry = new funcEntry("MONTH", 0);
        sasfns.put("MONTH", entry);
        sasfns.put("month", entry);
        entry = new funcEntry("LEFT(PUT", 11);
        sasfns.put("MONTHNAME", entry);
        sasfns.put("monthname", entry);
        entry = new funcEntry("DATETIME", 0);
        sasfns.put("NOW", entry);
        sasfns.put("now", entry);
        entry = new funcEntry("QTR", 0);
        sasfns.put("QUARTER", entry);
        sasfns.put("quarter", entry);
        entry = new funcEntry("SECOND", 0);
        sasfns.put("SECOND", entry);
        sasfns.put("second", entry);
        entry = new funcEntry(null, 0);
        sasfns.put("TIMESTAMPADD", entry);
        sasfns.put("timestampadd", entry);
        entry = new funcEntry(null, 0);
        sasfns.put("TIMESTAMPDIFF", entry);
        sasfns.put("timestampdiff", entry);
        entry = new funcEntry(null, 0);
        sasfns.put("WEEK", entry);
        sasfns.put("week", entry);
        entry = new funcEntry("YEAR", 0);
        sasfns.put("YEAR", entry);
        sasfns.put("year", entry);
        entry = new funcEntry(null, 0);
        sasfns.put("DATABASE", entry);
        sasfns.put("database", entry);
        entry = new funcEntry(null, 0);
        sasfns.put("IFNULL", entry);
        sasfns.put("ifnull", entry);
        entry = new funcEntry(null, 0);
        sasfns.put("USER", entry);
        sasfns.put("user", entry);
        entry = new funcEntry(null, 0);
        sasfns.put("CONVERT", entry);
        sasfns.put("convert", entry);
        ShareNetStatement.months[0] = "";
        ShareNetStatement.months[1] = "JAN";
        ShareNetStatement.months[2] = "FEB";
        ShareNetStatement.months[3] = "MAR";
        ShareNetStatement.months[4] = "APR";
        ShareNetStatement.months[5] = "MAY";
        ShareNetStatement.months[6] = "JUN";
        ShareNetStatement.months[7] = "JUL";
        ShareNetStatement.months[8] = "AUG";
        ShareNetStatement.months[9] = "SEP";
        ShareNetStatement.months[10] = "OCT";
        ShareNetStatement.months[11] = "NOV";
        ShareNetStatement.months[12] = "DEC";
    }
}

