/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.codepolicy.SASScope;
import com.sas.net.sharenet.Ans1;
import com.sas.net.sharenet.Column;
import com.sas.net.sharenet.Rcmsg;
import com.sas.net.sharenet.ShareLocalizedError;
import com.sas.net.sharenet.ShareNetConnection;
import com.sas.net.sharenet.ShareNetException;
import com.sas.net.sharenet.ShareNetResultSetMetaData;
import com.sas.net.sharenet.ShareNetSQLFeatureNotSupportedException;
import com.sas.net.sharenet.ShareNetSQLTypeConversionException;
import com.sas.net.sharenet.ShareNetStatement;
import com.sas.net.sharenet.ShareNetWarning;
import com.sas.net.sharenet.SqlField;
import com.sas.net.sharenet.SqlFieldArray;
import com.sas.net.sharenet.SqlValue;
import com.sas.net.sharenet.SqlValueArray;
import com.sas.net.sharenet.SqpCharacterValue;
import com.sas.net.sharenet.SqpDateTimeValue;
import com.sas.net.sharenet.SqpNumericValue;
import com.sas.net.sharenet.Tcpmsg;
import com.sas.net.sharenet.Wqecon;
import com.sas.net.sharenet.Wqefcb;
import com.sas.net.sharenet.Xhrspa3;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;

@SASScope(value="ALL")
public class ShareNetResultSet
implements ResultSet {
    protected SqlValue[] currentRow = null;
    protected SqlField[] fieldArray = null;
    private SqlFieldArray vars = null;
    private SqlValueArray values = null;
    private Wqecon con = null;
    private Tcpmsg msg = null;
    private int nvars;
    private Xhrspa3 ans = null;
    private int fetchSize = 10;
    private int blocknum = 10;
    protected int numColumns = 0;
    protected int currentRowNumber = 0;
    protected int rowsFetched = 0;
    protected boolean maxReached = false;
    protected int maxRows = 0;
    protected String cursorName = "";
    protected final Hashtable<String, Integer> namesToColumns = new Hashtable();
    protected final ShareNetStatement stmt;
    private final int maxFieldSize;
    protected boolean wasNull = false;
    protected SQLWarning warnings = null;
    protected ShareNetWarning shareWarning = null;
    protected short sv = 0;
    protected ShareNetConnection connection;
    private boolean destroyed = false;
    static final String[] BooleanTrueConstants = new String[]{"T", "Y", "1", "TRUE"};
    private final SqlValue[][] _dbmdValues;
    private boolean closed = false;

    @SASScope
    public ShareNetResultSet(ShareNetStatement stmt, String sql) throws SQLException {
        this.stmt = stmt;
        this.fetchSize = stmt.fetchSize;
        this.blocknum = stmt.fetchSize;
        this.connection = stmt.connection;
        this.sv = this.connection.xher1.share_rel;
        this.msg = this.connection.msg;
        this.con = this.connection.con;
        this.ans = stmt.getAns();
        this.nvars = this.ans.nvars;
        this.vars = stmt.getVars();
        this.numColumns = this.numFields();
        String[] names = this.fieldNames();
        this.fieldArray = this.vars.array;
        for (int i = 0; i < names.length; ++i) {
            this.namesToColumns.put(names[i].trim().toUpperCase(), i + 1);
        }
        this._dbmdValues = null;
        this.maxFieldSize = stmt.maxFieldSize;
    }

    ShareNetResultSet(Column[] columns, ArrayList<Object[]> rowData) {
        int i;
        this.fieldArray = new SqlField[columns.length];
        for (i = 0; i < columns.length; ++i) {
            this.namesToColumns.put(columns[i].getName().toUpperCase(), i + 1);
            this.fieldArray[i] = new SqlField(columns[i]);
        }
        this.numColumns = columns.length;
        this._dbmdValues = new SqlValue[rowData.size()][columns.length];
        for (i = 0; i < rowData.size(); ++i) {
            block11: for (int j = 0; j < rowData.get(i).length; ++j) {
                Object o = rowData.get(i)[j];
                int type = this.fieldArray[j].getSQLType();
                switch (type) {
                    case 91: {
                        SqpNumericValue nVal = new SqpDateTimeValue(this.fieldArray[j], true, false);
                        if (o == null) {
                            nVal.missing = true;
                        } else {
                            nVal.value = ((Number)o).doubleValue();
                        }
                        this._dbmdValues[i][j] = nVal;
                        continue block11;
                    }
                    case 92: {
                        SqpNumericValue nVal = new SqpDateTimeValue(this.fieldArray[j], false, true);
                        if (o == null) {
                            nVal.missing = true;
                        } else {
                            nVal.value = ((Number)o).doubleValue();
                        }
                        this._dbmdValues[i][j] = nVal;
                        continue block11;
                    }
                    case 93: {
                        SqpNumericValue nVal = new SqpDateTimeValue(this.fieldArray[j], true, true);
                        if (o == null) {
                            nVal.missing = true;
                        } else {
                            nVal.value = ((Number)o).doubleValue();
                        }
                        this._dbmdValues[i][j] = nVal;
                        continue block11;
                    }
                    case -7: 
                    case 16: {
                        SqpNumericValue nVal = new SqpNumericValue(this.fieldArray[j]);
                        if (o == null) {
                            nVal.missing = true;
                        } else {
                            nVal = new SqpNumericValue(this.fieldArray[j], (Boolean)o);
                        }
                        this._dbmdValues[i][j] = nVal;
                        continue block11;
                    }
                    case 4: 
                    case 5: {
                        SqpNumericValue nVal = new SqpNumericValue(this.fieldArray[j]);
                        if (o == null) {
                            nVal.missing = true;
                        } else {
                            nVal.value = ((Number)o).doubleValue();
                        }
                        this._dbmdValues[i][j] = nVal;
                        continue block11;
                    }
                    case 12: {
                        SqpCharacterValue cVal = new SqpCharacterValue(this.fieldArray[j], (String)o);
                        this._dbmdValues[i][j] = cVal;
                        continue block11;
                    }
                    case 8: {
                        SqpNumericValue nVal = new SqpNumericValue(this.fieldArray[j]);
                        if (o == null) {
                            nVal.missing = true;
                        } else {
                            nVal.value = ((Number)o).doubleValue();
                        }
                        this._dbmdValues[i][j] = nVal;
                        continue block11;
                    }
                    default: {
                        throw new RuntimeException("invalid type");
                    }
                }
            }
        }
        this.stmt = null;
        this.maxFieldSize = 200;
    }

    @Override
    public synchronized boolean next() throws SQLException {
        this.checkClosed();
        this.clearWarnings();
        if (this.maxReached) {
            return false;
        }
        if (this.stmt != null && this.stmt.getMaxRows() != 0 && this.currentRowNumber == this.stmt.getMaxRows()) {
            this.maxReached = true;
            this.close();
            return false;
        }
        try {
            if (this._dbmdValues != null) {
                if (this.currentRowNumber == this._dbmdValues.length) {
                    return false;
                }
                this.currentRow = this._dbmdValues[this.currentRowNumber];
                ++this.currentRowNumber;
                return true;
            }
            this.currentRow = this.fetch();
            if (this.currentRow == null) {
                this.maxReached = true;
                this.maxRows = this.currentRowNumber;
                this.close();
                return false;
            }
            if (this.shareWarning.warning.length() != 0) {
                SQLWarning warning = new SQLWarning(this.shareWarning.warning);
                this.addWarning(warning);
            }
            ++this.currentRowNumber;
        }
        catch (ShareNetException se) {
            this.close();
            this.currentRow = null;
            this.maxReached = true;
            this.maxRows = this.currentRowNumber;
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: {1}", new Object[]{"Sharenet.S588.ex.txt", se.getMessage()}), null, 588);
        }
        return true;
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        this.checkClosed();
        if (this.currentRow == null) {
            int vendorCode = 128;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Not positioned on a valid row.", new Object[]{messageIndex}), null, vendorCode);
        }
        return this.wasNull;
    }

    @Override
    public synchronized String getString(int columnIndex) throws SQLException {
        String s;
        this.checkAccess(columnIndex);
        SqlValue sqlValue = this.currentRow[columnIndex - 1];
        this.wasNull = sqlValue.isMissing();
        if (this.wasNull) {
            s = null;
        } else {
            int type = this.fieldArray[columnIndex - 1].getSQLType();
            switch (type) {
                case 91: {
                    s = sqlValue.getDate().toString();
                    break;
                }
                case 92: {
                    s = sqlValue.getTime().toString();
                    break;
                }
                case 93: {
                    s = sqlValue.getTimestamp().toString();
                    break;
                }
                case -7: 
                case 16: {
                    s = String.valueOf(this.getBoolean(columnIndex)).toUpperCase();
                    break;
                }
                case 4: 
                case 5: {
                    s = String.valueOf(this.getInt(columnIndex));
                    break;
                }
                case 8: {
                    s = String.valueOf(this.getDouble(columnIndex));
                    break;
                }
                case 12: {
                    String tempString = ((SqpCharacterValue)sqlValue).value;
                    if (this.maxFieldSize > 0 && tempString.length() > this.maxFieldSize) {
                        tempString = tempString.substring(0, this.maxFieldSize);
                    }
                    s = tempString;
                    break;
                }
                default: {
                    throw new RuntimeException("unknown type");
                }
            }
        }
        return s;
    }

    @Override
    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        this.checkAccess(columnIndex);
        int type = this.fieldArray[columnIndex - 1].getSQLType();
        if (type == 91 || type == 92 || type == 93) {
            int vendorCode = 133;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Cannot convert SQL type to {1}.", new Object[]{messageIndex, "boolean"}), null, vendorCode);
        }
        if (this.currentRow[columnIndex - 1].isMissing()) {
            this.wasNull = true;
            return false;
        }
        this.wasNull = false;
        if (type == -7) {
            boolean b = ((SqpNumericValue)this.currentRow[columnIndex - 1]).getValue() != 0.0;
            return b;
        }
        if (type == 12) {
            String ctemp = this.currentRow[columnIndex - 1].toString().trim().toUpperCase();
            return ctemp.equals(BooleanTrueConstants[0]) || ctemp.equals(BooleanTrueConstants[1]) || ctemp.equals(BooleanTrueConstants[2]) || ctemp.equals(BooleanTrueConstants[3]);
        }
        return ((SqpNumericValue)this.currentRow[columnIndex - 1]).getValue() != 0.0;
    }

    @Override
    public synchronized byte getByte(int columnIndex) throws SQLException {
        this.checkAccess(columnIndex);
        byte[] singleByte = new byte[1];
        int type = this.fieldArray[columnIndex - 1].getSQLType();
        if (type == 91 || type == 92 || type == 93) {
            int vendorCode = 137;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Cannot convert SQL type to {1}.", new Object[]{messageIndex, "byte"}), null, vendorCode);
        }
        if (this.currentRow[columnIndex - 1].isMissing()) {
            this.wasNull = true;
            int vendorCode = 466;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            SQLWarning w = new SQLWarning(ShareLocalizedError.getLocalizedError("{0}: Warning, missing value of type {1}.", new Object[]{messageIndex, "byte"}), null, vendorCode);
            if (this.warnings == null) {
                this.warnings = w;
            } else {
                this.warnings.setNextWarning(w);
            }
            return singleByte[0];
        }
        this.wasNull = false;
        if (type == 12) {
            String temp = this.currentRow[columnIndex - 1].toString().trim();
            if (temp.length() == 0) {
                return singleByte[0];
            }
            try {
                return Byte.valueOf(temp);
            }
            catch (NumberFormatException e) {
                int vendorCode = 138;
                String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Number format exception. {1}.", messageArg), null, vendorCode);
            }
        }
        double dtemp = ((SqpNumericValue)this.currentRow[columnIndex - 1]).getValue();
        singleByte[0] = (byte)dtemp;
        return singleByte[0];
    }

    @Override
    public synchronized short getShort(int columnIndex) throws SQLException {
        this.checkAccess(columnIndex);
        int type = this.fieldArray[columnIndex - 1].getSQLType();
        if (type == 91 || type == 92 || type == 93) {
            int vendorCode = 141;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Cannot convert SQL type to {1}.", new Object[]{messageIndex, "short"}), null, vendorCode);
        }
        if (this.currentRow[columnIndex - 1].isMissing()) {
            this.wasNull = true;
            int vendorCode = 466;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            SQLWarning w = new SQLWarning(ShareLocalizedError.getLocalizedError("{0}: Warning, missing value of type {1}.", new Object[]{messageIndex, "short"}), null, vendorCode);
            if (this.warnings == null) {
                this.warnings = w;
            } else {
                this.warnings.setNextWarning(w);
            }
            return 0;
        }
        this.wasNull = false;
        if (type == -7) {
            boolean b = ((SqpNumericValue)this.currentRow[columnIndex - 1]).getValue() != 0.0;
            return b ? (short)1 : 0;
        }
        if (type == 12) {
            String temp = this.getString(columnIndex);
            try {
                return Short.parseShort(temp.trim());
            }
            catch (NumberFormatException e) {
                int vendorCode = 142;
                String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Number format exception. {1}.", new Object[]{messageIndex, e.getMessage()}), null, vendorCode);
            }
        }
        return (short)((SqpNumericValue)this.currentRow[columnIndex - 1]).getValue();
    }

    @Override
    public synchronized int getInt(int columnIndex) throws SQLException {
        this.checkAccess(columnIndex);
        int type = this.fieldArray[columnIndex - 1].getSQLType();
        if (type == 91 || type == 92 || type == 93) {
            int vendorCode = 145;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex, "int"};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Cannot convert SQL type to {1}.", messageArg), null, vendorCode);
        }
        if (this.currentRow[columnIndex - 1].isMissing()) {
            this.wasNull = true;
            int vendorCode = 466;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex, "int"};
            SQLWarning w = new SQLWarning(ShareLocalizedError.getLocalizedError("{0}: Warning, missing value of type {1}.", messageArg), null, vendorCode);
            if (this.warnings == null) {
                this.warnings = w;
            } else {
                this.warnings.setNextWarning(w);
            }
            return 0;
        }
        this.wasNull = false;
        if (type == -7) {
            boolean b = ((SqpNumericValue)this.currentRow[columnIndex - 1]).getValue() != 0.0;
            return b ? 1 : 0;
        }
        if (type == 12) {
            String temp = this.getString(columnIndex);
            try {
                return Integer.parseInt(temp.trim());
            }
            catch (NumberFormatException e) {
                int vendorCode = 146;
                String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Number format exception. {1}.", messageArg), null, vendorCode);
            }
        }
        return (int)((SqpNumericValue)this.currentRow[columnIndex - 1]).getValue();
    }

    @Override
    public synchronized long getLong(int columnIndex) throws SQLException {
        this.checkAccess(columnIndex);
        int type = this.fieldArray[columnIndex - 1].getSQLType();
        if (type == 91 || type == 92 || type == 93) {
            int vendorCode = 149;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex, "long"};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Cannot convert SQL type to {1}.", messageArg), null, vendorCode);
        }
        if (this.currentRow[columnIndex - 1].isMissing()) {
            this.wasNull = true;
            int vendorCode = 466;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex, "long"};
            SQLWarning w = new SQLWarning(ShareLocalizedError.getLocalizedError("{0}: Warning, missing value of type {1}.", messageArg), null, vendorCode);
            if (this.warnings == null) {
                this.warnings = w;
            } else {
                this.warnings.setNextWarning(w);
            }
            return 0L;
        }
        this.wasNull = false;
        if (type == -7) {
            boolean b = ((SqpNumericValue)this.currentRow[columnIndex - 1]).getValue() != 0.0;
            return b ? 1 : 0;
        }
        if (type == 12) {
            String temp = this.getString(columnIndex);
            try {
                return Long.parseLong(temp.trim());
            }
            catch (NumberFormatException e) {
                int vendorCode = 150;
                String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Number format exception. {1}.", messageArg), null, vendorCode);
            }
        }
        return (long)((SqpNumericValue)this.currentRow[columnIndex - 1]).getValue();
    }

    @Override
    public synchronized float getFloat(int columnIndex) throws SQLException {
        int type = this.fieldArray[columnIndex - 1].getSQLType();
        if (type == 91 || type == 92 || type == 93) {
            int vendorCode = 153;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex, "float"};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Cannot convert SQL type to {1}.", messageArg), null, vendorCode);
        }
        if (this.currentRow[columnIndex - 1].isMissing()) {
            this.wasNull = true;
            int vendorCode = 466;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex, "float"};
            SQLWarning w = new SQLWarning(ShareLocalizedError.getLocalizedError("{0}: Warning, missing value of type {1}.", messageArg), null, vendorCode);
            if (this.warnings == null) {
                this.warnings = w;
            } else {
                this.warnings.setNextWarning(w);
            }
            return 0.0f;
        }
        this.wasNull = false;
        if (type == -7) {
            boolean b = ((SqpNumericValue)this.currentRow[columnIndex - 1]).getValue() != 0.0;
            return b ? 1 : 0;
        }
        if (type == 12) {
            String temp = this.getString(columnIndex);
            try {
                return Float.valueOf(temp.trim()).floatValue();
            }
            catch (NumberFormatException e) {
                int vendorCode = 154;
                String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Number format exception. {1}.", messageArg), null, vendorCode);
            }
        }
        return (float)((SqpNumericValue)this.currentRow[columnIndex - 1]).getValue();
    }

    @Override
    public synchronized double getDouble(int columnIndex) throws SQLException {
        this.checkAccess(columnIndex);
        int type = this.fieldArray[columnIndex - 1].getSQLType();
        if (type == 91 || type == 92 || type == 93) {
            int vendorCode = 157;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex, "double"};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Cannot convert SQL type to {1}.", messageArg), null, vendorCode);
        }
        if (this.currentRow[columnIndex - 1].isMissing()) {
            this.wasNull = true;
            int vendorCode = 466;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex, "double"};
            SQLWarning w = new SQLWarning(ShareLocalizedError.getLocalizedError("{0}: Warning, missing value of type {1}.", messageArg), null, vendorCode);
            if (this.warnings == null) {
                this.warnings = w;
            } else {
                this.warnings.setNextWarning(w);
            }
            return 0.0;
        }
        this.wasNull = false;
        if (type == -7) {
            boolean b = ((SqpNumericValue)this.currentRow[columnIndex - 1]).getValue() != 0.0;
            return b ? 1 : 0;
        }
        if (type == 12) {
            String temp = this.getString(columnIndex);
            try {
                return Double.valueOf(temp.trim());
            }
            catch (NumberFormatException e) {
                int vendorCode = 158;
                String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Number format exception. {1}.", messageArg), null, vendorCode);
            }
        }
        return ((SqpNumericValue)this.currentRow[columnIndex - 1]).getValue();
    }

    @Override
    @Deprecated
    public synchronized BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        double tdouble;
        this.checkAccess(columnIndex);
        int type = this.fieldArray[columnIndex - 1].getSQLType();
        if (type == 91 || type == 92 || type == 93) {
            int vendorCode = 161;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex, "Numeric"};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Cannot convert SQL type to {1}.", messageArg), null, vendorCode);
        }
        if (this.currentRow[columnIndex - 1].isMissing()) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        if (type == -7) {
            boolean b = ((SqpNumericValue)this.currentRow[columnIndex - 1]).getValue() != 0.0;
            double d = b ? 1 : 0;
        }
        if (type == 12) {
            String temp = this.getString(columnIndex);
            try {
                tdouble = Double.valueOf(temp.trim());
            }
            catch (NumberFormatException e) {
                int vendorCode = 162;
                String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Number format exception. {1}.", messageArg), null, vendorCode);
            }
        } else {
            tdouble = ((SqpNumericValue)this.currentRow[columnIndex - 1]).getValue();
        }
        return new BigDecimal(tdouble);
    }

    @Override
    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        this.checkAccess(columnIndex);
        int vendorCode = 163;
        String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
        Object[] messageArg = new Object[]{messageIndex};
        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Binary representation is not supported.", messageArg), null, vendorCode);
    }

    @Override
    public synchronized Date getDate(int columnIndex) throws SQLException {
        this.checkAccess(columnIndex);
        int type = this.fieldArray[columnIndex - 1].getSQLType();
        if (type != 91 && type != 93 && type != 12) {
            throw new ShareNetSQLTypeConversionException("DATE");
        }
        SqlValue sqlValue = this.currentRow[columnIndex - 1];
        this.wasNull = sqlValue.isMissing();
        Date d = this.wasNull ? null : sqlValue.getDate();
        return d;
    }

    @Override
    public synchronized Time getTime(int columnIndex) throws SQLException {
        this.checkAccess(columnIndex);
        int type = this.fieldArray[columnIndex - 1].getSQLType();
        if (type != 92 && type != 93 && type != 12) {
            throw new ShareNetSQLTypeConversionException("TIME");
        }
        SqlValue sqlValue = this.currentRow[columnIndex - 1];
        this.wasNull = sqlValue.isMissing();
        Time t = this.wasNull ? null : sqlValue.getTime();
        return t;
    }

    @Override
    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkAccess(columnIndex);
        int type = this.fieldArray[columnIndex - 1].getSQLType();
        if (type != 91 && type != 93 && type != 12) {
            throw new ShareNetSQLTypeConversionException("TIMESTAMP");
        }
        SqlValue sqlValue = this.currentRow[columnIndex - 1];
        this.wasNull = sqlValue.isMissing();
        Timestamp ts = this.wasNull ? null : sqlValue.getTimestamp();
        return ts;
    }

    @Override
    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        ByteArrayInputStream is;
        this.checkAccess(columnIndex);
        int type = this.fieldArray[columnIndex - 1].getSQLType();
        if (type == 12) {
            SqlValue sqlValue = this.currentRow[columnIndex - 1];
            this.wasNull = sqlValue.isMissing();
            if (this.wasNull) {
                is = null;
            } else {
                String s = ((SqpCharacterValue)this.currentRow[columnIndex - 1]).value;
                if (this.maxFieldSize > 0 && s.length() > this.maxFieldSize) {
                    s = s.substring(0, this.maxFieldSize);
                }
                is = new ByteArrayInputStream(s.getBytes());
            }
        } else {
            throw new ShareNetSQLTypeConversionException("InputStream");
        }
        return is;
    }

    @Override
    @Deprecated
    public synchronized InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkAccess(columnIndex);
        return this.getAsciiStream(columnIndex);
    }

    @Override
    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkAccess(columnIndex);
        return this.getAsciiStream(columnIndex);
    }

    @Override
    public synchronized String getString(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getString(column);
    }

    @Override
    public synchronized boolean getBoolean(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getBoolean(column);
    }

    @Override
    public synchronized byte getByte(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getByte(column);
    }

    @Override
    public synchronized short getShort(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getShort(column);
    }

    @Override
    public synchronized int getInt(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getInt(column);
    }

    @Override
    public synchronized long getLong(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getLong(column);
    }

    @Override
    public synchronized float getFloat(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getFloat(column);
    }

    @Override
    public synchronized double getDouble(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getDouble(column);
    }

    @Override
    @Deprecated
    public synchronized BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getBigDecimal(column, scale);
    }

    @Override
    public synchronized byte[] getBytes(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getBytes(column);
    }

    @Override
    public synchronized Date getDate(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getDate(column);
    }

    @Override
    public synchronized Time getTime(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getTime(column);
    }

    @Override
    public synchronized Timestamp getTimestamp(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getTimestamp(column);
    }

    @Override
    public synchronized InputStream getAsciiStream(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getAsciiStream(column);
    }

    @Override
    @Deprecated
    public synchronized InputStream getUnicodeStream(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getUnicodeStream(column);
    }

    @Override
    public synchronized InputStream getBinaryStream(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getBinaryStream(column);
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkClosed();
        return this.cursorName;
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warnings = null;
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        ShareNetResultSetMetaData rsmetadata = new ShareNetResultSetMetaData(this.fieldArray, this.stmt);
        return rsmetadata;
    }

    @Override
    public synchronized Object getObject(int columnIndex) throws SQLException {
        this.checkAccess(columnIndex);
        SqlValue sqlValue = this.currentRow[columnIndex - 1];
        this.wasNull = sqlValue.isMissing();
        if (sqlValue.isMissing()) {
            return null;
        }
        int type = this.fieldArray[columnIndex - 1].getSQLType();
        switch (type) {
            case 91: {
                return sqlValue.getDate();
            }
            case 92: {
                return sqlValue.getTime();
            }
            case 93: {
                return sqlValue.getTimestamp();
            }
            case -7: 
            case 16: {
                return this.getBoolean(columnIndex);
            }
            case 4: 
            case 5: {
                return this.getInt(columnIndex);
            }
            case 8: {
                return this.getDouble(columnIndex);
            }
            case 12: {
                return this.getString(columnIndex);
            }
        }
        throw new RuntimeException("unknown type");
    }

    @Override
    public synchronized Object getObject(String columnName) throws SQLException {
        int column = this.findColumn(columnName);
        return this.getObject(column);
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        if (columnName == null) {
            int vendorCode = 181;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: No column of that name.", messageArg), null, vendorCode);
        }
        Integer columnNumber = this.namesToColumns.get(columnName.trim().toUpperCase());
        if (columnNumber == null) {
            int vendorCode = 182;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: No column of that name.", messageArg), null, vendorCode);
        }
        return columnNumber;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex, null);
    }

    public Reader getCharacterStream(int columnIndex, String charsetName) throws SQLException {
        String temp = this.getString(columnIndex);
        byte[] outbytes = new byte[temp.length()];
        if (charsetName == null) {
            charsetName = System.getProperty("file.encoding");
        }
        InputStreamReader reader = null;
        try {
            outbytes = temp.getBytes(charsetName);
            reader = new InputStreamReader((InputStream)new ByteArrayInputStream(outbytes), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            int vendorCode = 584;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex, e.getMessage(), charsetName};
            throw new SQLException(ShareLocalizedError.getLocalizedError("Encoding operation failed. JVM does not support encoding: {0}.", messageArg), null, vendorCode);
        }
        return reader;
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getCharacterStream(columnIndex, null);
    }

    public Reader getCharacterStream(String columnName, String charsetName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getCharacterStream(columnIndex, charsetName);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkAccess(columnIndex);
        return this.getBigDecimal(columnIndex, 0);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getBigDecimal(columnIndex, 0);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void afterLast() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean first() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean last() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public int getRow() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean previous() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (direction != 1000) {
            int vendorCode = 334;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Invalid fetch direction.", messageArg), null, vendorCode);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public synchronized void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (this.sv < 41) {
            return;
        }
        if (rows == 0) {
            this.fetchSize = 10;
            this.blocknum = 10;
            return;
        }
        if (rows < 0 || this.stmt.getMaxRows() != 0 && rows > this.stmt.getMaxRows()) {
            int vendorCode = 336;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Invalid fetch size.", messageArg), null, vendorCode);
        }
        this.fetchSize = rows;
        this.blocknum = rows;
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return this.stmt.getResultSetConcurrency();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void insertRow() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.stmt;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkAccess(columnIndex);
        int type = this.fieldArray[columnIndex - 1].getSQLType();
        if (type != 91 && type != 93 && type != 12) {
            throw new ShareNetSQLTypeConversionException("DATE");
        }
        SqlValue sqlValue = this.currentRow[columnIndex - 1];
        this.wasNull = sqlValue.isMissing();
        Date d = this.wasNull ? null : sqlValue.getDate(cal);
        return d;
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkAccess(columnIndex);
        int type = this.fieldArray[columnIndex - 1].getSQLType();
        if (type != 92 && type != 93 && type != 12) {
            throw new ShareNetSQLTypeConversionException("TIME");
        }
        SqlValue sqlValue = this.currentRow[columnIndex - 1];
        this.wasNull = sqlValue.isMissing();
        Time t = this.wasNull ? null : sqlValue.getTime(cal);
        return t;
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkAccess(columnIndex);
        int type = this.fieldArray[columnIndex - 1].getSQLType();
        if (type != 91 && type != 93 && type != 12) {
            throw new ShareNetSQLTypeConversionException("TIMESTAMP");
        }
        SqlValue sqlValue = this.currentRow[columnIndex - 1];
        this.wasNull = sqlValue.isMissing();
        Timestamp ts = this.wasNull ? null : sqlValue.getTimestamp(cal);
        return ts;
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getTimestamp(columnIndex, cal);
    }

    public synchronized void addWarning(SQLWarning warning) {
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            this.warnings.setNextWarning(warning);
        }
    }

    protected synchronized SqlValue[] fetch() throws ShareNetException {
        try {
            if (this.connection.isClosed()) {
                String messageIndex = "Sharenet.S259.ex.txt";
                Object[] messageArg = new Object[]{messageIndex};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: No connection to server.", messageArg));
            }
        }
        catch (SQLException e) {
            String messageIndex = "Sharenet.S259.ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: No connection to server.", messageArg));
        }
        if (this.blocknum == this.fetchSize) {
            Wqefcb clientFcb = new Wqefcb(this.connection.sharenetType);
            this.shareWarning = new ShareNetWarning("");
            clientFcb.minfo.sv[0] = 289;
            if (this.fetchSize != 0) {
                clientFcb.minfo.sv[2] = (short)this.fetchSize;
            }
            clientFcb.minfo.sv[1] = (short)this.ans.thissel;
            if (this.connection.xher1.share_rel >= 41) {
                clientFcb.minfo.sv[6] = this.connection.xher1.mr_indx;
                clientFcb.minfo.sv[7] = this.connection.xher1.en_indx;
            }
            clientFcb.nseg = 3;
            clientFcb.waseg[0] = new Ans1();
            clientFcb.waseg[1] = new Rcmsg();
            if (this.connection.xher1.share_rel >= 41) {
                if (this.values == null) {
                    this.values = new SqlValueArray(this.vars, false, this.fetchSize, this.con.getShareEncoding());
                }
                clientFcb.waseg[2] = this.values;
            } else {
                if (this.values == null) {
                    this.values = new SqlValueArray(this.vars, true, this.fetchSize, this.con.getShareEncoding());
                }
                clientFcb.waseg[2] = this.values;
            }
            this.send(clientFcb);
            Rcmsg rcmsg = (Rcmsg)clientFcb.waseg[1];
            Ans1 ans1 = (Ans1)clientFcb.waseg[0];
            String tempMsg = ShareNetConnection.formatMsg(clientFcb.acc, ans1, rcmsg);
            if (clientFcb.acc == 0) {
                this.shareWarning.warning = tempMsg + this.shareWarning.warning;
            } else {
                if (clientFcb.acc < 0) {
                    String messageIndex = "Sharenet.S260.ex.txt";
                    Object[] messageArg = new Object[]{messageIndex, String.valueOf(clientFcb.acc), tempMsg};
                    throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1} {2}", messageArg));
                }
                tempMsg = tempMsg + this.shareWarning.warning;
                this.shareWarning = new ShareNetWarning(clientFcb.acc, tempMsg);
                if (tempMsg.indexOf("End of file.") != -1 && this.stmt != null) {
                    this.stmt.destroy();
                }
            }
            this.blocknum = 0;
        }
        if (this.values.array[this.blocknum] == null) {
            return null;
        }
        return this.values.array[this.blocknum++];
    }

    protected synchronized void send(Wqefcb fcb) throws ShareNetException {
        fcb.waseg[0] = new Ans1();
        fcb.acc = 0;
        int i = 0;
        int j = 10;
        while (i < 3) {
            fcb.minfo.sv[j] = 34;
            ++i;
            ++j;
        }
        this.con.wqesndm(fcb, this.msg);
    }

    public int numFields() {
        return this.nvars;
    }

    public String[] fieldNames() {
        String[] result = new String[this.nvars];
        for (int i = 0; i < this.nvars; ++i) {
            result[i] = this.vars.array[i].sname;
        }
        return result;
    }

    public int fieldType(int i) {
        int result = this.vars.array[i].type;
        if (result == 1 && this.vars.array[i].subtype != 0) {
            result = this.vars.array[i].subtype;
        }
        return result;
    }

    public String fieldFormat(int i) {
        String result = this.vars.array[i].format.name;
        return result;
    }

    @Override
    public synchronized void close() throws SQLException {
        this.closed = true;
        try {
            if (!this.destroyed && this.stmt != null) {
                this.stmt.destroy();
                this.destroyed = true;
            }
        }
        catch (ShareNetException shareNetException) {
            // empty catch block
        }
        this.currentRow = null;
        this.maxReached = true;
        if (this.stmt != null && this.stmt.closeOnCompletion) {
            this.stmt.closeOnCompletion = false;
            this.stmt.close();
            this.stmt.closeOnCompletion = true;
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            Wqefcb clientFcb = this.construct_destroy_fcb();
            this.con.destroyQueue.addElement(clientFcb);
        }
        super.finalize();
    }

    private Wqefcb construct_destroy_fcb() {
        Wqefcb clientFcb = new Wqefcb(this.connection.sharenetType);
        clientFcb.waseg[0] = new Ans1();
        clientFcb.wmseg[0] = this.connection.defdes;
        clientFcb.waseg[1] = new Rcmsg();
        clientFcb.minfo.sv[0] = 290;
        if (this.connection.xher1.share_rel >= 41) {
            clientFcb.minfo.sv[6] = this.connection.xher1.mr_indx;
            clientFcb.minfo.sv[7] = this.connection.xher1.en_indx;
        }
        clientFcb.minfo.sv[1] = (short)this.ans.thissel;
        clientFcb.nseg = 2;
        clientFcb.acc = 0;
        int i = 0;
        int j = 10;
        while (i < 3) {
            clientFcb.minfo.sv[j] = 34;
            ++i;
            ++j;
        }
        return clientFcb;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: unwrap operation failed; input parameter is null.", new Object[]{"Sharenet.S586.ex.txt"}), null, 586);
        }
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException(ShareLocalizedError.getLocalizedError("unwrap operation failed; class {1} does not implement {2}", new Object[]{"Sharenet.S587.ex.txt", iface.getName(), this.getClass().getName()}), null, 587);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    void checkClosed() throws SQLException {
        if (this.closed) {
            int vendorCode = 592;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: The ResultSet is closed.", messageArg), null, vendorCode);
        }
    }

    private void checkAccess(int columnIndex) throws SQLException {
        this.checkClosed();
        if (this.currentRow == null) {
            int vendorCode = 129;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Not positioned on a valid row.", messageArg), null, vendorCode);
        }
        if (columnIndex < 1 || columnIndex > this.numColumns) {
            int vendorCode = 130;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }
}

