/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.net.sharenet.ShareLocalizedError;
import com.sas.net.sharenet.ShareNetConnection;
import com.sas.net.sharenet.ShareNetSQLFeatureNotSupportedException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class ShareNetDriver
implements Driver {
    public static final int majorVersion = 9;
    public static final int minorVersion = 4;

    @Override
    public synchronized Connection connect(String url, Properties info) throws SQLException {
        String temp;
        int qi;
        if (url.length() < 19) {
            return null;
        }
        String tempString = "jdbc:sharenet://";
        if (!url.regionMatches(0, tempString, 0, 16)) {
            return null;
        }
        if (info == null) {
            info = new Properties();
        }
        if ((qi = url.indexOf("?")) >= 0) {
            String tu;
            String query = url.substring(++qi, url.length());
            url = tu = url.substring(0, qi - 1);
            StringTokenizer pairOff = new StringTokenizer(query, "&", false);
            while (pairOff.hasMoreTokens()) {
                int pi;
                String pair = pairOff.nextToken();
                char last = pair.charAt(pair.length() - 1);
                if (last == '\\') {
                    String realPair;
                    pair = realPair = pair.substring(0, pair.length() - 1) + "&" + pairOff.nextToken();
                }
                if ((pi = pair.indexOf("=")) < 0) continue;
                String propN = pair.substring(0, pi);
                String propV = pair.substring(pi + 1, pair.length());
                if (propN == null || propV == null) continue;
                info.put(propN, propV);
            }
        }
        if (info != null && (temp = info.getProperty("user")) != null) {
            info.put("shareUser", temp);
            temp = info.getProperty("password");
            if (temp != null) {
                info.put("sharePassword", temp);
            }
        }
        SQLWarning sw = null;
        if (!this.propertyCheck(info)) {
            int vendorCode = 568;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            sw = new SQLWarning(ShareLocalizedError.getLocalizedError("One or more invalid properties specified.", messageArg), null, vendorCode);
        }
        ShareNetConnection sc = new ShareNetConnection(url, info);
        if (sw != null) {
            if (sc.warnings == null) {
                sc.warnings = sw;
            } else {
                sc.warnings.setNextWarning(sw);
            }
        }
        return sc;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url.length() < 19) {
            return false;
        }
        String tempString = "jdbc:sharenet://";
        return url.regionMatches(0, tempString, 0, 16);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        DriverPropertyInfo[] shareProperties = new DriverPropertyInfo[14];
        shareProperties[0] = new DriverPropertyInfo("appname", "JavaApp");
        shareProperties[0].description = ShareLocalizedError.getLocalizedError("", new Object[]{"Sharenet.S569.ex.txt"});
        shareProperties[1] = new DriverPropertyInfo("shareUser", "");
        shareProperties[1].description = ShareLocalizedError.getLocalizedError("", new Object[]{"Sharenet.S570.ex.txt"});
        shareProperties[2] = new DriverPropertyInfo("sharePassword", "");
        shareProperties[2].description = ShareLocalizedError.getLocalizedError("", new Object[]{"Sharenet.S571.ex.txt"});
        shareProperties[3] = new DriverPropertyInfo("sapw", "");
        shareProperties[3].description = ShareLocalizedError.getLocalizedError("", new Object[]{"Sharenet.S572.ex.txt"});
        shareProperties[4] = new DriverPropertyInfo("pt2dbpw", "");
        shareProperties[4].description = ShareLocalizedError.getLocalizedError("", new Object[]{"Sharenet.S573.ex.txt"});
        shareProperties[5] = new DriverPropertyInfo("dbms", "SQLVIEW ");
        shareProperties[5].description = ShareLocalizedError.getLocalizedError("", new Object[]{"Sharenet.S574.ex.txt"});
        shareProperties[6] = new DriverPropertyInfo("dbms_options", "");
        shareProperties[6].description = ShareLocalizedError.getLocalizedError("", new Object[]{"Sharenet.S575.ex.txt"});
        shareProperties[7] = new DriverPropertyInfo("remarks", "false");
        shareProperties[7].description = ShareLocalizedError.getLocalizedError("", new Object[]{"Sharenet.S576.ex.txt"});
        shareProperties[8] = new DriverPropertyInfo("undoPolicyNone", "true");
        shareProperties[8].description = ShareLocalizedError.getLocalizedError("", new Object[]{"Sharenet.S577.ex.txt"});
        shareProperties[9] = new DriverPropertyInfo("routerUrl", "");
        shareProperties[9].description = ShareLocalizedError.getLocalizedError("", new Object[]{"Sharenet.S578.ex.txt"});
        shareProperties[10] = new DriverPropertyInfo("dbmsOptions", "");
        shareProperties[10].description = ShareLocalizedError.getLocalizedError("", new Object[]{"Sharenet.S579.ex.txt"});
        shareProperties[11] = new DriverPropertyInfo("user", "");
        shareProperties[11].description = ShareLocalizedError.getLocalizedError("", new Object[]{"Sharenet.S580.ex.txt"});
        shareProperties[12] = new DriverPropertyInfo("password", "");
        shareProperties[12].description = ShareLocalizedError.getLocalizedError("", new Object[]{"Sharenet.S581.ex.txt"});
        shareProperties[13] = new DriverPropertyInfo("librefs", "");
        shareProperties[13].description = ShareLocalizedError.getLocalizedError("", new Object[]{"Sharenet.S582.ex.txt"});
        return shareProperties;
    }

    @Override
    public int getMajorVersion() {
        return 9;
    }

    @Override
    public int getMinorVersion() {
        return 4;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    private boolean propertyCheck(Properties p) {
        DriverPropertyInfo[] dpiArray = this.getPropertyInfo(null, null);
        Enumeration<?> en = p.propertyNames();
        String pName = null;
        int x = 0;
        boolean found = false;
        boolean flag = true;
        while (en.hasMoreElements()) {
            pName = (String)en.nextElement();
            if (pName.equalsIgnoreCase("outputDir")) continue;
            for (x = 0; x < dpiArray.length; ++x) {
                if (!pName.equalsIgnoreCase(dpiArray[x].name)) continue;
                String pVal = p.getProperty(pName);
                p.setProperty(dpiArray[x].name, pVal);
                found = true;
                break;
            }
            if (found) {
                found = false;
                continue;
            }
            flag = false;
        }
        return flag;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    static {
        try {
            Driver driver = (Driver)Class.forName("com.sas.net.sharenet.ShareNetDriver").newInstance();
            DriverManager.registerDriver(driver);
        }
        catch (Exception exception) {
        }
        catch (ClassFormatError classFormatError) {
            // empty catch block
        }
    }
}

