/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.codepolicy.SASScope;
import com.sas.net.sharenet.Column;
import com.sas.net.sharenet.ShareLocalizedError;
import com.sas.net.sharenet.ShareNetConnection;
import com.sas.net.sharenet.ShareNetException;
import com.sas.net.sharenet.ShareNetResultSet;
import com.sas.net.sharenet.ShareNetSQLFeatureNotSupportedException;
import com.sas.net.sharenet.ShareNetStatement;
import com.sas.net.sharenet.SqlValue;
import com.sas.net.sharenet.Sqpformat;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.regex.Pattern;

@SASScope(value="ALL")
public class ShareNetDatabaseMetaData
implements DatabaseMetaData {
    private static final String driverName = "SAS/SHARE driver for JDBC, Version 9.4 Production";
    private ShareNetConnection connection;
    static int specialColumns = 2;
    static int specialBestRowIdentifier = 3;
    static int specialTypeInfo = 4;
    static int specialIndexInfo = 5;
    protected short sv = 0;
    private int vendorCode;
    private String messageIndex;
    static final int TABLE_CAT_LENGTH = 8;
    static final int TABLE_SCHEM_LENGTH = 8;
    private static final int TABLE_TABLE_LENGTH = 32;
    private static final int COLUMN_LENGTH = 32;
    private String m_driverVersion;

    @SASScope
    public ShareNetDatabaseMetaData(ShareNetConnection inconnection) throws SQLException {
        this.connection = inconnection;
        this.sv = this.connection.xher1.share_rel;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getUser();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "SAS";
    }

    @Override
    public synchronized String getDatabaseProductVersion() throws SQLException {
        int end;
        ShareNetStatement stmt = new ShareNetStatement(this.connection);
        String version = "";
        if (this.connection.isClosed()) {
            this.vendorCode = 71;
            this.messageIndex = "Sharenet.S" + this.vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            stmt.close();
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: No connection to server.", messageArg), null, this.vendorCode);
        }
        if (this.connection.version_msg != null && this.connection.version_msg.indexOf(0) == 0 && (end = this.connection.version_msg.indexOf(0, 1)) != -1) {
            version = this.connection.version_msg.substring(1, end);
            stmt.close();
            return version;
        }
        String sql = "select value as version from dictionary.macros where name='SYSVLONG'";
        try {
            stmt.prepareDescribe(sql);
        }
        catch (ShareNetException ioe) {
            sql = "select \"&sysvlong\" as version from dictionary.options where optname='LINESIZE'";
            try {
                stmt.prepareDescribe(sql);
            }
            catch (ShareNetException ioe2) {
                this.vendorCode = 72;
                this.messageIndex = "Sharenet.S" + this.vendorCode + ".ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex, ioe2.getMessage()};
                stmt.close();
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg), null, this.vendorCode);
            }
        }
        ShareNetResultSet rs = new ShareNetResultSet(stmt, sql);
        try {
            SqlValue[] row = rs.fetch();
            version = row == null ? "Version cannot be obtained" : row[0].toString();
        }
        catch (ShareNetException ioe3) {
            rs.close();
            this.vendorCode = 73;
            this.messageIndex = "Sharenet.S" + this.vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, ioe3.getMessage()};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg), null, this.vendorCode);
        }
        if (rs != null) {
            rs.close();
        }
        return version;
    }

    @Override
    public String getDriverName() throws SQLException {
        return driverName;
    }

    @Override
    public String getDriverVersion() throws SQLException {
        if (this.m_driverVersion == null) {
            String driverBuildVersion = null;
            Package p = Package.getPackage("com.sas.net.sharenet");
            if (p != null) {
                driverBuildVersion = p.getImplementationVersion();
            }
            this.m_driverVersion = driverBuildVersion == null ? "9.4" : "9.4." + driverBuildVersion;
        }
        return this.m_driverVersion;
    }

    @Override
    public int getDriverMajorVersion() {
        return 9;
    }

    @Override
    public int getDriverMinorVersion() {
        return 4;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.sv < 41;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.sv >= 41;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return " ";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "ABS, ACOS, ASIN, ATAN, CEILING, COS, EXP, FLOOR, LOG, LOG10, MOD, POWER, RAND, ROUND, SIGN, SIN, SQRT, TAN";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "ASCII, CHAR, CONCAT, LCASE, LEFT, LTRIM, REPEAT, REPLACE, RTRIM, SOUNDEX, SPACE, SUBSTRING, UCASE";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE, CURTIME, DAYNAME, DAYOFMONTH, DAYOFWEEK, DAYOFYEAR, HOUR, MINUTE, MONTH, MONTHNAME, NOW, QUARTER, SECOND, YEAR";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "library";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        if (this.sv >= 41) {
            return Short.MAX_VALUE;
        }
        return 200;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        if (this.sv >= 41) {
            return 32;
        }
        return 8;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 8;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        if (this.sv >= 41) {
            return 32;
        }
        return 8;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 8;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 0;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        this.vendorCode = 75;
        this.messageIndex = "Sharenet.S" + this.vendorCode + ".ex.txt";
        Object[] messageArg = new Object[]{this.messageIndex};
        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Stored procedures not supported.", messageArg), null, this.vendorCode);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        this.vendorCode = 76;
        this.messageIndex = "Sharenet.S" + this.vendorCode + ".ex.txt";
        Object[] messageArg = new Object[]{this.messageIndex};
        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Stored procedures not supported.", messageArg), null, this.vendorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        Column c1 = new Column.Builder().name("TABLE_CAT").sqlType(12).length(8).label("Catalog").build();
        Column c2 = new Column.Builder().name("TABLE_SCHEM").sqlType(12).length(8).label("Library Name").build();
        Column c3 = new Column.Builder().name("TABLE_NAME").sqlType(12).length(32).label("Member Name").build();
        Column c4 = new Column.Builder().name("TABLE_TYPE").sqlType(12).length(8).label("Member Type").build();
        Column c5 = new Column.Builder().name("REMARKS").sqlType(12).length(256).label("Remarks").build();
        Column c6 = new Column.Builder().name("TYPE_CAT").sqlType(12).length(256).label("Types Catalog").build();
        Column c7 = new Column.Builder().name("TYPE_SCHEM").sqlType(12).length(256).label("Types Schema").build();
        Column c8 = new Column.Builder().name("TYPE_NAME").sqlType(12).length(256).label("Type Name").build();
        Column c9 = new Column.Builder().name("SELF_REFERENCING_COL_NAME").sqlType(12).length(256).label("Identifier Column").build();
        Column c10 = new Column.Builder().name("REF_GENERATION").sqlType(12).length(256).label("Reference Generation").build();
        Column c11 = new Column.Builder().name("TABLE_PASS").sqlType(12).length(3).label("Type of Password Protection").build();
        try (ShareNetStatement st = null;){
            ShareNetResultSet shareNetResultSet;
            block37: {
                st = new ShareNetStatement(this.connection);
                boolean where = false;
                StringBuilder query = new StringBuilder();
                if (this.connection.getRemarks()) {
                    if (this.sv < 41) {
                        query.append("select '' as catalog, libname as schema, memname as table, memtype as type, memlabel as comment, '' as tcat, '' as tschem, '' as tname, '' as srcn, '' as rg, protect from dictionary.tables as tables");
                    } else {
                        query.append("select '' as TABLE_CAT, libname as TABLE_SCHEM, memname as TABLE_NAME, memtype as TABLE_TYPE, memlabel as REMARKS, '' as TYPE_CAT, '' as TYPE_SCHEM, '' as TYPE_NAME, '' as SELF_REFERENCING_COL_NAME, '' as REF_GENERATION, PROTECT as TABLE_PASS from dictionary.tables as tables");
                    }
                } else if (this.sv < 41) {
                    query.append("select '' as catalog, libname as schema, memname as table, memtype as type, 'No comments' as comment, '' as tcat, '' as tschem, '' as tname, '' as srcn, '' as rg, protect from dictionary.tables as tables");
                } else {
                    query.append("select '' as TABLE_CAT, libname as TABLE_SCHEM, memname as TABLE_NAME, memtype as TABLE_TYPE, 'No comments' as REMARKS, '' as TYPE_CAT, '' as TYPE_SCHEM, '' as TYPE_NAME, '' as SELECT_REFERENCING_COL_NAME, '' as REF_GENERATION, PROTECT as TABLE_PASS from dictionary.tables as tables");
                }
                if (schemaPattern != null && schemaPattern.length() != 0) {
                    query.append(" where libname like '" + schemaPattern.toUpperCase() + "' ");
                    where = true;
                }
                if (tableNamePattern != null && tableNamePattern.length() != 0) {
                    if (where) {
                        query.append(" and ");
                    } else {
                        where = true;
                        query.append(" where ");
                    }
                    query.append(" memname like '" + tableNamePattern + "' ");
                }
                if (types != null && types.length != 0) {
                    int i;
                    for (i = 0; i < types.length; ++i) {
                        if (types[i] == null || types[i].length() == 0 || !types[i].trim().toUpperCase().equals("TABLE")) continue;
                        types[i] = "DATA";
                    }
                    if (where) {
                        query.append(" and ");
                    } else {
                        where = true;
                        query.append(" where ");
                    }
                    query.append(" memtype in ('" + types[0].toUpperCase() + "' ");
                    for (i = 1; i < types.length; ++i) {
                        if (types[i] == null || types[i].length() == 0) continue;
                        query.append(", '" + types[i].toUpperCase() + "' ");
                    }
                    query.append(") ");
                }
                if (this.sv < 41) {
                    query.append(" order by type, schema, table");
                } else {
                    query.append(" order by TABLE_TYPE, TABLE_SCHEM, TABLE_NAME");
                }
                ResultSet rs = null;
                try {
                    rs = st.executeQuery(query.toString());
                    ArrayList<Object[]> rowData = new ArrayList<Object[]>();
                    String tableType = null;
                    String protect = null;
                    String privStr = null;
                    while (rs.next()) {
                        tableType = rs.getString(this.sv < 41 ? "type" : "TABLE_TYPE").trim().toUpperCase();
                        if ("DATA".equals(tableType)) {
                            tableType = "TABLE";
                        }
                        protect = rs.getString(this.sv < 41 ? "protect" : "TABLE_PASS").trim().toUpperCase();
                        privStr = "";
                        if (protect.length() == 3) {
                            char[] pc = protect.toCharArray();
                            assert (pc.length == 3);
                            if (pc[0] == 'R') {
                                privStr = "READ";
                            }
                            if (pc[1] == 'W') {
                                if (privStr.length() > 0) {
                                    privStr = privStr + ",";
                                }
                                privStr = privStr + "WRITE";
                            }
                            if (pc[2] == 'A') {
                                if (privStr.length() > 0) {
                                    privStr = privStr + ",";
                                }
                                privStr = privStr + "ALTER";
                            }
                        }
                        if ("".equals(privStr)) {
                            privStr = null;
                        }
                        rowData.add(new Object[]{rs.getString(this.sv < 41 ? "catalog" : "TABLE_CAT"), rs.getString(this.sv < 41 ? "schema" : "TABLE_SCHEM").trim(), rs.getString(this.sv < 41 ? "table" : "TABLE_NAME").trim(), tableType, rs.getString(this.sv < 41 ? "comment" : "REMARKS"), rs.getString(this.sv < 41 ? "tcat" : "TYPE_CAT"), rs.getString(this.sv < 41 ? "tschem" : "TYPE_SCHEM"), rs.getString(this.sv < 41 ? "tname" : "TYPE_NAME"), rs.getString(this.sv < 41 ? "srcn" : "SELECT_REFERENCING_COL_NAME"), rs.getString(this.sv < 41 ? "rg" : "REF_GENERATION"), privStr});
                    }
                    shareNetResultSet = new ShareNetResultSet(new Column[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11}, rowData);
                    if (rs == null) break block37;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        this.vendorCode = 78;
                        this.messageIndex = "Sharenet.S" + this.vendorCode + ".ex.txt";
                        Object[] messageArg = new Object[]{this.messageIndex, e.getMessage()};
                        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg), null, this.vendorCode);
                    }
                }
                rs.close();
            }
            return shareNetResultSet;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public ResultSet getSchemas() throws SQLException {
        if (this.connection.isClosed()) {
            this.vendorCode = 79;
            this.messageIndex = "Sharenet.S" + this.vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: No connection to server.", messageArg), null, this.vendorCode);
        }
        Column c1 = new Column.Builder().name("TABLE_SCHEM").sqlType(12).length(8).label("Library Name").build();
        Column c2 = new Column.Builder().name("TABLE_CATALOG").sqlType(12).length(8).label("Table Catalog").build();
        try (Statement st = null;){
            st = this.connection.createStatement();
            StringBuilder sql = this.sv < 41 ? new StringBuilder("SELECT distinct libname as schema, '' as catalog from dictionary.libnames order by schema") : new StringBuilder("SELECT distinct libname as TABLE_SCHEM, '' as TABLE_CATALOG from dictionary.libnames order by TABLE_SCHEM");
            try (ResultSet rs = null;){
                rs = st.executeQuery(sql.toString());
                ArrayList<Object[]> rowData = new ArrayList<Object[]>();
                while (rs.next()) {
                    rowData.add(new Object[]{rs.getString(1).trim(), null});
                }
                ShareNetResultSet shareNetResultSet = new ShareNetResultSet(new Column[]{c1, c2}, rowData);
                return shareNetResultSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        this.vendorCode = 81;
        this.messageIndex = "Sharenet.S" + this.vendorCode + ".ex.txt";
        Object[] messageArg = new Object[]{this.messageIndex};
        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Catalogs not supported.", messageArg), null, this.vendorCode);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        if (this.connection.isClosed()) {
            this.vendorCode = 82;
            this.messageIndex = "Sharenet.S" + this.vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: No connection to server.", messageArg), null, this.vendorCode);
        }
        Column c1 = new Column.Builder().name("TABLE_TYPE").sqlType(12).length(8).label("Member Type").build();
        ArrayList<Object[]> rowData = new ArrayList<Object[]>();
        rowData.add(new Object[]{"TABLE"});
        rowData.add(new Object[]{"VIEW"});
        return new ShareNetResultSet(new Column[]{c1}, rowData);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (this.connection.isClosed()) {
            this.vendorCode = 82;
            this.messageIndex = "Sharenet.S" + this.vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: No connection to server.", messageArg), null, this.vendorCode);
        }
        if (tableNamePattern == null || schemaPattern == null) {
            this.vendorCode = 313;
            this.messageIndex = "Sharenet.S" + this.vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Table name must be specified.", messageArg), null, this.vendorCode);
        }
        Column c1 = new Column.Builder().name("TABLE_CAT").sqlType(12).length(8).label("Catalog").build();
        Column c2 = new Column.Builder().name("TABLE_SCHEM").sqlType(12).length(8).label("Library Name").build();
        Column c3 = new Column.Builder().name("TABLE_NAME").sqlType(12).length(32).label("Member Name").build();
        Column c4 = new Column.Builder().name("COLUMN_NAME").sqlType(12).length(32).label("Column Name").build();
        Column c5 = new Column.Builder().name("DATA_TYPE").sqlType(5).label("Data Type").build();
        Column c6 = new Column.Builder().name("TYPE_NAME").sqlType(12).length(49).label("Column Format").build();
        Column c7 = new Column.Builder().name("COLUMN_SIZE").sqlType(4).label("Column Length").build();
        Column c8 = new Column.Builder().name("BUFFER_LENGTH").sqlType(4).label("Buffer Length").build();
        Column c9 = new Column.Builder().name("DECIMAL_DIGITS").sqlType(4).label("Decimal Digits").build();
        Column c10 = new Column.Builder().name("NUM_PREC_RADIX").sqlType(4).label("Num Prec Radix").build();
        Column c11 = new Column.Builder().name("NULLABLE").sqlType(4).label("Nullable").build();
        Column c12 = new Column.Builder().name("REMARKS").sqlType(12).length(256).label("Column Label").build();
        Column c13 = new Column.Builder().name("COLUMN_DEF").sqlType(12).length(1).label("Column Default").build();
        Column c14 = new Column.Builder().name("SQL_DATA_TYPE").sqlType(4).label("").build();
        Column c15 = new Column.Builder().name("SQL_DATETIME_SUB").sqlType(4).label("").build();
        Column c16 = new Column.Builder().name("CHAR_OCTET_LENGTH").sqlType(4).label("Column Length").build();
        Column c17 = new Column.Builder().name("ORDINAL_POSITION").sqlType(4).label("Column Number in Table").build();
        Column c18 = new Column.Builder().name("IS_NULLABLE").sqlType(12).length(3).label("Is Nullable").build();
        Column c19 = new Column.Builder().name("SCOPE_CATALOG").sqlType(12).length(32).label("Is Nullable").build();
        Column c20 = new Column.Builder().name("SCOPE_SCHEMA").sqlType(12).length(32).label("Is Nullable").build();
        Column c21 = new Column.Builder().name("SCOPE_TABLE").sqlType(12).length(32).label("Is Nullable").build();
        Column c22 = new Column.Builder().name("SOURCE_DATA_TYPE").sqlType(5).label("Is Nullable").build();
        Column c23 = new Column.Builder().name("IS_AUTOINCREMENT").sqlType(12).length(32).label("Is Nullable").build();
        Column c24 = new Column.Builder().name("IS_GENERATEDCOLUMN").sqlType(12).length(32).label("Is Nullable").build();
        Column c25 = new Column.Builder().name("FORMAT").sqlType(12).length(32).label("SAS Format").build();
        Column c26 = new Column.Builder().name("SASTYPE").sqlType(12).length(4).label("SAS Type").build();
        Column[] columns = new Column[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20, c21, c22, c23, c24, c25, c26};
        if (tableNamePattern.length() != 0 && tableNamePattern.indexOf(40) != -1) {
            return this.getColumnsPasswordProtected(schemaPattern, tableNamePattern, columns);
        }
        return this.getColumnsNotPasswordProtected(schemaPattern, tableNamePattern, columnNamePattern, columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getColumnsNotPasswordProtected(String schemaPattern, String tableNamePattern, String columnNamePattern, Column[] columns) throws SQLException {
        boolean where = false;
        StringBuilder sql = this.sv < 41 ? new StringBuilder("select ' ' as catalog, libname as schema, memname as table, name, 0 as sqltype, format as type, length as size, ' ' as empty, 0 as scale, 10 as radix, 0 as nullable, label as comment, ' ' as default, 0 as empty2, 0 as empty3, length as max, varnum as position, ' ' as notknown, '' as sc_cat, '' as sc_schema, '' as sc_table, '' as src_type, '' as autoinc, '' as gencol, format, type as sastype from dictionary.columns as columns") : new StringBuilder("select ' ' as TABLE_CAT, libname as TABLE_SCHEM, memname as TABLE_NAME, name as COLUMN_NAME, 0 as DATA_TYPE, format as TYPE_NAME, length as COLUMN_SIZE, ' ' as BUFFER_LENGTH, 0 as DECIMAL_DIGITS, 10 as NUM_PREC_RADIX, 0 as NULLABLE, label as REMARKS, ' ' as COLUMN_DEF, 0 as SQL_DATA_TYPE, 0 as SQL_DATETIME_SUB, length as CHAR_OCTET_LENGTH, varnum as ORDINAL_POSITION, ' ' as IS_NULLABLE, '' as SCOPE_CATLOG, '' as SCOPE_SCHEMA, '' as SCOPE_TABLE, '' as SOURCE_DATA_TYPE, '' as IS_AUTOINCREMENT, '' as IS_GENERATEDCOLUMN, FORMAT, type as SASTYPE from dictionary.columns as columns");
        if (schemaPattern.length() != 0) {
            sql.append(" where libname like '" + schemaPattern.toUpperCase() + "' ");
            where = true;
        }
        if (where) {
            sql.append(" and ");
        } else {
            where = true;
            sql.append(" where ");
        }
        sql.append(" memname like '" + tableNamePattern + "' ");
        if (columnNamePattern != null && columnNamePattern.length() != 0) {
            if (where) {
                sql.append(" and ");
            } else {
                where = true;
                sql.append(" where ");
            }
            sql.append(" name like '" + columnNamePattern + "' ");
            where = true;
        }
        if (this.sv < 41) {
            sql.append(" order by schema, table, position");
        } else {
            sql.append(" order by TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION");
        }
        try (Statement st = null;){
            ShareNetResultSet shareNetResultSet;
            block18: {
                st = this.connection.createStatement();
                ResultSet rs = null;
                try {
                    rs = st.executeQuery(sql.toString());
                    ArrayList<Object[]> rowData = new ArrayList<Object[]>();
                    while (rs.next()) {
                        int dataType = 0;
                        String tempFormat = rs.getString("sastype").trim();
                        if (tempFormat.equals("char")) {
                            dataType = 12;
                        }
                        rowData.add(new Object[]{"", rs.getString(this.sv < 41 ? "schema" : "TABLE_SCHEM").trim(), rs.getString(this.sv < 41 ? "table" : "TABLE_NAME").trim(), rs.getString(this.sv < 41 ? "name" : "COLUMN_NAME").trim(), dataType, rs.getString(this.sv < 41 ? "type" : "TYPE_NAME").trim(), rs.getInt(this.sv < 41 ? "size" : "COLUMN_SIZE"), 0, 0, 10, dataType == 12 ? 0 : 1, rs.getString(this.sv < 41 ? "comment" : "REMARKS"), null, 0, 0, rs.getDouble(this.sv < 41 ? "max" : "CHAR_OCTET_LENGTH"), rs.getDouble(this.sv < 41 ? "position" : "ORDINAL_POSITION"), dataType == 12 ? "NO" : "YES", rs.getString(19), rs.getString(20), rs.getString(21), null, rs.getString(23), rs.getString(24), rs.getString(25), rs.getString(26)});
                    }
                    shareNetResultSet = new ShareNetResultSet(columns, rowData);
                    if (rs == null) break block18;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        rs.close();
                    }
                    throw throwable;
                }
                rs.close();
            }
            return shareNetResultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ResultSet getColumnsPasswordProtected(String schemaPattern, String tableNamePattern, Column[] columns) throws SQLException {
        String sql = "select * from " + schemaPattern.trim() + "." + tableNamePattern.trim() + " WHERE 0";
        ShareNetResultSet snResultSet = null;
        try (Statement stmt = null;){
            stmt = this.connection.createStatement();
            ResultSet rs = null;
            ArrayList<Object[]> rowData = new ArrayList<Object[]>();
            try {
                rs = stmt.executeQuery(sql);
                ResultSetMetaData rsmd = rs.getMetaData();
                int dataType = 0;
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    dataType = rsmd.getColumnType(i);
                    rowData.add(new Object[]{"", rsmd.getSchemaName(i), rsmd.getTableName(i), rsmd.getColumnName(i), dataType, rsmd.getColumnTypeName(i), rsmd.getColumnDisplaySize(i), 0, rsmd.getScale(i), 10, rsmd.isNullable(i), rsmd.getColumnLabel(i), null, 0, 0, rsmd.getColumnDisplaySize(i), i, dataType == 12 ? "NO" : "YES"});
                }
                snResultSet = new ShareNetResultSet(columns, rowData);
                if (rs == null) return snResultSet;
            }
            catch (SQLException sQLException) {
                if (rs == null) return snResultSet;
                rs.close();
                return snResultSet;
                catch (Throwable throwable) {
                    if (rs == null) throw throwable;
                    rs.close();
                    throw throwable;
                }
            }
            rs.close();
            return snResultSet;
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    /*
     * Loose catch block
     */
    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        if (this.connection.isClosed()) {
            this.vendorCode = 82;
            this.messageIndex = "Sharenet.S" + this.vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: No connection to server.", messageArg), null, this.vendorCode);
        }
        if (table == null || table.length() == 0) {
            this.vendorCode = 314;
            this.messageIndex = "Sharenet.S" + this.vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Table name must be specified.", messageArg), null, this.vendorCode);
        }
        Column c1 = new Column.Builder().name("SCOPE").sqlType(5).label("Scope").build();
        Column c2 = new Column.Builder().name("COLUMN_NAME").sqlType(12).length(32).label("Column Name").build();
        Column c3 = new Column.Builder().name("DATA_TYPE").sqlType(5).length(32).label("Data Type").build();
        Column c4 = new Column.Builder().name("TYPE_NAME").sqlType(12).length(32).label("Column Type").build();
        Column c5 = new Column.Builder().name("COLUMN_SIZE").sqlType(4).label("Column Length").build();
        Column c6 = new Column.Builder().name("BUFFER_LENGTH").sqlType(4).label("Buffer Length").build();
        Column c7 = new Column.Builder().name("DECIMAL_DIGITS").sqlType(5).label("Decimal Digits").build();
        Column c8 = new Column.Builder().name("PSEUDO_COLUMN").sqlType(5).label("Pseudo Column").build();
        try (Statement st = null;){
            st = this.connection.createStatement();
            StringBuilder sql = this.sv < 41 ? new StringBuilder("select 2 as scope, indexes.name, 0 as sqltype, col.type as type, col.length as size, 0 as buffer, 0 as scale, 1 as pseudo, col.format as format, type as sastype from dictionary.indexes as indexes, dictionary.columns as col where ") : new StringBuilder("select 2 as SCOPE, indexes.name as COLUMN_NAME, 0 as DATA_TYPE, col.type as TYPE_NAME, col.length as COLUMN_SIZE, 0 as BUFFER_LENGTH, 0 as DECIMAL_DIGITS, 1 as PSEUDO_COLUMN, col.format as format, type as sastype from dictionary.indexes as indexes, dictionary.columns as col where ");
            sql.append("indexes.memname = '");
            sql.append(table.trim().toUpperCase());
            sql.append("' ");
            sql.append("and col.memname = '");
            sql.append(table.trim().toUpperCase());
            sql.append("' ");
            sql.append("and indexes.libname = col.libname and indexes.name = col.name ");
            if (schema != null && schema.length() != 0) {
                sql.append("and indexes.libname = '" + schema.trim().toUpperCase() + "' ");
                sql.append("and col.libname = '" + schema.trim().toUpperCase() + "' ");
            }
            sql.append("and indexes.unique = 'yes' ORDER BY indexes.indxname ");
            try (ResultSet rs = null;){
                rs = st.executeQuery(sql.toString());
                ArrayList<Object[]> rowData = new ArrayList<Object[]>();
                while (rs.next()) {
                    int dataType = 0;
                    String tempFormat = rs.getString("sastype").trim();
                    if (tempFormat.equals("char")) {
                        dataType = 12;
                    } else {
                        String format = rs.getString("format").trim();
                        dataType = this.sasNumericFormatToSqlType(format);
                    }
                    String sqlTypeName = this.getSQLTypeString(dataType);
                    rowData.add(new Object[]{2, rs.getString(this.sv < 41 ? "name" : "COLUMN_NAME").trim(), dataType, sqlTypeName, rs.getInt(this.sv < 41 ? "size" : "COLUMN_SIZE"), 0, 0, 1});
                }
                ShareNetResultSet dataType = new ShareNetResultSet(new Column[]{c1, c2, c3, c4, c5, c6, c7, c8}, rowData);
                return dataType;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        Column c1 = new Column.Builder().name("PKTABLE_CAT").sqlType(12).length(8).label("PK Catalog").build();
        Column c2 = new Column.Builder().name("PKTABLE_SCHEM").sqlType(12).length(8).label("PK Schema").build();
        Column c3 = new Column.Builder().name("PKTABLE_NAME").sqlType(12).length(32).label("PK Table Name").build();
        Column c4 = new Column.Builder().name("PKCOLUMN_NAME").sqlType(12).length(32).label("PK Column Name").build();
        Column c5 = new Column.Builder().name("FKTABLE_CAT").sqlType(12).length(32).length(8).label("FK Catalog").build();
        Column c6 = new Column.Builder().name("FKTABLE_SCHEM").sqlType(12).length(8).label("FK Schema").build();
        Column c7 = new Column.Builder().name("FKTABLE_NAME").sqlType(12).length(8).label("FK Table").build();
        Column c8 = new Column.Builder().name("FKCOLUMN_NAME").sqlType(12).length(32).label("FK Column").build();
        Column c9 = new Column.Builder().name("KEY_SEQ").sqlType(5).label("Key Sequence").build();
        Column c10 = new Column.Builder().name("UPDATE_RULE").sqlType(5).label("Update Rule").build();
        Column c11 = new Column.Builder().name("DELETE_RULE").sqlType(5).label("Delete Rule").build();
        Column c12 = new Column.Builder().name("FK_NAME").sqlType(12).length(32).label("FK Name").build();
        Column c13 = new Column.Builder().name("PK_NAME").sqlType(12).length(32).label("PK Name").build();
        Column c14 = new Column.Builder().name("DEFERRABILITY").sqlType(5).label("Deferrability").build();
        ArrayList<Object[]> rowData = new ArrayList<Object[]>();
        return new ShareNetResultSet(new Column[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14}, rowData);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        Column c1 = new Column.Builder().name("PKTABLE_CAT").sqlType(12).length(8).label("PK Catalog").build();
        Column c2 = new Column.Builder().name("PKTABLE_SCHEM").sqlType(12).length(8).label("PK Schema").build();
        Column c3 = new Column.Builder().name("PKTABLE_NAME").sqlType(12).length(32).label("PK Table Name").build();
        Column c4 = new Column.Builder().name("PKCOLUMN_NAME").sqlType(12).length(32).label("PK Column Name").build();
        Column c5 = new Column.Builder().name("FKTABLE_CAT").sqlType(12).length(32).length(8).label("FK Catalog").build();
        Column c6 = new Column.Builder().name("FKTABLE_SCHEM").sqlType(12).length(8).label("FK Schema").build();
        Column c7 = new Column.Builder().name("FKTABLE_NAME").sqlType(12).length(8).label("FK Table").build();
        Column c8 = new Column.Builder().name("FKCOLUMN_NAME").sqlType(12).length(32).label("FK Column").build();
        Column c9 = new Column.Builder().name("KEY_SEQ").sqlType(5).label("Key Sequence").build();
        Column c10 = new Column.Builder().name("UPDATE_RULE").sqlType(5).label("Update Rule").build();
        Column c11 = new Column.Builder().name("DELETE_RULE").sqlType(5).label("Delete Rule").build();
        Column c12 = new Column.Builder().name("FK_NAME").sqlType(12).length(32).label("FK Name").build();
        Column c13 = new Column.Builder().name("PK_NAME").sqlType(12).length(32).label("PK Name").build();
        Column c14 = new Column.Builder().name("DEFERRABILITY").sqlType(5).label("Deferrability").build();
        ArrayList<Object[]> rowData = new ArrayList<Object[]>();
        return new ShareNetResultSet(new Column[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14}, rowData);
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        Column c1 = new Column.Builder().name("PKTABLE_CAT").sqlType(12).length(8).label("PK Catalog").build();
        Column c2 = new Column.Builder().name("PKTABLE_SCHEM").sqlType(12).length(8).label("PK Schema").build();
        Column c3 = new Column.Builder().name("PKTABLE_NAME").sqlType(12).length(32).label("PK Table Name").build();
        Column c4 = new Column.Builder().name("PKCOLUMN_NAME").sqlType(12).length(32).label("PK Column Name").build();
        Column c5 = new Column.Builder().name("FKTABLE_CAT").sqlType(12).length(32).length(8).label("FK Catalog").build();
        Column c6 = new Column.Builder().name("FKTABLE_SCHEM").sqlType(12).length(8).label("FK Schema").build();
        Column c7 = new Column.Builder().name("FKTABLE_NAME").sqlType(12).length(8).label("FK Table").build();
        Column c8 = new Column.Builder().name("FKCOLUMN_NAME").sqlType(12).length(32).label("FK Column").build();
        Column c9 = new Column.Builder().name("KEY_SEQ").sqlType(5).label("Key Sequence").build();
        Column c10 = new Column.Builder().name("UPDATE_RULE").sqlType(5).label("Update Rule").build();
        Column c11 = new Column.Builder().name("DELETE_RULE").sqlType(5).label("Delete Rule").build();
        Column c12 = new Column.Builder().name("FK_NAME").sqlType(12).length(32).label("FK Name").build();
        Column c13 = new Column.Builder().name("PK_NAME").sqlType(12).length(32).label("PK Name").build();
        Column c14 = new Column.Builder().name("DEFERRABILITY").sqlType(5).label("Deferrability").build();
        ArrayList<Object[]> rowData = new ArrayList<Object[]>();
        return new ShareNetResultSet(new Column[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14}, rowData);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        Column c1 = new Column.Builder().name("TYPE_NAME").sqlType(12).length(10).label("SQL Type Name").build();
        Column c2 = new Column.Builder().name("DATA_TYPE").sqlType(5).label("SQL Type").build();
        Column c3 = new Column.Builder().name("PRECISION").sqlType(4).label("Precision").build();
        Column c4 = new Column.Builder().name("LITERAL_PREFIX").sqlType(12).length(1).label("Prefix").build();
        Column c5 = new Column.Builder().name("LITERAL_SUFFIX").sqlType(12).length(1).label("Suffix").build();
        Column c6 = new Column.Builder().name("CREATE_PARAMS").sqlType(12).length(1).label("Parameters").build();
        Column c7 = new Column.Builder().name("NULLABLE").sqlType(5).label("Nullable").build();
        Column c8 = new Column.Builder().name("CASE_SENSITIVE").sqlType(16).label("Case Sensitive").build();
        Column c9 = new Column.Builder().name("SEARCHABLE").sqlType(5).label("Where").build();
        Column c10 = new Column.Builder().name("UNSIGNED_ATTRIBUTE").sqlType(16).label("Unsigned").build();
        Column c11 = new Column.Builder().name("FIXED_PREC_SCALE").sqlType(16).label("Money").build();
        Column c12 = new Column.Builder().name("AUTO_INCREMENT").sqlType(16).label("Auto-increment").build();
        Column c13 = new Column.Builder().name("LOCAL_TYPE_NAME").sqlType(12).length(5).label("Local Version Name").build();
        Column c14 = new Column.Builder().name("MINIMUM_SCALE").sqlType(5).label("Minimum Scale").formatName("").build();
        Column c15 = new Column.Builder().name("MAXIMUM_SCALE").sqlType(5).label("Maximum Scale").build();
        Column c16 = new Column.Builder().name("SQL_DATA_TYPE").sqlType(4).label("Data Type").build();
        Column c17 = new Column.Builder().name("SQL_DATETIME_SUB").sqlType(4).label("DateTime").build();
        Column c18 = new Column.Builder().name("NUM_PREC_RADIX").sqlType(4).label("Radix").build();
        ArrayList<Object[]> rowData = new ArrayList<Object[]>(8);
        rowData.add(new Object[]{"CHAR", 1, Short.MAX_VALUE, "", "", "", 0, true, 3, true, false, false, "", 0, 0, 0, 0, 10});
        rowData.add(new Object[]{"INTEGER", 4, 10, "", "", "", 1, false, 3, false, false, false, "", 0, 0, 0, 0, 10});
        rowData.add(new Object[]{"FLOAT", 6, 15, "", "", "", 1, false, 3, false, false, false, "", 0, 0, 0, 0, 10});
        rowData.add(new Object[]{"DOUBLE PRECISION", 8, 15, "", "", "", 1, false, 3, false, false, false, "", 0, 0, 0, 0, 10});
        rowData.add(new Object[]{"VARCHAR", 12, Short.MAX_VALUE, "", "", "", 0, true, 3, true, false, false, "", 0, 0, 0, 0, 10});
        rowData.add(new Object[]{"DATE", 91, 10, "", "", "", 1, false, 3, false, false, false, "", 0, 0, 0, 0, 10});
        rowData.add(new Object[]{"TIME", 92, 8, "", "", "", 1, false, 3, false, false, false, "", 0, 0, 0, 0, 10});
        rowData.add(new Object[]{"TIMESTAMP", 93, 21, "", "", "", 1, false, 3, false, false, false, "", 0, 0, 0, 0, 10});
        return new ShareNetResultSet(new Column[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18}, rowData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (this.connection.isClosed()) {
            this.vendorCode = 96;
            this.messageIndex = "Sharenet.S" + this.vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: No connection to server.", messageArg), null, this.vendorCode);
        }
        if (table == null || table.trim().length() == 0) {
            this.vendorCode = 313;
            this.messageIndex = "Sharenet.S" + this.vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Table name must be specified.", messageArg), null, this.vendorCode);
        }
        Column c1 = new Column.Builder().name("TABLE_CAT").sqlType(12).length(8).label("Catalog").build();
        Column c2 = new Column.Builder().name("TABLE_SCHEM").sqlType(12).length(8).label("Library Name").build();
        Column c3 = new Column.Builder().name("TABLE_NAME").sqlType(12).length(32).label("Member Name").build();
        Column c4 = new Column.Builder().name("NON_UNIQUE").sqlType(16).label("Non Unique").build();
        Column c5 = new Column.Builder().name("INDEX_QUALIFIER").sqlType(12).length(0).label("Index Qualifier").build();
        Column c6 = new Column.Builder().name("INDEX_NAME").sqlType(12).length(32).label("Index Name").build();
        Column c7 = new Column.Builder().name("TYPE").sqlType(5).label("Type").build();
        Column c8 = new Column.Builder().name("ORDINAL_POSITION").sqlType(5).label("Position of Column in Concatenated Key").build();
        Column c9 = new Column.Builder().name("COLUMN_NAME").sqlType(12).length(32).label("Column Name").build();
        Column c10 = new Column.Builder().name("ASC_OR_DESC").sqlType(12).length(1).label("Ascending or Descending").build();
        Column c11 = new Column.Builder().name("CARDINALITY").sqlType(4).label("Cardinality").build();
        Column c12 = new Column.Builder().name("PAGES").sqlType(4).label("Pages").build();
        Column c13 = new Column.Builder().name("FILTER_CONDITION").sqlType(12).length(0).label("Filter Condition").build();
        StringBuilder sql = new StringBuilder();
        if (this.sv < 41) {
            sql.append("select '' as catalog, libname as schema, memname as table, unique ne 'yes' as nonuniq, '' as qual, indxname as index, 1 as type, indxpos as pos, name, 'A' as seq, 0 as cardinal, 0 as pages, '' as filter from dictionary.indexes as indexes where ");
        } else {
            sql.append("select '' as TABLE_CAT, libname as TABLE_SCHEM, memname as TABLE_NAME, unique ne 'yes' as NON_UNIQUE, '' as INDEX_QUALIFIER,indxname as INDEX_NAME,1 as TYPE,indxpos as ORDINAL_POSITION, name as COLUMN_NAME, 'A' as ASC_OR_DESC, 0 as CARDINALITY, 0 as PAGES, '' as FILTER_CONDITION from dictionary.indexes as indexes where ");
        }
        sql.append(" memname = '" + table.toUpperCase() + "' ");
        if (schema != null && schema.length() != 0) {
            sql.append("and libname = '" + schema.toUpperCase() + "' ");
        }
        if (unique) {
            sql.append("and unique = 'yes' ");
        }
        if (this.sv < 41) {
            sql.append("ORDER BY nonuniq, type, index, pos ");
        } else {
            sql.append("ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION ");
        }
        try (Statement st = null;){
            ShareNetResultSet shareNetResultSet;
            block17: {
                st = this.connection.createStatement();
                ResultSet rs = null;
                try {
                    rs = st.executeQuery(sql.toString());
                    int ordinalPosition = 0;
                    ArrayList<Object[]> rowData = new ArrayList<Object[]>();
                    while (rs.next()) {
                        ordinalPosition = (int)rs.getDouble(this.sv < 41 ? "pos" : "ORDINAL_POSITION");
                        ordinalPosition = ordinalPosition / 8 + 1;
                        rowData.add(new Object[]{"", rs.getString(this.sv < 41 ? "schema" : "TABLE_SCHEM").trim(), rs.getString(this.sv < 41 ? "table" : "TABLE_NAME").trim(), rs.getBoolean(this.sv < 41 ? "nonuniq" : "NON_UNIQUE"), "", rs.getString(this.sv < 41 ? "index" : "INDEX_NAME").trim(), (short)1, ordinalPosition, rs.getString(this.sv < 41 ? "name" : "COLUMN_NAME").trim(), "A", 0, 0, null});
                    }
                    shareNetResultSet = new ShareNetResultSet(new Column[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13}, rowData);
                    if (rs == null) break block17;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        rs.close();
                    }
                    throw throwable;
                }
                rs.close();
            }
            return shareNetResultSet;
        }
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return type == 1003 && concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        String[] v = this.connection.version_msg.trim().split(Pattern.quote("."));
        if ("V".equals(v[0])) {
            return Integer.parseInt(v[1]);
        }
        return Integer.parseInt(v[0]);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        String[] v = this.connection.version_msg.trim().split(Pattern.quote("."));
        if ("V".equals(v[0])) {
            String minorVersion = v[2].substring(0, 2);
            return Integer.parseInt(minorVersion);
        }
        return Integer.parseInt(v[1]);
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public int getSQLStateType() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        Column c1 = new Column.Builder().name("NAME").sqlType(12).length(32).label("Name").build();
        Column c2 = new Column.Builder().name("MAX_LEN").sqlType(4).label("Maximum Length").build();
        Column c3 = new Column.Builder().name("DEFAULT_VALUE").sqlType(12).length(255).label("Default Value").build();
        Column c4 = new Column.Builder().name("DESCRIPTION").sqlType(12).length(255).label("Description").build();
        ArrayList<Object[]> rowData = new ArrayList<Object[]>(8);
        return new ShareNetResultSet(new Column[]{c1, c2, c3, c4}, rowData);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: unwrap operation failed; input parameter is null.", new Object[]{"Sharenet.S586.ex.txt"}), null, 586);
        }
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException(ShareLocalizedError.getLocalizedError("unwrap operation failed; class {1} does not implement {2}", new Object[]{"Sharenet.S587.ex.txt", iface.getName(), this.getClass().getName()}), null, 587);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    String getSQLTypeString(int type) {
        switch (type) {
            case 16: {
                return "BOOLEAN";
            }
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 0: {
                return "NULL";
            }
        }
        return "";
    }

    int sasNumericFormatToSqlType(String format) {
        int dataType;
        int subtype = Sqpformat.intepretFormat(format);
        switch (subtype) {
            case 4: {
                dataType = 8;
                break;
            }
            case 3: {
                dataType = 93;
                break;
            }
            case 1: {
                dataType = 91;
                break;
            }
            case 2: {
                dataType = 92;
                break;
            }
            default: {
                dataType = 8;
            }
        }
        return dataType;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (this.connection.isClosed()) {
            this.vendorCode = 82;
            this.messageIndex = "Sharenet.S" + this.vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: No connection to server.", messageArg), null, this.vendorCode);
        }
        Column c1 = new Column.Builder().name("TABLE_CAT").sqlType(12).length(8).label("Catalog").build();
        Column c2 = new Column.Builder().name("TABLE_SCHEM").sqlType(12).length(8).label("Library Name").build();
        Column c3 = new Column.Builder().name("TABLE_NAME").sqlType(12).length(32).label("Member Name").build();
        Column c4 = new Column.Builder().name("COLUMN_NAME").sqlType(12).length(32).label("Column Name").build();
        Column c5 = new Column.Builder().name("DATA_TYPE").sqlType(5).label("Data Type").build();
        Column c6 = new Column.Builder().name("DECIMAL_DIGITS").sqlType(4).label("Decimal Digits").build();
        Column c7 = new Column.Builder().name("NUM_PREC_RADIX").sqlType(4).label("Num Prec Radix").build();
        Column c8 = new Column.Builder().name("COLUMN_USAGE").sqlType(12).length(32).label("Column Usage").build();
        Column c9 = new Column.Builder().name("REMARKS").sqlType(12).length(256).label("Column Label").build();
        Column c10 = new Column.Builder().name("CHAR_OCTET_LENGTH").sqlType(4).label("Column Length").build();
        Column c11 = new Column.Builder().name("IS_NULLABLE").sqlType(12).length(3).label("Is Nullable").build();
        ArrayList<Object[]> rowData = new ArrayList<Object[]>(0);
        return new ShareNetResultSet(new Column[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11}, rowData);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }
}

