/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.codepolicy.SASScope;
import com.sas.net.sharenet.Crypt;
import com.sas.net.sharenet.ShareLocalizedError;
import com.sas.net.sharenet.ShareNetException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Properties;

@SASScope
public class HTTPConnection {
    ByteArrayInputStream input = null;
    ByteArrayOutputStream output = new ByteArrayOutputStream();
    OutputStream outstream = null;
    InputStream instream = null;
    Date date = new Date();
    String time = String.valueOf(this.date.getTime());
    URL url = null;
    String host = null;
    String port = null;
    String logdir = null;
    Properties info = null;
    byte[] buf = new byte[512];
    String handle = null;
    URLConnection urlconnect = null;
    boolean connection = false;
    String routerUrl = null;
    Crypt crypt = new Crypt();
    private String messageIndex;
    private boolean d = false;

    public HTTPConnection(InetAddress address, int port, Properties info) throws ShareNetException {
        this(address.toString(), port, info);
    }

    public HTTPConnection(String host, int port, Properties info) throws ShareNetException {
        this.host = host;
        this.port = String.valueOf(port);
        if (info == null) {
            this.messageIndex = "Sharenet.S14.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Missing router URL.", messageArg));
        }
        this.info = info;
        String temp = info.getProperty("debugTunneledConnectClient");
        if (temp != null && temp.length() > 0) {
            this.d = true;
        }
        this.logdir = info.getProperty("logdir");
        this.routerUrl = info.getProperty("routerUrl");
        if (this.routerUrl != null && this.routerUrl.length() != 0) {
            try {
                this.url = new URL(this.routerUrl);
            }
            catch (MalformedURLException ue) {
                this.messageIndex = "Sharenet.S15.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Malformed router URL.", messageArg));
            }
        } else {
            this.messageIndex = "Sharenet.S16.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Malformed router URL.", messageArg));
        }
        String prompt = info.getProperty("prompt1");
        if (prompt != null) {
            this.telnet();
        } else {
            this.open();
        }
    }

    public int getPort() throws ShareNetException {
        if (this.handle != null) {
            int tint;
            String[] tokenArr = this.handle.split("\\s");
            String temp = tokenArr[3];
            try {
                tint = Integer.parseInt(temp);
            }
            catch (NumberFormatException e) {
                this.messageIndex = "Sharenet.S17.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: No established connection.", messageArg));
            }
            return tint;
        }
        this.messageIndex = "Sharenet.S18.ex.txt";
        Object[] messageArg = new Object[]{this.messageIndex};
        throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: No established connection.", messageArg));
    }

    public String getShrHost() throws ShareNetException {
        return this.url.getHost();
    }

    public int getShrPort() throws ShareNetException {
        String temp = null;
        if (this.handle != null) {
            int tint;
            String[] tokenArr = this.handle.split("\\s");
            temp = tokenArr[1];
            try {
                tint = Integer.parseInt(temp);
            }
            catch (NumberFormatException e) {
                this.messageIndex = "Sharenet.S19.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: No established connection.", messageArg));
            }
            return tint;
        }
        this.messageIndex = "Sharenet.S20.ex.txt";
        Object[] messageArg = new Object[]{this.messageIndex};
        throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: No established connection.", messageArg));
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    public InputStream getInputStream() {
        return this.input;
    }

    void telnet() throws ShareNetException {
        byte[] intemp;
        int l;
        int count = 0;
        String userName = null;
        String password = null;
        String temp = null;
        String userNameResponse = (String)this.info.get("userNameResponse");
        String passwordResponse = (String)this.info.get("passwordResponse");
        String response = null;
        int cryptlen = 0;
        for (int j = 1; j < 6 && (temp = (String)this.info.get("prompt" + j)) != null; ++j) {
            count += 4;
        }
        temp = (String)this.info.get("sasPortTag");
        if (temp != null) {
            count += 2;
        }
        int i = 6;
        if (this.logdir != null) {
            i = 8;
        }
        String[] fields = new String[count + i];
        fields[0] = "MSGTYPE";
        fields[1] = "T";
        fields[2] = "HOST";
        fields[3] = this.host;
        fields[4] = "PORT";
        fields[5] = this.port;
        if (this.logdir != null) {
            fields[6] = "LOG";
            StringBuffer tempBuffer = new StringBuffer(this.logdir);
            fields[7] = tempBuffer.append("c").append(this.time).append(".log").toString();
        }
        for (int j = 1; j < 6 && (temp = (String)this.info.get("prompt" + j)) != null; ++j) {
            fields[i++] = "P" + j;
            fields[i++] = temp;
            response = "response" + j;
            temp = (String)this.info.get(response);
            if (temp == null) {
                temp = "";
            }
            fields[i++] = "R" + j;
            if (userNameResponse != null && userNameResponse.equals(response)) {
                userName = temp;
                fields[i++] = "$USERNAME";
                continue;
            }
            if (passwordResponse != null && passwordResponse.equals(response)) {
                password = temp;
                fields[i++] = "$PASSWORD";
                continue;
            }
            fields[i++] = temp;
        }
        if (userName != null && password != null) {
            byte[] cryptbuf = new byte[39];
            byte[] tbytes = HTTPConnection.charToByte8859_1(userName);
            cryptlen = this.crypt.zscode(tbytes, tbytes.length, cryptbuf, cryptlen);
            this.output.write(cryptlen);
            this.output.write(cryptbuf, 0, cryptlen);
            tbytes = HTTPConnection.charToByte8859_1(password);
            cryptlen = this.crypt.zscode(tbytes, tbytes.length, cryptbuf, cryptlen);
            this.output.write(cryptlen);
            this.output.write(cryptbuf, 0, cryptlen);
        }
        if ((temp = (String)this.info.get("sasPortTag")) != null) {
            fields[i++] = "PORT_PROMPT";
            fields[i++] = temp;
        }
        this.transmit(fields);
        if (this.input != null && this.input.available() != 0) {
            l = this.input.available();
            intemp = new byte[l];
            for (int x = 0; x < l; x += this.input.read(intemp, x, l - x)) {
            }
        } else {
            this.messageIndex = "Sharenet.S21.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Could not establish requested connection.", messageArg));
        }
        this.handle = HTTPConnection.byteToChar8859_1(intemp, 0, l);
        this.connection = true;
    }

    void open() throws ShareNetException {
        byte[] temp;
        int l;
        int i = this.logdir == null ? 6 : 8;
        String[] fields = new String[i];
        fields[0] = "MSGTYPE";
        fields[1] = "O";
        fields[2] = "HOST";
        fields[3] = this.host;
        fields[4] = "PORT";
        fields[5] = this.port;
        if (this.logdir != null) {
            fields[6] = "LOG";
            fields[7] = this.logdir + "c" + this.time + ".log";
        }
        this.transmit(fields);
        if (this.input != null && this.input.available() != 0) {
            l = this.input.available();
            temp = new byte[l];
            for (int x = 0; x < l; x += this.input.read(temp, x, l - x)) {
            }
        } else {
            this.messageIndex = "Sharenet.S22.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Could not establish requested connection.", messageArg));
        }
        this.handle = HTTPConnection.byteToChar8859_1(temp, 0, l);
        this.connection = true;
    }

    public InputStream sendInit() throws ShareNetException {
        this.commonSend("I");
        return this.input;
    }

    public InputStream sendEncrypt() throws ShareNetException {
        this.commonSend("E");
        return this.input;
    }

    public InputStream sendEndInit() throws ShareNetException {
        this.commonSend("J");
        return this.input;
    }

    public InputStream send() throws ShareNetException {
        this.commonSend("M");
        return this.input;
    }

    void close() throws ShareNetException {
        this.commonSend("D");
    }

    void commonSend(String command) throws ShareNetException {
        if (!this.connection) {
            this.messageIndex = "Sharenet.S26.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: No connection to server.", messageArg));
        }
        int i = 4;
        if (this.logdir != null) {
            i = 6;
        }
        String[] fields = new String[i];
        fields[0] = "MSGTYPE";
        fields[1] = command;
        fields[2] = "HANDLE";
        fields[3] = this.handle;
        if (this.logdir != null) {
            fields[4] = "LOG";
            fields[5] = this.logdir + "c" + this.time + ".log";
        }
        this.transmit(fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmit(String[] fields) throws ShareNetException {
        int count = 0;
        StringBuffer temp = new StringBuffer(this.url.toString());
        if (fields != null && fields.length != 0) {
            temp.append("?");
            for (int i = 0; i < fields.length; ++i) {
                if (i != 0) {
                    temp.append("&");
                }
                temp.append(fields[i++]).append("=").append(URLEncoder.encode(fields[i]));
            }
        }
        if (this.d) {
            System.out.println("URL: " + temp.toString());
        }
        URL tempurl = null;
        try {
            tempurl = new URL(temp.toString());
        }
        catch (MalformedURLException e) {
            this.connection = false;
            this.messageIndex = "Sharenet.S33.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Connection to SAS server broken. Invalid router URL.", messageArg));
        }
        try {
            this.urlconnect = tempurl.openConnection();
            this.urlconnect.setUseCaches(false);
            this.urlconnect.setDoInput(true);
            if (this.output.size() != 0) {
                count = this.output.size();
                if (this.d) {
                    System.out.println("Sending " + count + " bytes");
                }
                this.urlconnect.setDoOutput(true);
                this.urlconnect.setRequestProperty("Content-type", "application/octet-stream");
                this.outstream = this.urlconnect.getOutputStream();
                try {
                    this.output.writeTo(this.outstream);
                    this.outstream.flush();
                    this.output.reset();
                }
                finally {
                    this.outstream.close();
                }
            }
            this.instream = this.urlconnect.getInputStream();
            String type = null;
            try {
                type = this.urlconnect.getContentType();
                if (type == null) {
                    int i = 0;
                    while ((type = this.urlconnect.getHeaderFieldKey(i++)) != null && !type.toUpperCase().equals("CONTENT-TYPE")) {
                    }
                    if (type == null) {
                        this.connection = false;
                        this.messageIndex = "Sharenet.!!!.ex.txt";
                        Object[] messageArg = new Object[]{this.messageIndex};
                        throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Cannot determine content type of message from server.", messageArg));
                    }
                    type = this.urlconnect.getHeaderField(type);
                }
                type = type.toUpperCase();
                if (this.d) {
                    System.out.println("Received content type " + type);
                }
                if ((count = this.urlconnect.getContentLength()) < 0 && (count = this.instream.available()) < 0) {
                    count = 0;
                }
                if (this.d) {
                    System.out.println("Received content length " + count);
                }
                if (count > 0) {
                    if (count > this.buf.length) {
                        this.buf = new byte[count];
                    }
                    for (int x = 0; x < count; x += this.instream.read(this.buf, x, count - x)) {
                    }
                }
            }
            finally {
                this.instream.close();
            }
            if (type.indexOf("TEXT/HTML") != -1) {
                this.connection = false;
                if (count > 0) {
                    type = HTTPConnection.byteToChar8859_1(this.buf, 0, count);
                    if ((count = type.indexOf("<H1>")) != -1) {
                        type = type.substring(count + 4);
                    }
                    if ((count = type.indexOf("</H1>")) != -1) {
                        type = type.substring(0, count);
                    }
                    while ((count = type.indexOf("JTunnel")) != -1) {
                        type = type.substring(0, count) + type.substring(count + 1);
                    }
                    if (this.d) {
                        System.out.println("Error message: " + type);
                    }
                    this.messageIndex = "Sharenet.S27.ex.txt";
                    Object[] messageArg = new Object[]{this.messageIndex, type};
                    throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: No connection to server. {1}", messageArg));
                }
                this.messageIndex = "Sharenet.S29.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Connection to SAS server broken. Please check Tunnel log.", messageArg));
            }
            if (count == 0) {
                this.connection = false;
                this.messageIndex = "Sharenet.S31.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Connection to SAS server broken. No response from Web server.", messageArg));
            }
            this.input = new ByteArrayInputStream(this.buf, 0, count);
            this.urlconnect = null;
        }
        catch (IOException ie) {
            this.connection = false;
            this.messageIndex = "Sharenet.S34.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, ie.getMessage()};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Connection to SAS server broken. IO exception: {1}.", messageArg));
        }
    }

    private static byte[] charToByte8859_1(String s) {
        int len = s.length();
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            b[i] = (byte)s.charAt(i);
        }
        return b;
    }

    private static String byteToChar8859_1(byte[] b, int o, int l) {
        char[] c = new char[l];
        int i = 0;
        int x = o;
        while (i < l) {
            byte t = b[x];
            c[i++] = t >= 0 ? (char)t : (char)(t + 256);
            ++x;
        }
        return new String(c, 0, l);
    }
}

