/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.connect;

import com.sas.net.connect.ConnectClient;
import com.sas.net.connect.ConnectException;
import com.sas.net.connect.ConnectLocalizedError;
import com.sas.net.sharenet.HTTPConnection;
import com.sas.net.sharenet.ShareNetException;
import com.sas.net.sharenet.Wqecon;
import java.util.Properties;

public class TunneledConnectClient
extends ConnectClient {
    private String messageIndex;

    public TunneledConnectClient(Properties info) throws ConnectException {
        super(info);
        if (info == null) {
            this.messageIndex = "Connect.C107.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Missing Properties object.", messageArg));
        }
        String temp = (String)info.get("sasPortTag");
        if (temp == null) {
            info.put("sasPortTag", "PORT=");
        }
    }

    @Override
    public synchronized void connect(String host, int port) throws ConnectException {
        try {
            HTTPConnection httpcon = new HTTPConnection(host, port, this.info);
            this.con = new Wqecon(this.info, httpcon);
            super.connect(host, port);
        }
        catch (ShareNetException se) {
            String m = se.getMessage();
            int i = m.indexOf("ShareNet Exception:");
            if (i != -1) {
                m = m.substring(i + 19);
            }
            if (m != null) {
                this.messageIndex = "Connect.C108.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex, m};
                throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: {1}", messageArg));
            }
            this.messageIndex = "Connect.C109.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Could not connect to SAS server. Unknown error occured.", messageArg));
        }
    }

    public synchronized void connect(String host) throws ConnectException {
        this.connect(host, 23);
    }
}

