/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.connect;

import com.sas.codepolicy.SASScope;
import com.sas.io.Encoder;
import com.sas.io.EncoderInterface;
import com.sas.net.connect.ConnectClient;
import com.sas.net.connect.ConnectException;
import com.sas.net.connect.ConnectLocalizedError;
import com.sas.net.connect.ConnectRecord;
import java.io.UnsupportedEncodingException;

@SASScope
public class LoglnRecord
extends ConnectRecord {
    public LoglnRecord(ConnectClient client) throws ConnectException {
        super(client);
        this.maxlen = 257;
    }

    @Override
    public synchronized void action() throws ConnectException {
        super.action();
        String printLine = null;
        char lineType = '\u0000';
        EncoderInterface encoder = null;
        try {
            encoder = Encoder.getInstance((String)this.client.getTextTransportFormat());
            String tempLine = encoder.toString(this.buf, 0, this.final_len);
            int len = tempLine.length();
            if (len > 1) {
                lineType = tempLine.charAt(0);
                printLine = tempLine.substring(1);
            } else {
                printLine = "";
                lineType = len > 0 ? (char)tempLine.charAt(0) : (char)'D';
            }
        }
        catch (UnsupportedEncodingException e) {
            String index = "Connect.C117.ex.txt";
            Object[] messageArg = new Object[]{index, this.client.getTextTransportFormat()};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Unsupported character encoding: {1}", messageArg));
        }
        finally {
            if (encoder != null) {
                Encoder.returnInstance((EncoderInterface)encoder);
            }
        }
        if (this.client.getMver() < 45) {
            lineType = Character.toUpperCase(lineType);
        }
        Integer typeCode = null;
        switch (lineType) {
            default: {
                typeCode = ConnectClient.LINE_TYPE_NORMAL;
                break;
            }
            case 'H': {
                typeCode = ConnectClient.LINE_TYPE_HILIGHTED;
                break;
            }
            case 'S': {
                typeCode = ConnectClient.LINE_TYPE_SOURCE;
                break;
            }
            case 'T': {
                typeCode = ConnectClient.LINE_TYPE_TITLE;
                break;
            }
            case 'B': {
                typeCode = ConnectClient.LINE_TYPE_BYLINE;
                break;
            }
            case 'F': {
                typeCode = ConnectClient.LINE_TYPE_FOOTNOTE;
                break;
            }
            case 'E': {
                typeCode = ConnectClient.LINE_TYPE_ERROR;
                if (this.rec_code != 2 || !this.client.logException) break;
                if (this.client.exceptionLogLines == null) {
                    this.client.exceptionLogLines = new StringBuffer(printLine);
                    break;
                }
                if (this.client.exceptionLogLines.length() != 0) {
                    this.client.exceptionLogLines.append(" ");
                }
                this.client.exceptionLogLines.append(printLine);
                break;
            }
            case 'W': {
                typeCode = ConnectClient.LINE_TYPE_WARNING;
                break;
            }
            case ' ': 
            case 'N': {
                typeCode = ConnectClient.LINE_TYPE_NOTE;
                break;
            }
            case 'M': {
                typeCode = ConnectClient.LINE_TYPE_MESSAGE;
            }
        }
        if (this.rec_code == 2) {
            this.client.logLines.addElement(printLine);
            this.client.logLineTypes.addElement(typeCode);
        } else {
            this.client.listLines.addElement(printLine);
            this.client.listLineTypes.addElement(typeCode);
        }
    }
}

