/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.connect;

import com.sas.codepolicy.SASScope;
import com.sas.io.Encoder;
import com.sas.io.EncoderInterface;
import com.sas.net.connect.BadRecord;
import com.sas.net.connect.Cbuf;
import com.sas.net.connect.ConnectClientExtensionInterface;
import com.sas.net.connect.ConnectException;
import com.sas.net.connect.ConnectLocalizedError;
import com.sas.net.connect.ConnectLogException;
import com.sas.net.connect.ConnectRecord;
import com.sas.net.connect.DdefRecord;
import com.sas.net.connect.DownloadFile;
import com.sas.net.connect.EditResponseRecord;
import com.sas.net.connect.EndRsubmitRecord;
import com.sas.net.connect.FdataRecord;
import com.sas.net.connect.FeofRecord;
import com.sas.net.connect.FopenRecord;
import com.sas.net.connect.LoglnRecord;
import com.sas.net.connect.Lsgcb;
import com.sas.net.connect.NullRecord;
import com.sas.net.connect.NullResponseRecord;
import com.sas.net.connect.RqddefRecord;
import com.sas.net.connect.RqedRecord;
import com.sas.net.connect.Sendbuffer;
import com.sas.net.connect.ServRecord;
import com.sas.net.connect.ShareNetRecord;
import com.sas.net.connect.ShutDownRecord;
import com.sas.net.connect.ShutdownResponseRecord;
import com.sas.net.connect.SjrnumRecord;
import com.sas.net.connect.SysrputRecord;
import com.sas.net.connect.VersionRecord;
import com.sas.net.crypto.CipherInterface;
import com.sas.net.sharenet.ShareNetConnection;
import com.sas.net.sharenet.ShareNetException;
import com.sas.net.sharenet.Tcpmsg;
import com.sas.net.sharenet.Wqecon;
import com.sas.net.sharenet.Wqefcb;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

@SASScope(value="ALL")
public class ConnectClient {
    public static final Integer LINE_TYPE_NORMAL = new Integer(0);
    public static final Integer LINE_TYPE_HILIGHTED = new Integer(1);
    public static final Integer LINE_TYPE_SOURCE = new Integer(2);
    public static final Integer LINE_TYPE_TITLE = new Integer(3);
    public static final Integer LINE_TYPE_BYLINE = new Integer(4);
    public static final Integer LINE_TYPE_FOOTNOTE = new Integer(5);
    public static final Integer LINE_TYPE_ERROR = new Integer(6);
    public static final Integer LINE_TYPE_WARNING = new Integer(7);
    public static final Integer LINE_TYPE_NOTE = new Integer(8);
    public static final Integer LINE_TYPE_MESSAGE = new Integer(9);
    private static final String driverName = "SAS/CONNECT Driver for Java, Version 9.4 Production";
    static final int HDRLEN = 4;
    static final short XHR_UMTCASE_S_PREP = 287;
    static final short XHR_UMTCASE_S_DESC = 288;
    static final short XHR_UMTCASE_S_FTCH = 289;
    static final short XHR_UMTCASE_S_DSTR = 290;
    static final short XHR_UMTCASE_S_EXEC = 291;
    Properties info = null;
    Wqecon con = null;
    private String userpass = new String("");
    protected Wqefcb clientFcb = null;
    protected boolean connected = false;
    short buffersize = (short)32;
    protected boolean abort = false;
    boolean spanrec = false;
    Vector<String> logLines = new Vector();
    Vector<Integer> logLineTypes = new Vector();
    Vector<String> listLines = new Vector();
    Vector<Integer> listLineTypes = new Vector();
    StringBuffer editLines = new StringBuffer();
    Connection sharenet = null;
    Tcpmsg msg = null;
    Hashtable<String, ConnectRecord> recordTable = new Hashtable();
    Sendbuffer sbuf = new Sendbuffer();
    Cbuf cbuf = new Cbuf();
    DownloadFile dnfile = null;
    Hashtable<String, DownloadFile> files = new Hashtable();
    int mver;
    int options = Integer.MIN_VALUE;
    boolean rcancel = false;
    boolean submitting = false;
    boolean logException = false;
    StringBuffer exceptionLogLines = null;
    Hashtable<String, ConnectClientExtensionInterface> extensions = new Hashtable();
    String host = null;
    int port = 0;
    private String messageIndex;
    private String textTransportFormat = null;
    private int debugLevel = 0;

    public ConnectClient() {
        this.con = new Wqecon(this.info);
    }

    public ConnectClient(Properties info) {
        String connectClientDebugLevel;
        String compressionPolicy;
        this.info = info;
        this.con = new Wqecon(info);
        Boolean btemp = new Boolean(false);
        Object temp = info.get("logException");
        if (temp != null && !(temp instanceof Boolean)) {
            try {
                btemp = new Boolean((String)temp);
            }
            catch (Exception exception) {}
        } else if (temp != null && temp instanceof Boolean) {
            btemp = (Boolean)temp;
        }
        this.logException = btemp != false;
        String extClasses = info.getProperty("extensions");
        if (extClasses != null && extClasses.length() > 0) {
            StringTokenizer t = new StringTokenizer(extClasses, ",");
            while (t.hasMoreTokens()) {
                try {
                    this.addExtension(t.nextToken());
                }
                catch (ConnectException connectException) {}
            }
        }
        if ((compressionPolicy = info.getProperty("compressionPolicy")) != null && compressionPolicy.equals("none")) {
            this.options &= Integer.MAX_VALUE;
        }
        if ((connectClientDebugLevel = info.getProperty("connectClientDebugLevel")) != null && connectClientDebugLevel.length() > 0) {
            try {
                this.debugLevel = Integer.parseInt(connectClientDebugLevel);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.disconnect();
        }
        catch (ConnectException connectException) {
        }
        finally {
            super.finalize();
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getDriverName() {
        return driverName;
    }

    public int getMajorSasVersion() throws ConnectException {
        if (!this.isConnected()) {
            this.messageIndex = "Connect.C02.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: There is no live connection to a SAS server.", messageArg));
        }
        String serverVersion = this.con.getServerVersion();
        int dotIndex = serverVersion.indexOf(".");
        if (dotIndex >= 0) {
            serverVersion = serverVersion.substring(0, dotIndex);
        }
        try {
            return Integer.parseInt(serverVersion);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public int getMinorSasVersion() throws ConnectException {
        if (!this.isConnected()) {
            this.messageIndex = "Connect.C03.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: There is no live connection to a SAS server.", messageArg));
        }
        String serverVersion = this.con.getServerVersion();
        int dotIndex1 = serverVersion.indexOf(".");
        if (dotIndex1 >= 0 && dotIndex1 + 1 < serverVersion.length()) {
            int dotIndex2 = serverVersion.indexOf(".", dotIndex1 + 1);
            serverVersion = dotIndex2 >= 0 ? serverVersion.substring(dotIndex1 + 1, dotIndex2) : serverVersion.substring(dotIndex1 + 1);
        } else {
            return 0;
        }
        try {
            return Integer.parseInt(serverVersion);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void setLogException(boolean logException) {
        this.logException = logException;
        if (this.info == null) {
            this.info = new Properties();
        }
        this.info.put("logException", String.valueOf(logException));
    }

    public void connect(String host, int port) throws ConnectException {
        this.connectCommon(host, port, null, null);
    }

    protected void connect(Socket socket, CipherInterface cipher) throws ConnectException {
        this.connectCommon(null, 0, socket, cipher);
    }

    private synchronized void connectCommon(String host, int port, Socket socket, CipherInterface cipher) throws ConnectException {
        this.host = host;
        this.port = port;
        this.clientFcb = new Wqefcb(2);
        this.clientFcb.setMinfoRsvd(this.buffersize);
        this.clientFcb.acc = 1;
        this.con.userpass = this.userpass;
        Lsgcb msg1 = new Lsgcb();
        this.clientFcb.wmseg[0] = msg1;
        this.clientFcb.waseg[0] = this.cbuf;
        try {
            this.msg = socket == null ? this.con.open(host, port, this.clientFcb) : this.con.open(socket, cipher, this.clientFcb);
        }
        catch (ShareNetException se) {
            this.messageIndex = "Connect.C05.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, se.getMessage()};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
        if (this.clientFcb.acc != 0 && this.clientFcb.acc < 0) {
            this.messageIndex = "Connect.C06.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, String.valueOf(this.clientFcb.acc), new String(this.cbuf.buf, 0, this.cbuf.len)};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: {1} {2}", messageArg));
        }
        this.connected = true;
        this.textTransportFormat = this.con.getShareEncoding();
        this.getRecords();
        this.drain();
    }

    public synchronized Connection getSharenet() throws ConnectException {
        try {
            if (this.sharenet == null) {
                ShareNetRecord record = new ShareNetRecord(this);
                this.addRecords(record, true);
                this.drain();
                if (this.info == null) {
                    this.info = new Properties();
                }
                this.info.put("SingleUser", new String("true"));
                this.sharenet = new ShareNetConnection(this.host, this.port, this.info, this.con);
            }
        }
        catch (SQLException se) {
            this.messageIndex = "Connect.C07.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, se.getMessage()};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
        return this.sharenet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void rsubmit(String lines) throws ConnectException, ConnectLogException {
        this.addEditLine(lines);
        this.addEditLine("\n");
        StringTokenizer st = new StringTokenizer(lines, "\n", true);
        String token = null;
        String delim = " ;+-:#?\\({[)}]";
        String blank = " ";
        boolean eoln = false;
        boolean gotone = false;
        int tokenLen = 0;
        EncoderInterface encoder = null;
        if (this.exceptionLogLines != null) {
            this.exceptionLogLines.setLength(0);
        }
        try {
            encoder = Encoder.getInstance((String)this.textTransportFormat);
        }
        catch (UnsupportedEncodingException e) {
            this.messageIndex = "Connect.C116.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, this.textTransportFormat};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Unsupported character encoding: {1}", messageArg));
        }
        try {
            while (st.hasMoreTokens()) {
                int index;
                block17: {
                    gotone = true;
                    token = st.nextToken();
                    index = 0;
                    if (token.charAt(0) == '\n') {
                        if (!eoln) {
                            token = blank;
                            break block17;
                        } else {
                            eoln = false;
                            continue;
                        }
                    }
                    eoln = true;
                }
                do {
                    tokenLen = token.length() - index;
                    byte[] buffer = encoder.toByteArray(token, index, tokenLen);
                    while (buffer.length > 256) {
                        if (tokenLen > 256) {
                            tokenLen = 256;
                        }
                        while (tokenLen > 0 && delim.indexOf(token.charAt(index + tokenLen)) == -1) {
                            --tokenLen;
                        }
                        if (tokenLen == 0) {
                            this.messageIndex = "Connect.C08.ex.txt";
                            Object[] messageArg = new Object[]{this.messageIndex, token.substring(index, index + 64)};
                            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Source line longer than 256 bytes after transcoding and attempts to split it: {1}...", messageArg));
                        }
                        buffer = encoder.toByteArray(token, index, tokenLen);
                    }
                    EditResponseRecord edresponse = new EditResponseRecord(this);
                    edresponse.add(buffer);
                    this.addRecords(edresponse, true);
                } while ((index += tokenLen) < token.length());
            }
        }
        finally {
            Encoder.returnInstance((EncoderInterface)encoder);
        }
        if (gotone) {
            EndRsubmitRecord endresponse = new EndRsubmitRecord(this);
            this.addRecords(endresponse, true);
            this.submitting = true;
            this.drain();
            this.submitting = false;
        }
        if (this.exceptionLogLines != null && this.logException && this.exceptionLogLines.length() > 0) {
            this.messageIndex = "Connect.C09.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, this.exceptionLogLines.toString()};
            throw new ConnectLogException(ConnectLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
    }

    public void rcancel() {
        if (this.submitting) {
            this.rcancel = true;
        }
    }

    public synchronized void disconnect() throws ConnectException {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        ShutDownRecord shutDownRecord = new ShutDownRecord(this);
        this.addRecords(shutDownRecord, true);
        this.drain();
        this.clientFcb = new Wqefcb();
        try {
            this.con.wqeclos(this.msg);
        }
        catch (ShareNetException se) {
            this.messageIndex = "Connect.C10.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, se.getMessage()};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
    }

    public String getLogLines() {
        return ConnectClient.vectorToString(this.logLines);
    }

    public int getLogLines(String[] lines, Integer[] types) {
        return ConnectClient.getLinesFromVector(lines, types, this.logLines, this.logLineTypes);
    }

    public int getLogLineCount() {
        return this.logLines.size();
    }

    public void clearLogLines() {
        this.logLines.removeAllElements();
        this.logLineTypes.removeAllElements();
    }

    public String getListLines() {
        return ConnectClient.vectorToString(this.listLines);
    }

    public int getListLines(String[] lines, Integer[] types) {
        return ConnectClient.getLinesFromVector(lines, types, this.listLines, this.listLineTypes);
    }

    public int getListLineCount() {
        return this.listLines.size();
    }

    public void clearListLines() {
        this.listLines.removeAllElements();
        this.listLineTypes.removeAllElements();
    }

    private static String vectorToString(Vector<String> vector) {
        StringBuffer buffer = new StringBuffer();
        int size = vector.size();
        for (int i = 0; i < size; ++i) {
            buffer.append(vector.elementAt(i));
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private static int getLinesFromVector(String[] lines, Integer[] types, Vector<String> lineVector, Vector<Integer> typeVector) {
        if (lines == null || types == null) {
            return 0;
        }
        int size = Math.min(Math.min(lines.length, types.length), lineVector.size());
        for (int i = 0; i < size; ++i) {
            lines[i] = lineVector.elementAt(i);
            types[i] = typeVector.elementAt(i);
        }
        return size;
    }

    public String getEditLines() {
        return this.editLines.toString();
    }

    public void clearEditLines() {
        this.editLines.setLength(0);
    }

    public byte[] getDownloadData(String name) throws ConnectException {
        DownloadFile dntemp = this.files.get(name);
        if (dntemp == null) {
            this.messageIndex = "Connect.C11.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Requested file not found.", messageArg));
        }
        return dntemp.getData();
    }

    @SASScope
    public void addExtension(String name) throws ConnectException {
        this.addExtension(name, null);
    }

    public void addExtension(String name, ClassLoader cl) throws ConnectException {
        try {
            ConnectClientExtensionInterface testObject = this.extensions.get(name);
            if (testObject != null) {
                return;
            }
            Class<?> xClass = cl != null ? Class.forName(name, true, cl) : Class.forName(name);
            Object xObject = xClass.newInstance();
            if (!(xObject instanceof ConnectClientExtensionInterface)) {
                this.messageIndex = "Connect.C12.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex, name, "com.sas.net.connect.ConnectClientExtensionInterface"};
                throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Class {1} must implement {2}.", messageArg));
            }
            this.extensions.put(name, (ConnectClientExtensionInterface)xObject);
            ((ConnectClientExtensionInterface)xObject).setClient(this);
        }
        catch (ClassNotFoundException e1) {
            this.messageIndex = "Connect.C13.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, name};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Class {1} was not found.", messageArg));
        }
        catch (InstantiationException e2) {
            this.messageIndex = "Connect.C14.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, name};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Class {1} could not be instantiated.", messageArg));
        }
        catch (IllegalAccessException e3) {
            this.messageIndex = "Connect.C15.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, name};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Class {1} could not be accessed.", messageArg));
        }
    }

    @SASScope
    public Object getExtension(String name) throws ConnectException {
        ConnectClientExtensionInterface testObject = this.extensions.get(name);
        if (testObject == null) {
            this.messageIndex = "Connect.C16.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, name};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Extension {1} does not exist.", messageArg));
        }
        return testObject;
    }

    @SASScope
    public void removeExtension(String name) {
        this.extensions.remove(name);
    }

    public String getTextTransportFormat() {
        return this.textTransportFormat;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized boolean getRecords() throws ConnectException {
        ConnectRecord record = null;
        int rec_len = 0;
        int rec_code = 0;
        int rec_type = 0;
        int trcode = 0;
        while (true) {
            if (!this.abort && !this.rcancel && this.cbuf.b_use && this.cbuf.b_pos < this.cbuf.b_len) {
                try {
                    rec_len = this.cbuf.stream.readUnsignedShort();
                    rec_len -= 4;
                    short temp = this.cbuf.stream.readShort();
                    trcode = temp & 0xFFFF;
                    rec_code = temp & 0xFF;
                    rec_type = temp >> 14 & 3;
                }
                catch (IOException e) {
                    this.messageIndex = "Connect.C17.ex.txt";
                    Object[] messageArg = new Object[]{this.messageIndex, e.getMessage()};
                    throw new ConnectException(-1, ConnectLocalizedError.getLocalizedError("{0}: {1}", messageArg));
                }
                if (rec_len < 0 || rec_code < 0) {
                    this.messageIndex = "Connect.C18.ex.txt";
                    Object[] messageArg = new Object[]{this.messageIndex};
                    throw new ConnectException(-1, ConnectLocalizedError.getLocalizedError("{0}: Bad record received.", messageArg));
                }
                if (this.debugLevel > 0) {
                    System.out.println("Received record type 0x" + Integer.toHexString(rec_code));
                }
                record = null;
                Enumeration<ConnectClientExtensionInterface> items = this.extensions.elements();
                while (items.hasMoreElements() && record == null) {
                    ConnectClientExtensionInterface ext = items.nextElement();
                    record = ext.getRecords(rec_code);
                }
                if (record == null) {
                    switch (rec_code) {
                        case 0: {
                            record = this.recordTable.get("requestEditLines");
                            if (record != null) break;
                            record = new RqedRecord(this);
                            this.recordTable.put("requestEditLines", record);
                            break;
                        }
                        case 32: {
                            ConnectRecord frecord;
                            record = this.recordTable.get("fileOpen");
                            if (record == null) {
                                record = new FopenRecord(this);
                                this.recordTable.put("fileOpen", record);
                            }
                            if ((frecord = this.recordTable.get("fileData")) != null) break;
                            frecord = new FdataRecord(this);
                            this.recordTable.put("fileData", frecord);
                            break;
                        }
                        case 38: {
                            record = this.recordTable.get("fileData");
                            if (record == null) {
                                this.messageIndex = "Connect.C19.ex.txt";
                                Object[] messageArg = new Object[]{this.messageIndex};
                                throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: File download record received without a prior open file record.", messageArg));
                            }
                            ((FdataRecord)record).setMaxlen(this.dnfile.getLrecl());
                            break;
                        }
                        case 39: {
                            record = this.recordTable.get("fileEOF");
                            if (record != null) break;
                            record = new FeofRecord(this);
                            this.recordTable.put("fileEOF", record);
                            break;
                        }
                        case 2: 
                        case 3: {
                            record = this.recordTable.get("responseLogLines");
                            if (record != null) break;
                            record = new LoglnRecord(this);
                            this.recordTable.put("responseLogLines", record);
                            break;
                        }
                        case 17: {
                            record = this.recordTable.get("responseVersion");
                            if (record != null) break;
                            record = new VersionRecord(this);
                            this.recordTable.put("responseVersion", record);
                            break;
                        }
                        case 21: {
                            record = this.recordTable.get("responseNullRecord");
                            if (record != null) break;
                            record = new NullRecord(this);
                            this.recordTable.put("responseNullRecord", record);
                            break;
                        }
                        case 22: {
                            record = this.recordTable.get("responseShutdown");
                            if (record != null) break;
                            record = new ShutdownResponseRecord(this);
                            this.recordTable.put("responseShutdown", record);
                            break;
                        }
                        case 68: {
                            record = this.recordTable.get("responseSingleUserServer");
                            if (record != null) break;
                            record = new ServRecord(this);
                            this.recordTable.put("responseSingleUserServer", record);
                            break;
                        }
                        case 5: {
                            record = this.recordTable.get("datasetDefinition");
                            if (record != null) break;
                            record = new DdefRecord(this);
                            this.recordTable.put("datasetDefinition", record);
                            break;
                        }
                        case 46: {
                            record = this.recordTable.get("sysrput");
                            if (record != null) break;
                            record = new SysrputRecord(this);
                            this.recordTable.put("sysrput", record);
                            break;
                        }
                        case 11: {
                            record = this.recordTable.get("rqddef");
                            if (record != null) break;
                            record = new RqddefRecord(this);
                            this.recordTable.put("rqddef", record);
                            break;
                        }
                        case 117: {
                            record = this.recordTable.get("sjrnum");
                            if (record != null) break;
                            record = new SjrnumRecord(this);
                            this.recordTable.put("sjrnum", record);
                            break;
                        }
                        default: {
                            rec_type = 0;
                            record = this.recordTable.get("bad");
                            if (record != null) break;
                            record = new BadRecord(this);
                            this.recordTable.put("bad", record);
                        }
                    }
                }
                this.cbuf.b_pos = this.cbuf.b_pos + rec_len + 4;
                if (rec_type != 0) {
                    if (rec_type == 1) {
                        record.empty(trcode);
                    }
                    record.add(this.cbuf.stream, rec_len);
                    if (rec_type != 3) {
                        this.spanrec = true;
                        return this.abort;
                    }
                    this.spanrec = false;
                } else {
                    record.empty(trcode);
                    record.add(this.cbuf.stream, rec_len);
                }
                if (rec_type != 0 && rec_type != 3) continue;
                record.action();
                continue;
            }
            this.cbuf.b_use = false;
            this.cbuf.b_len = 0;
            this.cbuf.b_pos = 0;
            if (!this.cbuf.b_use) break;
        }
        return this.abort;
    }

    protected synchronized void addRecords(ConnectRecord record, boolean must) throws ConnectException {
        ConnectRecord deferredRecord = this.recordTable.get("deferredRecord");
        if (deferredRecord != null) {
            this.recordTable.remove("deferredRecord");
            this.addRecords(deferredRecord, false);
        }
        byte[] inbuffer = record.getBuffer();
        int code = record.getReccode();
        if (this.debugLevel > 0) {
            System.out.println("Add a record: code=0x" + Integer.toHexString(code));
        }
        boolean compressed = false;
        boolean entirerec = false;
        boolean firsttime = true;
        byte[] out_buf = null;
        int left = 0;
        int type = 0;
        int offset = 0;
        if (inbuffer != null && (this.options & Integer.MIN_VALUE) != 0 && (out_buf = ConnectRecord.compress(inbuffer)) != null) {
            compressed = true;
            inbuffer = out_buf;
        }
        int tlen = 0;
        if (inbuffer != null) {
            tlen = inbuffer.length;
        }
        while (!entirerec) {
            left = this.sbuf.out_len - this.sbuf.out_used;
            if ((left -= 4) >= tlen) {
                type = firsttime ? 0 : 3;
                try {
                    this.sbuf.OutRec(code, inbuffer, tlen, offset, type, compressed);
                }
                catch (ShareNetException se) {
                    this.messageIndex = "Connect.C20.ex.txt";
                    Object[] messageArg = new Object[]{this.messageIndex, se.getMessage()};
                    throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: {1}", messageArg));
                }
                entirerec = true;
                continue;
            }
            if (left >= 0) {
                type = firsttime ? 1 : 2;
                try {
                    this.sbuf.OutRec(code, inbuffer, left, offset, type, compressed);
                }
                catch (ShareNetException se) {
                    this.messageIndex = "Connect.C21.ex.txt";
                    Object[] messageArg = new Object[]{this.messageIndex, se.getMessage()};
                    throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: {1}", messageArg));
                }
                offset += left;
                tlen -= left;
                firsttime = false;
            }
            this.flush();
            if (code != 1 && code != 45) continue;
            this.submitting = true;
            this.drain();
            this.submitting = false;
        }
    }

    protected synchronized boolean drain() throws ConnectException {
        while (!this.abort && (this.sbuf.out_used > 0 || this.cbuf.in_full || this.rcancel)) {
            this.flush();
        }
        return this.abort;
    }

    protected synchronized boolean flush() throws ConnectException {
        ConnectRecord response = null;
        if (this.rcancel) {
            this.sbuf.reset();
            response = new ShutDownRecord(this, 999);
            this.rcancel = false;
            this.addRecords(response, true);
        }
        if (this.sbuf.out_used == 0) {
            response = new NullResponseRecord(this);
            this.addRecords(response, true);
            try {
                Wqefcb drainFcb = new Wqefcb(2);
                drainFcb.wmseg[0] = this.sbuf;
                drainFcb.acc = 0;
                this.send(drainFcb);
                if (!this.abort) {
                    this.getRecords();
                }
            }
            catch (Exception drainFcb) {}
        } else {
            Wqefcb drainFcb = new Wqefcb(2);
            drainFcb.wmseg[0] = this.sbuf;
            drainFcb.acc = 0;
            if (this.debugLevel > 0) {
                System.out.println("Sending sendbuffer record");
            }
            this.send(drainFcb);
            if (!this.abort || this.cbuf.in_full) {
                this.getRecords();
            }
        }
        return this.abort;
    }

    protected synchronized void send(Wqefcb fcb) throws ConnectException {
        fcb.waseg[0] = this.cbuf;
        fcb.utype = 0;
        fcb.acc = 0;
        try {
            this.con.wqesndm(fcb, this.msg);
        }
        catch (ShareNetException se) {
            this.messageIndex = "Connect.C22.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, se.getMessage()};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
    }

    protected void addEditLine(String editline) {
        this.editLines.append(editline);
    }

    protected synchronized void createDownload(String name, int lrecl, boolean text) throws ConnectException {
        if (this.dnfile != null) {
            this.messageIndex = "Connect.C23.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Parallel downloads not supported.", messageArg));
        }
        this.dnfile = new DownloadFile(name, lrecl, text);
    }

    protected synchronized void checkDownloadRecno(int recno) throws ConnectException {
        if (this.dnfile == null) {
            this.messageIndex = "Connect.C24.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: No download in progress.", messageArg));
        }
        this.dnfile.checkRecno(recno);
        this.files.put(this.dnfile.getName(), this.dnfile);
        this.dnfile = null;
    }

    protected void setMver(int masterVersion) {
        this.mver = masterVersion;
    }

    protected int getMver() {
        return this.mver;
    }

    protected void setTextTransportFormat(String s) {
        this.textTransportFormat = s;
    }

    protected void mergeOptions(int masterOptions) {
        this.options &= masterOptions;
        if (this.mver >= 45) {
            try {
                this.getExtension("com.sas.net.connect.privapp.PrivilegedApplicationExtension");
                this.options |= 0x10000000;
            }
            catch (ConnectException e) {
                this.options |= 0x20000000;
            }
        } else {
            this.options |= 0x20000000;
        }
    }

    protected boolean checkOptions(int optionFlag) {
        return (optionFlag & this.options) != 0;
    }

    protected int getOptions() {
        return this.options;
    }
}

