/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web.session;

import com.sas.vfabrictcsvr.session.SessionFixationSupport;
import java.lang.reflect.Field;
import java.util.Map;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;

public class SessionFixationProtectionStrategy
extends org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy {
    private static final Logger logger = LogManager.getLogger(SessionFixationProtectionStrategy.class);
    private boolean migrateSessionAttributes = true;
    private boolean alwaysCreateSession;
    private boolean sharedSessionCookies;
    private static final String SLEEP_MILLIS_PROP_NAME = "sas.web.session.fixation.sleepMillis";
    private long sleepMillis = Long.parseLong(System.getProperty("sas.web.session.fixation.sleepMillis", "100"));

    public void onAuthentication(Authentication authentication, HttpServletRequest request, HttpServletResponse response) {
        boolean hadSessionAlready;
        boolean bl = hadSessionAlready = request.getSession(false) != null;
        if (!hadSessionAlready && !this.alwaysCreateSession) {
            return;
        }
        SessionFixationSupport sessionFixationSupport = null;
        if (this.sharedSessionCookies) {
            sessionFixationSupport = SessionFixationSupport.getInstance();
        }
        HttpSession session = request.getSession();
        String originalSessionId = session.getId();
        if (hadSessionAlready && request.isRequestedSessionIdValid()) {
            if (this.sharedSessionCookies) {
                String name = sessionFixationSupport.getAuthenticatedName(session);
                if (name != null) {
                    if (!name.equals(authentication.getName())) {
                        String errorMsg = "Possible CSRF attack detected; session " + originalSessionId + " is already authenticated for user " + name;
                        logger.warn(errorMsg);
                        throw new SessionAuthenticationException(errorMsg);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Existing session not changed because session is already authenticated in another web app");
                    }
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Session " + originalSessionId + " is not authenticated in any other web apps");
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Invalidating session with Id '" + originalSessionId + "' " + (this.migrateSessionAttributes ? "and" : "without") + " migrating attributes.");
            }
            try {
                Map attributesToMigrate = this.extractAttributes(session);
                session.invalidate();
                if (this.sleepMillis > 0L) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Sleeping " + this.sleepMillis + " milliseconds");
                    }
                    try {
                        Thread.sleep(this.sleepMillis);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.sharedSessionCookies) {
                    this.clearRequestedSessionId(request);
                }
                session = request.getSession(true);
                if (this.sharedSessionCookies) {
                    sessionFixationSupport.registerAuthenticatedHttpSession(session, authentication.getName());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Started new session: " + session.getId());
                }
                if (originalSessionId.equals(session.getId())) {
                    logger.warn("Your servlet container did not change the session ID when a new session was created. You will not be adequately protected against session-fixation attacks");
                }
                this.transferAttributes(attributesToMigrate, session);
                this.onSessionChange(originalSessionId, session, authentication);
            }
            catch (IllegalStateException e) {
                if (e.getMessage().matches("Session .* has already been invalidated")) {
                    logger.warn(e.getMessage());
                }
                throw e;
            }
        }
    }

    private void transferAttributes(Map<String, Object> attributes, HttpSession newSession) {
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                newSession.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setMigrateSessionAttributes(boolean migrateSessionAttributes) {
        this.migrateSessionAttributes = migrateSessionAttributes;
    }

    public void setAlwaysCreateSession(boolean alwaysCreateSession) {
        this.alwaysCreateSession = alwaysCreateSession;
    }

    public void setSharedSessionCookies(boolean sharedSessionCookies) {
        this.sharedSessionCookies = sharedSessionCookies;
    }

    private void clearRequestedSessionId(HttpServletRequest request) {
        HttpServletRequest req = this.getWrappedRequest(request);
        if (req instanceof Request) {
            try {
                logger.debug("Clearing the requestedSessionId from the wrapped request");
                Field field = Request.class.getDeclaredField("requestedSessionId");
                field.setAccessible(true);
                field.set(req, null);
            }
            catch (Exception e) {
                logger.debug("Exception clearing the requestedSessionId from " + req.getClass().getName() + ": " + e.getMessage());
            }
        }
    }

    private HttpServletRequest getWrappedRequest(HttpServletRequest request) {
        try {
            if (request instanceof ServletRequestWrapper) {
                Field field = ServletRequestWrapper.class.getDeclaredField("request");
                field.setAccessible(true);
                HttpServletRequest req = (HttpServletRequest)field.get(request);
                logger.debug("Unwrapped: " + req.getClass().getName());
                return this.getWrappedRequest(req);
            }
            if (request instanceof RequestFacade) {
                Field field = RequestFacade.class.getDeclaredField("request");
                field.setAccessible(true);
                HttpServletRequest req = (HttpServletRequest)field.get(request);
                logger.debug("Unwrapped: " + req.getClass().getName());
                return this.getWrappedRequest(req);
            }
        }
        catch (Exception e) {
            logger.debug("Exception unwrapping request from " + request.getClass().getName() + ": " + e.getMessage());
        }
        return request;
    }
}

