/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web.filters;

import com.sas.framework.commons.holders.SessionHolder;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class SessionIdentifierFilter
extends OncePerRequestFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        try {
            SecurityContext securityContext = SecurityContextHolder.getContext();
            Authentication authToken = securityContext.getAuthentication();
            if (authToken instanceof CasAuthenticationToken) {
                CasAuthenticationToken casToken = (CasAuthenticationToken)authToken;
                String value = (String)casToken.getAssertion().getPrincipal().getAttributes().get("SAS_SESSION_IDENTIFIER");
                SessionHolder.set((String)value);
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            SessionHolder.clear();
        }
    }
}

