/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web;

import com.sas.svcs.security.authentication.web.LogonHandler;
import com.sas.util.SasPasswordString;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class RequestParameterLogonHandler
extends LogonHandler {
    String useridField;
    String passwordField;

    public void setUseridField(String useridField) {
        this.useridField = useridField;
    }

    public void setPasswordField(String passwordField) {
        this.passwordField = passwordField;
    }

    @Override
    public String getUserid(HttpServletRequest request) {
        return request.getParameter(this.useridField);
    }

    @Override
    public String getPassword(HttpServletRequest request) {
        String password = request.getParameter(this.passwordField);
        if (null != password) {
            password = this.passwordValueAllowed(password) ? null : password;
        }
        return password;
    }

    private boolean passwordValueAllowed(String password) {
        boolean allowEncodedPassword;
        Properties settings = this.configService.getSettings(this.applicationName);
        String property = settings.getProperty("App.AllowEncodedPassword");
        if (null == property) {
            property = settings.getProperty("AllowEncodedPassword");
        }
        return !(allowEncodedPassword = Boolean.parseBoolean(property)) && SasPasswordString.isEncoded((String)password);
    }

    @Override
    public String[] getEnablementPropertyNames() {
        return new String[]{"App.AcceptDirectCredentials"};
    }
}

