/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web;

import com.sas.svcs.security.authentication.web.AuthenticationFailureHandler;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class NoninteractiveAuthenticationEntryPoint
implements AuthenticationEntryPoint,
InitializingBean {
    private static final Logger LOGGER = LogManager.getLogger(NoninteractiveAuthenticationEntryPoint.class);
    private List<String> _htmlTypeLst;

    public void setHtmlTypes(List<String> htmlTypes) {
        this._htmlTypeLst = htmlTypes;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        String msg = authException != null ? authException.getMessage() : null;
        AuthenticationFailureHandler.handleFailure(request, response, authException);
        if (this.acceptsHtml(request)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Client accepts HTML. Sending 401 response with HTML document including message " + msg);
            }
            response.sendError(401, msg);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Client does not accept HTML. Sending 401 response with plain text message " + msg);
            }
            response.resetBuffer();
            response.setStatus(401);
            if (msg != null) {
                response.setHeader("Content-Type", "text/plain");
                int contentLength = NoninteractiveAuthenticationEntryPoint.calculateContentLength(response, msg);
                response.setHeader("Content-Length", Integer.toString(contentLength));
                response.getOutputStream().print(msg);
            }
            response.flushBuffer();
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notEmpty(this._htmlTypeLst, (String)"html-types must not be empty");
    }

    private boolean acceptsHtml(HttpServletRequest request) {
        Enumeration acceptedContentTypesEnm = request.getHeaders("Accept");
        if (acceptedContentTypesEnm == null) {
            return false;
        }
        while (acceptedContentTypesEnm.hasMoreElements()) {
            String[] acceptedContentTypeArr;
            String acceptedContentTypes = (String)acceptedContentTypesEnm.nextElement();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("comparing Accept header " + acceptedContentTypes + " against list of HTML types " + this._htmlTypeLst);
            }
            for (String acceptedContentType : acceptedContentTypeArr = StringUtils.tokenizeToStringArray((String)acceptedContentTypes, (String)",")) {
                if (!this._htmlTypeLst.contains(acceptedContentType)) continue;
                return true;
            }
        }
        return false;
    }

    private static int calculateContentLength(HttpServletResponse response, String msg) throws IOException {
        String enc = response.getCharacterEncoding();
        if (!StringUtils.hasText((String)enc)) {
            throw new IllegalStateException("Response character encoding must be set");
        }
        byte[] arr = msg.getBytes(enc);
        return arr.length;
    }
}

