/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web;

import com.sas.svcs.authentication.helper.TrustedUserFactory;
import com.sas.svcs.config.client.ConfigurationServiceInterface;
import com.sas.svcs.config.client.UrlGeneratorInterface;
import com.sas.svcs.security.authentication.client.AuthenticationClient;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;

public abstract class LogonHandler
implements ServletContextAware {
    private final Logger logger = LogManager.getLogger(this.getClass());
    UrlGeneratorInterface urlGenerator;
    ConfigurationServiceInterface configService;
    TrustedUserFactory trustedUserFactory;
    String service;
    AntPathRequestMatcher pathMatcher = new AntPathRequestMatcher("/**");
    String applicationName;

    public abstract String getUserid(HttpServletRequest var1);

    public abstract String getPassword(HttpServletRequest var1);

    public abstract String[] getEnablementPropertyNames();

    @Autowired
    public void setUrlGenerator(UrlGeneratorInterface urlGenerator) {
        this.urlGenerator = urlGenerator;
    }

    @Autowired
    public void setConfigurationService(ConfigurationServiceInterface configService) {
        this.configService = configService;
    }

    @Autowired(required=false)
    public void setTrustedUserFactory(TrustedUserFactory trustedUserFactory) {
        this.trustedUserFactory = trustedUserFactory;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setPath(String path) {
        this.pathMatcher = new AntPathRequestMatcher(path);
    }

    public void setServletContext(ServletContext servletContext) {
        this.applicationName = servletContext.getInitParameter("application-name");
    }

    public boolean supports(HttpServletRequest request) {
        boolean featureEnabled = this.getFeatureEnabled();
        if (!featureEnabled) {
            this.logger.debug("Logon feature disabled...");
        }
        String userid = this.getUserid(request);
        String password = this.getPassword(request);
        return featureEnabled && this.pathMatcher.matches(request) && StringUtils.hasText((String)userid) && StringUtils.hasText((String)password);
    }

    private boolean getFeatureEnabled() {
        boolean featureEnabled = false;
        String[] propertyNames = this.getEnablementPropertyNames();
        if (null != propertyNames) {
            String propertyName;
            String propertyValue;
            Properties settings = this.configService.getSettings(this.applicationName);
            String[] stringArray = propertyNames;
            int n = stringArray.length;
            for (int i = 0; i < n && !(featureEnabled = Boolean.parseBoolean(propertyValue = settings.getProperty(propertyName = stringArray[i]))); ++i) {
            }
        }
        return featureEnabled;
    }

    public HttpServletResponse generateLogonResponse(HttpServletRequest request, HttpServletResponse response) {
        AuthenticationClient authenticationClient = this.getAuthenticationClient();
        try {
            String userid = this.getUserid(request);
            String password = this.getPassword(request);
            authenticationClient.logon(userid, password);
            final String ticketId = authenticationClient.acquireTicket(this.service);
            response = new HttpServletResponseWrapper((HttpServletResponse)response){

                public void sendRedirect(String location) throws IOException {
                    location = location + "&direct_authentication_ticket=" + ticketId;
                    super.sendRedirect(location);
                }
            };
        }
        catch (Exception e) {
            authenticationClient.logout();
            response = new HttpServletResponseWrapper((HttpServletResponse)response){

                public void sendRedirect(String location) throws IOException {
                    location = location + "&sasAuthError=1";
                    super.sendRedirect(location);
                }
            };
        }
        return response;
    }

    protected AuthenticationClient getAuthenticationClient() {
        String url = this.urlGenerator.generateInternalUrl("Logon Manager 9.4", "", "");
        AuthenticationClient authClient = new AuthenticationClient(url);
        authClient.setAppendAuthClientParameter(true);
        return authClient;
    }
}

