/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.provider;

import com.sas.svcs.security.authentication.provider.SimpleServiceAuthenticationDetails;
import com.sas.svcs.security.authentication.resolver.ServiceResolver;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.cas.web.authentication.ServiceAuthenticationDetails;
import org.springframework.util.Assert;

public class ServiceResolverAuthenticationDetailsSource
implements AuthenticationDetailsSource<HttpServletRequest, ServiceAuthenticationDetails> {
    protected final Pattern artifactPattern;
    protected ServiceResolver resolver;

    public ServiceResolverAuthenticationDetailsSource() {
        this("ticket");
    }

    public void setServiceResolver(ServiceResolver resolver) {
        this.resolver = resolver;
    }

    private static Pattern createArtifactPattern(String artifactParameterName) {
        Assert.hasLength((String)artifactParameterName);
        return Pattern.compile("&?" + Pattern.quote(artifactParameterName) + "=[^&]*");
    }

    public ServiceResolverAuthenticationDetailsSource(String artifactParameterName) {
        this.artifactPattern = ServiceResolverAuthenticationDetailsSource.createArtifactPattern(artifactParameterName);
    }

    private String getQueryString(HttpServletRequest request, Pattern artifactPattern) {
        String query = request.getQueryString();
        if (query == null) {
            return null;
        }
        String result = artifactPattern.matcher(query).replaceFirst("");
        if (result.length() == 0) {
            return null;
        }
        return result.startsWith("&") ? result.substring(1) : result;
    }

    public ServiceAuthenticationDetails buildDetails(HttpServletRequest request) {
        String query = this.getQueryString(request, this.artifactPattern);
        String pathInfo = request.getRequestURI();
        int slashLoc = (pathInfo = (null == pathInfo ? "" : pathInfo) + (null == query ? "" : query)).indexOf(47, 1);
        if (slashLoc > 0) {
            pathInfo = pathInfo.substring(slashLoc);
        }
        String url = this.resolver.getService(pathInfo, true);
        return new SimpleServiceAuthenticationDetails(request, url);
    }
}

