/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication;

import com.sas.svcs.config.client.UrlGeneratorInterface;
import java.net.InetAddress;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DevelopmentUtility {
    private static final Logger logger = LogManager.getLogger(DevelopmentUtility.class);

    public static String getServiceUrl(UrlGeneratorInterface urlGenerator, String applicationName, String path) {
        return DevelopmentUtility.getExternalServiceUrl(urlGenerator, applicationName, path);
    }

    public static String getExternalServiceUrl(UrlGeneratorInterface urlGenerator, String applicationName, String path) {
        String service = urlGenerator.generateExternalUrl(applicationName, path, "");
        return DevelopmentUtility.getServiceUrl(service);
    }

    public static String getInternalServiceUrl(UrlGeneratorInterface urlGenerator, String applicationName, String path) {
        String service = urlGenerator.generateInternalUrl(applicationName, path, "");
        return DevelopmentUtility.getServiceUrl(service);
    }

    private static String getServiceUrl(String service) {
        if (null != System.getProperty("sas.development.mode")) {
            try {
                URL serviceUrl = new URL(service);
                URL url = new URL(serviceUrl.getProtocol(), InetAddress.getLocalHost().getCanonicalHostName(), System.getProperty("sas.auto.publish.port") == null ? 8080 : Integer.parseInt(System.getProperty("sas.auto.publish.port")), serviceUrl.getFile());
                service = url.toString();
            }
            catch (Exception e) {
                logger.warn("Unable to process development mode URL, falling back to default application information...", (Throwable)e);
            }
        }
        return service;
    }
}

