/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.labeledentity.client;

import com.sas.svcs.commons.IdentifiableBase;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.labeledentity.client.Label;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LabeledEntity
extends IdentifiableBase
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final long OBJECT_TYPE = 38L;
    private Locale defaultLocale;
    private Map<Locale, Label> labels;
    private ObjectIdentity owningObject;

    public LabeledEntity(Locale defaultLocale, List<Label> labels) {
        this.defaultLocale = defaultLocale;
        this.labels = new HashMap<Locale, Label>(labels.size());
        for (Label label : labels) {
            this.labels.put(label.getLocale(), label);
        }
        this.setObjectType(38L);
    }

    public LabeledEntity(Locale defaultLocale, List<Label> labels, ObjectIdentity owningObject) {
        this(defaultLocale, labels);
        this.owningObject = owningObject;
    }

    public LabeledEntity() {
        this.labels = new HashMap<Locale, Label>();
        this.setObjectType(38L);
    }

    public void setLabels(Map<Locale, Label> labels) {
        this.labels = labels;
    }

    public Map<Locale, Label> getLabels() {
        return this.labels;
    }

    public void addLabel(Label label) {
        if (this.labels == null) {
            this.labels = new HashMap<Locale, Label>();
        }
        this.labels.put(label.getLocale(), label);
    }

    public Label getLabel(Locale locale) {
        if (this.labels == null) {
            return null;
        }
        return this.labels.get(locale);
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public ObjectIdentity getOwningObject() {
        return this.owningObject;
    }

    public void setOwningObject(ObjectIdentity owningObject) {
        this.owningObject = owningObject;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        LabeledEntity other = (LabeledEntity)obj;
        if (this.labels == null && other.labels != null) {
            return false;
        }
        if (this.labels.size() != other.labels.size()) {
            return false;
        }
        return this.labels.values().containsAll(other.labels.values());
    }

    public LabeledEntity clone() {
        LabeledEntity ret = null;
        try {
            ret = (LabeledEntity)super.clone();
        }
        catch (CloneNotSupportedException e) {
            ret = new LabeledEntity();
        }
        ret.setDefaultLocale(this.defaultLocale);
        ret.setId(this.getId());
        ret.setObjectType(38L);
        ret.setOwningObject(new ObjectIdentity(this.owningObject.getObjectType(), this.owningObject.getId()));
        if (this.labels != null) {
            for (Label label : this.labels.values()) {
                Label newLabel = new Label(label.getLocale(), label.getValue());
                newLabel.setId(label.getId());
                ret.addLabel(newLabel);
            }
        }
        return ret;
    }
}

