/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.MdAbstractHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@SASScope
public class MdUpdateHandler
extends MdAbstractHandler {
    static final String DELETED_OBJECTS_TAG = "DeletedObjects";
    static final String DELETE_METADATA_TAG = "DeleteMetadata";
    static final String UPDATE_METADATA_TAG = "UpdateMetadata";
    static final String METADATA_TAG = "Metadata";
    Map<String, String> _deleteMetadataMap;
    List<String> _updateObjectsList;
    List<String> _deletedObjectsList;
    boolean _processingDeletedObjects = false;
    boolean _processingUpdate = false;
    boolean _processingDeleteMetadata = false;

    public MdUpdateHandler(SAXParserFactory factory) {
        super(factory);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this._processingDeleteMetadata) {
            this.addObjectToMap(this._deleteMetadataMap, qName, attributes);
        } else if (this._processingUpdate) {
            if (qName.equalsIgnoreCase(DELETED_OBJECTS_TAG)) {
                this._processingDeletedObjects = true;
                this._processingUpdate = false;
                return;
            }
            this.addObjectToList(this._updateObjectsList, attributes);
        } else if (this._processingDeletedObjects) {
            if (this._deletedObjectsList == null) {
                this._deletedObjectsList = new ArrayList<String>();
            }
            this.addObjectToList(this._deletedObjectsList, attributes);
        } else if (qName.equalsIgnoreCase(DELETE_METADATA_TAG)) {
            this._processingDeleteMetadata = true;
            this._deleteMetadataMap = new HashMap<String, String>();
        } else if (qName.equalsIgnoreCase(UPDATE_METADATA_TAG)) {
            this._processingUpdate = true;
            this._updateObjectsList = new ArrayList<String>();
        }
    }

    private void addObjectToList(List<String> list, Attributes attributes) {
        if (attributes.getLength() == 0) {
            return;
        }
        String id = attributes.getValue("Id");
        if (id != null) {
            list.add(id);
        }
    }

    private void addObjectToMap(Map<String, String> map, String qName, Attributes attributes) {
        if (attributes.getLength() == 0) {
            return;
        }
        String id = attributes.getValue("Id");
        if (id != null) {
            map.put(id, qName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this._processingDeleteMetadata && qName.equalsIgnoreCase(METADATA_TAG)) {
            this._processingDeleteMetadata = false;
        } else if (this._processingUpdate) {
            if (this._processingDeletedObjects) {
                this._processingUpdate = false;
            }
        } else if (this._processingDeletedObjects && qName.equalsIgnoreCase(DELETED_OBJECTS_TAG)) {
            this._processingDeletedObjects = false;
        }
    }

    public Map<String, String> getDeleteMetadataMap() {
        return this._deleteMetadataMap;
    }

    public List<String> getUpdatedObjectsList() {
        return this._updateObjectsList;
    }

    public List<String> getDeletedObjectsList() {
        return this._deletedObjectsList;
    }

    @Override
    public void dispose() {
        if (this._deleteMetadataMap != null) {
            this._deleteMetadataMap.clear();
            this._deleteMetadataMap = null;
        }
        if (this._updateObjectsList != null) {
            this._updateObjectsList.clear();
            this._updateObjectsList = null;
        }
        if (this._deletedObjectsList != null) {
            this._deletedObjectsList.clear();
            this._deletedObjectsList = null;
        }
    }
}

