/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Converter;
import com.sas.metadata.remote.MapPool;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectAttribute;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdServerStore;
import com.sas.metadata.remote.MdStore;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

@SASScope
public class MdStoreUtil {
    private static final Class<?>[] attr_classes = new Class[]{String.class, Integer.TYPE};

    public static void copyMetaObject(MdServerStore sourceStore, MdObjectStore targetStore, String objectID) throws RemoteException {
        CMetadata outObject = targetStore.getObject(objectID, true);
        if (outObject != null) {
            MdStoreUtil.refreshMetaObject(sourceStore, targetStore, objectID);
            return;
        }
        CMetadata inObject = sourceStore.getObject(objectID);
        if (inObject == null) {
            return;
        }
        MdFactory myFactory = targetStore.getFactory();
        outObject = myFactory.createComplexMetadataObjectStoreOnly(targetStore, inObject.getName(), inObject.getCMetadataType(), inObject.getFQID());
        if (!targetStore.getIsObjectCopiedFromParentOnCreation()) {
            return;
        }
        Map<String, String> inAttrs = inObject.getAttrs();
        MdStoreUtil.setMetaObjectAttributes(inObject, outObject, inAttrs);
        MapPool.returnMap(inAttrs);
        inAttrs = null;
        Map<String, AssociationList> inAssocs = inObject.getAssocsWA();
        MdStoreUtil.setMetaObjectAssociations(inObject, outObject, inAssocs);
        MapPool.returnMap(inAssocs);
        inAssocs = null;
    }

    public static void copyMetaObject(MdObjectStore sourceStore, MdServerStore targetStore, String objectID) throws RemoteException {
        CMetadata outObject = targetStore.getObject(objectID, true);
        if (outObject != null) {
            MdStoreUtil.refreshMetaObject(sourceStore, targetStore, objectID);
            return;
        }
        CMetadata inObject = sourceStore.getObject(objectID);
        if (inObject == null) {
            return;
        }
        MdFactory myFactory = targetStore.getFactory();
        outObject = myFactory.createComplexMetadataObjectServerStoreOnly(inObject.getName(), inObject.getCMetadataType(), inObject.getFQID());
        Map<String, String> inAttrs = inObject.getAttrs();
        MdStoreUtil.setMetaObjectAttributes(inObject, outObject, inAttrs);
        MapPool.returnMap(inAttrs);
        inAttrs = null;
        Map<String, AssociationList> inAssocs = inObject.getAssocsWA();
        MdStoreUtil.setMetaObjectAssociations(inObject, outObject, inAssocs);
        MapPool.returnMap(inAssocs);
        inAssocs = null;
    }

    public static void copyMetaObject(MdObjectStore sourceStore, MdObjectStore targetStore, String objectID) throws RemoteException {
        CMetadata outObject = targetStore.getObject(objectID, true);
        if (outObject != null) {
            MdStoreUtil.refreshMetaObject(sourceStore, targetStore, objectID);
            return;
        }
        CMetadata inObject = sourceStore.getObject(objectID);
        if (inObject == null) {
            return;
        }
        MdFactory myFactory = targetStore.getFactory();
        outObject = myFactory.createComplexMetadataObjectStoreOnly(targetStore, inObject.getName(), inObject.getCMetadataType(), inObject.getFQID());
        if (targetStore.getOwningStore().equals(sourceStore) && !targetStore.getIsObjectCopiedFromParentOnCreation()) {
            return;
        }
        Map<String, String> inAttrs = inObject.getAttrs();
        MdStoreUtil.setMetaObjectAttributes(inObject, outObject, inAttrs);
        Map<String, AssociationList> inAssocs = inObject.getAssocsWA();
        MdStoreUtil.setMetaObjectAssociations(inObject, outObject, inAssocs);
        MapPool.returnMap(inAttrs);
        inAttrs = null;
        MapPool.returnMap(inAssocs);
        inAssocs = null;
        inObject = null;
        outObject = null;
    }

    public static void copyMetaObject(MdStore sourceStore, MdStore targetStore, String objectID) throws RemoteException {
        if (sourceStore.getStoreType() == 0 && targetStore.getStoreType() == 1) {
            MdStoreUtil.copyMetaObject((MdServerStore)sourceStore, (MdObjectStore)targetStore, objectID);
        } else if (sourceStore.getStoreType() == 1 && targetStore.getStoreType() == 0) {
            MdStoreUtil.copyMetaObject((MdObjectStore)sourceStore, (MdServerStore)targetStore, objectID);
        } else if (sourceStore.getStoreType() == 1 && targetStore.getStoreType() == 1) {
            MdStoreUtil.copyMetaObject((MdObjectStore)sourceStore, (MdObjectStore)targetStore, objectID);
        }
    }

    public static void refreshMetaObject(MdStore sourceStore, MdStore targetStore, String objectID) throws RemoteException {
        if (sourceStore.getStoreType() == 0 && targetStore.getStoreType() == 1) {
            MdStoreUtil.refreshMetaObject((MdServerStore)sourceStore, (MdObjectStore)targetStore, objectID);
        } else if (sourceStore.getStoreType() == 1 && targetStore.getStoreType() == 0) {
            MdStoreUtil.refreshMetaObject((MdObjectStore)sourceStore, (MdServerStore)targetStore, objectID);
        } else if (sourceStore.getStoreType() == 1 && targetStore.getStoreType() == 1) {
            MdStoreUtil.refreshMetaObject((MdObjectStore)sourceStore, (MdObjectStore)targetStore, objectID);
        }
    }

    public static void refreshMetaObject(MdServerStore sourceStore, MdObjectStore targetStore, String objectID) throws RemoteException {
        CMetadata outObject = targetStore.getObject(objectID, true);
        if (outObject == null) {
            if (targetStore.isDeletedObject(objectID)) {
                return;
            }
            MdStoreUtil.copyMetaObject(sourceStore, targetStore, objectID);
            return;
        }
        CMetadata inObject = sourceStore.getObject(objectID);
        if (inObject == null) {
            return;
        }
        Map<String, String> inAttrs = inObject.getAttrs();
        MdStoreUtil.setMetaObjectAttributes(inObject, outObject, inAttrs);
        MapPool.returnMap(inAttrs);
        inAttrs = null;
        Map<String, AssociationList> inAssocs = inObject.getAssocsWA();
        MdStoreUtil.setMetaObjectAssociations(inObject, outObject, inAssocs);
        MapPool.returnMap(inAssocs);
        inAssocs = null;
        inObject = null;
        outObject = null;
    }

    public static void refreshMetaObject(MdObjectStore sourceStore, MdObjectStore targetStore, String objectID) throws RemoteException {
        CMetadata outObject = targetStore.getObject(objectID, true);
        if (outObject == null) {
            if (targetStore.isDeletedObject(objectID)) {
                return;
            }
            MdStoreUtil.copyMetaObject(sourceStore, targetStore, objectID);
            return;
        }
        CMetadata inObject = sourceStore.getObject(objectID);
        if (inObject == null) {
            return;
        }
        Map<String, String> inAttrs = inObject.getAttrs();
        MdStoreUtil.setMetaObjectAttributes(inObject, outObject, inAttrs);
        MapPool.returnMap(inAttrs);
        inAttrs = null;
        Map<String, AssociationList> inAssocs = inObject.getAssocsWA();
        MdStoreUtil.setMetaObjectAssociations(inObject, outObject, inAssocs);
        MapPool.returnMap(inAssocs);
        inAssocs = null;
        inObject = null;
        outObject = null;
    }

    public static void refreshMetaObject(MdObjectStore sourceStore, MdServerStore targetStore, String objectID) throws RemoteException {
        CMetadata outObject = targetStore.getObject(objectID, true);
        if (outObject == null) {
            MdStoreUtil.copyMetaObject(sourceStore, targetStore, objectID);
            return;
        }
        CMetadata inObject = sourceStore.getObject(objectID);
        if (inObject == null) {
            return;
        }
        Map<String, String> inAttrs = inObject.getAttrs();
        MdStoreUtil.setMetaObjectAttributes(inObject, outObject, inAttrs);
        MapPool.returnMap(inAttrs);
        inAttrs = null;
        Map<String, AssociationList> inAssocs = inObject.getAssocsWA();
        MdStoreUtil.setMetaObjectAssociations(inObject, outObject, inAssocs);
        MapPool.returnMap(inAssocs);
        inAssocs = null;
        inObject = null;
        outObject = null;
    }

    private static void refreshMetaObject(MdStore sourceStore, MdObjectStore targetStore, String objectID, boolean deepCopy) throws RemoteException {
        CMetadata outObject = targetStore.getObject(objectID, true);
        if (outObject == null) {
            if (targetStore.isDeletedObject(objectID)) {
                return;
            }
            MdStoreUtil.copyMetaObject(sourceStore, targetStore, objectID, deepCopy);
            return;
        }
        CMetadata inObject = sourceStore.getObject(objectID);
        if (inObject == null) {
            return;
        }
        Map<String, String> inAttrs = inObject.getAttrs();
        MdStoreUtil.setMetaObjectAttributes(inObject, outObject, inAttrs);
        MapPool.returnMap(inAttrs);
        inAttrs = null;
        if (deepCopy) {
            Map<String, AssociationList> inAssocs = inObject.getAssocsWA();
            MdStoreUtil.setMetaObjectAssociations(inObject, outObject, inAssocs);
            MapPool.returnMap(inAssocs);
            inAssocs = null;
        }
        inObject = null;
        outObject = null;
    }

    private static void copyMetaObject(MdStore sourceStore, MdObjectStore targetStore, String objectID, boolean deepCopy) throws RemoteException {
        CMetadata outObject = targetStore.getObject(objectID, true);
        if (outObject != null) {
            MdStoreUtil.refreshMetaObject(sourceStore, targetStore, objectID, deepCopy);
            return;
        }
        CMetadata inObject = sourceStore.getObject(objectID);
        if (inObject == null) {
            return;
        }
        MdFactory myFactory = targetStore.getFactory();
        outObject = myFactory.createComplexMetadataObjectStoreOnly(targetStore, inObject.getName(), inObject.getCMetadataType(), inObject.getFQID());
        if (targetStore.getOwningStore().equals(sourceStore) && !targetStore.getIsObjectCopiedFromParentOnCreation()) {
            return;
        }
        Map<String, String> inAttrs = inObject.getAttrs();
        MdStoreUtil.setMetaObjectAttributes(inObject, outObject, inAttrs);
        if (deepCopy) {
            Map<String, AssociationList> inAssocs = inObject.getAssocsWA();
            MdStoreUtil.setMetaObjectAssociations(inObject, outObject, inAssocs);
            MapPool.returnMap(inAttrs);
            inAttrs = null;
            MapPool.returnMap(inAssocs);
            inAssocs = null;
        }
        inObject = null;
        outObject = null;
    }

    public static void setMetaObjectAttributes(CMetadata sourceObject, CMetadata targetObject, Map<String, String> attributes) throws RemoteException {
        HashMap setAttrs = MapPool.getMap();
        Map<String, Integer> attrStates = sourceObject.getAttrsStates();
        for (String attrName : attributes.keySet()) {
            Integer attrState = attrStates.get(attrName);
            if (attrState == null || attrState == 0) continue;
            String attrValue = attributes.get(attrName);
            setAttrs.put(attrName, new MdObjectAttribute(attrName, (int)attrState, attrValue));
        }
        targetObject.setAttrs(setAttrs);
        MapPool.returnMap(setAttrs);
        setAttrs = null;
        MapPool.returnMap(attrStates);
        attrStates = null;
    }

    public static void setMetaObjectAttributes(CMetadata sourceObject, CMetadata targetObject, Map<String, String> attributes, int attrValueState) throws RemoteException {
        HashMap setAttrs = MapPool.getMap();
        for (String attrName : attributes.keySet()) {
            String attrValue = attributes.get(attrName);
            setAttrs.put(attrName, new MdObjectAttribute(attrName, attrValueState, attrValue));
        }
        targetObject.setAttrs(setAttrs);
        MapPool.returnMap(setAttrs);
        setAttrs = null;
    }

    public static void setMetaObjectAssociations(CMetadata sourceObject, CMetadata targetObject, Map<String, AssociationList> associations) throws RemoteException {
        Map<String, AssociationList> targetAssocs = targetObject.getAssocsWA();
        for (String assnName : associations.keySet()) {
            AssociationList AssnValue = associations.get(assnName);
            if (AssnValue == null) continue;
            MdStoreUtil.setMetaObjectAssociation(sourceObject, targetObject, AssnValue, targetAssocs);
        }
        MapPool.returnMap(targetAssocs);
        targetAssocs = null;
    }

    public static void setMetaObjectAssociation(CMetadata sourceObject, CMetadata targetObject, AssociationList assocValue, Map<String, AssociationList> targetAssociations) throws RemoteException {
        List<String> deletedObjects;
        if (assocValue == null) {
            return;
        }
        AssociationList targetObjectList = null;
        String assocName = assocValue.getAssociationName();
        targetObjectList = targetAssociations.get(assocName);
        if (targetObjectList == null) {
            targetObjectList = new AssociationList(assocName, targetObject.getObjectStore().getFactory().isRemoteEnvironment());
            targetObject.setMdObjectAssociation(targetObjectList);
        }
        if ((deletedObjects = assocValue.getDeletedItems()) != null && deletedObjects.size() > 0) {
            for (int i = 0; i < deletedObjects.size(); ++i) {
                targetObjectList._addDeletedItem(deletedObjects.get(i), false);
            }
        }
        Vector<String> ids = assocValue.getObjectIDs();
        targetObjectList.setObjectIDs(ids);
        boolean processOtherSide = false;
        MdStore targetStore = targetObject.getObjectStore();
        if (targetStore.getStoreType() == 1) {
            MdObjectStore store = (MdObjectStore)targetStore;
            boolean deepCopy = store.isDeepCopyObjects();
            for (String id : ids) {
                CMetadata otherObject = store.getObject(id, true);
                if (otherObject == null && !store.isDeletedObject(id)) {
                    processOtherSide = true;
                    MdStoreUtil.refreshMetaObject(sourceObject.getObjectStore(), store, id, deepCopy);
                }
                otherObject = null;
            }
        }
        if (processOtherSide) {
            targetObjectList.updateOppositeSideAssn();
        }
        targetObjectList.setState(assocValue.getState(), false);
        targetObjectList = null;
    }

    public static void setMetaObjectAssociation(CMetadata inObject, String AssociationName, AssociationList AssociationValue, int AssociationState, Map<String, AssociationList> assocs) throws RemoteException {
        AssociationList inObjectList = null;
        inObjectList = assocs.get(AssociationName);
        if (inObjectList == null) {
            inObjectList = new AssociationList(AssociationValue.getAssociationName());
            inObject.setMdObjectAssociation(inObjectList);
        }
        if (AssociationValue != null) {
            Vector<String> ids = AssociationValue.getObjectIDs();
            inObjectList.setObjectIDs(ids);
            List<String> deletedObjects = AssociationValue.getDeletedItems();
            if (deletedObjects != null && deletedObjects.size() > 0) {
                for (int i = 0; i < deletedObjects.size(); ++i) {
                    inObjectList._addDeletedItem(deletedObjects.get(i), false);
                }
            }
            MdStore inStore = inObject.getObjectStore();
            boolean processOtherSide = false;
            for (String id : ids) {
                if (inStore.getStoreType() != 1) continue;
                CMetadata otherObject = ((MdObjectStore)inStore).getObject(id, true);
                if (!(otherObject != null || ((MdObjectStore)inStore).getDeletedObjects() != null && ((MdObjectStore)inStore).getDeletedObjects().containsKey(id))) {
                    processOtherSide = true;
                    MdStoreUtil.refreshMetaObject(inStore.getOwningStore(), inStore, id);
                }
                otherObject = null;
            }
            if (processOtherSide) {
                inObjectList.updateOppositeSideAssn();
            }
            inObjectList.setState(AssociationState, false);
        }
        inObjectList = null;
    }

    public static void setMetaObjectAssociation(CMetadata inObject, String AssociationName, AssociationList AssociationValue, int AssociationState) throws RemoteException {
        AssociationList inObjectList = null;
        Map<String, AssociationList> assocs = inObject.getAssocsWA();
        inObjectList = assocs.get(AssociationName);
        if (inObjectList == null) {
            inObjectList = new AssociationList(AssociationValue.getAssociationName());
            inObject.setMdObjectAssociation(inObjectList);
        }
        if (AssociationValue != null) {
            Vector<String> ids = AssociationValue.getObjectIDs();
            inObjectList.setObjectIDs(ids);
            List<String> deletedObjects = AssociationValue.getDeletedItems();
            if (deletedObjects != null && deletedObjects.size() > 0) {
                for (int i = 0; i < deletedObjects.size(); ++i) {
                    inObjectList._addDeletedItem(deletedObjects.get(i), false);
                }
            }
            MdStore inStore = inObject.getObjectStore();
            boolean processOtherSide = false;
            for (String id : ids) {
                if (inStore.getStoreType() != 1) continue;
                CMetadata otherObject = ((MdObjectStore)inStore).getObject(id, true);
                if (!(otherObject != null || ((MdObjectStore)inStore).getDeletedObjects() != null && ((MdObjectStore)inStore).getDeletedObjects().containsKey(id))) {
                    processOtherSide = true;
                    MdStoreUtil.refreshMetaObject(inStore.getOwningStore(), inStore, id);
                }
                otherObject = null;
            }
            if (processOtherSide) {
                inObjectList.updateOppositeSideAssn();
            }
            inObjectList.setState(AssociationState, false);
        }
        inObjectList = null;
        MapPool.returnMap(assocs);
        assocs = null;
    }

    public static void setMetaObjectAttribute(CMetadata inObject, String AttributeName, String AttributeValue, int AttributeValueState) throws RemoteException {
        try {
            StringBuffer strTemp = new StringBuffer("set");
            strTemp.append(AttributeName);
            Object[] args = new Object[]{AttributeValue, Converter.toInteger(AttributeValueState)};
            Method method = inObject.getClass().getMethod(strTemp.toString(), attr_classes);
            method.invoke((Object)inObject, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getMetaObjectAttributeState(CMetadata inObject, String AttributeName) throws RemoteException {
        int returnvalue = 0;
        try {
            Map<String, Integer> stateMap = inObject.getAttrsStates();
            Integer returnInt = stateMap.get(AttributeName);
            MapPool.returnMap(stateMap);
            stateMap = null;
            returnvalue = returnInt;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnvalue;
    }

    public static int getMetaObjectAssociationState(CMetadata inObject, String AssociationName) throws RemoteException {
        int returnvalue = 0;
        Map<String, AssociationList> myAssocs = inObject.getAssocs();
        AssociationList myList = myAssocs.get(AssociationName);
        if (myList != null) {
            returnvalue = myList.getState();
        }
        MapPool.returnMap(myAssocs);
        myAssocs = null;
        return returnvalue;
    }

    public static void copyObjectAttributes(CMetadata sourceObject, CMetadata targetObject) throws RemoteException {
        MdStoreUtil.copyObjectAttributes(sourceObject, targetObject, 1);
    }

    public static void copyObjectAttributes(CMetadata sourceObject, CMetadata targetObject, int State2) throws RemoteException {
        Map<String, String> sourceAttrs = sourceObject.getAttrs();
        sourceAttrs.remove("Id");
        sourceAttrs.remove("ChangeState");
        sourceAttrs.remove("LockedBy");
        MdStoreUtil.setMetaObjectAttributes(sourceObject, targetObject, sourceAttrs, State2);
        MapPool.returnMap(sourceAttrs);
        sourceAttrs = null;
    }
}

