/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectList;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.XMLUtil;
import java.lang.reflect.Array;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;

@SASScope
public class MdObjectListImpl
implements MdObjectList {
    static final long serialVersionUID = -6013589079986412265L;
    protected int m_state = 0;
    protected String m_strAssociationName;
    protected List<String> m_deletedItems;
    protected String m_strAssociationType = null;
    protected boolean m_isPredAssoc = false;
    protected CMetadata m_parent = null;
    protected String m_props = null;
    protected volatile Vector<String> m_ids;
    protected static final int FUNCTION_NORMAL = 0;
    protected static final int FUNCTION_REPLACE = 1;
    protected static final int FUNCTION_REMOVE = 2;
    protected transient int modCount = 0;

    public MdObjectListImpl(String strAssociationName, int initialCapacity, int capacityIncrement) throws RemoteException {
        this.m_ids = new Vector(initialCapacity, capacityIncrement);
        this.m_strAssociationName = strAssociationName;
    }

    public MdObjectListImpl(String strAssociationName) throws RemoteException {
        this(strAssociationName, 10, false);
    }

    public MdObjectListImpl(String strAssociationName, int initialCapacity) throws RemoteException {
        this(strAssociationName, initialCapacity, false);
    }

    public MdObjectListImpl(String strAssociationName, int initialCapacity, boolean remoteEnvironment) throws RemoteException {
        this.m_ids = new Vector(initialCapacity);
        this.m_strAssociationName = strAssociationName;
        if (remoteEnvironment) {
            UnicastRemoteObject.exportObject(this);
        }
    }

    public MdObjectListImpl(String strAssociationType, String strAssociationName, boolean isPredAssoc, String properties, CMetadata parentObj) throws RemoteException {
        this.m_ids = new Vector(10);
        this.m_strAssociationName = strAssociationName;
        this.setAssociationType(strAssociationType);
        this.setIsPredAssoc(isPredAssoc);
        this.setParent(parentObj);
        this.setProperties(properties);
        boolean isRemoteable = false;
        if (parentObj != null && parentObj.getObjectStore() != null) {
            isRemoteable = parentObj.getObjectStore().getFactory().isRemoteEnvironment();
        }
        if (isRemoteable) {
            UnicastRemoteObject.exportObject(this);
        }
    }

    public MdObjectListImpl(String strAssociationName, Object obj) throws RemoteException {
        CMetadata meta;
        this.m_ids = new Vector(1);
        String id = null;
        try {
            id = ((CMetadata)obj).getFQID();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (id != null && id.length() > 0) {
            this.m_ids.add(id);
        }
        this.m_state = 0;
        this.m_strAssociationName = strAssociationName;
        boolean isRemoteable = false;
        if (obj instanceof CMetadata && (meta = (CMetadata)obj) != null && meta.getObjectStore() != null) {
            isRemoteable = meta.getObjectStore().getFactory().isRemoteEnvironment();
        }
        if (isRemoteable) {
            UnicastRemoteObject.exportObject(this);
        }
    }

    public MdObjectListImpl(String strAssociationName, Collection<CMetadata> c) throws RemoteException {
        this(strAssociationName, c, null);
    }

    public MdObjectListImpl(String strAssociationName, Collection<CMetadata> c, CMetadata parentObj) throws RemoteException {
        this.m_strAssociationName = strAssociationName;
        this.setParent(parentObj);
        int size = c.size();
        this.m_ids = new Vector(size);
        if (size > 0) {
            for (CMetadata obj : c) {
                String id = null;
                try {
                    id = obj.getFQID();
                }
                catch (RemoteException re) {
                    re.printStackTrace();
                }
                if (id == null || id.length() <= 0) continue;
                this.m_ids.add(id);
            }
        }
        boolean isRemoteable = false;
        if (parentObj != null && parentObj.getObjectStore() != null) {
            isRemoteable = parentObj.getObjectStore().getFactory().isRemoteEnvironment();
        }
        if (isRemoteable) {
            UnicastRemoteObject.exportObject(this);
        }
    }

    @Override
    public String generateAssociationXML(boolean fRequired, String callingObjectID) throws RemoteException {
        StringBuffer strXML = new StringBuffer("");
        boolean fCreatedStartingBlock = false;
        if (!fRequired) {
            if (this.m_state == 0) {
                return strXML.toString();
            }
            if (this.m_state == 1) {
                return strXML.toString();
            }
            if (this.m_state == 64 || this.m_state == 32) {
                return strXML.toString();
            }
            if (((this.m_state & 0x20) > 0 || (this.m_state & 0x40) > 0) && (this.m_state & 0x10) <= 0 && this.m_ids.size() > 0) {
                if ((this.m_state & 2) > 0) {
                    return strXML.toString();
                }
                if ((this.m_state & 4) > 0 && !this.getIsPredAssoc()) {
                    return strXML.toString();
                }
            }
        }
        if ((this.m_state & 2) > 0 && (this.m_state & 0x20) <= 0 || (this.m_state & 0x10) > 0) {
            strXML.append("<");
            strXML.append(this.m_strAssociationName);
            strXML.append(" Function=\"Replace\">");
            fCreatedStartingBlock = true;
        }
        for (int i = 0; i < this.m_ids.size(); ++i) {
            String objID;
            CMetadata obj;
            if (!fCreatedStartingBlock) {
                fCreatedStartingBlock = true;
                strXML.append("<");
                strXML.append(this.m_strAssociationName);
                strXML.append(">");
            }
            if ((obj = (CMetadata)this.getObjectforID(objID = this.m_ids.elementAt(i))) == null) continue;
            try {
                strXML.append("<");
                strXML.append(obj.getCMetadataType());
                strXML.append(" ObjRef=\"");
                strXML.append(obj.getId());
                strXML.append("\"/>");
                continue;
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
        if (fCreatedStartingBlock) {
            strXML.append("</");
            strXML.append(this.m_strAssociationName);
            strXML.append(">");
        }
        return strXML.toString();
    }

    @Override
    public String generateAssociationAllXML(boolean fRequired, String callingObjectID) throws RemoteException {
        if (this.m_ids != null && this.m_ids.size() == 0) {
            StringBuffer strXML = new StringBuffer(this.m_strAssociationName.length() + 3);
            strXML.append("<");
            strXML.append(this.m_strAssociationName);
            strXML.append("/>");
            return strXML.toString();
        }
        StringBuffer strXML = new StringBuffer();
        boolean fCreatedStartingBlock = false;
        for (int i = 0; i < this.m_ids.size(); ++i) {
            String objID;
            CMetadata obj;
            if (!fCreatedStartingBlock) {
                fCreatedStartingBlock = true;
                strXML.append("<");
                strXML.append(this.m_strAssociationName);
                strXML.append(">");
            }
            if ((obj = (CMetadata)this.getObjectforID(objID = this.m_ids.elementAt(i))) == null) continue;
            try {
                strXML.append("<");
                strXML.append(obj.getCMetadataType());
                strXML.append(" ObjRef=\"");
                strXML.append(obj.getId());
                strXML.append("\"/>");
                continue;
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
        if (fCreatedStartingBlock) {
            strXML.append("</");
            strXML.append(this.m_strAssociationName);
            strXML.append(">");
        }
        return strXML.toString();
    }

    @Override
    public String generateEmptyReplaceXML() throws RemoteException {
        StringBuffer strXML = new StringBuffer("");
        if (this.m_strAssociationName.length() > 0) {
            strXML.append("<");
            strXML.append(this.m_strAssociationName);
            strXML.append(" Function=\"Replace\"></");
            strXML.append(this.m_strAssociationName);
            strXML.append(">");
        }
        return strXML.toString();
    }

    @Override
    public String generateAssociationWriteXML(boolean fRequired, String callingObjectID) throws RemoteException {
        try {
            boolean writeableOutput = false;
            int function = 0;
            if (fRequired || this.getIsRequired()) {
                if (this.m_parent.isNewObject()) {
                    writeableOutput = true;
                } else if (!this.getMaxCardinality().equals("1")) {
                    writeableOutput = true;
                }
                if (writeableOutput) {
                    if ((this.m_state & 0x10) > 0) {
                        function = 1;
                    } else if ((this.m_state & 4) > 0 && (this.m_state & 2) > 0) {
                        this.generateObjectAndAssociationRemoveXML();
                    } else if ((this.m_state & 2) > 0) {
                        function = 2;
                    }
                }
            } else if ((this.m_state & 0x10) > 0) {
                function = 1;
                writeableOutput = true;
            } else if ((this.m_state & 4) > 0 && (this.m_state & 2) > 0) {
                this.generateObjectAndAssociationRemoveXML();
                writeableOutput = true;
            } else if ((this.m_state & 2) > 0) {
                function = 2;
                if (!this.m_parent.isNewObject()) {
                    writeableOutput = true;
                }
            } else if ((this.m_state & 4) > 0) {
                writeableOutput = true;
            }
            if (writeableOutput) {
                StringBuffer strXML = new StringBuffer();
                strXML.append("<");
                strXML.append(this.m_strAssociationName);
                switch (function) {
                    case 1: {
                        strXML.append(" Function=\"Replace\">");
                        break;
                    }
                    case 2: {
                        strXML.append(" Function=\"Remove\">");
                        break;
                    }
                    default: {
                        strXML.append(">");
                    }
                }
                if (function == 2) {
                    for (int i = 0; this.m_deletedItems != null && i < this.m_deletedItems.size(); ++i) {
                        String objID = this.m_deletedItems.get(i);
                        CMetadata obj = (CMetadata)this.getObjectforID(objID);
                        if (obj == null || this.contains(obj)) continue;
                        strXML.append("<");
                        strXML.append(obj.getCMetadataType());
                        strXML.append(" ObjRef=\"");
                        strXML.append(obj.getId());
                        strXML.append("\"/>");
                    }
                } else {
                    for (int i = 0; this.m_ids != null && i < this.m_ids.size(); ++i) {
                        String objID = this.m_ids.get(i);
                        CMetadata obj = (CMetadata)this.getObjectforID(objID);
                        if (obj == null) continue;
                        strXML.append("<");
                        strXML.append(obj.getCMetadataType());
                        strXML.append(" ObjRef=\"");
                        strXML.append(obj.getId());
                        strXML.append("\"/>");
                    }
                }
                strXML.append("</");
                strXML.append(this.m_strAssociationName);
                strXML.append(">");
                return strXML.toString();
            }
            return "";
        }
        catch (RemoteException rex) {
            rex.printStackTrace();
            return "";
        }
    }

    @Override
    public String generateObjectAndAssociationRemoveXML() throws RemoteException {
        try {
            MdStore parentStore;
            if (this.m_parent.isNewObject()) {
                return "";
            }
            StringBuffer outXML = new StringBuffer();
            boolean createdStart = false;
            if (this.m_deletedItems != null && this.m_deletedItems.size() > 0) {
                for (String deletedId : this.m_deletedItems) {
                    CMetadata otherObject = (CMetadata)this.getObjectforID(deletedId);
                    if (otherObject == null || this.contains(otherObject)) continue;
                    if (!createdStart) {
                        outXML.append("<");
                        outXML.append(this.m_parent.getCMetadataType());
                        outXML.append(" Id=\"");
                        outXML.append(this.m_parent.getId());
                        outXML.append("\" >");
                        outXML.append("<");
                        outXML.append(this.m_strAssociationName);
                        outXML.append(" Function=\"Remove\">");
                        createdStart = true;
                    }
                    outXML.append("<");
                    outXML.append(otherObject.getCMetadataType());
                    outXML.append(" ObjRef=\"");
                    outXML.append(otherObject.getId());
                    outXML.append("\"/>");
                }
                if (createdStart) {
                    outXML.append("</");
                    outXML.append(this.m_strAssociationName);
                    outXML.append(">");
                    outXML.append("</");
                    outXML.append(this.m_parent.getCMetadataType());
                    outXML.append(">");
                }
            }
            if (outXML.length() != 0 && (parentStore = this.m_parent.getObjectStore()).getStoreType() == 1) {
                ((MdObjectStore)parentStore).appendWriteBuffer(outXML.toString());
            }
            return outXML.toString();
        }
        catch (RemoteException rex) {
            rex.printStackTrace();
            return "";
        }
    }

    @Override
    public void updateObjectID(String strOldId, String strNewId) throws RemoteException {
        if (this.m_parent == null) {
            return;
        }
        try {
            String parentID = this.m_parent.getFQID();
            if (parentID.equalsIgnoreCase(strOldId) || parentID.equalsIgnoreCase(strNewId)) {
                int len = this.m_ids.size();
                for (int i = 0; i < len; ++i) {
                    String id = this.m_ids.get(i);
                    CMetadata otherObject = (CMetadata)this.getObjectforID(id);
                    if (otherObject == null) continue;
                    otherObject.updateAssnsIds(strOldId, strNewId);
                }
            } else {
                int len = this.m_ids.size();
                for (int i = 0; i < len; ++i) {
                    String id = this.m_ids.get(i);
                    if (!id.equalsIgnoreCase(strOldId)) continue;
                    this.m_ids.set(i, strNewId);
                }
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    protected void removeOppositeAssn(String otherID) throws MdException, RemoteException {
        if (this.m_parent == null) {
            return;
        }
        CMetadata otherObject = (CMetadata)this.getObjectforID(otherID, true);
        if (otherObject == null) {
            return;
        }
        if (this.getIsPredAssoc()) {
            AssociationList inObjectList = null;
            inObjectList = otherObject.getMdObjectAssociation(this.m_strAssociationType.substring(this.m_strAssociationType.indexOf(45) + 1, this.m_strAssociationType.length()));
            if (inObjectList != null && inObjectList.contains(this.m_parent)) {
                inObjectList.removeElement(this.m_parent, false);
            }
        } else {
            AssociationList inObjectList = null;
            inObjectList = otherObject.getMdObjectAssociation(this.m_strAssociationType.substring(0, this.m_strAssociationType.indexOf(45)));
            if (inObjectList != null && inObjectList.contains(this.m_parent)) {
                inObjectList.removeElement(this.m_parent, false);
            }
        }
    }

    @Override
    public void updateOppositeSideAssn() throws RemoteException {
        if (this.m_ids != null) {
            int len = this.m_ids.size();
            for (int i = 0; i < len; ++i) {
                try {
                    this.setOppositeAssn(this.m_ids.get(i));
                    continue;
                }
                catch (MdException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (RemoteException re) {
                    re.printStackTrace();
                }
            }
        }
    }

    protected void setOppositeAssn(String otherID) throws MdException, RemoteException {
        if (this.m_parent == null) {
            return;
        }
        CMetadata otherObject = (CMetadata)this.getObjectforID(otherID);
        if (otherObject == null) {
            return;
        }
        if (this.getIsPredAssoc()) {
            AssociationList inObjectList = null;
            inObjectList = otherObject.getMdObjectAssociation(this.m_strAssociationType.substring(this.m_strAssociationType.indexOf(45) + 1, this.m_strAssociationType.length()));
            if (inObjectList != null) {
                if (inObjectList.contains(this.m_parent)) {
                    return;
                }
                if (this.m_props != null && this.m_props.charAt(3) == '1') {
                    inObjectList.getInternalListObject().add(this.m_parent, 64, false);
                } else {
                    inObjectList.getInternalListObject().add(this.m_parent, 32, false);
                }
            }
            inObjectList = null;
        } else {
            AssociationList inObjectList = null;
            inObjectList = otherObject.getMdObjectAssociation(this.m_strAssociationType.substring(0, this.m_strAssociationType.indexOf(45)));
            if (inObjectList != null) {
                if (inObjectList.contains(this.m_parent)) {
                    return;
                }
                if (this.m_props != null && this.m_props.charAt(1) == '1') {
                    inObjectList.getInternalListObject().add(this.m_parent, 64, false);
                } else {
                    inObjectList.getInternalListObject().add(this.m_parent, 32, false);
                }
            }
            Object var3_4 = null;
        }
    }

    public AssociationList getOppositeAssn(String otherID) throws MdException, RemoteException {
        if (this.m_parent == null) {
            return null;
        }
        CMetadata otherObject = (CMetadata)this.getObjectforID(otherID);
        if (otherObject == null) {
            return null;
        }
        if (this.getIsPredAssoc()) {
            AssociationList inObjectList = null;
            inObjectList = otherObject.getMdObjectAssociation(this.m_strAssociationType.substring(this.m_strAssociationType.indexOf(45) + 1, this.m_strAssociationType.length()));
            return inObjectList;
        }
        AssociationList inObjectList = null;
        inObjectList = otherObject.getMdObjectAssociation(this.m_strAssociationType.substring(0, this.m_strAssociationType.indexOf(45)));
        return inObjectList;
    }

    @Override
    public Vector<String> getObjectIDs() throws RemoteException {
        return this.m_ids;
    }

    @Override
    public void setObjectIDs(List<String> newIds) throws RemoteException {
        ++this.modCount;
        this.m_ids = new Vector<String>(newIds);
        this.setSize(this.m_ids.size());
    }

    @Override
    public CMetadata getParent() throws RemoteException {
        return this.m_parent;
    }

    @Override
    public void setParent(CMetadata inParent) throws RemoteException {
        this.m_parent = inParent;
    }

    @Override
    public void setProperties(String inProperties) throws RemoteException {
        this.m_props = inProperties;
    }

    @Override
    public String getProperties() throws RemoteException {
        return this.m_props;
    }

    @Override
    public String getAssociationName() throws RemoteException {
        return this.m_strAssociationName;
    }

    @Override
    public String getAssociationType() throws RemoteException {
        return this.m_strAssociationType;
    }

    @Override
    public void setAssociationType(String type) throws RemoteException {
        this.m_strAssociationType = type;
    }

    @Override
    public void setIsPredAssoc(boolean ispred) throws RemoteException {
        this.m_isPredAssoc = ispred;
    }

    @Override
    public boolean getIsPredAssoc() throws RemoteException {
        return this.m_isPredAssoc;
    }

    @Override
    public String getMinCardinality() throws RemoteException {
        if (this.m_props != null && this.m_props.length() == 6) {
            if (this.m_isPredAssoc) {
                return this.m_props.substring(0, 1);
            }
            return this.m_props.substring(2, 3);
        }
        return null;
    }

    @Override
    public String getMaxCardinality() throws RemoteException {
        if (this.m_props != null && this.m_props.length() == 6) {
            if (this.m_isPredAssoc) {
                return this.m_props.substring(1, 2);
            }
            return this.m_props.substring(3, 4);
        }
        return null;
    }

    @Override
    public boolean getIsRequired() throws RemoteException {
        if (this.m_props != null && this.m_props.length() == 6) {
            if (this.m_isPredAssoc) {
                return this.m_props.charAt(4) != '0';
            }
            return this.m_props.charAt(5) != '0';
        }
        return false;
    }

    @Override
    public List<String> getDeletedItems() throws RemoteException {
        return this.m_deletedItems;
    }

    @Override
    public int getState() throws RemoteException {
        return this.m_state;
    }

    @Override
    public void setState(int iValue) throws RemoteException {
        this.setState(iValue, true);
    }

    @Override
    public void setState(int iValue, boolean AddToChangeIfChanged) throws RemoteException {
        switch (iValue) {
            case 0: 
            case 1: {
                this.m_state = iValue;
                break;
            }
            case 32: 
            case 64: {
                if ((this.m_state & 0x20) > 0) {
                    this.m_state &= 0xFFFFFFDF;
                }
                if ((this.m_state & 0x40) > 0) {
                    this.m_state &= 0xFFFFFFBF;
                }
                if ((this.m_state & 1) > 0) {
                    this.m_state &= 0xFFFFFFFE;
                }
                this.m_state |= iValue;
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                if ((this.m_state & 1) > 0) {
                    this.m_state &= 0xFFFFFFFE;
                }
                this.m_state |= iValue;
                break;
            }
            default: {
                this.m_state = iValue;
            }
        }
        if ((iValue == 2 || iValue == 4 || iValue == 16) && this.m_parent != null && AddToChangeIfChanged) {
            try {
                this.m_parent.setState(1);
                this.m_parent.addElementToChangeList(this.m_parent);
            }
            catch (RemoteException rex) {
                rex.printStackTrace();
            }
        }
    }

    @Override
    public void resetState(int iValue) throws RemoteException {
        this.resetState(iValue, false);
    }

    @Override
    public void resetState(int iValue, boolean forceState) throws RemoteException {
        this.m_state = forceState ? ((this.m_state & 0x20) > 0 ? 32 : ((this.m_state & 0x40) > 0 ? 64 : iValue)) : (this.m_state &= ~iValue);
    }

    @Override
    public boolean isGoToServerForAssoc() throws RemoteException {
        if (this.m_parent == null || this.m_parent.isNewObject()) {
            return false;
        }
        if (this.m_parent.getObjectStore() == null) {
            return false;
        }
        return (this.m_state & 0x20) > 0 || this.m_state == 0;
    }

    @Override
    public void setSize(int newSize) throws RemoteException {
        ++this.modCount;
        if (newSize < this.m_ids.size()) {
            this.setState(2);
            for (int index = newSize; index < this.m_ids.size(); ++index) {
                this._addDeletedItem(this.m_ids.elementAt(index));
            }
        }
        this.m_ids.setSize(newSize);
    }

    @Override
    public void setElementAt(Object obj, int index) throws RemoteException {
        this.setState(4);
        this.setState(2);
        if (obj != null && this.m_ids.size() > 0 && index < this.m_ids.size()) {
            this._addDeletedItem(this.m_ids.elementAt(index));
            String id = null;
            try {
                id = ((CMetadata)obj).getFQID();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            if (id != null && id.length() > 0) {
                this.m_ids.setElementAt(id, index);
                try {
                    this.setOppositeAssn(id);
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
                catch (RemoteException re) {
                    re.printStackTrace();
                }
            }
        }
    }

    @Override
    public synchronized void removeElementAt(int index) throws RemoteException {
        ++this.modCount;
        if (this.m_ids.size() > 0 && index < this.m_ids.size()) {
            this._addDeletedItem(this.m_ids.elementAt(index));
            this.m_ids.removeElementAt(index);
        }
    }

    @Override
    public synchronized void insertElementAt(Object obj, int index) throws RemoteException {
        ++this.modCount;
        this.setState(4);
        if (obj != null) {
            String id = null;
            try {
                id = ((CMetadata)obj).getFQID();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            if (id != null && id.length() > 0) {
                this.m_ids.insertElementAt(id, index);
                try {
                    this.setOppositeAssn(id);
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
                catch (RemoteException re) {
                    re.printStackTrace();
                }
            }
        }
    }

    @Override
    public synchronized void insertElementAt(Object obj, int index, boolean objectModified) throws RemoteException {
        ++this.modCount;
        if (objectModified) {
            this.setState(4);
        }
        if (obj != null) {
            String id = null;
            try {
                id = ((CMetadata)obj).getFQID();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            if (id != null && id.length() > 0) {
                this.m_ids.insertElementAt(id, index);
                try {
                    this.setOppositeAssn(id);
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
                catch (RemoteException re) {
                    re.printStackTrace();
                }
            }
        }
    }

    @Override
    public synchronized void addElement(Object obj) throws RemoteException {
        ++this.modCount;
        this.setState(4);
        if (obj != null) {
            String id = null;
            try {
                id = ((CMetadata)obj).getFQID();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            if (id != null && id.length() > 0) {
                this.m_ids.addElement(id);
                try {
                    this.setOppositeAssn(id);
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
                catch (RemoteException re) {
                    re.printStackTrace();
                }
            }
        }
    }

    @Override
    public synchronized boolean removeElement(Object obj) throws RemoteException {
        ++this.modCount;
        boolean removed = false;
        if (obj != null) {
            String id = null;
            try {
                id = ((CMetadata)obj).getFQID();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            if (id != null && id.length() > 0) {
                removed = this.m_ids.remove(id);
                this._addDeletedItem(id);
            }
        }
        return removed;
    }

    @Override
    public synchronized boolean removeElement(Object obj, boolean processOtherSide) throws RemoteException {
        ++this.modCount;
        boolean removed = false;
        if (obj != null) {
            String id = null;
            try {
                id = ((CMetadata)obj).getFQID();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            if (id != null && id.length() > 0) {
                removed = this.m_ids.remove(id);
                this._addDeletedItem(id, processOtherSide);
            }
        }
        return removed;
    }

    @Override
    public synchronized void removeAllElements() throws RemoteException {
        this.setState(16);
        int id_size = this.m_ids.size();
        for (int index = id_size - 1; index >= 0; --index) {
            this._addDeletedItem(this.m_ids.elementAt(index));
        }
        this.m_ids.removeAllElements();
    }

    @Override
    public synchronized void removeAllElements(boolean objectChanged) throws MdException, RemoteException {
        if (this.m_ids == null || this.m_ids.size() == 0) {
            return;
        }
        int id_size = this.m_ids.size();
        for (int index = id_size - 1; index >= 0; --index) {
            try {
                if (objectChanged) {
                    this._addDeletedItem(this.m_ids.elementAt(index));
                    continue;
                }
                this.removeOppositeAssn(this.m_ids.elementAt(index));
                continue;
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
        this.m_ids.removeAllElements();
    }

    @Override
    public synchronized Object set(int index, Object obj) throws RemoteException {
        if (this.m_ids.size() == 0) {
            if (obj != null) {
                String id = null;
                try {
                    id = ((CMetadata)obj).getFQID();
                }
                catch (RemoteException re) {
                    re.printStackTrace();
                }
                if (id != null) {
                    this.setState(4);
                    this.m_ids.add(id);
                    try {
                        this.setOppositeAssn(id);
                    }
                    catch (MdException e) {
                        e.printStackTrace();
                    }
                    catch (RemoteException re) {
                        re.printStackTrace();
                    }
                    return null;
                }
            }
        } else {
            this._addDeletedItem(this.m_ids.elementAt(index));
            if (obj != null) {
                String id = null;
                try {
                    id = ((CMetadata)obj).getFQID();
                }
                catch (RemoteException re) {
                    re.printStackTrace();
                }
                if (id != null) {
                    this.setState(4);
                    this.setState(2);
                    String oldID = this.m_ids.set(index, id);
                    try {
                        this.setOppositeAssn(id);
                    }
                    catch (MdException e) {
                        e.printStackTrace();
                    }
                    catch (RemoteException re) {
                        re.printStackTrace();
                    }
                    return this.getObjectforID(oldID);
                }
            }
        }
        return null;
    }

    public synchronized boolean add(Object obj, int state) throws RemoteException {
        return this.add(obj, state, true);
    }

    @Override
    public synchronized boolean add(Object obj, int state, boolean processOtherSideOfAssn) throws RemoteException {
        ++this.modCount;
        if (this.getState() == 0) {
            this.setState(state, false);
        } else {
            this.setState(8, false);
        }
        boolean ret = false;
        if (obj != null) {
            String objID = null;
            try {
                objID = ((CMetadata)obj).getFQID();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            if (objID != null && objID.length() > 0) {
                ret = this.m_ids.add(objID);
                if (processOtherSideOfAssn) {
                    try {
                        this.setOppositeAssn(objID);
                    }
                    catch (MdException e) {
                        e.printStackTrace();
                    }
                    catch (RemoteException re) {
                        re.printStackTrace();
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public synchronized boolean add(Object obj) throws RemoteException {
        ++this.modCount;
        this.setState(4);
        boolean ret = false;
        try {
            String objID;
            if (obj != null && (objID = ((CMetadata)obj).getFQID()) != null && objID.length() > 0) {
                ret = this.m_ids.add(objID);
                try {
                    this.setOppositeAssn(objID);
                }
                catch (MdException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return ret;
    }

    @Override
    public boolean remove(Object o) throws RemoteException {
        return this.removeElement(o);
    }

    @Override
    public synchronized void add(int index, Object element) throws RemoteException {
        this.insertElementAt(element, index);
    }

    @Override
    public synchronized Object remove(int index) throws RemoteException {
        ++this.modCount;
        if (this.m_ids.size() > 0) {
            String oldID = this.m_ids.remove(index);
            this._addDeletedItem(oldID);
            return this.getObjectforID(oldID);
        }
        return null;
    }

    public Object getObjectforID(String ID) throws RemoteException {
        return this.getObjectforID(ID, false);
    }

    public Object getObjectforID(String ID, boolean hashOnly) throws RemoteException {
        CMetadata ret;
        block9: {
            ret = null;
            if (ID != null && ID.length() > 0 && this.m_parent != null) {
                try {
                    MdStore oStore = this.m_parent.getObjectStore();
                    if (oStore.getStoreType() != 1) {
                        return oStore.getObject(ID);
                    }
                    ret = ((MdObjectStore)oStore).getObject(ID, hashOnly);
                    if (ret != null || hashOnly || ID.indexOf(36) > -1 || !(oStore instanceof MdObjectStore) || ((MdObjectStore)oStore).isDeletedObject(ID)) break block9;
                    try {
                        List returnObjects;
                        if (oStore.getFactory().getDebug()) {
                            oStore.getFactory().getUtil().printOutputln("DEBUG NOTE: AssociationList going to server for object: " + XMLUtil.normalize(ID));
                        }
                        if ((returnObjects = oStore.getFactory().getOMIUtil().getMetadataObjectsSubset(oStore, "A0000001." + ID.substring(0, ID.indexOf(".")), "Root", 408, "<XMLSelect search=\"*[@Id='" + ID + "']\"/>", true)) != null && returnObjects.size() == 1) {
                            ret = (CMetadata)returnObjects.get(0);
                        }
                    }
                    catch (MdException mex) {
                        mex.printStackTrace();
                    }
                    catch (RemoteException rex) {
                        rex.printStackTrace();
                    }
                }
                catch (RemoteException re) {
                    re.printStackTrace();
                }
            }
        }
        return ret;
    }

    @Override
    public synchronized void clear() throws RemoteException {
        this.removeAllElements();
    }

    @Override
    public synchronized boolean addAll(Collection c) throws RemoteException {
        ++this.modCount;
        this.setState(4);
        boolean ret = false;
        for (Object obj : c) {
            if (obj == null) continue;
            String id = null;
            try {
                id = ((CMetadata)obj).getFQID();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            if (id == null || id.length() <= 0) continue;
            ret = this.m_ids.add(id);
            try {
                this.setOppositeAssn(id);
            }
            catch (MdException e) {
                e.printStackTrace();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    public synchronized boolean removeAll(Collection c) throws RemoteException {
        boolean ret = false;
        for (Object obj : c) {
            if (obj == null || !(obj instanceof CMetadata)) continue;
            String id = null;
            try {
                id = ((CMetadata)obj).getFQID();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            if (id == null || id.length() <= 0) continue;
            this._addDeletedItem(id);
            if (!this.m_ids.remove(id)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public synchronized boolean retainAll(Collection c) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean addAll(int index, Collection c) throws RemoteException {
        ++this.modCount;
        this.setState(4);
        int numnew = c.size();
        int incrementer = 0;
        for (Object obj : c) {
            if (obj == null || !(obj instanceof CMetadata)) continue;
            String id = null;
            try {
                id = ((CMetadata)obj).getFQID();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            if (id == null || id.length() <= 0) continue;
            this.m_ids.add(index + incrementer, id);
            ++incrementer;
            try {
                this.setOppositeAssn(id);
            }
            catch (MdException e) {
                e.printStackTrace();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
        return numnew != 0;
    }

    protected synchronized void removeRange(int fromIndex, int toIndex) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void flushAll() throws RemoteException {
        this.removeAllElements();
    }

    @Override
    public void _addDeletedItem(Object obj) throws RemoteException {
        this._addDeletedItem(obj, true);
    }

    @Override
    public void _addDeletedItem(Object obj, boolean processOtherSide) throws RemoteException {
        if (this.m_deletedItems == null) {
            this.m_deletedItems = new Vector<String>();
        }
        if (obj instanceof String && !this.m_deletedItems.contains(obj)) {
            this.m_deletedItems.add((String)obj);
        }
        if (processOtherSide) {
            this.setState(2);
        } else {
            this.setState(8, false);
        }
        if (obj != null && obj instanceof String && processOtherSide) {
            try {
                this.removeOppositeAssn((String)obj);
            }
            catch (MdException e) {
                e.printStackTrace();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
    }

    @Override
    public Iterator iterator() throws RemoteException {
        return new Itr();
    }

    @Override
    public ListIterator listIterator() throws RemoteException {
        return this.listIterator(0);
    }

    @Override
    public ListIterator listIterator(int index) throws RemoteException {
        try {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
            return new ListItr(index);
        }
        catch (RemoteException rex) {
            rex.printStackTrace();
            return new ListItr(0);
        }
    }

    @Override
    public int capacity() throws RemoteException {
        return this.m_ids.capacity();
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Clone not supported");
    }

    @Override
    public synchronized void dispose() throws RemoteException {
    }

    @Override
    public synchronized boolean contains(Object obj) throws RemoteException {
        boolean ret = false;
        if (obj != null && obj instanceof CMetadata) {
            String id = null;
            try {
                id = ((CMetadata)obj).getFQID();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            ret = this.m_ids.contains(id);
        }
        return ret;
    }

    @Override
    public synchronized boolean containsAll(Collection c) throws RemoteException {
        boolean ret = false;
        for (Object obj : c) {
            if (obj == null || !(obj instanceof CMetadata)) continue;
            String id = null;
            try {
                id = ((CMetadata)obj).getFQID();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            if (this.m_ids.contains(id)) continue;
            return ret;
        }
        return true;
    }

    @Override
    public synchronized void copyInto(Object[] anArray) throws RemoteException {
        int num = 0;
        for (String id : this.m_ids) {
            if (id != null && id.length() > 0) {
                anArray[num] = this.getObjectforID(id);
            }
            ++num;
        }
    }

    @Override
    public synchronized Object elementAt(int index) throws RemoteException {
        String id = this.m_ids.elementAt(index);
        if (id != null && id.length() > 0) {
            return this.getObjectforID(id);
        }
        return null;
    }

    @Override
    public synchronized Enumeration elements() throws RemoteException {
        return new Enumeration(){
            int count = 0;

            @Override
            public boolean hasMoreElements() {
                int size = 0;
                try {
                    if (MdObjectListImpl.this.getObjectIDs() != null) {
                        size = MdObjectListImpl.this.getObjectIDs().size();
                    }
                }
                catch (RemoteException rex) {
                    rex.printStackTrace();
                }
                return this.count < size;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object nextElement() {
                MdObjectListImpl mdObjectListImpl = MdObjectListImpl.this;
                synchronized (mdObjectListImpl) {
                    block8: {
                        int size = 0;
                        try {
                            if (MdObjectListImpl.this.getObjectIDs() != null) {
                                size = MdObjectListImpl.this.getObjectIDs().size();
                                if (this.count < size) {
                                    String id = MdObjectListImpl.this.getObjectIDs().elementAt(this.count);
                                    ++this.count;
                                    if (id != null && id.length() > 0) {
                                        return MdObjectListImpl.this.getObjectforID(id);
                                    }
                                    return null;
                                }
                                break block8;
                            }
                            return null;
                        }
                        catch (RemoteException rex) {
                            rex.printStackTrace();
                        }
                    }
                }
                throw new NoSuchElementException("List Enumeration");
            }
        };
    }

    @Override
    public synchronized void ensureCapacity(int minCapacity) throws RemoteException {
        ++this.modCount;
        this.m_ids.ensureCapacity(minCapacity);
    }

    @Override
    public synchronized Object firstElement() throws RemoteException {
        String id = this.m_ids.firstElement();
        if (id != null && id.length() > 0) {
            return this.getObjectforID(id);
        }
        return null;
    }

    @Override
    public synchronized Object get(int index) throws RemoteException {
        String id = this.m_ids.get(index);
        if (id != null && id.length() > 0) {
            return this.getObjectforID(id);
        }
        return null;
    }

    public synchronized int hashCode() {
        return super.hashCode();
    }

    @Override
    public int indexOf(Object elem) throws RemoteException {
        return this.indexOf(elem, 0);
    }

    @Override
    public synchronized int indexOf(Object elem, int index) throws RemoteException {
        if (elem == null) {
            this.m_ids.indexOf(elem, index);
        } else if (elem instanceof CMetadata) {
            String id = null;
            try {
                id = ((CMetadata)elem).getFQID();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            return this.m_ids.indexOf(id, index);
        }
        return -1;
    }

    @Override
    public boolean isEmpty() throws RemoteException {
        return this.m_ids.isEmpty();
    }

    @Override
    public synchronized Object lastElement() throws RemoteException {
        String id = this.m_ids.get(this.m_ids.size() - 1);
        return this.getObjectforID(id);
    }

    @Override
    public int lastIndexOf(Object elem) throws RemoteException {
        return this.lastIndexOf(elem, this.m_ids.size() - 1);
    }

    @Override
    public synchronized int lastIndexOf(Object elem, int index) throws RemoteException {
        if (elem == null) {
            return this.m_ids.lastIndexOf(elem, index);
        }
        if (elem instanceof CMetadata) {
            String id = null;
            try {
                id = ((CMetadata)elem).getFQID();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            return this.m_ids.lastIndexOf(id, index);
        }
        return -1;
    }

    @Override
    public synchronized int size() throws RemoteException {
        if (this.m_ids != null) {
            return this.m_ids.size();
        }
        return 0;
    }

    @Override
    public synchronized List<CMetadata> subList(int fromIndex, int toIndex) throws RemoteException {
        List<String> idslist = Collections.synchronizedList(this.m_ids.subList(fromIndex, toIndex));
        ArrayList<CMetadata> objList = new ArrayList<CMetadata>(idslist.size());
        for (String id : idslist) {
            objList.add((CMetadata)this.getObjectforID(id));
        }
        return objList;
    }

    @Override
    public synchronized Object[] toArray() throws RemoteException {
        Object[] result = new Object[this.m_ids.size()];
        int index = 0;
        for (String id : this.m_ids) {
            result[index] = this.getObjectforID(id);
            ++index;
        }
        return result;
    }

    @Override
    public synchronized Object[] toArray(Object[] a) throws RemoteException {
        if (a.length < this.m_ids.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.m_ids.size());
        }
        int index = 0;
        for (String id : this.m_ids) {
            a[index] = this.getObjectforID(id);
            ++index;
        }
        if (a.length > this.m_ids.size()) {
            a[this.m_ids.size()] = null;
        }
        return a;
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        Object[] objects = null;
        try {
            objects = this.toArray();
        }
        catch (RemoteException rex) {
            rex.printStackTrace();
        }
        buf.append("[");
        int maxIndex = this.m_ids.size() - 1;
        if (objects != null) {
            for (int i = 0; i <= maxIndex; ++i) {
                buf.append(String.valueOf(objects[i]));
                if (i >= maxIndex) continue;
                buf.append(", ");
            }
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public synchronized void trimToSize() throws RemoteException {
        ++this.modCount;
        this.m_ids.trimToSize();
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        public Object previous() {
            try {
                Object previous = MdObjectListImpl.this.get(--this.cursor);
                this.checkForComodification();
                this.lastRet = this.cursor;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
            catch (RemoteException rex) {
                rex.printStackTrace();
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        public void set(Object o) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                MdObjectListImpl.this.set(this.lastRet, o);
                this.expectedModCount = MdObjectListImpl.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
            catch (RemoteException rex) {
                rex.printStackTrace();
            }
        }

        public void add(Object o) {
            this.checkForComodification();
            try {
                MdObjectListImpl.this.add(this.cursor++, o);
                this.lastRet = -1;
                this.expectedModCount = MdObjectListImpl.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
            catch (RemoteException rex) {
                rex.printStackTrace();
            }
        }
    }

    protected class Itr
    implements Iterator {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        protected Itr() {
            this.expectedModCount = MdObjectListImpl.this.modCount;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.cursor != MdObjectListImpl.this.size();
            }
            catch (RemoteException rex) {
                rex.printStackTrace();
                return false;
            }
        }

        public Object next() {
            try {
                Object next = MdObjectListImpl.this.get(this.cursor);
                this.checkForComodification();
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
            catch (RemoteException rex) {
                rex.printStackTrace();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                MdObjectListImpl.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = MdObjectListImpl.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
            catch (RemoteException rex) {
                rex.printStackTrace();
            }
        }

        final void checkForComodification() {
            if (MdObjectListImpl.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

