/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.IMetadataTransport;
import com.sas.meta.SASOMI.IMetadataTransportHelper;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IOMIHelper;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurityAdmin;
import com.sas.meta.SASOMI.ISecurityAdminHelper;
import com.sas.meta.SASOMI.ISecurityHelper;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.meta.SASOMI.ISecurity_1_1Helper;
import com.sas.meta.SASOMI.IServer;
import com.sas.meta.SASOMI.IServerHelper;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectBase;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MetadataResource;
import com.sas.metadata.remote.UnsupportedPlatformVersionException;
import com.sas.net.brg.orb.BrgOrb;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ConnectionResources;
import com.sas.services.connection.Credential;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.MetadataClusterUtil;
import com.sas.services.connection.SecurityPackageCredential;
import com.sas.services.connection.Server;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ObjectImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
public class MdOMRConnectionImpl
implements MdOMRConnection,
Serializable {
    static final long serialVersionUID = 2860128513370614165L;
    public static final String WORKSPACECLASSID = "440196D4-90F0-11D0-9F41-00A024BB830C";
    protected MetadataResource bundle = null;
    protected IOMI m_pCMR = null;
    protected ArrayList<IWorkspace> workspaceArray = new ArrayList();
    protected DocumentBuilder m_docBuilder = null;
    protected DocumentBuilderFactory dbf = null;
    private MdOMRConnection m_singleton = null;
    private MdFactory m_factory = null;
    private ConnectionInterface OMRcx = null;
    private Map<String, String> m_credMap = null;
    private static Level log_level = Level.OFF;
    private ConnectionFactoryManager m_cxfManager = null;
    private boolean _remoteEnvironment = false;
    private static final String shortTemplate = "<Templates><Login Name=\"\" Password=\"\" UserID=\"\"><Domain/></Login><AuthenticationDomain Name=\"\"/><Identity><Logins/></Identity><Person><Logins/></Person><IdentityGroup><Logins/></IdentityGroup></Templates>";
    private static final int flags = 260;
    private static final String SUPPORTED_VERSIONS_PROPERTY = "sas.metadata.server.supported.versions";
    private static final int MINIMUM_SUPPORTED_VERSION = 9300;

    public MdOMRConnectionImpl(MdFactory mdFactory) throws RemoteException {
        this.bundle = new MetadataResource(MdOMRConnectionImpl.class);
        this.m_singleton = this;
        this.m_cxfManager = new ConnectionFactoryManager();
        this.m_factory = mdFactory;
        boolean bl = this._remoteEnvironment = mdFactory != null && mdFactory.isRemoteEnvironment();
        if (this._remoteEnvironment) {
            UnicastRemoteObject.exportObject(this);
        }
    }

    @Override
    public MdOMRConnection getConnection() throws RemoteException {
        return this.m_singleton;
    }

    @Override
    public IOMI getCMRHandle() throws RemoteException {
        return this.m_pCMR;
    }

    @Override
    public void setCMRHandle(IOMI pCMR) throws RemoteException {
        this.m_pCMR = pCMR;
    }

    @Override
    public IWorkspace getIOMHandle(int index) throws RemoteException {
        if (index < 0) {
            index = 0;
        }
        return this.workspaceArray.get(index);
    }

    @Override
    public IWorkspace getIOMHandle() throws RemoteException {
        return this.workspaceArray.get(0);
    }

    @Override
    public void setIOMHandle(IWorkspace work) throws RemoteException {
        this.workspaceArray.add(work);
    }

    @Override
    public void setIOMHandle(IWorkspace work, int index) throws RemoteException {
        this.workspaceArray.add(index, work);
    }

    @Override
    public void closeIOMHandle() throws RemoteException {
        IWorkspace iWorkspace = this.workspaceArray.get(0);
        this.workspaceArray.set(0, null);
        this.closeConnectionObject((Object)iWorkspace);
    }

    @Override
    public DocumentBuilder getDocumentBuilder() throws RemoteException {
        if (this.dbf == null) {
            this.setupDocumentBuilder();
        }
        DocumentBuilder m_docBuilder = null;
        try {
            m_docBuilder = this.dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return m_docBuilder;
    }

    @Override
    public void setupDocumentBuilder() throws RemoteException {
        if (this.dbf == null) {
            this.dbf = DocumentBuilderFactory.newInstance();
        }
    }

    @Override
    public IOMI makeOMRConnection(String cmrHost, String cmrPort, String cmrUserName, String cmrPassword) throws RemoteException, MdException {
        String[] credential = new String[]{cmrUserName, cmrPassword};
        IOMI iOMI = this.makeOMRConnection(cmrHost, cmrPort, credential, null);
        return iOMI;
    }

    @Override
    public IOMI makeOMRConnectionUsingSecurityPackage(String cmrHost, String cmrPort, String cmrSecurityPackageList, String cmrSPN) throws RemoteException, MdException {
        String[] securityPackage = new String[]{cmrSecurityPackageList, cmrSPN};
        IOMI iOMI = this.makeOMRConnection(cmrHost, cmrPort, null, securityPackage);
        return iOMI;
    }

    @Override
    public Map<String, String> getCredentialMap() throws RemoteException {
        return this.m_credMap;
    }

    @Override
    public void closeOMRConnection() throws RemoteException {
        if (this.m_pCMR != null) {
            this.m_pCMR._release();
            this.m_pCMR = null;
        }
        if (this.OMRcx != null) {
            this.OMRcx.close();
            this.OMRcx = null;
        }
    }

    @Override
    public void disconnectOMRConnection(IOMI iOMI) throws RemoteException, MdException {
        this.closeOMRConnection();
    }

    @Override
    public IWorkspace makeIOMConnection(String Host, String Port, String Username, String Password) throws RemoteException, MdException {
        String[] credential = new String[]{Username, Password};
        IWorkspace iWorkspace = this.makeIOMConnection(Host, Port, credential, null);
        return iWorkspace;
    }

    @Override
    public IWorkspace makeIOMConnectionUsingSecurityPackage(String Host, String Port, String SecurityPackageList, String SPN) throws RemoteException, MdException {
        String[] securityPackage = new String[]{SecurityPackageList, SPN};
        IWorkspace iWorkspace = this.makeIOMConnection(Host, Port, null, securityPackage);
        return iWorkspace;
    }

    @Override
    public void closeIOMConnection(IWorkspace workspace) throws RemoteException, MdException {
        this.closeConnection((Object)workspace);
    }

    @Override
    public void disconnectIOMConnection(IWorkspace workspace) throws RemoteException, MdException {
        this.disconnectConnection((Object)workspace);
    }

    @Override
    public IServer MakeIServerConnection() throws RemoteException, MdException {
        return this.MakeIServerConnection(this.m_pCMR);
    }

    @Override
    public IServer MakeIServerConnection(IOMI OMRConnection) throws RemoteException, MdException {
        try {
            if (OMRConnection != null) {
                Object obj = OMRConnection._duplicate();
                IServer iServer = IServerHelper.narrow((Object)obj);
                if (iServer != null) {
                    return iServer;
                }
                throw new MdException(this.bundle.getString("MdOMRConnectionImpl.UnableToConnectToServer.msg.txt") + this.bundle.getString("MdOMRConnectionImpl.MsgSeperator.msg.txt") + "UNKNOWN");
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return null;
    }

    @Override
    public IServer makeIServerConnection(String Host, String Port, String Username, String Password) throws RemoteException, MdException {
        String[] credential = new String[]{Username, Password};
        IServer iServer = this.makeIServerConnection(Host, Port, credential, null);
        return iServer;
    }

    @Override
    public IServer makeIServerConnectionUsingSecurityPackage(String Host, String Port, String SecurityPackageList, String SPN) throws RemoteException, MdException {
        String[] securityPackage = new String[]{SecurityPackageList, SPN};
        IServer iServer = this.makeIServerConnection(Host, Port, null, securityPackage);
        return iServer;
    }

    @Override
    public void closeIServerConnection(IServer serverConnection) throws RemoteException, MdException {
        this.closeConnection((Object)serverConnection);
    }

    @Override
    public void disconnectIServerConnection(IServer serverConnection) throws RemoteException, MdException {
        this.disconnectConnection((Object)serverConnection);
    }

    @Override
    public ISecurity_1_1 MakeISecurityConnection() throws RemoteException, MdException {
        return this.MakeISecurityConnection(this.m_pCMR);
    }

    @Override
    public ISecurity_1_1 MakeISecurityConnection(IOMI OMRConnection) throws RemoteException, MdException {
        try {
            if (OMRConnection != null) {
                Object obj = OMRConnection._duplicate();
                ISecurity_1_1 iSecurity = ISecurity_1_1Helper.narrow((Object)obj);
                if (iSecurity != null) {
                    return iSecurity;
                }
                throw new MdException(this.bundle.getString("MdOMRConnectionImpl.UnableToConnectToServer.msg.txt") + this.bundle.getString("MdOMRConnectionImpl.MsgSeperator.msg.txt") + "UNKNOWN");
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return null;
    }

    @Override
    public ISecurity_1_1 makeISecurityConnection(String Host, String Port, String Username, String Password) throws RemoteException, MdException {
        String[] credential = new String[]{Username, Password};
        ISecurity_1_1 iSecurity = this.makeISecurityConnection(Host, Port, credential, null);
        return iSecurity;
    }

    @Override
    public ISecurity_1_1 makeISecurityConnectionUsingSecurityPackage(String Host, String Port, String SecurityPackageList, String SPN) throws RemoteException, MdException {
        String[] securityPackage = new String[]{SecurityPackageList, SPN};
        ISecurity_1_1 iSecurity = this.makeISecurityConnection(Host, Port, null, securityPackage);
        return iSecurity;
    }

    @Override
    public void closeISecurityConnection(ISecurity secureConnection) throws RemoteException, MdException {
        this.closeConnection((Object)secureConnection);
    }

    @Override
    public void disconnectISecurityConnection(ISecurity secureConnection) throws RemoteException, MdException {
        this.disconnectConnection((Object)secureConnection);
    }

    @Override
    public ISecurityAdmin MakeISecurityAdminConnection(IOMI OMRConnection) throws RemoteException, MdException {
        try {
            if (OMRConnection != null) {
                Object obj = OMRConnection._duplicate();
                ISecurityAdmin iSecAdmin = ISecurityAdminHelper.narrow((Object)obj);
                if (iSecAdmin != null) {
                    return iSecAdmin;
                }
                throw new MdException(this.bundle.getString("MdOMRConnectionImpl.UnableToConnectToServer.msg.txt") + this.bundle.getString("MdOMRConnectionImpl.MsgSeperator.msg.txt") + this.bundle.getString("MdOMRConnectionImpl.NullOrbReturn.msg.txt"));
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return null;
    }

    @Override
    public ISecurityAdmin makeISecurityAdminConnection(String Host, String Port, String Username, String Password) throws RemoteException, MdException {
        String[] credential = new String[]{Username, Password};
        ISecurityAdmin iSecAdmin = this.makeISecurityAdminConnection(Host, Port, credential, null);
        return iSecAdmin;
    }

    @Override
    public ISecurityAdmin makeISecurityAdminConnectionUsingSecurityPackage(String Host, String Port, String SecurityPackageList, String SPN) throws RemoteException, MdException {
        String[] securityPackage = new String[]{SecurityPackageList, SPN};
        ISecurityAdmin iSecAdmin = this.makeISecurityAdminConnection(Host, Port, null, securityPackage);
        return iSecAdmin;
    }

    @Override
    public void closeISecurityAdminConnection(ISecurityAdmin secAdminConnection) throws RemoteException, MdException {
        this.closeConnection((Object)secAdminConnection);
    }

    @Override
    public void disconnectISecurityAdminConnection(ISecurityAdmin secAdminConnection) throws RemoteException, MdException {
        this.disconnectConnection((Object)secAdminConnection);
    }

    public IMetadataTransport makeIMetadataTransportConnection() throws RemoteException, MdException {
        return this.makeIMetadataTransportConnection(this.m_pCMR);
    }

    @Override
    public IMetadataTransport makeIMetadataTransportConnection(IOMI OMRConnection) throws RemoteException, MdException {
        try {
            if (OMRConnection != null) {
                Object obj = OMRConnection._duplicate();
                IMetadataTransport iTransport = IMetadataTransportHelper.narrow((Object)obj);
                if (iTransport != null) {
                    return iTransport;
                }
                throw new MdException(this.bundle.getString("MdOMRConnectionImpl.UnableToConnectToServer.msg.txt") + this.bundle.getString("MdOMRConnectionImpl.MsgSeperator.msg.txt") + "UNKNOWN");
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return null;
    }

    @Override
    public IMetadataTransport makeIMetadataTransportConnection(String Host, String Port, String Username, String Password) throws RemoteException, MdException {
        String[] credential = new String[]{Username, Password};
        IMetadataTransport iTransport = this.makeIMetadataTransportConnection(Host, Port, credential, null);
        return iTransport;
    }

    @Override
    public IMetadataTransport makeIMetadataTransportConnectionUsingSecurityPackage(String Host, String Port, String SecurityPackageList, String SPN) throws RemoteException, MdException {
        String[] securityPackage = new String[]{SecurityPackageList, SPN};
        IMetadataTransport iTransport = this.makeIMetadataTransportConnection(Host, Port, null, securityPackage);
        return iTransport;
    }

    private IMetadataTransport makeIMetadataTransportConnection(String host, String port, String[] credential, String[] securityPackage) throws MdException {
        ConnectionInterface cx = this.makeConnection("0217e202-b560-11db-ad91-001083ff6836", host, port, credential, securityPackage);
        Object obj = cx.getObject();
        IMetadataTransport iTransport = IMetadataTransportHelper.narrow((Object)obj);
        if (iTransport == null) {
            String msg = this.bundle.getString("MdOMRConnectionImpl.NullOrbReturn.msg.txt");
            throw new MdException(msg);
        }
        return iTransport;
    }

    @Override
    public void closeIMetadataTransportConnection(IMetadataTransport serverConnection) throws RemoteException, MdException {
        this.closeConnection((Object)serverConnection);
    }

    @Override
    public void disconnectIMetadataTransportConnection(IMetadataTransport serverConnection) throws RemoteException, MdException {
        this.disconnectConnection((Object)serverConnection);
    }

    public static String normalizeSecurityPackageList(String securityPackage, String securityPackageList) {
        return "Negotiate".equals(securityPackage) ? securityPackageList : securityPackage;
    }

    @Override
    public void dispose() throws RemoteException {
        this.bundle = null;
        this.m_docBuilder = null;
        this.dbf = null;
        if (this.m_pCMR != null) {
            this.m_pCMR._release();
        }
        this.m_pCMR = null;
        if (this.workspaceArray != null && this.workspaceArray.size() > 0) {
            this.workspaceArray.clear();
        }
        this.workspaceArray = null;
        if (this.OMRcx != null) {
            this.OMRcx.close();
        }
        this.OMRcx = null;
        this.m_singleton = null;
        if (this._remoteEnvironment) {
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
    }

    @Override
    public Properties getCMRProperties() throws RemoteException, MdException {
        MdObjectBase ID = null;
        try {
            int index;
            BrgOrb orb = (BrgOrb)((ObjectImpl)this.m_pCMR)._orb();
            Properties env = orb.objectToProperties((Object)this.m_pCMR);
            env.remove("logFile");
            String userName = (String)env.remove("userName");
            if (userName == null) {
                Properties properties = env;
                return properties;
            }
            if (userName.indexOf(64) > -1 && (index = userName.indexOf("@!*(generatedpassworddomain)*!")) > -1) {
                userName = userName.substring(0, index);
            }
            userName = userName.toLowerCase();
            ISecurity iSecurity = ISecurityHelper.narrow((Object)this.m_pCMR);
            StringHolder idHolder = new StringHolder();
            iSecurity.GetIdentity("", idHolder);
            String urn = idHolder.value;
            if (urn.indexOf("UNKNOWN") >= 0) {
                String message = this.bundle.getString("MdOMRConnectionImpl.NoIdentity.msg.txt");
                throw new MdException(message);
            }
            int slashIndex = urn.lastIndexOf(47);
            String type = urn.substring(7, slashIndex);
            String fqid = urn.substring(slashIndex + 1);
            MdOMIUtil omiUtil = this.m_factory.getOMIUtil();
            ID = (Identity)omiUtil.getMetadataAllDepths(null, type, fqid, null, null, shortTemplate, 260);
            AssociationList logins = ID.getLogins();
            String domain = null;
            if (logins != null) {
                int size = logins.size();
                for (int i = 0; i < size; ++i) {
                    Login login = (Login)logins.get(i);
                    String userID = login.getUserID();
                    if (!userName.equals(userID = userID.toLowerCase())) continue;
                    AuthenticationDomain authDomain = login.getDomain();
                    if (authDomain == null) break;
                    domain = authDomain.getName();
                    break;
                }
            }
            env.put("domain", domain != null ? domain : "");
            Properties properties = env;
            return properties;
        }
        catch (SystemException se) {
            throw new MdException(se);
        }
        catch (GenericError ge) {
            throw new MdException(ge);
        }
        catch (InvalidCredHandle iche) {
            throw new MdException(iche);
        }
        finally {
            if (ID != null) {
                ID.getObjectStore().dispose();
            }
        }
    }

    public static void configLogger(String factoryName) {
        final Logger logger = Logger.getLogger(factoryName);
        PrivilegedAction action = new PrivilegedAction(){

            public java.lang.Object run() {
                logger.setLevel(log_level);
                return null;
            }
        };
        try {
            AccessController.doPrivileged(action);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public String getPauseComment() throws MdException, RemoteException {
        String comment = "";
        IServer serverConn = null;
        try {
            serverConn = this.MakeIServerConnection(this.getCMRHandle());
            StringHolder output = new StringHolder();
            serverConn.Status("<PauseComment/>", output, "");
            Document doc = this.m_factory.getOMIUtil().parseXML(output.value);
            NodeList list = doc.getElementsByTagName("PauseComment");
            Node listitem = list.item(0);
            NodeList clist = listitem.getChildNodes();
            Node cvalue = clist.item(0);
            String sComment = cvalue.getNodeValue();
            if (sComment != null) {
                comment = sComment;
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (serverConn != null) {
                this.closeIServerConnection(serverConn);
            }
        }
        return comment;
    }

    @Override
    public boolean isServerPaused() throws MdException, RemoteException {
        return this.getServerStatus() == 1;
    }

    @Override
    public int getServerStatus() throws MdException, RemoteException {
        try {
            IServer serverConn = this.MakeIServerConnection(this.getCMRHandle());
            return this.getServerStatus(serverConn);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    @Override
    public int getServerStatus(IServer serverConn) throws MdException, RemoteException {
        int iStatus = 0;
        try {
            StringHolder outStatus = new StringHolder();
            serverConn.Status("<State/>", outStatus, "");
            String sStatus = outStatus.value;
            String s1 = "<State>";
            String s2 = "</State>";
            sStatus = sStatus.substring(sStatus.indexOf(s1) + s1.length(), sStatus.indexOf(s2));
            iStatus = Integer.parseInt(sStatus);
        }
        catch (Exception e) {
            iStatus = -1;
        }
        return iStatus;
    }

    @Override
    public Document getServerStatus(String request) throws MdException, RemoteException {
        try {
            StringHolder response = new StringHolder();
            this.MakeIServerConnection(this.getCMRHandle()).Status(request, response, "");
            String xml = "<Metadata>" + response.value + "</Metadata>";
            return this.m_factory.getOMIUtil().parseXML(xml);
        }
        catch (GenericError e) {
            throw new MdException(e);
        }
    }

    @Override
    public int getVersionCompatibility(IServer serverConn) throws MdException, RemoteException {
        try {
            String returnvalue = this.getServerModelVersion(serverConn);
            double value = Double.parseDouble(returnvalue);
            double jvalue = Double.parseDouble("6.00");
            if (value > jvalue) {
                return 1;
            }
            if (value < jvalue) {
                return -1;
            }
            return 0;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    @Override
    public int getVersionCompatibility() throws MdException, RemoteException {
        try {
            IServer serverConn = this.MakeIServerConnection(this.getCMRHandle());
            return this.getVersionCompatibility(serverConn);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    @Override
    public String getServerModelVersion() throws MdException, RemoteException {
        if (this.m_pCMR != null) {
            IServer serverConn = this.MakeIServerConnection(this.getCMRHandle());
            return this.getServerModelVersion(serverConn);
        }
        return "-1";
    }

    @Override
    public String getServerModelVersion(IServer serverConn) throws MdException, RemoteException {
        String returnValue = "";
        StringHolder outVersion = new StringHolder();
        try {
            serverConn.Status("<ModelVersion/>", outVersion, "");
            String sStatus = outVersion.value;
            String s1 = "<ModelVersion>";
            String s2 = "</ModelVersion>";
            returnValue = sStatus.substring(sStatus.indexOf(s1) + s1.length(), sStatus.indexOf(s2));
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return returnValue;
    }

    @Override
    public String getServerVersion(IServer serverConn) throws MdException, RemoteException {
        StringHolder output = new StringHolder();
        String input = new String("<Version/>");
        String returnvalue = "";
        try {
            serverConn.Status(input, output, "");
            Document doc = this.m_factory.getOMIUtil().parseXML(output.value);
            NodeList list = doc.getElementsByTagName("Version");
            Node listitem = list.item(0);
            NodeList clist = listitem.getChildNodes();
            Node cvalue = clist.item(0);
            returnvalue = cvalue.getNodeValue();
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return returnvalue;
    }

    @Override
    public String getCurrentServerVerion() throws MdException, RemoteException {
        if (this.m_pCMR != null) {
            IServer serverConn = this.MakeIServerConnection(this.m_pCMR);
            return this.getServerVersion(serverConn);
        }
        return "-1";
    }

    @Override
    public int getPlatformVersion() throws MdException, RemoteException {
        try {
            IServer serverConn = this.MakeIServerConnection(this.getCMRHandle());
            return this.getPlatformVersion(serverConn);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    @Override
    public int getPlatformVersion(IServer serverConn) throws MdException, RemoteException {
        StringHolder output = new StringHolder();
        String input = "<PlatformVersion/>";
        int version = 0;
        try {
            String s;
            serverConn.Status("<PlatformVersion/>", output, "");
            Document doc = this.m_factory.getOMIUtil().parseXML(output.value);
            NodeList nodeList = doc.getElementsByTagName("PlatformVersion");
            Node node = nodeList.item(0);
            NodeList childList = node.getChildNodes();
            Node childNode = childList.item(0);
            if (childNode != null && (s = childNode.getNodeValue()) != null && s.length() > 0) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    if (c == '.') continue;
                    sb.append(c);
                }
                version = Integer.parseInt(sb.toString());
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return version;
    }

    @Override
    public Identity getIdentityOfUserConnected(MdStore store, String reposID) throws MdException, RemoteException {
        if (this.m_pCMR == null) {
            return null;
        }
        try {
            String type;
            String options;
            String repositoryID;
            ISecurity iSecurity = ISecurityHelper.narrow((Object)this.m_pCMR);
            StringHolder idHolder = new StringHolder();
            iSecurity.GetIdentity("", idHolder);
            String value = idHolder.value;
            int flags = 392;
            if (value.indexOf("UNKNOWN") >= 0) {
                repositoryID = reposID;
                options = "<XMLSELECT Search=\"@Name='PUBLIC'\"/>";
                flags |= 0x2000;
                type = "IdentityGroup";
            } else {
                int index = value.lastIndexOf(47);
                String strFQID = value.substring(index + 1);
                repositoryID = "A0000001." + value.substring(index + 1, index + 9);
                options = "<XMLSELECT Search=\"@Id='" + strFQID + "'\"/>";
                flags |= 0x10;
                type = "Identity";
            }
            List objects = this.m_factory.getOMIUtil().getMetadataObjectsSubset(store, repositoryID, type, flags, options, false);
            return objects.size() > 0 ? (Identity)objects.get(0) : null;
        }
        catch (InvalidCredHandle ice) {
            throw new MdException(ice);
        }
        catch (GenericError ge) {
            throw new MdException(ge);
        }
    }

    @Override
    public Level getMessageLevel() throws RemoteException {
        return log_level;
    }

    @Override
    public void setMessageLevel(Level inLevel) throws RemoteException {
        log_level = inLevel;
    }

    @Override
    public void setConnectionResources(ConnectionResources cxResources) throws RemoteException {
        this.m_cxfManager.setConnectionResources(cxResources);
    }

    @Override
    public ConnectionResources getConnectionResources() throws RemoteException {
        ConnectionResources cxResources = this.m_cxfManager.getConnectionResources();
        return cxResources;
    }

    private IOMI makeOMRConnection(String cmrHost, String cmrPort, String[] cmrCredential, String[] cmrSecurityPackage) throws MdException, RemoteException {
        ConnectionInterface cx;
        this.OMRcx = cx = this.makeConnection("0217e202-b560-11db-ad91-001083ff6836", cmrHost, cmrPort, cmrCredential, cmrSecurityPackage);
        Object obj = cx.getObject();
        IOMI iomiHandle = IOMIHelper.narrow((Object)obj);
        if (iomiHandle != null) {
            this.m_pCMR = iomiHandle;
            try {
                this.validatePlatformVersion();
            }
            catch (UnsupportedPlatformVersionException e) {
                this.closeOMRConnection();
                throw e;
            }
            this.m_credMap = new HashMap<String, String>(4);
            this.m_credMap.put("Hostname", cmrHost);
            this.m_credMap.put("Port", cmrPort);
            if (cmrCredential != null) {
                this.m_credMap.put("Username", cmrCredential[0]);
                this.m_credMap.put("Password", cmrCredential[1]);
            } else {
                this.m_credMap.put("SecurityPackage", cmrSecurityPackage[0]);
                this.m_credMap.put("SPN", cmrSecurityPackage[1]);
            }
        } else {
            this.m_credMap = new HashMap<String, String>();
            String msg = this.bundle.getString("MdOMRConnectionImpl.NullOrbReturn.msg.txt");
            throw new MdException(msg);
        }
        return iomiHandle;
    }

    private IWorkspace makeIOMConnection(String host, String port, String[] credential, String[] securityPackage) throws MdException {
        ConnectionInterface cx = this.makeConnection("440196d4-90f0-11d0-9f41-00a024bb830c", host, port, credential, securityPackage);
        Object obj = cx.getObject();
        IWorkspace iWorkspace = IWorkspaceHelper.narrow((Object)obj);
        if (iWorkspace == null) {
            String msg = this.bundle.getString("MdOMRConnectionImpl.NullOrbReturn.msg.txt");
            throw new MdException(msg);
        }
        return iWorkspace;
    }

    private IServer makeIServerConnection(String host, String port, String[] credential, String[] securityPackage) throws MdException {
        ConnectionInterface cx = this.makeConnection("0217e202-b560-11db-ad91-001083ff6836", host, port, credential, securityPackage);
        Object obj = cx.getObject();
        IServer iServer = IServerHelper.narrow((Object)obj);
        if (iServer == null) {
            String msg = this.bundle.getString("MdOMRConnectionImpl.NullOrbReturn.msg.txt");
            throw new MdException(msg);
        }
        return iServer;
    }

    private ISecurity_1_1 makeISecurityConnection(String host, String port, String[] credential, String[] securityPackage) throws MdException {
        ConnectionInterface cx = this.makeConnection("0217e202-b560-11db-ad91-001083ff6836", host, port, credential, securityPackage);
        Object obj = cx.getObject();
        ISecurity_1_1 iSecurity = ISecurity_1_1Helper.narrow((Object)obj);
        if (iSecurity == null) {
            String msg = this.bundle.getString("MdOMRConnectionImpl.NullOrbReturn.msg.txt");
            throw new MdException(msg);
        }
        return iSecurity;
    }

    private ISecurityAdmin makeISecurityAdminConnection(String host, String port, String[] credential, String[] securityPackage) throws MdException {
        ConnectionInterface cx = this.makeConnection("0217e202-b560-11db-ad91-001083ff6836", host, port, credential, securityPackage);
        Object obj = cx.getObject();
        ISecurityAdmin iSecurityAdmin = ISecurityAdminHelper.narrow((Object)obj);
        if (iSecurityAdmin == null) {
            String msg = this.bundle.getString("MdOMRConnectionImpl.NullOrbReturn.msg.txt");
            throw new MdException(msg);
        }
        return iSecurityAdmin;
    }

    private ConnectionInterface makeConnection(String classID, String host, String port, String[] credential, String[] securityPackage) throws MdException {
        ManualConnectionFactoryConfiguration cxfConfig;
        if ("0217e202-b560-11db-ad91-001083ff6836".equalsIgnoreCase(classID)) {
            HashMap<String, String> options = new HashMap<String, String>();
            if (securityPackage != null) {
                options.put("sspipackagelist", securityPackage[0]);
                options.put("sspispn", securityPackage[1]);
            }
            Cluster cluster = MetadataClusterUtil.createCluster((String)host, (String)port, options);
            cxfConfig = new ManualConnectionFactoryConfiguration(cluster);
        } else {
            int iPort = Integer.parseInt(port);
            BridgeServer server = new BridgeServer(classID, host, iPort);
            if (securityPackage != null) {
                String spn;
                server.setSecurityPackage("Negotiate");
                String securityPackageList = securityPackage[0];
                if (securityPackageList != null) {
                    server.setSecurityPackageList(securityPackageList);
                }
                if ((spn = securityPackage[1]) != null) {
                    server.setSPN(spn);
                }
            }
            cxfConfig = new ManualConnectionFactoryConfiguration((Server)server);
        }
        String factoryName = this.m_cxfManager.getFactoryLoggerName((ConnectionFactoryConfiguration)cxfConfig);
        MdOMRConnectionImpl.configLogger(factoryName);
        ConnectionInterface cx = null;
        try {
            ConnectionFactoryInterface cxf = this.m_cxfManager.getFactory((ConnectionFactoryConfiguration)cxfConfig);
            if (securityPackage != null) {
                SecurityPackageCredential cred = SecurityPackageCredential.getInstance();
                cx = cxf.getConnection((Credential)cred);
            } else {
                String userName = credential[0];
                String password = credential[1];
                cx = cxf.getConnection(userName, password);
            }
        }
        catch (ConnectionFactoryException cfe) {
            throw new MdException(cfe);
        }
        return cx;
    }

    private void closeConnection(Object obj) throws MdException {
        try {
            this.closeConnectionObject(obj);
        }
        catch (SystemException se) {
            throw new MdException(se);
        }
    }

    private void closeConnectionObject(Object obj) {
        obj._release();
    }

    private void disconnectConnection(Object obj) throws MdException {
        try {
            ORB orb = ((ObjectImpl)obj)._orb();
            orb.shutdown(true);
        }
        catch (SystemException se) {
            throw new MdException(se);
        }
    }

    @Override
    public void validatePlatformVersion() throws MdException, RemoteException {
        int platformVersion = this.getPlatformVersion();
        String supportedVersions = System.getProperty(SUPPORTED_VERSIONS_PROPERTY);
        if (supportedVersions == null || supportedVersions.length() == 0) {
            if (platformVersion >= 9300) {
                return;
            }
        } else {
            String[] ranges = supportedVersions.split(";");
            try {
                for (String range : ranges) {
                    int max;
                    int min;
                    int dash = range.indexOf(45);
                    if (dash < 0) {
                        max = min = Integer.parseInt(range);
                    } else {
                        min = dash == 0 ? 0 : Integer.parseInt(range.substring(0, dash));
                        max = dash < range.length() - 1 ? Integer.parseInt(range.substring(dash + 1)) : Integer.MAX_VALUE;
                    }
                    if (platformVersion < min || platformVersion > max) continue;
                    return;
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid value for sas.metadata.server.supported.versions property: " + supportedVersions);
            }
        }
        throw new UnsupportedPlatformVersionException(platformVersion);
    }
}

