/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ConnectionUtil;
import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.MdDeletedObjectsHandler;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdGetObjectHandler;
import com.sas.metadata.remote.MdGetObjectNoCacheHandler;
import com.sas.metadata.remote.MdGetTypesHandler;
import com.sas.metadata.remote.MdOMIWrapper;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdServerStoreImpl;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdUpdateHandler;
import java.io.InputStream;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParserFactory;
import org.omg.CORBA.StringHolder;

@SASScope
public class MdOMIWrapperImpl
implements MdOMIWrapper,
Serializable {
    protected MdFactory m_factory = null;
    private SAXParserFactory m_parserFactory = null;
    public static final Pattern m_idPattern = Pattern.compile("(?:Id)=\"([0-9a-zA-Z.$]+)\"");
    protected static final Pattern m_delObjectsPattern = Pattern.compile("<DeletedObjects/>");
    private static final String UPDATE_METADATA_TAG = "<UpdateMetadata>";

    public MdOMIWrapperImpl(MdFactory inFactory) throws RemoteException {
        this.m_factory = inFactory;
        this.m_parserFactory = SAXParserFactory.newInstance();
        this.m_parserFactory.setNamespaceAware(false);
        this.m_parserFactory.setValidating(false);
        if (this.m_factory.isRemoteEnvironment()) {
            UnicastRemoteObject.exportObject(this);
        }
    }

    @Override
    public void getTypes(IOMI connectionHandle, List<String> nameList, List<String> descList) throws MdException, RemoteException {
        MdGetTypesHandler myHandler = null;
        StringHolder outXML = new StringHolder();
        StringBuffer inputXML = new StringBuffer(67);
        inputXML.append("<GetTypes><Types/><NS>");
        inputXML.append(this.m_factory.getOMIUtil().getNamespace());
        inputXML.append("</NS><Flags>0</Flags><Options/></GetTypes>");
        this.m_factory.getUtil().printLoglnClient(inputXML.toString());
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getInstance().getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            connectionHandle.GetTypes(outXML, this.m_factory.getOMIUtil().getNamespace(), 0, "");
            if (this.m_factory.getInstance().getPerf()) {
                t1 = System.currentTimeMillis();
                this.m_factory.getUtil().printPerfln(Thread.currentThread().getName() + ",GetTypes," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            }
            String strXML = outXML.value;
            this.m_factory.getUtil().printLoglnServer(strXML);
            myHandler = new MdGetTypesHandler(nameList, descList, this.m_parserFactory);
            myHandler.parseXML(strXML);
            nameList = myHandler.getObjectTypes();
            descList = myHandler.getObjectDescriptions();
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this.m_factory, e)) {
                this.getTypes(this.m_factory.getConnection().getCMRHandle(), nameList, descList);
                return;
            }
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }

    @Override
    public int updateMetadata(String inXML, int iFlags) throws MdException, RemoteException {
        StringHolder outXML = new StringHolder();
        if ((iFlags & 0x10000000) == 0) {
            iFlags |= 0x10000000;
        }
        int rc = 0;
        this.m_factory.getUtil().printLoglnClient(inXML);
        long t0 = System.currentTimeMillis();
        try {
            rc = this.m_factory.getConnection().getCMRHandle().UpdateMetadata(inXML, outXML, this.m_factory.getOMIUtil().getNamespace(), iFlags, "");
            if (rc != 0) {
                this.m_factory.getUtil().printOutputln("Bad Update! rc = " + rc);
            }
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this.m_factory, e)) {
                return this.updateMetadata(inXML, iFlags);
            }
            throw new MdException(e);
        }
        long t1 = System.currentTimeMillis();
        this.m_factory.getUtil().printPerfln(Thread.currentThread().getName() + ",UpdateMetadata," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        this.m_factory.getUtil().printLoglnServer(outXML.value);
        return rc;
    }

    @Override
    public AssociationList getAssociatedObjects(CMetadata object, String strAssociation, String strTemplate, boolean doNotOverrideAssocs) throws MdException, RemoteException {
        ArrayList<String> inXMLComplex = new ArrayList<String>(1);
        inXMLComplex.add(strAssociation);
        int options = 2056;
        if (strTemplate != null && strTemplate.length() > 0) {
            options |= 4;
        }
        List<String> attributes = null;
        if (this.m_factory.getDebug()) {
            this.m_factory.getUtil().printOutputln("DEBUG NOTE: GetAssociatedObjects going to the server for association " + strAssociation + " (Object Type: " + object.getCMetadataType() + ")");
        }
        if (object == null || object.getFQID().indexOf(36) > -1 || !object.getObjectStore().isGoToServerForMetadata()) {
            this.m_factory.getUtil().printOutputln(this.m_factory.getBundle().getString("MetadataUtil.getMetadataAllDepthsNotToServer.txt"));
            return object.getMdObjectAssociation(strAssociation);
        }
        String inXML = this.m_factory.getOMIUtil().createGetXMLString(object.getCMetadataType(), object.getFQID(), attributes, inXMLComplex);
        String outXMLString = this.getMetadataFromServer(this.m_factory.getConnection().getCMRHandle(), inXML, options, strTemplate);
        if (object.getObjectStore() == null) {
            object = this.m_factory.createComplexMetadataObjectServerStoreOnly(object.getName(), object.getCMetadataType(), object.getFQID());
        }
        MdGetObjectHandler myHandler = null;
        AssociationList associatedObjectList = null;
        try {
            myHandler = new MdGetObjectHandler(object.getObjectStore(), this.m_parserFactory);
            if (!doNotOverrideAssocs) {
                myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS);
            }
            myHandler.parseXML(outXMLString);
            if (object.getObjectStore().getStoreType() == 0) {
                object.resetObject();
            }
            object = (CMetadata)myHandler.getRootLevelCreatedObjects().get(0);
            Pattern assocPattern = Pattern.compile("<" + strAssociation + ">");
            Matcher m = assocPattern.matcher(outXMLString);
            if (m.find()) {
                associatedObjectList = object.getMdObjectAssociation(strAssociation);
                if (object.getObjectStore().isGoToServerForMetadata()) {
                    associatedObjectList.setState(1);
                }
            } else {
                associatedObjectList = new AssociationList(strAssociation, this.m_factory.isRemoteEnvironment());
                associatedObjectList.setState(1);
                object.setMdObjectAssociation(associatedObjectList);
            }
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return associatedObjectList;
    }

    @Override
    public CMetadata getFullObject(MdObjectStore store, CMetadata meta) throws MdException, RemoteException {
        if (meta == null) {
            return meta;
        }
        return this.getFullObject(store, meta.getCMetadataType(), meta.getId());
    }

    @Override
    public CMetadata getFullObject(MdObjectStore store, String objectType, String objectID) throws MdException, RemoteException {
        MdGetObjectHandler myHandler = null;
        CMetadata object = null;
        try {
            String inXML = this.m_factory.getOMIUtil().createGetXMLString(objectType, objectID, null, null);
            int flags = 2058;
            String returnXML = this.getMetadataFromServer(this.m_factory.getConnection().getCMRHandle(), inXML, flags, "");
            myHandler = new MdGetObjectHandler(store, this.m_parserFactory);
            myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS);
            myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ATTRIBUTES);
            myHandler.parseXML(returnXML);
            object = store.getObject(objectID);
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return object;
    }

    @Override
    public List getFullObjects(MdObjectStore store, Map<String, String> objectMap) throws MdException, RemoteException {
        if (objectMap == null || objectMap.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        MdGetObjectHandler myHandler = null;
        try {
            String inXML = this.m_factory.getOMIUtil().createGetXMLString(objectMap);
            int flags = 2058;
            StringBuilder sb = new StringBuilder();
            sb.append("<Metadata>");
            sb.append(this.getMetadataFromServer(this.m_factory.getConnection().getCMRHandle(), inXML, flags, ""));
            sb.append("</Metadata>");
            myHandler = new MdGetObjectHandler(store, this.m_parserFactory);
            myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS);
            myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ATTRIBUTES);
            myHandler.parseXML(sb.toString());
            ArrayList arrayList = new ArrayList(myHandler.getRootLevelCreatedObjects());
            return arrayList;
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }

    @Override
    public CMetadata getMetadataAllDepths(MdStore inStore, String strType, String strFQID, List<String> inSimpleAttr, List<String> inComplexObject, String strTemplate, int iOptions, boolean doNotOverrideAssocs, boolean doNotOverrideAttrs) throws MdException, RemoteException {
        if (inStore == null) {
            inStore = this.m_factory.getStore();
        }
        MdGetObjectHandler myHandler = null;
        CMetadata object = null;
        try {
            String inXML = this.m_factory.getOMIUtil().createGetXMLString(strType, strFQID, inSimpleAttr, inComplexObject);
            String returnXML = this.getMetadataFromServer(this.m_factory.getConnection().getCMRHandle(), inXML, iOptions, strTemplate);
            myHandler = new MdGetObjectHandler(inStore, this.m_parserFactory);
            if (!doNotOverrideAssocs) {
                myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS);
            }
            if (!doNotOverrideAttrs) {
                myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ATTRIBUTES);
            }
            myHandler.parseXML(returnXML);
            object = inStore.getStoreType() == 1 ? inStore.getObject(strFQID) : ((MdServerStoreImpl)inStore).getObjectFromServerStoreOnly(strFQID);
            if (inStore.getStoreType() == 0) {
                object.resetObject();
            }
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return object;
    }

    @Override
    public CMetadata getMetadataAllDepths(CMetadata object, List<String> inSimpleAttr, List<String> inComplexObject, String strTemplate, int iOptions, boolean doNotOverrideAssocs) throws MdException, RemoteException {
        if (object == null || object.getFQID().indexOf(36) > -1 || !object.getObjectStore().isGoToServerForMetadata()) {
            this.m_factory.getUtil().printOutputln(this.m_factory.getBundle().getString("MdOMIUtil.getMetadataAllDepthsNotToServer.txt"));
            return object;
        }
        MdGetObjectHandler myHandler = null;
        try {
            String inXML = this.m_factory.getOMIUtil().createGetXMLString(object.getCMetadataType(), object.getFQID(), inSimpleAttr, inComplexObject);
            String returnXML = this.getMetadataFromServer(this.m_factory.getConnection().getCMRHandle(), inXML, iOptions, strTemplate);
            myHandler = new MdGetObjectHandler(object.getObjectStore(), this.m_parserFactory);
            if (!doNotOverrideAssocs) {
                myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS);
            }
            myHandler.parseXML(returnXML);
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return object;
    }

    @Override
    public List getMetadata(IOMI connectionHandle, MdStore store, Map objectMap, String template, int flags, boolean doNotOverrideAssocs, boolean doNotOverrideAttrs) throws MdException, RemoteException {
        MdGetObjectHandler myHandler = null;
        try {
            if (store == null) {
                store = this.m_factory.getStore();
            }
            if (objectMap == null || objectMap.size() == 0 || !store.isGoToServerForMetadata()) {
                this.m_factory.getUtil().printOutputln("Debug Note: getMetadata not going to server...");
                ArrayList arrayList = new ArrayList();
                return arrayList;
            }
            String inXML = this.m_factory.getOMIUtil().createGetXMLString(objectMap);
            StringBuffer returnXML = new StringBuffer();
            returnXML.append("<Metadata>");
            returnXML.append(this.getMetadataFromServer(connectionHandle, inXML, flags, template));
            returnXML.append("</Metadata>");
            myHandler = new MdGetObjectHandler(store, this.m_parserFactory);
            if (!doNotOverrideAssocs) {
                myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS);
            }
            if (!doNotOverrideAttrs) {
                myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ATTRIBUTES);
            }
            myHandler.parseXML(returnXML.toString());
            ArrayList arrayList = new ArrayList(myHandler.getRootLevelCreatedObjects());
            return arrayList;
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }

    @Override
    public List getMetadataObjectsSubset(IOMI connectionHandle, MdStore inStore, String strReposID, String strType, int flags, String options, boolean doOverrideAssocs) throws MdException, RemoteException {
        MdStore store = inStore;
        MdGetObjectHandler myHandler = null;
        Vector retList = null;
        try {
            if (store == null) {
                store = this.m_factory.getStore();
            }
            if (!store.isGoToServerForMetadata()) {
                this.m_factory.getUtil().printOutputln("Debug Note: getMetadataObjectsSubset Not going to server...");
                Vector vector = new Vector();
                return vector;
            }
            String outXMLString = this.getMetadataObjectsFromServer(connectionHandle, strReposID, strType, flags, options);
            myHandler = new MdGetObjectHandler(store, this.m_parserFactory);
            if (!doOverrideAssocs) {
                myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS);
            }
            myHandler.parseXML(outXMLString);
            retList = new Vector(myHandler.getRootLevelCreatedObjects());
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return retList;
    }

    @Override
    public String DoRequest(IOMI connectionHandle, String inXML, boolean fUpdateIds) throws MdException, RemoteException {
        this.m_factory.getUtil().printLoglnClient(inXML);
        StringHolder outXML = new StringHolder();
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        MdUpdateHandler myHandler = null;
        try {
            List<String> deletedObjectsList;
            List<String> updateList;
            if (connectionHandle == null) {
                throw new IllegalStateException(this.m_factory.getBundle().getString("MdOMIUtil.NoServerConnection.txt"));
            }
            connectionHandle.DoRequest(inXML, outXML);
            if (this.m_factory.getPerf()) {
                t1 = System.currentTimeMillis();
                this.m_factory.getUtil().printPerfln(Thread.currentThread().getName() + ",DoRequest," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            }
            String outXMLString = outXML.value;
            this.m_factory.getUtil().printLoglnServer(outXMLString);
            myHandler = new MdUpdateHandler(this.m_parserFactory);
            myHandler.parseXML(outXMLString);
            Map<String, String> deleteMap = myHandler.getDeleteMetadataMap();
            if (deleteMap != null) {
                this.m_factory.deleteObjectsFromStores(deleteMap);
            }
            if ((updateList = myHandler.getUpdatedObjectsList()) != null && fUpdateIds) {
                this.updateObjectIds(inXML, updateList);
            }
            if ((deletedObjectsList = myHandler.getDeletedObjectsList()) != null) {
                this.processDeletedObjects(deletedObjectsList);
            }
            String string = outXMLString;
            return string;
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this.m_factory, e) && this.m_factory.getConnection() != null) {
                String string = this.DoRequest(this.m_factory.getConnection().getCMRHandle(), inXML, fUpdateIds);
                return string;
            }
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }

    @Override
    public void processDeletedObjects(String inXML) throws MdException, RemoteException {
        Matcher matcher = m_delObjectsPattern.matcher(inXML);
        if (matcher.find()) {
            return;
        }
        MdDeletedObjectsHandler myHandler = null;
        try {
            myHandler = new MdDeletedObjectsHandler(this.m_parserFactory);
            myHandler.parseXML(inXML);
            List<String> deletedObjects = myHandler.getDeletedObjects();
            int size = deletedObjects.size();
            for (int i = 0; i < size; ++i) {
                String toDelete = deletedObjects.get(i);
                this.m_factory.deleteDetailMetadataObject(toDelete);
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }

    @Override
    @Deprecated
    public Map getMetadataNoCache(String strType, String strFQID, String strOptions, int iFlags) throws MdException, RemoteException {
        return this.getFastMetadata(strType, strFQID, strOptions, iFlags);
    }

    @Override
    public FastMetadata getFastMetadata(String strType, String strFQID, String strOptions, int iFlags) throws MdException, RemoteException {
        MdGetObjectHandler myHandler = null;
        FastMetadata objectMap = new FastMetadata();
        StringBuffer inXML = new StringBuffer(40);
        inXML.append("<");
        inXML.append(strType);
        inXML.append(" Id=\"");
        inXML.append(strFQID);
        inXML.append("\"/>");
        try {
            String outXMLString = this.getMetadataFromServer(this.m_factory.getConnection().getCMRHandle(), inXML.toString(), iFlags, strOptions);
            myHandler = new MdGetObjectNoCacheHandler(this.m_parserFactory);
            myHandler.parseXML(outXMLString);
            if (myHandler.getRootLevelCreatedObjects().size() > 0) {
                objectMap = (FastMetadata)myHandler.getRootLevelCreatedObjects().get(0);
            }
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return objectMap;
    }

    @Override
    @Deprecated
    public List getMetadataNoCache(Map objectMap, String strOptions, int iFlags) throws MdException, RemoteException {
        return this.getFastMetadata(objectMap, strOptions, iFlags);
    }

    @Override
    public List<FastMetadata> getFastMetadata(Map<String, String> objectMap, String strOptions, int iFlags) throws MdException, RemoteException {
        MdGetObjectHandler myHandler = null;
        ArrayList<FastMetadata> objectList = null;
        String inXML = this.m_factory.getOMIUtil().createGetXMLString(objectMap);
        try {
            String xml = this.getMetadataFromServer(this.m_factory.getConnection().getCMRHandle(), inXML, iFlags, strOptions);
            StringBuffer sb = new StringBuffer(21 + xml.length());
            sb.append("<Metadata>");
            sb.append(xml);
            sb.append("</Metadata>");
            myHandler = new MdGetObjectNoCacheHandler(this.m_parserFactory);
            myHandler.parseXML(sb.toString());
            objectList = new ArrayList<FastMetadata>(myHandler.getRootLevelCreatedObjects());
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return objectList;
    }

    @Override
    @Deprecated
    public List getMetadataObjectsNoCache(String strType, String strReposId, String strOptions, int iFlags) throws MdException, RemoteException {
        return this.getFastMetadataObjects(strType, strReposId, strOptions, iFlags);
    }

    @Override
    public List<FastMetadata> getFastMetadataObjects(String strType, String strReposId, String strOptions, int iFlags) throws MdException, RemoteException {
        MdGetObjectHandler myHandler = null;
        ArrayList<FastMetadata> objectList = null;
        try {
            String outXMLString = this.getMetadataObjectsFromServer(this.m_factory.getConnection().getCMRHandle(), strReposId, strType, iFlags, strOptions);
            myHandler = new MdGetObjectNoCacheHandler(this.m_parserFactory);
            myHandler.parseXML(outXMLString);
            objectList = new ArrayList<FastMetadata>(myHandler.getRootLevelCreatedObjects());
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return objectList;
    }

    @Override
    public List getMetadataObjects(IOMI connectionHandle, String strReposID, String strType, int flags, String strOptions) throws MdException, RemoteException {
        MdGetObjectHandler myHandler = null;
        Vector retList = null;
        try {
            String outXMLString = this.getMetadataObjectsFromServer(connectionHandle, strReposID, strType, flags, strOptions);
            myHandler = new MdGetObjectHandler(this.m_factory.getStore(), this.m_parserFactory);
            myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ATTRIBUTES);
            myHandler.setFlag(MdGetObjectHandler.CREATE_SIMPLE_OBJECTS_ONLY);
            myHandler.parseXML(outXMLString);
            retList = new Vector(myHandler.getRootLevelCreatedObjects());
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return retList;
    }

    @Override
    public void populateStoreFromString(MdStore inStore, String inXML, int state, boolean useReposForNewObjects) throws MdException, RemoteException {
        MdGetObjectHandler myHandler = null;
        try {
            MdStore store = inStore;
            if (inStore == null) {
                store = this.m_factory.getStore();
            }
            myHandler = new MdGetObjectHandler(store, this.m_parserFactory);
            myHandler.setFlag(MdGetObjectHandler.MDSTORE_XML);
            if (state == 1) {
                myHandler.setFlag(MdGetObjectHandler.LOCAL_STATE_ON);
            }
            myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS | MdGetObjectHandler.OVERRIDE_LOCALLYSET_ATTRIBUTES);
            myHandler.parseXML(inXML);
            List createdObjects = myHandler.getObjectCreatedList();
            if (useReposForNewObjects) {
                for (CMetadata listObject : createdObjects) {
                    if (!listObject.isNewObject()) continue;
                    String newId = listObject.getObjectStore().makeID(listObject.getFQID().substring(0, 8));
                    this.m_factory.changeHashKey(listObject.getId(), newId);
                }
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }

    @Override
    public void populateStoreFromInputStream(MdStore inStore, InputStream stream, int state, boolean useReposForNewObjects) throws MdException, RemoteException {
        MdStore store = inStore;
        if (inStore == null) {
            store = this.m_factory.getStore();
        }
        MdGetObjectHandler myHandler = null;
        try {
            myHandler = new MdGetObjectHandler(store, this.m_parserFactory);
            myHandler.setFlag(MdGetObjectHandler.MDSTORE_XML);
            if (state == 1) {
                myHandler.setFlag(MdGetObjectHandler.LOCAL_STATE_ON);
            }
            myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS | MdGetObjectHandler.OVERRIDE_LOCALLYSET_ATTRIBUTES);
            myHandler.parseXML(stream);
            List createdObjects = myHandler.getObjectCreatedList();
            if (useReposForNewObjects) {
                for (CMetadata listObject : createdObjects) {
                    if (!listObject.isNewObject()) continue;
                    String newId = listObject.getObjectStore().makeID(listObject.getFQID().substring(0, 8));
                    this.m_factory.changeHashKey(listObject.getId(), newId);
                }
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }

    @Override
    public List getMetadataObjectsSubsetList(IOMI connectionHandle, MdStore inStore, String strReposID, String strType, int flags, String options, boolean doOverrideAssocs) throws MdException, RemoteException {
        MdGetObjectHandler myHandler = null;
        ArrayList retList = null;
        try {
            MdStore store = inStore;
            if (store == null) {
                store = this.m_factory.getStore();
            }
            if (store != null && !store.isDisposed() && !store.isGoToServerForMetadata()) {
                this.m_factory.getUtil().printOutputln("Debug Note: getMetadataObjectsSubsetList() Not going to server...");
                ArrayList arrayList = new ArrayList();
                return arrayList;
            }
            String outXMLString = this.getMetadataObjectsFromServer(connectionHandle, strReposID, strType, flags, options);
            myHandler = new MdGetObjectHandler(store, this.m_parserFactory);
            if (!doOverrideAssocs) {
                myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS);
            }
            myHandler.parseXML(outXMLString);
            retList = new ArrayList(myHandler.getObjectCreatedList());
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return retList;
    }

    @Override
    public List getMetadataObjects(IOMI connectionHandle, MdStore inStore, String inXML, String strTemplate, int iFlags, boolean doNotOverrideAssocs) throws MdException, RemoteException {
        MdGetObjectHandler myHandler = null;
        Vector retList = null;
        try {
            MdStore store = inStore;
            if (store == null) {
                store = this.m_factory.getStore();
            }
            if (store != null && !store.isDisposed() && !store.isGoToServerForMetadata()) {
                this.m_factory.getUtil().printOutputln("Debug Note: getMetadataObjects Not going to server...");
                Vector vector = new Vector();
                return vector;
            }
            String xml = this.getMetadataFromServer(connectionHandle, inXML, iFlags, strTemplate);
            StringBuffer sb = new StringBuffer(21 + xml.length());
            sb.append("<Metadata>");
            sb.append(xml);
            sb.append("</Metadata>");
            myHandler = new MdGetObjectHandler(store, this.m_parserFactory);
            if (!doNotOverrideAssocs) {
                myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS);
            }
            myHandler.parseXML(sb.toString());
            retList = new Vector(myHandler.getRootLevelCreatedObjects());
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return retList;
    }

    @Override
    public void refreshStoreFromServer(MdStore inStore, boolean includeLocallyChangedItems, boolean getFullObjectUpdate) throws MdException, RemoteException {
        MdGetObjectHandler myHandler = null;
        try {
            String updateXML = inStore.createRefreshXMLforStore(includeLocallyChangedItems, getFullObjectUpdate);
            int flags = 2304;
            if (getFullObjectUpdate) {
                flags |= 1;
            }
            String retXML = this.getMetadataFromServer(this.m_factory.getConnection().getCMRHandle(), updateXML, flags, "");
            StringBuffer outXMLBuffer = new StringBuffer(retXML.length() + 19);
            outXMLBuffer.append("<Objects>");
            outXMLBuffer.append(retXML);
            outXMLBuffer.append("</Objects>");
            myHandler = new MdGetObjectHandler(inStore, this.m_parserFactory);
            myHandler.setFlag(MdGetObjectHandler.MDSTORE_XML);
            myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS | MdGetObjectHandler.OVERRIDE_LOCALLYSET_ATTRIBUTES);
            myHandler.parseXML(outXMLBuffer.toString());
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }

    @Override
    public void refreshObjectFromServer(CMetadata inObject, boolean includeLocallyChangedItems, boolean getFullObjectUpdate, boolean refreshAssocsSetByServerOnly) throws MdException, RemoteException {
        MdGetObjectHandler myHandler = null;
        try {
            MdStore inStore = inObject.getObjectStore();
            int flags = 264;
            if (getFullObjectUpdate && !refreshAssocsSetByServerOnly) {
                flags |= 1;
            }
            String refreshXML = this.m_factory.getOMIUtil().createRefreshXML(inObject, refreshAssocsSetByServerOnly, getFullObjectUpdate);
            String retXML = this.getMetadataFromServer(this.m_factory.getConnection().getCMRHandle(), refreshXML, flags, "");
            StringBuffer outXMLBuffer = new StringBuffer(retXML.length() + 19);
            outXMLBuffer.append("<Objects>");
            outXMLBuffer.append(retXML);
            outXMLBuffer.append("</Objects>");
            myHandler = new MdGetObjectHandler(inStore, this.m_parserFactory);
            myHandler.setFlag(MdGetObjectHandler.MDSTORE_XML);
            myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS | MdGetObjectHandler.OVERRIDE_LOCALLYSET_ATTRIBUTES);
            myHandler.parseXML(outXMLBuffer.toString());
        }
        catch (MdException me) {
            throw me;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }

    private void updateObjectIds(String clientXML, List<String> serverIDList) throws RemoteException {
        int index = clientXML.indexOf(UPDATE_METADATA_TAG);
        List<String> clientIDList = this.getListOfIdMatchesInString(clientXML = clientXML.substring(index, clientXML.length()));
        int clientSize = clientIDList.size();
        if (clientSize > serverIDList.size()) {
            clientSize = serverIDList.size();
        }
        ArrayList<String> idsFound = new ArrayList<String>();
        for (int i = 0; i < clientSize; ++i) {
            String serverID;
            String clientID = clientIDList.get(i);
            if (idsFound.contains(clientID) || clientID.equals(serverID = serverIDList.get(i))) continue;
            idsFound.add(clientID);
            this.m_factory.changeHashKey(clientID, serverID);
        }
    }

    @Override
    public void updateObjectIds(String clientXML, String serverXML) throws RemoteException {
        ArrayList<String> idsFound = new ArrayList<String>();
        List<String> oldids = this.getListOfIdMatchesInString(clientXML);
        List<String> newids = this.getListOfIdMatchesInString(serverXML);
        int oldsize = oldids.size();
        if (oldsize > newids.size()) {
            oldsize = newids.size();
        }
        for (int i = 0; i < oldsize; ++i) {
            String newID;
            String oldID = oldids.get(i);
            if (idsFound.contains(oldID) || oldID.equals(newID = newids.get(i))) continue;
            idsFound.add(oldID);
            this.m_factory.changeHashKey(oldID, newID);
        }
    }

    private List<String> getListOfIdMatchesInString(String inString) {
        Matcher matcher = m_idPattern.matcher(inString);
        ArrayList<String> ids = new ArrayList<String>();
        while (matcher.find()) {
            String matchvalue;
            if (matcher.groupCount() != 1 || (matchvalue = matcher.group(1)) == null) continue;
            ids.add(matchvalue);
        }
        return ids;
    }

    private void processDeletedObjects(List<String> deletedObjects) throws MdException, RemoteException {
        int size = deletedObjects.size();
        for (int i = 0; i < size; ++i) {
            String toDelete = deletedObjects.get(i);
            this.m_factory.deleteDetailMetadataObject(toDelete);
        }
    }

    @Override
    public List<String> deleteObjectsFromServer(String inXML) throws MdException, RemoteException {
        return this.deleteObjectsFromServer(inXML, null);
    }

    @Override
    public List<String> deleteObjectsFromServer(String inXML, String templates) throws MdException, RemoteException {
        StringHolder outXML = new StringHolder();
        int flags = 402654208;
        if (templates != null) {
            flags |= 4;
        } else {
            templates = "";
        }
        if (this.m_factory.getLoggingEnabled()) {
            StringBuffer inputXML = new StringBuffer(105 + inXML.length());
            inputXML.append("<DeleteMetadata><Metadata>");
            inputXML.append(inXML);
            inputXML.append("</Metadata><NS>");
            inputXML.append(this.m_factory.getOMIUtil().getNamespace());
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags>");
            if (templates == null) {
                inputXML.append("<Options/>");
            } else {
                inputXML.append("<Options>");
                inputXML.append(templates);
                inputXML.append("</Options>");
            }
            inputXML.append("</DeleteMetadata>");
            this.m_factory.getUtil().printLoglnClient(inputXML.toString());
        }
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            IOMI connectionHandle = this.m_factory.getConnection().getCMRHandle();
            if (connectionHandle == null) {
                throw new IllegalStateException(this.m_factory.getBundle().getString("MdOMIUtil.NoServerConnection.txt"));
            }
            connectionHandle.DeleteMetadata(inXML, outXML, this.m_factory.getOMIUtil().getNamespace(), flags, templates);
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this.m_factory, e)) {
                return this.deleteObjectsFromServer(inXML, templates);
            }
            throw new MdException(e);
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            this.m_factory.getUtil().printPerfln(Thread.currentThread().getName() + ",DeleteMetadata," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        StringBuffer outStrings = new StringBuffer(33 + outXML.value.length());
        outStrings.append("<DeleteMetadata>");
        outStrings.append(outXML.value);
        outStrings.append("</DeleteMetadata>");
        String xml = outStrings.toString();
        this.m_factory.getUtil().printLoglnServer(xml);
        MdUpdateHandler myHandler = null;
        try {
            myHandler = new MdUpdateHandler(this.m_parserFactory);
            myHandler.parseXML(xml);
            Map<String, String> deletedObjects = myHandler.getDeleteMetadataMap();
            ArrayList<String> arrayList = new ArrayList<String>(deletedObjects.keySet());
            return arrayList;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }

    @Override
    public void dispose() throws RemoteException {
        if (this.m_factory.isRemoteEnvironment()) {
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        this.m_factory = null;
    }

    private String getMetadataFromServer(IOMI connectionHandle, String inXML, int flags, String options) throws MdException, RemoteException {
        if (connectionHandle == null) {
            connectionHandle = this.m_factory.getConnection().getCMRHandle();
        }
        StringHolder outXML = new StringHolder();
        if (options == null) {
            options = "";
        }
        if (!this.m_factory.getUseServerFormattedDates()) {
            flags |= 0x4000000;
        }
        if (this.m_factory.getLoggingEnabled()) {
            StringBuffer inputXML = new StringBuffer(100 + inXML.length() + options.length());
            inputXML.append("<GetMetadata><Metadata>");
            inputXML.append(inXML);
            inputXML.append("</Metadata><NS>");
            inputXML.append(this.m_factory.getOMIUtil().getNamespace());
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags><Options>");
            inputXML.append(options);
            inputXML.append("</Options></GetMetadata>");
            this.m_factory.getUtil().printLoglnClient(inputXML.toString());
        }
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            if (connectionHandle == null) {
                throw new IllegalStateException(this.m_factory.getBundle().getString("MdOMIUtil.NoServerConnection.txt"));
            }
            connectionHandle.GetMetadata(inXML, outXML, this.m_factory.getOMIUtil().getNamespace(), flags, options);
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this.m_factory, e) && this.m_factory.getConnection() != null) {
                return this.getMetadataFromServer(this.m_factory.getConnection().getCMRHandle(), inXML, flags, options);
            }
            throw new MdException(e);
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            StringBuffer sb = new StringBuffer();
            sb.append(Thread.currentThread().getName());
            sb.append(",GetMetadata,");
            sb.append(DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            this.m_factory.getUtil().printPerfln(sb.toString());
        }
        this.m_factory.getUtil().printLoglnServer(outXML.value);
        return outXML.value;
    }

    private String getMetadataObjectsFromServer(IOMI connectionHandle, String reposID, String type, int flags, String options) throws MdException, RemoteException {
        if (connectionHandle == null) {
            connectionHandle = this.m_factory.getConnection().getCMRHandle();
        }
        StringHolder outXML = new StringHolder();
        if (options == null) {
            options = "";
        }
        if (!this.m_factory.getUseServerFormattedDates()) {
            flags |= 0x4000000;
        }
        if (this.m_factory.getLoggingEnabled()) {
            StringBuffer inputXML = new StringBuffer(155 + options.length());
            inputXML.append("<GetMetadataObjects><Reposid>");
            inputXML.append(reposID);
            inputXML.append("</Reposid><Type>");
            inputXML.append(type);
            inputXML.append("</Type><NS>");
            inputXML.append(this.m_factory.getOMIUtil().getNamespace());
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags><Options>");
            inputXML.append(options);
            inputXML.append("</Options></GetMetadataObjects>");
            this.m_factory.getUtil().printLoglnClient(inputXML.toString());
        }
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            if (connectionHandle == null) {
                throw new IllegalStateException(this.m_factory.getBundle().getString("MdOMIUtil.NoServerConnection.txt"));
            }
            connectionHandle.GetMetadataObjects(reposID, type, outXML, this.m_factory.getOMIUtil().getNamespace(), flags, options);
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this.m_factory, e) && this.m_factory.getConnection() != null) {
                return this.getMetadataObjectsFromServer(this.m_factory.getConnection().getCMRHandle(), reposID, type, flags, options);
            }
            throw new MdException(e);
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            StringBuffer sb = new StringBuffer();
            sb.append(Thread.currentThread().getName());
            sb.append(",GetMetadataObjects,");
            sb.append(DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            this.m_factory.getUtil().printPerfln(sb.toString());
        }
        this.m_factory.getUtil().printLoglnServer(outXML.value);
        return outXML.value;
    }
}

