/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ConnectionUtil;
import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MapPool;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdOMIWrapper;
import com.sas.metadata.remote.MdOMIWrapperImpl;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectAttribute;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdUtil;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.XMLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@SASScope
public class MdOMIUtilImpl
implements MdOMIUtil,
Serializable {
    static final long serialVersionUID = 7805796542671986173L;
    protected String m_Namespace = new String("SAS");
    protected MdFactory m_factory = null;
    protected MdOMRConnection m_connection = null;
    protected MdUtil m_Util = null;
    protected MdOMIWrapper omi_wrapper = null;

    public MdOMIUtilImpl(MdFactory factory, MdOMRConnection OMRConnection, MdUtil writer) throws RemoteException {
        this.m_factory = factory;
        this.m_connection = OMRConnection;
        this.m_Util = writer;
        this.omi_wrapper = new MdOMIWrapperImpl(this.m_factory);
        if (this.m_factory.isRemoteEnvironment()) {
            UnicastRemoteObject.exportObject(this);
        }
    }

    @Override
    public MdOMIWrapper getOMIUtility() throws RemoteException {
        return this.omi_wrapper;
    }

    @Override
    public void dispose() throws RemoteException {
        this.m_connection = null;
        this.m_Util = null;
        this.omi_wrapper.dispose();
        this.omi_wrapper = null;
        if (this.m_factory.isRemoteEnvironment()) {
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        this.m_factory = null;
    }

    @Override
    public String getNamespace() throws RemoteException {
        return this.m_Namespace;
    }

    @Override
    public void setNamespace(String newNamespace) throws RemoteException {
        this.m_Namespace = new String(newNamespace);
    }

    @Override
    public String getReposIdFromMetadataObject(CMetadata meta) throws RemoteException {
        return meta == null ? "" : "A0000001." + meta.getRepositoryID();
    }

    @Override
    public CMetadata getFoundationRepository() throws MdException, RemoteException {
        String repos_manager_id = "A0000001.A0000001";
        int flags = 2440;
        String options = "<XMLSelect Search=\"@RepositoryType='FOUNDATION'\"/>";
        StringBuffer inXML = new StringBuffer();
        inXML.append("<GetMetadataObjects><ReposId>");
        inXML.append("A0000001.A0000001");
        inXML.append("</ReposId><Type><RepositoryBase>");
        inXML.append("</Type><Ns>REPOS</Ns><Flags>");
        inXML.append(flags);
        inXML.append("</Flags><Options>");
        inXML.append(options);
        inXML.append("</Options></GetMetadataObjects>");
        StringHolder outXML = new StringHolder();
        this.m_Util.printLoglnClient(inXML.toString());
        try {
            IOMI connectionHandle = this.m_connection.getCMRHandle();
            connectionHandle.GetMetadataObjects("A0000001.A0000001", "RepositoryBase", outXML, "REPOS", flags, options);
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this.m_factory, e)) {
                return this.getFoundationRepository();
            }
            throw new MdException(e);
        }
        String outXMLString = outXML.value;
        this.m_Util.printLoglnServer(outXMLString);
        Document doc = this.parseXML(outXMLString);
        Node firstNode = doc.getFirstChild();
        NodeList secondLevelList = firstNode.getChildNodes();
        int length = secondLevelList.getLength();
        for (int k = 0; k < length; ++k) {
            CMetadata metadata;
            Node descNode;
            NamedNodeMap attributeMap = secondLevelList.item(k).getAttributes();
            Node idNode = attributeMap.getNamedItem("Id");
            if (idNode == null) continue;
            String name = null;
            String desc = null;
            String id = idNode.getNodeValue();
            Node nameNode = attributeMap.getNamedItem("Name");
            if (nameNode != null) {
                name = nameNode.getNodeValue();
            }
            if ((descNode = attributeMap.getNamedItem("Desc")) != null) {
                desc = descNode.getNodeValue();
            }
            if ((metadata = this.m_factory.createSimpleMetadataObject(name, "Environment", id)) == null) continue;
            metadata.setDesc(desc, 2);
            return metadata;
        }
        return null;
    }

    @Override
    public List<CMetadata> getRepositories() throws MdException, RemoteException {
        Vector<CMetadata> returnValues = new Vector<CMetadata>();
        StringHolder outXML = new StringHolder();
        String inputXML = "<GetRepositories><Repositories/><Flags>0</Flags><Options/></GetRepositories>";
        this.m_Util.printLoglnClient(inputXML);
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            this.m_connection.getCMRHandle().GetRepositories(outXML, 0, "");
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this.m_factory, e)) {
                return this.getRepositories();
            }
            throw new MdException(e);
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            this.m_Util.printPerfln(Thread.currentThread().getName() + ",GetRepositories," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        String outXMLString = outXML.value;
        this.m_Util.printLoglnServer(outXMLString);
        Document mainDoc = this.parseXML(outXMLString);
        if (mainDoc != null) {
            Node firstNode = mainDoc.getFirstChild();
            NodeList nodeList = firstNode.getChildNodes();
            int cRepositories = nodeList.getLength();
            for (int index = 0; index < cRepositories; ++index) {
                String strFQID;
                NamedNodeMap childNodeMap = nodeList.item(index).getAttributes();
                String strName = childNodeMap.getNamedItem("Name").getNodeValue();
                try {
                    strFQID = childNodeMap.getNamedItem("Id").getNodeValue();
                }
                catch (Exception e) {
                    strFQID = childNodeMap.getNamedItem("ObjRef").getNodeValue();
                }
                String strDesc = childNodeMap.getNamedItem("Desc").getNodeValue();
                String strType = "Environment";
                CMetadata metadata = ((MdFactoryImpl)this.m_factory).createSimpleMetadataObject(strName, strType, strFQID);
                if (metadata == null) continue;
                metadata.setDesc(strDesc, 2);
                returnValues.add(metadata);
            }
            firstNode = null;
            nodeList = null;
        }
        mainDoc = null;
        return returnValues;
    }

    @Override
    public CMetadata getFullObject(MdObjectStore store, String objectType, String objectID) throws MdException, RemoteException {
        return this.omi_wrapper.getFullObject(store, objectType, objectID);
    }

    @Override
    public CMetadata getFullObject(MdObjectStore store, CMetadata meta) throws MdException, RemoteException {
        return this.omi_wrapper.getFullObject(store, meta);
    }

    @Override
    public List getFullObjects(MdObjectStore store, Map<String, String> objectMap) throws MdException, RemoteException {
        return this.omi_wrapper.getFullObjects(store, objectMap);
    }

    @Override
    public String getMetadataSimple(String strType, String strFQID, String attributeName) throws MdException, RemoteException {
        ArrayList<String> attributeList = new ArrayList<String>(1);
        attributeList.add(attributeName);
        List<String> attrs = this.getMetadataSimple(strType, strFQID, attributeList);
        return attrs.size() > 0 ? attrs.get(0) : "";
    }

    @Override
    public List<String> getMetadataSimple(String strType, String strFQID, List<String> attributes) throws MdException, RemoteException {
        int iLength = attributes.size();
        Vector<String> outData = new Vector<String>(iLength);
        String inXML = this.createGetXMLString(strType, strFQID, attributes, null);
        Document doc = this.getMetadata(inXML, 0);
        Node firstNode = doc.getFirstChild();
        NamedNodeMap childNodeMap = firstNode.getAttributes();
        for (int i = 0; i < iLength; ++i) {
            String value = attributes.get(i);
            outData.add(i, childNodeMap.getNamedItem(value).getNodeValue());
        }
        firstNode = null;
        childNodeMap = null;
        doc = null;
        return outData;
    }

    @Override
    public CMetadata getMetadataAllDepths(CMetadata object, List<String> inSimpleAttr, List<String> inComplexObject, String strTemplate, int iOptions) throws MdException, RemoteException {
        return this.getMetadataAllDepths(object, inSimpleAttr, inComplexObject, strTemplate, iOptions, false);
    }

    @Override
    public CMetadata getMetadataAllDepths(CMetadata object, List<String> inSimpleAttr, List<String> inComplexObject, String strTemplate, int iOptions, boolean doNotOverrideAssocs) throws MdException, RemoteException {
        if (this.m_factory.getParsingType() == 0) {
            return this.omi_wrapper.getMetadataAllDepths(object, inSimpleAttr, inComplexObject, strTemplate, iOptions, doNotOverrideAssocs);
        }
        if (object.getFQID().indexOf(36) > -1) {
            return object;
        }
        String inXML = this.createGetXMLString(object.getCMetadataType(), object.getFQID(), inSimpleAttr, inComplexObject);
        Document doc = this.getMetadata(inXML, strTemplate, iOptions);
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        if ((object = this.createObjectInStore(object.getObjectStore(), object.getName(), object.getCMetadataType(), object.getFQID())) == null) {
            return object;
        }
        Node firstNode = doc.getFirstChild();
        CMetadata returnObject = this.populateObject(object, firstNode.getAttributes(), firstNode.getChildNodes(), doNotOverrideAssocs);
        firstNode = null;
        doc = null;
        if (returnObject.getObjectStore().getStoreType() == 0) {
            returnObject.resetObject();
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            StringBuffer sb = new StringBuffer();
            sb.append(Thread.currentThread().getName());
            sb.append(",GetMetadata Parsing Time,");
            sb.append(DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            this.m_factory.getUtil().printPerfln(sb.toString());
        }
        return returnObject;
    }

    @Override
    public CMetadata getMetadataAllDepths(MdStore inStore, String strType, String strFQID, List<String> inSimpleAttr, List<String> inComplexObject, String strTemplate, int iOptions) throws MdException, RemoteException {
        return this.getMetadataAllDepths(inStore, strType, strFQID, inSimpleAttr, inComplexObject, strTemplate, iOptions, false);
    }

    @Override
    public CMetadata getMetadataAllDepths(MdStore inStore, String strType, String strFQID, List<String> inSimpleAttr, List<String> inComplexObject, String strTemplate, int iOptions, boolean doNotOverrideAssocs) throws MdException, RemoteException {
        if (this.m_factory.getParsingType() == 0) {
            return this.omi_wrapper.getMetadataAllDepths(inStore, strType, strFQID, inSimpleAttr, inComplexObject, strTemplate, iOptions, doNotOverrideAssocs, true);
        }
        String inXML = this.createGetXMLString(strType, strFQID, inSimpleAttr, inComplexObject);
        Document doc = this.getMetadata(inXML, strTemplate, iOptions);
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        Node firstNode = doc.getFirstChild();
        if (strType == null) {
            throw new MdException("Cannot create object with null type");
        }
        CMetadata metaObject = this.createObjectInStore(inStore, "", strType, strFQID);
        if (metaObject == null) {
            return metaObject;
        }
        if (metaObject.getFQID().indexOf(36) > -1) {
            return metaObject;
        }
        CMetadata temp = this.populateObject(metaObject, firstNode.getAttributes(), firstNode.getChildNodes(), doNotOverrideAssocs, true, 2);
        if (temp.getObjectStore().getStoreType() == 0) {
            temp.resetObject();
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            StringBuffer sb = new StringBuffer();
            sb.append(Thread.currentThread().getName());
            sb.append(",GetMetadata Parsing Time,");
            sb.append(DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            this.m_factory.getUtil().printPerfln(sb.toString());
        }
        firstNode = null;
        doc = null;
        return temp;
    }

    @Override
    public void populateStoreFromString(MdStore inStore, Document doc, int state, boolean useReposForNewObjects) throws MdException, RemoteException {
        Node firstNode = doc.getFirstChild();
        ArrayList<CMetadata> createdObjects = new ArrayList<CMetadata>(10);
        NodeList myNodeList = firstNode.getChildNodes();
        int length = myNodeList.getLength();
        for (int i = 0; i < length; ++i) {
            CMetadata metaObject;
            String strId = "";
            String strName = "";
            NamedNodeMap nodeMap = myNodeList.item(i).getAttributes();
            if (nodeMap == null || nodeMap.getLength() == 0) continue;
            String strType = myNodeList.item(i).getNodeName();
            Node idNode = nodeMap.getNamedItem("Id");
            boolean populate = true;
            if (idNode == null) {
                idNode = nodeMap.getNamedItem("ObjRef");
                populate = false;
            }
            if (idNode == null) {
                throw new MdException("Id must be specified in input XML");
            }
            strId = idNode.getNodeValue();
            Node nameNode = nodeMap.getNamedItem("Name");
            if (nameNode != null) {
                strName = nameNode.getNodeValue();
            }
            if ((metaObject = this.createObjectInStore(inStore, strName, strType, strId)) == null) continue;
            createdObjects.add(metaObject);
            this.populateObjectsLocal(metaObject, myNodeList.item(i).getAttributes(), myNodeList.item(i).getChildNodes(), false, state, populate, createdObjects);
        }
        if (useReposForNewObjects) {
            for (CMetadata listObject : createdObjects) {
                if (!listObject.isNewObject()) continue;
                String newId = listObject.getObjectStore().makeID(listObject.getFQID().substring(0, 8));
                this.m_factory.changeHashKey(listObject.getId(), newId);
            }
        }
        myNodeList = null;
        firstNode = null;
    }

    @Override
    public void populateStoreFromString(MdStore inStore, String inXML, int state, boolean useReposForNewObjects) throws MdException, RemoteException {
        if (this.m_factory.getParsingType() == 0) {
            this.omi_wrapper.populateStoreFromString(inStore, inXML, state, useReposForNewObjects);
            return;
        }
        Document doc = this.parseXML(inXML);
        ArrayList<CMetadata> createdObjects = new ArrayList<CMetadata>(10);
        Node firstNode = doc.getFirstChild();
        NodeList myNodeList = firstNode.getChildNodes();
        int length = myNodeList.getLength();
        for (int i = 0; i < length; ++i) {
            CMetadata metaObject;
            String strId = "";
            String strName = "";
            NamedNodeMap nodeMap = myNodeList.item(i).getAttributes();
            String strType = myNodeList.item(i).getNodeName();
            if (nodeMap == null || nodeMap.getLength() == 0 || strType.indexOf("#") > -1) continue;
            Node idNode = nodeMap.getNamedItem("Id");
            boolean populate = true;
            if (idNode == null) {
                idNode = nodeMap.getNamedItem("ObjRef");
                populate = false;
            }
            if (idNode == null) {
                throw new MdException("Id must be specified in input XML");
            }
            strId = idNode.getNodeValue();
            Node nameNode = nodeMap.getNamedItem("Name");
            if (nameNode != null) {
                strName = nameNode.getNodeValue();
            }
            if ((metaObject = this.createObjectInStore(inStore, strName, strType, strId)) == null) continue;
            createdObjects.add(metaObject);
            this.populateObjectsLocal(metaObject, myNodeList.item(i).getAttributes(), myNodeList.item(i).getChildNodes(), false, state, populate, createdObjects);
        }
        if (useReposForNewObjects) {
            for (CMetadata listObject : createdObjects) {
                if (!listObject.isNewObject()) continue;
                String newId = listObject.getObjectStore().makeID(listObject.getFQID().substring(0, 8));
                this.m_factory.changeHashKey(listObject.getId(), newId);
            }
        }
        myNodeList = null;
        firstNode = null;
        doc = null;
    }

    @Override
    public void populateStoreFromInputStream(MdStore inStore, InputStream stream, int state, boolean useReposForNewObjects) throws MdException, RemoteException {
        this.omi_wrapper.populateStoreFromInputStream(inStore, stream, state, useReposForNewObjects);
    }

    @Override
    public CMetadata populateObject(CMetadata metaObject, NamedNodeMap simpleNodeMap, NodeList complexNodeList) throws MdException, RemoteException {
        return this.populateObject(metaObject, simpleNodeMap, complexNodeList, false);
    }

    @Override
    public CMetadata populateObject(CMetadata metaObject, NamedNodeMap simpleNodeMap, NodeList complexNodeList, boolean doNotOverrideAssocs) throws MdException, RemoteException {
        return this.populateObject(metaObject, simpleNodeMap, complexNodeList, doNotOverrideAssocs, true, 2);
    }

    public CMetadata populateObject(CMetadata metaObject, NamedNodeMap simpleNodeMap, NodeList complexNodeList, boolean doNotOverrideAssocs, boolean doNotOverrideAttrs, int state) throws MdException, RemoteException {
        metaObject = this.doSimple(metaObject, simpleNodeMap, state, doNotOverrideAttrs);
        ArrayList outComplexNames = new ArrayList();
        List[] outComplexObjects = new ArrayList[10];
        outComplexObjects = this.createObjectAssociations(metaObject, complexNodeList, outComplexNames, outComplexObjects, doNotOverrideAssocs);
        if ((metaObject.getState() & 4) > 0) {
            metaObject.resetState(4);
        }
        int assoc_state = 1;
        if (state == 1) {
            assoc_state = 4;
        }
        this.setObjectAssociations(metaObject, outComplexNames, outComplexObjects, doNotOverrideAssocs, assoc_state);
        for (int i = 0; i < outComplexObjects.length; ++i) {
            outComplexObjects[i].clear();
            outComplexObjects[i] = null;
        }
        outComplexObjects = null;
        outComplexNames.clear();
        outComplexNames = null;
        return metaObject;
    }

    public CMetadata populateObjectsLocal(CMetadata metaObject, NamedNodeMap simpleNodeMap, NodeList complexNodeList, boolean doNotOverrideAssocs, int state, boolean setAttrs, List createdObjects) throws MdException, RemoteException {
        if (setAttrs) {
            metaObject = this.doSimple(metaObject, simpleNodeMap, state, doNotOverrideAssocs);
        }
        ArrayList outComplexNames = new ArrayList();
        List[] outComplexObjects = new ArrayList[10];
        outComplexObjects = this.createObjectAssociationsLocal(metaObject, complexNodeList, outComplexNames, outComplexObjects, doNotOverrideAssocs, state, createdObjects);
        int assoc_state = 1;
        if (state == 1) {
            assoc_state = 4;
        }
        this.setObjectAssociations(metaObject, outComplexNames, outComplexObjects, doNotOverrideAssocs, assoc_state);
        for (int i = 0; i < outComplexObjects.length; ++i) {
            outComplexObjects[i].clear();
            outComplexObjects[i] = null;
        }
        outComplexObjects = null;
        outComplexNames.clear();
        outComplexNames = null;
        return metaObject;
    }

    @Override
    public List populateObjects(CMetadata metaObject, NamedNodeMap simpleNodeMap, NodeList complexNodeList, boolean doNotOverrideAssocs, List objects) throws MdException, RemoteException {
        int i;
        metaObject = this.doSimple(metaObject, simpleNodeMap);
        ArrayList outComplexNames = new ArrayList();
        List[] outComplexObjects = new ArrayList[10];
        outComplexObjects = this.createObjectAssociations(metaObject, complexNodeList, outComplexNames, outComplexObjects, doNotOverrideAssocs, objects);
        if ((metaObject.getState() & 4) > 0) {
            metaObject.resetState(4);
        }
        this.setObjectAssociations(metaObject, outComplexNames, outComplexObjects, doNotOverrideAssocs);
        if (!objects.contains(metaObject)) {
            objects.add(metaObject);
        }
        for (i = 0; i < outComplexObjects.length; ++i) {
            List listobject = outComplexObjects[i];
            for (int j = 0; j < listobject.size(); ++j) {
                if (objects.contains(listobject.get(j))) continue;
                objects.add(listobject.get(j));
            }
        }
        outComplexNames.clear();
        outComplexNames = null;
        for (i = 0; i < outComplexObjects.length; ++i) {
            outComplexObjects[i].clear();
            outComplexObjects[i] = null;
        }
        outComplexObjects = null;
        return objects;
    }

    @Override
    public CMetadata doSimple(CMetadata thisObject, NamedNodeMap thisNodeMap) throws MdException, RemoteException {
        return this.doSimple(thisObject, thisNodeMap, 2);
    }

    public CMetadata doSimple(CMetadata thisObject, NamedNodeMap thisNodeMap, int state) throws MdException, RemoteException {
        return this.doSimple(thisObject, thisNodeMap, state, true);
    }

    public CMetadata doSimple(CMetadata thisObject, NamedNodeMap thisNodeMap, int state, boolean doNotOverrideValues) throws MdException, RemoteException {
        int iLengthinSimpleAttr = thisNodeMap.getLength();
        if (thisObject == null) {
            return thisObject;
        }
        Map<String, Integer> attrStates = thisObject.getAttrsStates();
        HashMap setAttrs = MapPool.getMap();
        for (int i = 0; i < iLengthinSimpleAttr; ++i) {
            try {
                String attrName = thisNodeMap.item(i).getNodeName();
                if (attrName == null) continue;
                Integer attrState = attrStates.get(attrName);
                if (doNotOverrideValues && attrState != null && attrState == 1) continue;
                setAttrs.put(attrName, new MdObjectAttribute(attrName, state, thisNodeMap.item(i).getNodeValue()));
                continue;
            }
            catch (Exception e) {
                throw new MdException(e);
            }
        }
        thisObject.setAttrs(setAttrs);
        MapPool.returnMap(setAttrs);
        setAttrs = null;
        MapPool.returnMap(attrStates);
        attrStates = null;
        return thisObject;
    }

    private List[] createObjectAssociations(CMetadata thisObject, NodeList thisNodeList, List outComplexNames, List[] outComplexObjects, boolean doNotOverrideAssocs) throws MdException, RemoteException {
        String id = null;
        int numChildLists = thisNodeList.getLength();
        outComplexObjects = new ArrayList[numChildLists];
        for (int k = 0; k < numChildLists; ++k) {
            NodeList myChildNodeList = thisNodeList.item(k).getChildNodes();
            int length = myChildNodeList.getLength();
            outComplexObjects[k] = new ArrayList(length);
            outComplexNames.add(k, thisNodeList.item(k).getNodeName());
            for (int i = 0; i < length; ++i) {
                CMetadata complexObject;
                NamedNodeMap childNodeMap2 = myChildNodeList.item(i).getAttributes();
                String strType = myChildNodeList.item(i).getNodeName();
                boolean populateObject = true;
                Node idNode = childNodeMap2.getNamedItem("Id");
                if (idNode == null) {
                    idNode = childNodeMap2.getNamedItem("ObjRef");
                    populateObject = false;
                }
                if (idNode == null) {
                    throw new MdException("ID not specified in input XML.");
                }
                id = idNode.getNodeValue();
                Node nameNode = childNodeMap2.getNamedItem("Name");
                String strName = "";
                if (nameNode != null) {
                    strName = nameNode.getNodeValue();
                }
                if (thisObject == null || (complexObject = this.m_factory.createComplexMetadataObject(thisObject.getObjectStore(), null, strName, strType, id, null)) == null) continue;
                if (populateObject) {
                    complexObject = this.populateObject(complexObject, childNodeMap2, myChildNodeList.item(i).getChildNodes(), doNotOverrideAssocs);
                }
                outComplexObjects[k].add(complexObject);
            }
        }
        return outComplexObjects;
    }

    private List[] createObjectAssociationsLocal(CMetadata thisObject, NodeList thisNodeList, List outComplexNames, List[] outComplexObjects, boolean doNotOverrideAssocs, int state, List createdObjects) throws MdException, RemoteException {
        String id = null;
        int numChildLists = thisNodeList.getLength();
        outComplexObjects = new ArrayList[numChildLists];
        for (int k = 0; k < numChildLists; ++k) {
            NodeList myChildNodeList = thisNodeList.item(k).getChildNodes();
            int length = myChildNodeList.getLength();
            outComplexObjects[k] = new ArrayList(length);
            outComplexNames.add(k, thisNodeList.item(k).getNodeName());
            for (int i = 0; i < length; ++i) {
                CMetadata complexObject;
                NamedNodeMap childNodeMap2 = myChildNodeList.item(i).getAttributes();
                if (childNodeMap2 == null || childNodeMap2.getLength() == 0) continue;
                String strType = myChildNodeList.item(i).getNodeName();
                boolean populate = true;
                Node idNode = childNodeMap2.getNamedItem("Id");
                if (idNode == null) {
                    idNode = childNodeMap2.getNamedItem("ObjRef");
                    populate = false;
                }
                if (idNode == null) {
                    throw new MdException("ID not specified in input XML.");
                }
                id = idNode.getNodeValue();
                Node nameNode = childNodeMap2.getNamedItem("Name");
                String strName = "";
                if (nameNode != null) {
                    strName = nameNode.getNodeValue();
                }
                if (thisObject == null || (complexObject = this.m_factory.createComplexMetadataObject(thisObject.getObjectStore(), null, strName, strType, id, null)) == null) continue;
                createdObjects.add(complexObject);
                if (populate) {
                    this.populateObjectsLocal(complexObject, childNodeMap2, myChildNodeList.item(i).getChildNodes(), doNotOverrideAssocs, state, true, createdObjects);
                }
                outComplexObjects[k].add(complexObject);
            }
        }
        return outComplexObjects;
    }

    private List[] createObjectAssociations(CMetadata thisObject, NodeList thisNodeList, List outComplexNames, List[] outComplexObjects, boolean doNotOverrideAssocs, List objects) throws MdException, RemoteException {
        String id = null;
        int numChildLists = thisNodeList.getLength();
        outComplexObjects = new ArrayList[numChildLists];
        for (int k = 0; k < numChildLists; ++k) {
            NodeList myChildNodeList = thisNodeList.item(k).getChildNodes();
            int length = myChildNodeList.getLength();
            outComplexObjects[k] = new ArrayList(length);
            outComplexNames.add(k, thisNodeList.item(k).getNodeName());
            for (int i = 0; i < length; ++i) {
                CMetadata complexObject;
                NamedNodeMap childNodeMap2 = myChildNodeList.item(i).getAttributes();
                String strType = myChildNodeList.item(i).getNodeName();
                Node idNode = childNodeMap2.getNamedItem("Id");
                boolean populateObject = true;
                if (idNode == null) {
                    idNode = childNodeMap2.getNamedItem("ObjRef");
                    populateObject = false;
                }
                if (idNode == null) {
                    throw new MdException("ID not specified in input XML.");
                }
                id = idNode.getNodeValue();
                Node nameNode = childNodeMap2.getNamedItem("Name");
                String strName = "";
                if (nameNode != null) {
                    strName = nameNode.getNodeValue();
                }
                if (thisObject == null || (complexObject = this.m_factory.createComplexMetadataObject(thisObject.getObjectStore(), null, strName, strType, id, null)) == null) continue;
                if (populateObject) {
                    this.populateObjects(complexObject, childNodeMap2, myChildNodeList.item(i).getChildNodes(), doNotOverrideAssocs, objects);
                }
                outComplexObjects[k].add(complexObject);
            }
        }
        return outComplexObjects;
    }

    @Override
    public void setObjectAssociations(CMetadata metaObject, List outComplexNames, List[] outComplexObjects, boolean doNotOverrideAssns) throws MdException, RemoteException {
        this.setObjectAssociations(metaObject, outComplexNames, outComplexObjects, doNotOverrideAssns, 1);
    }

    public void setObjectAssociations(CMetadata metaObject, List outComplexNames, List[] outComplexObjects, boolean doNotOverrideAssns, int state) throws MdException, RemoteException {
        int length = outComplexNames.size();
        if (metaObject == null) {
            return;
        }
        Map<String, AssociationList> assns = metaObject.getAssocs();
        for (int i = 0; i < length; ++i) {
            String AssocName = (String)outComplexNames.get(i);
            if (AssocName.charAt(0) == '#') continue;
            AssociationList assn = assns.get(AssocName);
            if (doNotOverrideAssns && assn != null) continue;
            assn = null;
            AssociationList complexAssoc = new AssociationList(AssocName, outComplexObjects[i], metaObject);
            complexAssoc.setState(state);
            metaObject.setMdObjectAssociation(complexAssoc);
        }
        MapPool.returnMap(assns);
        assns = null;
    }

    private CMetadata createObjectInStore(MdStore store, String name, String type, String id) throws RemoteException {
        if (store == null || store.getStoreType() == 0) {
            return this.m_factory.createComplexMetadataObjectServerStoreOnly(name, type, id);
        }
        if (store.getStoreType() == 1) {
            return this.m_factory.createComplexMetadataObject((MdObjectStore)store, null, name, type, id, null);
        }
        return null;
    }

    @Override
    public String getUserHomeFolderName(String userName, String folderName) throws RemoteException {
        String displayName;
        block2: {
            displayName = null;
            try {
                displayName = this.getUserHomeFolderAttribute("DisplayName", userName, folderName, false);
            }
            catch (MdException e) {
                int startIndex;
                String msg = e.getLocalizedMessage();
                String userFolder = "user folder";
                int index = msg.indexOf("user folder");
                if (index <= -1 || (startIndex = msg.indexOf(39, index)) <= index) break block2;
                int endIndex = msg.indexOf(39, startIndex + 1);
                displayName = msg.substring(startIndex + 1, endIndex);
            }
        }
        return displayName == null ? folderName : displayName;
    }

    @Override
    public Tree getUserHomeFolder(MdObjectStore store, String userName, String folderName, String template, int flags) throws MdException, RemoteException {
        return this.getUserHomeFolder(store, userName, folderName, template, flags, false);
    }

    @Override
    public Tree getUserHomeFolder(MdObjectStore store, String userName, String folderName, String template, int flags, boolean createIfNecessary) throws MdException, RemoteException {
        String folderID;
        block6: {
            folderID = null;
            try {
                folderID = this.getUserHomeFolderAttribute("Id", userName, folderName, false);
            }
            catch (MdException e) {
                if (createIfNecessary) break block6;
                throw e;
            }
        }
        boolean created = false;
        if (folderID == null && createIfNecessary) {
            folderID = this.getUserHomeFolderAttribute("Id", userName, folderName, true);
            created = true;
        }
        if (folderID != null) {
            if (flags == 0 && (template == null || template.length() == 0)) {
                flags |= 4;
                template = "<Templates><Tree Name=\"\" PublicType=\"\" UsageVersion=\"\"/></Templates>";
            }
            Tree tree = (Tree)this.getMetadataAllDepths(store, "Tree", folderID, null, null, template, flags);
            if (created) {
                HashMap<String, String> map = new HashMap<String, String>(1);
                map.put(folderID, "Tree");
                this.m_factory.fireMdObjectsCreated(new MdFactoryEvent(this.m_factory, map));
                this.m_factory.fireMdObjectsModified(new MdFactoryEvent(this.m_factory, new HashMap<String, String>(map)));
            }
            return tree;
        }
        return null;
    }

    private String getUserHomeFolderAttribute(String attributeName, String userName, String folderName, boolean create) throws MdException, RemoteException {
        IOMI connectionHandle = this.m_connection.getCMRHandle();
        StringBuffer sb = new StringBuffer();
        if (create) {
            sb.append("<AddUserFolders>");
            sb.append("<Tree PersonName=\"");
            sb.append(userName);
            sb.append("\" FolderName=\"");
            sb.append(folderName);
            sb.append("\"/></AddUserFolders>");
        } else {
            sb.append("<GetUserFolders>");
            sb.append("<Tree PersonName=\"");
            sb.append(userName);
            sb.append("\" FolderName=\"");
            sb.append(folderName);
            sb.append("\"/></GetUserFolders>");
        }
        String inputXML = sb.toString();
        this.m_factory.getUtil().printLoglnClient(inputXML);
        StringHolder outputXML = new StringHolder();
        try {
            connectionHandle.DoRequest(inputXML, outputXML);
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this.m_factory, e)) {
                return this.getUserHomeFolderAttribute(attributeName, userName, folderName, create);
            }
            throw new MdException(e);
        }
        String output = outputXML.value;
        this.m_factory.getUtil().printLoglnServer(output);
        String search = attributeName + "=\"";
        int attrLength = search.length();
        int index = output.indexOf(search);
        return index > -1 ? output.substring(index + attrLength, output.indexOf("\"", index + attrLength)) : null;
    }

    @Override
    public String getObjectPath(MdObjectStore store, PrimaryType publicObject, boolean includeType) throws MdException, RemoteException {
        if (publicObject == null) {
            return "";
        }
        String metadataType = publicObject.getCMetadataType();
        String publicType = publicObject.getPublicType();
        StringBuffer sb = new StringBuffer();
        boolean isFolder = false;
        if ("Folder".equalsIgnoreCase(publicType)) {
            sb.append("<Templates><Tree Name=\"\"><ParentTree/><SoftwareComponents/></Tree></Templates>");
            isFolder = true;
        } else {
            sb.append("<Templates><");
            sb.append(metadataType);
            sb.append("><Trees/></");
            sb.append(metadataType);
            sb.append("><Tree Name=\"\"><ParentTree/><SoftwareComponents/></Tree>");
            sb.append("</Templates>");
        }
        int flags = 260;
        MdFactory factory = store.getFactory();
        publicObject = (PrimaryType)factory.getOMIUtil().getMetadataAllDepths(store, metadataType, publicObject.getId(), null, null, sb.toString(), flags);
        Tree parentFolder = null;
        if (isFolder) {
            parentFolder = ((Tree)publicObject).getParentTree();
        } else {
            AssociationList list = publicObject.getTrees();
            if (list.size() > 0) {
                parentFolder = (Tree)list.get(0);
            }
            if (parentFolder == null) {
                return "";
            }
        }
        int pathSeparator = 47;
        StringBuffer path = new StringBuffer();
        path.append('/').append(publicObject.getName());
        while (parentFolder != null) {
            path.insert(0, '/' + parentFolder.getName());
            parentFolder = parentFolder.getParentTree();
        }
        if (includeType && publicType.length() > 0) {
            path.append("(").append(publicType).append(")");
        }
        return path.toString();
    }

    @Override
    public ResponsibleParty getResponsibleParty(MdObjectStore store, String identityName, String responsibility) throws MdException, RemoteException {
        int flags = 2056;
        return this.getResponsibleParty(store, identityName, responsibility, null, flags);
    }

    @Override
    public ResponsibleParty getResponsibleParty(MdObjectStore store, String identityName, String responsibility, String template, int flags) throws MdException, RemoteException {
        if (responsibility == null || responsibility.length() == 0) {
            throw new IllegalArgumentException("Invalid responsibility argument.");
        }
        String respPartyID = this.getResponsiblePartyID(identityName, responsibility, false);
        if (respPartyID == null || respPartyID.length() == 0) {
            respPartyID = this.getResponsiblePartyID(identityName, responsibility, true);
        }
        if (respPartyID != null) {
            if (template == null) {
                template = "";
            }
            ResponsibleParty respParty = (ResponsibleParty)this.getMetadataAllDepths(store, "ResponsibleParty", respPartyID, null, null, template, flags);
            return respParty;
        }
        return null;
    }

    private String getResponsiblePartyID(String identityName, String responsibility, boolean create) throws MdException, RemoteException {
        IOMI connectionHandle = this.m_connection.getCMRHandle();
        StringBuffer sb = new StringBuffer();
        if (create) {
            sb.append("<AddResponsibleParty>");
            sb.append("<ResponsibleParty IdentityName=\"");
            sb.append(identityName);
            sb.append("\" Responsibility=\"");
            sb.append(responsibility);
            sb.append("\"/></AddResponsibleParty>");
        } else {
            sb.append("<GetResponsibleParty>");
            sb.append("<ResponsibleParty IdentityName=\"");
            sb.append(identityName);
            sb.append("\" Responsibility=\"");
            sb.append(responsibility);
            sb.append("\"/></GetResponsibleParty>");
        }
        String inputXML = sb.toString();
        this.m_Util.printLoglnClient(inputXML);
        StringHolder outputXML = new StringHolder();
        try {
            connectionHandle.DoRequest(inputXML, outputXML);
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this.m_factory, e)) {
                return this.getResponsiblePartyID(identityName, responsibility, create);
            }
            throw new MdException(e);
        }
        String output = outputXML.value;
        this.m_Util.printLoglnServer(output);
        String idAttribute = "Id=\"";
        int index = output.indexOf(idAttribute);
        return index > -1 ? output.substring(index + 4, output.indexOf("\"", index + 4)) : null;
    }

    @Override
    public int doesObjectExist(String reposID, String objectType, String xmlSelect) throws MdException, RemoteException {
        int flags = 256;
        if (xmlSelect == null) {
            xmlSelect = "";
        } else {
            flags |= 0x80;
        }
        String outXMLString = this.getMetadataObjectsFromServer(reposID, objectType, flags, xmlSelect);
        if (outXMLString.length() <= 10) {
            return 0;
        }
        int count = 0;
        Pattern assocPattern = Pattern.compile("<" + objectType);
        Matcher m = assocPattern.matcher(outXMLString);
        while (m.find()) {
            ++count;
        }
        return count;
    }

    @Override
    public List getMetadataObjectsSubset(MdStore inStore, String strReposID, String strType, int flags, String options) throws MdException, RemoteException {
        return this.getMetadataObjectsSubset(inStore, strReposID, strType, flags, options, false);
    }

    @Override
    public List getMetadataObjectsSubset(MdStore inStore, String strReposID, String strType, int flags, String options, boolean doOverrideAssocs) throws MdException, RemoteException {
        if (this.m_factory.getParsingType() == 0) {
            return this.omi_wrapper.getMetadataObjectsSubset(this.m_connection.getCMRHandle(), inStore, strReposID, strType, flags, options, doOverrideAssocs);
        }
        Vector<CMetadata> outObjects = new Vector<CMetadata>(0);
        if (inStore != null && !inStore.isDisposed() && !inStore.isGoToServerForMetadata()) {
            this.m_Util.printOutputln("Debug Note: getMetadataObjectsSubset Not going to server...");
            return outObjects;
        }
        String outXMLString = this.getMetadataObjectsFromServer(strReposID, strType, flags, options);
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        Document doc = this.parseXML(outXMLString);
        Node firstNode = doc.getFirstChild();
        NodeList secondLevelList = firstNode.getChildNodes();
        int allObjects = secondLevelList.getLength();
        for (int k = 0; k < allObjects; ++k) {
            String tempStrType;
            CMetadata metaObject;
            NamedNodeMap attributeMap = secondLevelList.item(k).getAttributes();
            Node idNode = attributeMap.getNamedItem("Id");
            boolean populateObject = true;
            if (idNode == null) {
                idNode = attributeMap.getNamedItem("ObjRef");
                populateObject = false;
            }
            if (idNode == null) {
                throw new MdException("Id node not specified, invalid object XML.");
            }
            String strFQID = idNode.getNodeValue();
            String strName = "";
            Node nameNode = attributeMap.getNamedItem("Name");
            if (nameNode != null) {
                strName = nameNode.getNodeValue();
            }
            if ((metaObject = this.createObjectInStore(inStore, strName, tempStrType = secondLevelList.item(k).getNodeName(), strFQID)) == null) continue;
            if (populateObject) {
                this.populateObject(metaObject, secondLevelList.item(k).getAttributes(), secondLevelList.item(k).getChildNodes(), doOverrideAssocs);
            }
            outObjects.add(metaObject);
            if (metaObject == null || metaObject.getObjectStore() == null || metaObject.getObjectStore().getStoreType() != 0) continue;
            metaObject.resetObject();
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            StringBuffer sb = new StringBuffer();
            sb.append(Thread.currentThread().getName());
            sb.append(",GetMetadataObjects Parsing Time,");
            sb.append(DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            this.m_factory.getUtil().printPerfln(sb.toString());
        }
        outXMLString = null;
        firstNode = null;
        secondLevelList = null;
        doc = null;
        return outObjects;
    }

    @Override
    public List getMetadataObjectsSubsetList(MdStore inStore, String strReposID, String strType, int flags, String options, boolean doOverrideAssocs) throws MdException, RemoteException {
        if (this.m_factory.getParsingType() == 0) {
            return this.omi_wrapper.getMetadataObjectsSubsetList(this.m_connection.getCMRHandle(), inStore, strReposID, strType, flags, options, doOverrideAssocs);
        }
        ArrayList outObjects = new ArrayList(100);
        if (inStore != null && !inStore.isDisposed() && !inStore.isGoToServerForMetadata()) {
            this.m_Util.printOutputln("Debug Note: getMetadataObjectsSubsetList() Not going to server...");
            return outObjects;
        }
        String outXMLString = this.getMetadataObjectsFromServer(strReposID, strType, flags, options);
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        Document doc = this.parseXML(outXMLString);
        Node firstNode = doc.getFirstChild();
        NodeList secondLevelList = firstNode.getChildNodes();
        int allObjects = secondLevelList.getLength();
        for (int k = 0; k < allObjects; ++k) {
            String tempStrType;
            CMetadata metaObject;
            NamedNodeMap attributeMap = secondLevelList.item(k).getAttributes();
            boolean populateObject = true;
            Node idNode = attributeMap.getNamedItem("Id");
            if (idNode == null) {
                idNode = attributeMap.getNamedItem("ObjRef");
                populateObject = false;
            }
            if (idNode == null) {
                throw new MdException("Id node not specified, invalid object XML.");
            }
            String strFQID = idNode.getNodeValue();
            Node nameNode = attributeMap.getNamedItem("Name");
            String strName = "";
            if (nameNode != null) {
                strName = nameNode.getNodeValue();
            }
            if ((metaObject = this.createObjectInStore(inStore, strName, tempStrType = secondLevelList.item(k).getNodeName(), strFQID)) == null) continue;
            if (populateObject) {
                this.populateObjects(metaObject, secondLevelList.item(k).getAttributes(), secondLevelList.item(k).getChildNodes(), doOverrideAssocs, outObjects);
            }
            if (metaObject.getObjectStore().getStoreType() != 0) continue;
            metaObject.resetObject();
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            StringBuffer sb = new StringBuffer();
            sb.append(Thread.currentThread().getName());
            sb.append(",GetMetadata Parsing Time,");
            sb.append(DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            this.m_factory.getUtil().printPerfln(sb.toString());
        }
        outXMLString = null;
        firstNode = null;
        secondLevelList = null;
        doc = null;
        return outObjects;
    }

    @Override
    public List getMetadataObjects(String strReposID, String strType, int iFlags) throws MdException, RemoteException {
        return this.getMetadataObjects(strReposID, strType, iFlags, "");
    }

    @Override
    public List getMetadataObjects(String strReposID, String strType) throws MdException, RemoteException {
        return this.getMetadataObjects(strReposID, strType, 0, "");
    }

    @Override
    public List getMetadataObjects(String strReposID, String strType, int flags, String strOptions) throws MdException, RemoteException {
        if (this.m_factory.getParsingType() == 0) {
            return this.omi_wrapper.getMetadataObjects(this.m_factory.getConnection().getCMRHandle(), strReposID, strType, flags, strOptions);
        }
        Vector<Root> outData = new Vector<Root>();
        String outXMLString = this.getMetadataObjectsFromServer(strReposID, strType, flags, strOptions);
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        Document doc = this.parseXML(outXMLString);
        Node firstNode = doc.getFirstChild();
        NodeList myNodeList = firstNode.getChildNodes();
        int length = myNodeList.getLength();
        for (int i = 0; i < length; ++i) {
            String strId = "";
            String strName = "";
            NamedNodeMap nodeMap = myNodeList.item(i).getAttributes();
            Node idNode = nodeMap.getNamedItem("Id");
            if (idNode == null) {
                idNode = nodeMap.getNamedItem("ObjRef");
            }
            if (idNode == null) {
                throw new MdException("Id must be specified in input XML");
            }
            strId = idNode.getNodeValue();
            Node nameNode = nodeMap.getNamedItem("Name");
            if (nameNode != null) {
                strName = nameNode.getNodeValue();
            }
            String strLockedBy = null;
            Node thisNode = nodeMap.getNamedItem("LockedBy");
            if (thisNode != null) {
                strLockedBy = thisNode.getNodeValue();
            }
            Root cmobject = (Root)((MdFactoryImpl)this.m_factory).createSimpleMetadataObject(strName, strType, strId, strLockedBy);
            thisNode = nodeMap.getNamedItem("ChangeState");
            if (thisNode != null) {
                cmobject.setChangeState(thisNode.getNodeValue());
            }
            outData.add(cmobject);
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            StringBuffer sb = new StringBuffer();
            sb.append(Thread.currentThread().getName());
            sb.append(",GetMetadataObjects Parsing Time,");
            sb.append(DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            this.m_factory.getUtil().printPerfln(sb.toString());
        }
        doc = null;
        return outData;
    }

    @Override
    public List getMetadata(MdStore store, Map objectMap, String template, int flags) throws MdException, RemoteException {
        return this.getMetadata(store, objectMap, template, flags, false, true);
    }

    @Override
    public List getMetadata(MdStore store, Map objectMap, String template, int flags, boolean doNotOverrideAssocs, boolean doNotOverrideAttrs) throws MdException, RemoteException {
        if (this.m_factory.getParsingType() == 0) {
            return this.omi_wrapper.getMetadata(this.m_factory.getConnection().getCMRHandle(), store, objectMap, template, flags, doNotOverrideAssocs, doNotOverrideAttrs);
        }
        if (objectMap == null || objectMap.size() == 0 || !store.isGoToServerForMetadata()) {
            this.m_Util.printOutputln("Debug Note: getMetadata not going to server...");
            return Collections.EMPTY_LIST;
        }
        ArrayList<CMetadata> outObjects = new ArrayList<CMetadata>();
        String inXML = this.createGetXMLString(objectMap);
        String outXMLString = this.getMetadataFromServer(inXML, flags, template);
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        StringBuffer sb = new StringBuffer(21 + outXMLString.length());
        sb.append("<Metadata>");
        sb.append(outXMLString);
        sb.append("</Metadata>");
        Document doc = this.parseXML(sb.toString());
        Node firstNode = doc.getFirstChild();
        NodeList secondLevelList = firstNode.getChildNodes();
        int allObjects = secondLevelList.getLength();
        for (int k = 0; k < allObjects; ++k) {
            String tempStrType;
            CMetadata metaObject;
            NamedNodeMap attributeMap = secondLevelList.item(k).getAttributes();
            Node idNode = attributeMap.getNamedItem("Id");
            boolean populateObject = true;
            if (idNode == null) {
                idNode = attributeMap.getNamedItem("ObjRef");
                populateObject = false;
            }
            if (idNode == null) {
                throw new MdException(this.m_factory.getBundle().getString("MetadataUtil.IdMustBeSpecInInputXML.txt"));
            }
            String id = idNode.getNodeValue();
            String strName = "";
            Node nameNode = attributeMap.getNamedItem("Name");
            if (nameNode != null) {
                strName = nameNode.getNodeValue();
            }
            if ((metaObject = this.createObjectInStore(store, strName, tempStrType = secondLevelList.item(k).getNodeName(), id)) == null) continue;
            if (populateObject) {
                this.populateObject(metaObject, secondLevelList.item(k).getAttributes(), secondLevelList.item(k).getChildNodes(), doNotOverrideAssocs, doNotOverrideAttrs, 2);
            }
            outObjects.add(metaObject);
            if (metaObject.getObjectStore().getStoreType() != 0) continue;
            metaObject.resetObject();
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            StringBuffer buffer = new StringBuffer();
            buffer.append(Thread.currentThread().getName());
            buffer.append(",GetMetadata Parsing Time,");
            buffer.append(DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            this.m_factory.getUtil().printPerfln(buffer.toString());
        }
        firstNode = null;
        secondLevelList = null;
        doc = null;
        return outObjects;
    }

    @Override
    public Document getMetadata(String inXML, int iFlags) throws MdException, RemoteException {
        return this.getMetadata(inXML, "", iFlags);
    }

    @Override
    public Document getMetadata(String inXML, String strTemplate, int iFlags) throws MdException, RemoteException {
        String outXMLString = this.getMetadataFromServer(inXML, iFlags, strTemplate);
        Document doc = this.parseXML(outXMLString);
        return doc;
    }

    @Override
    public List getMetadataObjects(MdStore inStore, String inXML, String strTemplate, int iFlags) throws MdException, RemoteException {
        return this.getMetadataObjects(inStore, inXML, strTemplate, iFlags, false);
    }

    @Override
    public List getMetadataObjects(MdStore inStore, String inXML, String strTemplate, int iFlags, boolean doNotOverrideAssocs) throws MdException, RemoteException {
        if (this.m_factory.getParsingType() == 0) {
            return this.omi_wrapper.getMetadataObjects(this.m_factory.getConnection().getCMRHandle(), inStore, inXML, strTemplate, iFlags, doNotOverrideAssocs);
        }
        Vector<CMetadata> outObjects = new Vector<CMetadata>(0);
        if (inStore != null && !inStore.isDisposed() && !inStore.isGoToServerForMetadata()) {
            this.m_Util.printOutputln("Debug Note: getMetadataObjects Not going to server...");
            return outObjects;
        }
        String strFQID = null;
        String strName = null;
        String outXMLString = this.getMetadataFromServer(inXML, iFlags, strTemplate);
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        StringBuffer sb = new StringBuffer(outXMLString.length() + 21);
        sb.append("<Metadata>");
        sb.append(outXMLString);
        sb.append("</Metadata>");
        Document doc = this.parseXML(sb.toString());
        Node firstNode = doc.getFirstChild();
        NodeList secondLevelList = firstNode.getChildNodes();
        int allObjects = secondLevelList.getLength();
        for (int k = 0; k < allObjects; ++k) {
            NamedNodeMap attributeMap = secondLevelList.item(k).getAttributes();
            Node idNode = attributeMap.getNamedItem("Id");
            boolean populateObject = true;
            if (idNode == null) {
                idNode = attributeMap.getNamedItem("ObjRef");
                populateObject = false;
            }
            if (idNode == null) {
                throw new MdException("ID must be specified in XML.");
            }
            strFQID = idNode.getNodeValue();
            Node nameNode = attributeMap.getNamedItem("Name");
            strName = nameNode != null ? nameNode.getNodeValue() : "";
            String tempStrType = secondLevelList.item(k).getNodeName();
            CMetadata metaObject = this.createObjectInStore(inStore, strName, tempStrType, strFQID);
            if (metaObject == null) continue;
            if (populateObject) {
                this.populateObject(metaObject, secondLevelList.item(k).getAttributes(), secondLevelList.item(k).getChildNodes(), doNotOverrideAssocs);
            }
            outObjects.add(metaObject);
            if (metaObject.getObjectStore().getStoreType() != 0) continue;
            metaObject.resetObject();
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            StringBuffer buffer = new StringBuffer();
            buffer.append(Thread.currentThread().getName());
            buffer.append(",GetMetadataObjects Parsing Time,");
            buffer.append(DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            this.m_factory.getUtil().printPerfln(buffer.toString());
        }
        doc = null;
        return outObjects;
    }

    @Override
    public FastMetadata getFastMetadata(String strType, String strFQID, String strOptions, int iFlags) throws MdException, RemoteException {
        if (this.m_factory.getParsingType() == 0) {
            return this.omi_wrapper.getFastMetadata(strType, strFQID, strOptions, iFlags);
        }
        StringBuffer inXML = new StringBuffer(40);
        inXML.append("<");
        inXML.append(strType);
        inXML.append(" Id=\"");
        inXML.append(strFQID);
        inXML.append("\"/>");
        String outXMLString = this.getMetadataFromServer(inXML.toString(), iFlags, strOptions);
        Document doc = this.parseXML(outXMLString);
        FastMetadata objectMap = new FastMetadata();
        Node firstNode = doc.getFirstChild();
        this.addObjectAttributesToMap(firstNode, objectMap);
        this.addObjectAssociationsToMap(firstNode, objectMap);
        doc = null;
        return objectMap;
    }

    @Override
    public Map getMetadataNoCache(String strType, String strFQID, String strOptions, int iFlags) throws MdException, RemoteException {
        return this.getFastMetadata(strType, strFQID, strOptions, iFlags);
    }

    @Override
    public List<FastMetadata> getFastMetadata(Map<String, String> objectMap, String strOptions, int iFlags) throws MdException, RemoteException {
        if (this.m_factory.getInstance().getParsingType() == 0) {
            return this.omi_wrapper.getFastMetadata(objectMap, strOptions, iFlags);
        }
        String inXML = this.createGetXMLString(objectMap);
        String outXMLString = this.getMetadataFromServer(inXML, iFlags, strOptions);
        StringBuffer sb = new StringBuffer(21 + outXMLString.length());
        sb.append("<Metadata>");
        sb.append(outXMLString);
        sb.append("</Metadata>");
        Document doc = this.parseXML(sb.toString());
        ArrayList<FastMetadata> objectList = new ArrayList<FastMetadata>();
        Node firstNode = doc.getFirstChild();
        NodeList secondLevelList = firstNode.getChildNodes();
        int allObjects = secondLevelList.getLength();
        for (int i = 0; i < allObjects; ++i) {
            FastMetadata map = new FastMetadata();
            Node objectNode = secondLevelList.item(i);
            this.addObjectAttributesToMap(objectNode, map);
            this.addObjectAssociationsToMap(objectNode, map);
            objectList.add(map);
        }
        doc = null;
        return objectList;
    }

    @Override
    public List getMetadataNoCache(Map objectMap, String strOptions, int iFlags) throws MdException, RemoteException {
        return this.getFastMetadata(objectMap, strOptions, iFlags);
    }

    @Override
    public List<FastMetadata> getFastMetadataObjects(String strType, String strReposId, String strOptions, int iFlags) throws MdException, RemoteException {
        if (this.m_factory.getParsingType() == 0) {
            return this.omi_wrapper.getFastMetadataObjects(strType, strReposId, strOptions, iFlags);
        }
        String outXMLString = this.getMetadataObjectsFromServer(strReposId, strType, iFlags, strOptions);
        Document doc = this.parseXML(outXMLString);
        ArrayList<FastMetadata> objectList = new ArrayList<FastMetadata>();
        Node firstNode = doc.getFirstChild();
        NodeList secondLevelList = firstNode.getChildNodes();
        int allObjects = secondLevelList.getLength();
        for (int i = 0; i < allObjects; ++i) {
            FastMetadata objectMap = new FastMetadata();
            Node objectNode = secondLevelList.item(i);
            this.addObjectAttributesToMap(objectNode, objectMap);
            this.addObjectAssociationsToMap(objectNode, objectMap);
            objectList.add(objectMap);
        }
        doc = null;
        return objectList;
    }

    @Override
    public List getMetadataObjectsNoCache(String strType, String strReposId, String strOptions, int iFlags) throws MdException, RemoteException {
        return this.getFastMetadataObjects(strType, strReposId, strOptions, iFlags);
    }

    private void addObjectAttributesToMap(Node objectNode, Map objectMap) throws RemoteException {
        objectMap.put("MetadataObjectType", objectNode.getNodeName());
        NamedNodeMap nodeMap = objectNode.getAttributes();
        int attr_length = nodeMap.getLength();
        for (int i = 0; i < attr_length; ++i) {
            String attrName = nodeMap.item(i).getNodeName();
            String attrValue = nodeMap.item(i).getNodeValue();
            objectMap.put(attrName, attrValue);
        }
    }

    private void addObjectAssociationsToMap(Node objectNode, Map objectMap) throws RemoteException {
        NodeList nodeList = objectNode.getChildNodes();
        int child_length = nodeList.getLength();
        for (int i = 0; i < child_length; ++i) {
            Node assocNode = nodeList.item(i);
            if (assocNode.getChildNodes().getLength() <= 0) continue;
            String association_name = assocNode.getNodeName();
            ArrayList association_values = new ArrayList();
            NodeList assocList = assocNode.getChildNodes();
            int assoc_length = assocList.getLength();
            for (int j = 0; j < assoc_length; ++j) {
                HashMap map = new HashMap();
                this.addObjectAttributesToMap(assocList.item(j), map);
                this.addObjectAssociationsToMap(assocList.item(j), map);
                association_values.add(map);
            }
            objectMap.put(association_name, association_values);
        }
    }

    @Override
    public Document DoRequest(String inXML) throws MdException, RemoteException {
        return this.DoRequest(inXML, true);
    }

    @Override
    public void DoRequestNoReturn(String inXML, boolean fUpdateIds) throws MdException, RemoteException {
        if (this.m_factory.getParsingType() == 0) {
            this.omi_wrapper.DoRequest(this.m_connection.getCMRHandle(), inXML, fUpdateIds);
        } else {
            this.DoRequest(inXML, fUpdateIds);
        }
    }

    @Override
    public Document DoRequest(String inXML, boolean fUpdateIds) throws MdException, RemoteException {
        this.m_Util.printLoglnClient(inXML);
        StringHolder outXML = new StringHolder();
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            IOMI connectionHandle = this.m_connection.getCMRHandle();
            if (connectionHandle == null) {
                throw new IllegalStateException(this.m_factory.getBundle().getString("MdOMIUtil.NoServerConnection.txt"));
            }
            connectionHandle.DoRequest(inXML, outXML);
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this.m_factory, e)) {
                return this.DoRequest(inXML, fUpdateIds);
            }
            throw new MdException(e);
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            this.m_Util.printPerfln(Thread.currentThread().getName() + ",DoRequest," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            t2 = System.currentTimeMillis();
        }
        Document inDoc = this.parseXML(inXML);
        String outXMLString = outXML.value;
        this.m_Util.printLoglnServer(outXMLString);
        Document outDoc = this.parseXML(outXMLString);
        this.processDeleteMetadataObjects(outDoc);
        if (fUpdateIds) {
            this.updateObjectId_Internal(inDoc, outDoc);
        }
        this.processDeletedObjects(outDoc);
        if (this.m_factory.getPerf()) {
            t3 = System.currentTimeMillis();
            StringBuffer sb = new StringBuffer();
            sb.append(Thread.currentThread().getName());
            sb.append(",UpdateMetadata Parsing Time,");
            sb.append(DecimalFormat.getInstance().format((double)(t3 - t2) / 1000.0));
            this.m_factory.getUtil().printPerfln(sb.toString());
        }
        return outDoc;
    }

    private void processDeleteMetadataObjects(Document outDoc) throws RemoteException {
        NodeList nodeList = outDoc.getElementsByTagName("DeleteMetadata");
        if (nodeList.getLength() > 0) {
            Node metadataNode = nodeList.item(0).getFirstChild();
            NodeList nodes = metadataNode.getChildNodes();
            HashMap<String, String> objectMap = new HashMap<String, String>();
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node objectNode = nodes.item(i);
                String type = objectNode.getNodeName();
                NamedNodeMap attributes = objectNode.getAttributes();
                Node idNode = attributes.getNamedItem("Id");
                if (idNode == null) continue;
                objectMap.put(idNode.getNodeValue(), type);
            }
            if (objectMap.size() > 0) {
                this.m_factory.deleteObjectsFromStores(objectMap);
            }
        }
    }

    @Override
    public void processDeletedObjects(Document outDoc) throws RemoteException {
        NodeList DeletedObjectsNodes = outDoc.getElementsByTagName("DeletedObjects");
        ArrayList<String> objectIds = new ArrayList<String>(10);
        for (int i = 0; i < DeletedObjectsNodes.getLength(); ++i) {
            Node DeletedObjectNode = DeletedObjectsNodes.item(i);
            NodeList DeletedChildrenNodes = DeletedObjectNode.getChildNodes();
            for (int j = 0; j < DeletedChildrenNodes.getLength(); ++j) {
                Node DeletedObject = DeletedChildrenNodes.item(j);
                NamedNodeMap attribMap = DeletedObject.getAttributes();
                Node IdNode = attribMap.getNamedItem("Id");
                if (IdNode == null) continue;
                String Id = IdNode.getNodeValue();
                objectIds.add(Id);
            }
        }
        for (String id : objectIds) {
            this.m_factory.deleteDetailMetadataObject(id);
        }
    }

    private void updateObjectId_Internal(Document inDoc, Document outDoc) throws MdException, RemoteException {
        NodeList clientList = inDoc.getElementsByTagName("UpdateMetadata");
        NodeList serverList = outDoc.getElementsByTagName("UpdateMetadata");
        if (clientList.getLength() > 0 && serverList.getLength() > 0) {
            Node oldNode = clientList.item(0).getFirstChild();
            Node newNode = serverList.item(0).getFirstChild();
            NodeList oldNodeList = oldNode.getChildNodes();
            NodeList newNodeList = newNode.getChildNodes();
            int oldLength = newNodeList.getLength();
            int newLength = oldNodeList.getLength();
            int length = oldLength;
            if (oldLength > newLength) {
                length = newLength;
            }
            for (int i = 0; i < length; ++i) {
                Node newIdNode;
                String strOldId;
                Node oldIdNode;
                NamedNodeMap oldNodeMap = oldNodeList.item(i).getAttributes();
                NamedNodeMap newNodeMap = newNodeList.item(i).getAttributes();
                if (oldNodeMap == null || newNodeMap == null || (oldIdNode = oldNodeMap.getNamedItem("Id")) == null || (strOldId = oldIdNode.getNodeValue()) == null || strOldId.indexOf(".$") == -1 || (newIdNode = newNodeMap.getNamedItem("Id")) == null) continue;
                String strNewId = newIdNode.getNodeValue();
                ((MdFactoryImpl)this.m_factory).changeHashKey(strOldId, strNewId);
            }
        }
    }

    @Override
    public void updateObjectId(Document inDoc, Document outDoc) throws MdException, RemoteException {
        Node oldNode = inDoc.getFirstChild().getFirstChild();
        Node newNode = outDoc.getFirstChild().getFirstChild();
        NodeList oldNodeList = oldNode.getChildNodes();
        NodeList newNodeList = newNode.getChildNodes();
        int oldLength = newNodeList.getLength();
        int newLength = oldNodeList.getLength();
        int length = oldLength;
        if (oldLength > newLength) {
            length = newLength;
        }
        for (int i = 0; i < length; ++i) {
            Node newIdNode;
            String strOldId;
            Node oldIdNode;
            NamedNodeMap oldNodeMap = oldNodeList.item(i).getAttributes();
            NamedNodeMap newNodeMap = newNodeList.item(i).getAttributes();
            if (oldNodeMap == null || newNodeMap == null || (oldIdNode = oldNodeMap.getNamedItem("Id")) == null || (strOldId = oldIdNode.getNodeValue()) == null || strOldId.indexOf(".$") == -1 || (newIdNode = newNodeMap.getNamedItem("Id")) == null) continue;
            String strNewId = newIdNode.getNodeValue();
            ((MdFactoryImpl)this.m_factory).changeHashKey(strOldId, strNewId);
        }
    }

    @Override
    public String createGetXMLString(String strType, String strFQID, List<String> simpleAttr, List<String> complexAttr) throws RemoteException {
        return XMLUtil.createGetMetadataXML(strType, strFQID, simpleAttr, complexAttr);
    }

    @Override
    public String createGetXMLString(Map<String, String> objectMap) throws RemoteException {
        return XMLUtil.createGetMetadataXML(objectMap);
    }

    @Override
    public String createObjectAttributeString(Map<String, String> attributes) throws RemoteException {
        return XMLUtil.createObjectAttributeXML(attributes);
    }

    @Override
    public String createXMLSubString(List<String> attributes, List<String> values) throws RemoteException {
        int iLength = Math.min(attributes.size(), values.size());
        if (iLength < 1) {
            return "";
        }
        StringBuffer inXML = new StringBuffer();
        for (int i = 0; i < iLength; ++i) {
            inXML.append(attributes.get(i));
            inXML.append("=\"");
            inXML.append(XMLUtil.normalize(values.get(i)));
            inXML.append("\" ");
        }
        return inXML.toString();
    }

    @Override
    public String createRefreshXML(CMetadata meta, boolean refreshAssocsSetByServerOnly, boolean refreshAll) throws RemoteException {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(meta.getCMetadataType());
        sb.append(" Id=\"");
        sb.append(meta.getId());
        sb.append("\">");
        if (refreshAssocsSetByServerOnly || !refreshAll) {
            Map<String, AssociationList> associations = meta.getAssocs();
            for (Map.Entry<String, AssociationList> entry : associations.entrySet()) {
                int state;
                AssociationList assoc = entry.getValue();
                if (assoc == null || ((state = assoc.getState()) & 0x20) > 0 || (state & 0x40) > 0) continue;
                if (refreshAssocsSetByServerOnly && state == 1) {
                    sb.append("<");
                    sb.append(entry.getKey());
                    sb.append("/>");
                    continue;
                }
                if (refreshAssocsSetByServerOnly || refreshAll) continue;
                sb.append("<");
                sb.append(entry.getKey());
                sb.append("/>");
            }
            MapPool.returnMap(associations);
        }
        sb.append("</");
        sb.append(meta.getCMetadataType());
        sb.append(">");
        return sb.toString();
    }

    @Override
    public String cleanStringForXML(String s) throws RemoteException {
        return XMLUtil.normalize(s);
    }

    @Override
    public String createUpdateXMLSimple(String strType, String strFQID, List<String> attributes, List<String> values) throws RemoteException {
        int iLength = Math.min(attributes.size(), values.size());
        if (iLength < 1) {
            return null;
        }
        StringBuffer inXML = new StringBuffer();
        inXML.append("<");
        inXML.append(strType);
        inXML.append(" Id=\"");
        inXML.append(strFQID);
        inXML.append("\" ");
        for (int i = 0; i < iLength; ++i) {
            inXML.append(attributes.get(i));
            inXML.append("=\"");
            inXML.append(values.get(i));
            inXML.append("\" ");
        }
        inXML.append("></");
        inXML.append(strType);
        inXML.append(">");
        return inXML.toString();
    }

    @Override
    public void updateMetadataSimple(String strType, String strFQID, List<String> attributes, List<String> values) throws MdException, RemoteException {
        String inXML = this.createUpdateXMLSimple(strType, strFQID, attributes, values);
        StringHolder outXML = new StringHolder();
        this.updateMetadata(inXML, outXML, 0);
    }

    @Override
    public void updateMetadataSimple(String inXML) throws MdException, RemoteException {
        StringHolder outXML = new StringHolder();
        this.updateMetadata(inXML, outXML, 0);
    }

    @Override
    public void updateMetadata(String inXML) throws MdException, RemoteException {
        StringHolder outXML = new StringHolder();
        this.updateMetadata(inXML, outXML, 0);
    }

    @Override
    public int updateMetadata(String inXML, StringHolder outXML, int iFlags) throws MdException, RemoteException {
        if ((iFlags & 0x10000000) == 0) {
            iFlags |= 0x10000000;
        }
        int rc = 0;
        this.m_Util.printLoglnClient(inXML);
        try {
            long t0 = 0L;
            long t1 = 0L;
            if (this.m_factory.getPerf()) {
                t0 = System.currentTimeMillis();
            }
            rc = this.m_connection.getCMRHandle().UpdateMetadata(inXML, outXML, this.m_Namespace, iFlags, "");
            if (this.m_factory.getPerf()) {
                t1 = System.currentTimeMillis();
                this.m_Util.printPerfln(Thread.currentThread().getName() + ",UpdateMetadata," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            }
            if (rc != 0) {
                this.m_Util.printOutputln("Bad Update! rc = " + rc);
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        this.m_Util.printLoglnServer(outXML.value);
        return rc;
    }

    @Override
    public int addMetadata(String inXML, String reposID, StringHolder outXML, int iFlags) throws MdException, RemoteException {
        if ((iFlags & 0x10000000) == 0) {
            iFlags |= 0x10000000;
        }
        String kludgeReposID = "A0000001." + reposID.substring(0, 8);
        int rc = 0;
        this.m_Util.printLoglnClient(inXML);
        try {
            long t0 = 0L;
            long t1 = 0L;
            if (this.m_factory.getPerf()) {
                t0 = System.currentTimeMillis();
            }
            rc = this.m_connection.getCMRHandle().AddMetadata(inXML, kludgeReposID, outXML, this.m_Namespace, iFlags, "");
            if (this.m_factory.getPerf()) {
                t1 = System.currentTimeMillis();
                this.m_Util.printPerfln(Thread.currentThread().getName() + ",AddMetadata," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            }
            if (rc != 0) {
                this.m_Util.printOutputln("Bad Add! rc = " + rc);
                this.m_Util.printLoglnServer(outXML.value);
            } else {
                this.m_Util.printLoglnServer(outXML.value);
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return rc;
    }

    @Override
    public List copyMetadata(MdObjectStore instore, String inXML, String reposID, String template, int iFlags) throws MdException, RemoteException {
        return this.copyMetadata(this.m_connection.getCMRHandle(), instore, inXML, reposID, template, iFlags);
    }

    @Override
    public synchronized List copyMetadata(IOMI connectionHandle, MdObjectStore instore, String inXML, String reposID, String template, int iFlags) throws MdException, RemoteException {
        ArrayList<CMetadata> idList = new ArrayList<CMetadata>(10);
        ArrayList<String> idOnlyList = new ArrayList<String>(10);
        String kludgeReposID = "A0000001." + reposID.substring(0, 8);
        int rc = 0;
        if (template != null && template.length() > 0) {
            template = "<LockTemplates>" + template + "</LockTemplates>";
            iFlags |= 0x10000;
        }
        StringBuffer inputXML = new StringBuffer("<CopyMetadata><Metadata>");
        inputXML.append(inXML);
        inputXML.append("</Metadata><ToReposid>");
        inputXML.append(kludgeReposID);
        inputXML.append("</ToReposid><Ns>");
        inputXML.append(this.m_Namespace);
        inputXML.append("</Ns><Flags>");
        inputXML.append(iFlags);
        inputXML.append("</Flags><Options>");
        inputXML.append(template);
        inputXML.append("</Options><CopyMetadata>");
        this.m_Util.printLoglnClient(inputXML.toString());
        StringHolder outXML = new StringHolder();
        try {
            long t0 = 0L;
            long t1 = 0L;
            if (this.m_factory.getPerf()) {
                t0 = System.currentTimeMillis();
            }
            rc = connectionHandle.CopyMetadata(inXML, kludgeReposID, outXML, this.m_Namespace, iFlags, template);
            if (this.m_factory.getPerf()) {
                t1 = System.currentTimeMillis();
                this.m_Util.printPerfln(Thread.currentThread().getName() + ",CopyMetadata," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            }
            if (rc != 0) {
                this.m_Util.printOutputln("Bad Add! rc = " + rc);
                this.m_Util.printLoglnServer(outXML.value);
            } else {
                this.m_Util.printLoglnServer(outXML.value);
            }
            String outStrings = new String("<CopyMetadata>" + outXML.value + "</CopyMetadata>");
            Document doc = this.parseXML(outStrings);
            Node firstNode = doc.getFirstChild();
            NodeList typeNodeList = firstNode.getChildNodes();
            int length = typeNodeList.getLength();
            for (int index = 0; index < length; ++index) {
                CMetadata createdObject;
                Node nameNode;
                String type = null;
                String name = "";
                String id = null;
                Node objectNode = typeNodeList.item(index);
                type = objectNode.getNodeName();
                NamedNodeMap nodeMap = objectNode.getAttributes();
                Node idNode = nodeMap.getNamedItem("Id");
                if (idNode != null) {
                    id = idNode.getNodeValue();
                }
                if ((nameNode = nodeMap.getNamedItem("Name")) != null) {
                    name = nameNode.getNodeValue();
                }
                if ((createdObject = this.m_factory.createComplexMetadataObject(instore, null, name, type, id, null)) == null) continue;
                this.m_factory.getInstance().fireMdObjectCreated(new MdEvent(this.m_factory.getInstance(), instore), createdObject.getId());
                idList.add(createdObject);
                idOnlyList.add(createdObject.getId());
            }
            firstNode = null;
            typeNodeList = null;
            doc = null;
            if (idList.size() > 0) {
                this.m_factory.fireMdObjectsCreated(new MdEvent(this.m_factory, instore), idOnlyList);
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return idList;
    }

    @Override
    public void getTypes(List<String> nameList, List<String> descList) throws MdException, RemoteException {
        if (this.m_factory.getParsingType() == 0) {
            this.omi_wrapper.getTypes(this.m_connection.getCMRHandle(), nameList, descList);
            return;
        }
        StringHolder outXML = new StringHolder();
        StringBuffer inputXML = new StringBuffer(67);
        inputXML.append("<GetTypes><Types/><NS>");
        inputXML.append(this.m_Namespace);
        inputXML.append("</NS><Flags>0</Flags><Options/></GetTypes>");
        this.m_Util.printLoglnClient(inputXML.toString());
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            this.m_connection.getCMRHandle().GetTypes(outXML, this.m_Namespace, 0, "");
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this.m_factory, e)) {
                this.getTypes(nameList, descList);
                return;
            }
            throw new MdException(e);
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            this.m_Util.printPerfln(Thread.currentThread().getName() + ",GetTypes," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        String strXML = outXML.value;
        this.m_Util.printLoglnServer(strXML);
        Document doc = this.parseXML(strXML);
        Node firstNode = doc.getFirstChild();
        NodeList typeNodeList = firstNode.getChildNodes();
        int length = typeNodeList.getLength();
        for (int index = 0; index < length; ++index) {
            NamedNodeMap nodeMap = typeNodeList.item(index).getAttributes();
            Node idNode = nodeMap.getNamedItem("Id");
            if (idNode != null) {
                nameList.add(index, idNode.getNodeValue());
            } else {
                idNode = nodeMap.getNamedItem("ObjRef");
                if (idNode != null) {
                    nameList.add(index, idNode.getNodeValue());
                }
            }
            Node descNode = nodeMap.getNamedItem("Desc");
            if (descNode == null) continue;
            descList.add(index, descNode.getNodeValue());
        }
        doc = null;
    }

    @Override
    public void getTypeProperties(String objectType, Map<String, Map<String, String>> attributeMap, Map<String, Map<String, String>> associationMap) throws MdException, RemoteException {
        StringHolder outXML = new StringHolder();
        StringBuffer inputXML = new StringBuffer(105);
        inputXML.append("<GetTypeProperties><Type>");
        inputXML.append(objectType);
        inputXML.append("</Type><NS>");
        inputXML.append(this.m_Namespace);
        inputXML.append("</NS><Flags>");
        inputXML.append(1);
        inputXML.append("</Flags><Options/></GetTypeProperties>");
        this.m_Util.printLoglnClient(inputXML.toString());
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            this.m_connection.getCMRHandle().GetTypeProperties(objectType, outXML, this.m_Namespace, 1, "");
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this.m_factory, e)) {
                this.getTypeProperties(objectType, attributeMap, associationMap);
                return;
            }
            throw new MdException(e);
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            this.m_Util.printPerfln(Thread.currentThread().getName() + ",GetTypeProperties," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        String strXML = outXML.value;
        this.m_Util.printLoglnServer(strXML);
        Document doc = this.parseXML(strXML);
        Node firstNode = doc.getFirstChild();
        NodeList typeNodeList = firstNode.getChildNodes();
        for (int i = 0; i < typeNodeList.getLength(); ++i) {
            Node typeNode = typeNodeList.item(i);
            boolean isAttribute = false;
            boolean isAssociation = false;
            if (typeNode.getNodeName().equalsIgnoreCase("Attributes")) {
                isAttribute = true;
            } else if (typeNode.getNodeName().equalsIgnoreCase("Associations")) {
                isAssociation = true;
            }
            NodeList list = typeNode.getChildNodes();
            for (int j = 0; j < list.getLength(); ++j) {
                Node node = list.item(j);
                NamedNodeMap nodeMap = node.getAttributes();
                if (nodeMap == null || nodeMap.getLength() <= 0) continue;
                int length = nodeMap.getLength();
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(length);
                for (int k = 0; k < length; ++k) {
                    Node attr = nodeMap.item(k);
                    map.put(attr.getNodeName(), attr.getNodeValue());
                }
                if (isAttribute) {
                    attributeMap.put(node.getNodeName(), map);
                    continue;
                }
                if (!isAssociation) continue;
                associationMap.put(node.getNodeName(), map);
            }
        }
        doc = null;
    }

    @Override
    public List<String> getSubTypes(String objectType, boolean includeDescendants) throws MdException, RemoteException {
        int flags = includeDescendants ? 64 : 0;
        StringHolder outXML = new StringHolder();
        StringBuffer inputXML = new StringBuffer(105);
        inputXML.append("<GetSubtypes><Supertype>");
        inputXML.append(objectType);
        inputXML.append("</Supertype><Subtypes/><NS>");
        inputXML.append(this.m_Namespace);
        inputXML.append("</NS><Flags>");
        inputXML.append(flags);
        inputXML.append("</Flags><Options/></GetSubtypes>");
        this.m_factory.getUtil().printLoglnClient(inputXML.toString());
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            this.m_connection.getCMRHandle().GetSubtypes(objectType, outXML, this.m_Namespace, flags, "");
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this.m_factory, e)) {
                return this.getSubTypes(objectType, includeDescendants);
            }
            throw new MdException(e);
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            this.m_factory.getUtil().printPerfln(Thread.currentThread().getName() + ",GetSubtypes," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        String strXML = outXML.value;
        this.m_factory.getUtil().printLoglnServer(strXML);
        ArrayList<String> types = new ArrayList<String>();
        Document doc = this.parseXML(strXML);
        Node firstNode = doc.getFirstChild();
        NodeList typeNodeList = firstNode.getChildNodes();
        for (int i = 0; i < typeNodeList.getLength(); ++i) {
            Node idNode;
            NamedNodeMap nodeMap;
            Node typeNode = typeNodeList.item(i);
            if (typeNode.getNodeType() != 1 || (nodeMap = typeNode.getAttributes()) == null || (idNode = nodeMap.getNamedItem("Id")) == null) continue;
            types.add(idNode.getNodeValue());
        }
        doc = null;
        return types;
    }

    @Override
    public CMetadata getAssociatedObject(CMetadata object, String strAssociation, String strTemplate) throws MdException, RemoteException {
        return this.getAssociatedObject(object, strAssociation, strTemplate, false);
    }

    @Override
    public CMetadata getAssociatedObject(CMetadata object, String strAssociation, String strTemplate, boolean doNotOverrideAssocs) throws MdException, RemoteException {
        CMetadata md = null;
        AssociationList objList = this.getAssociatedObjects(object, strAssociation, strTemplate, doNotOverrideAssocs);
        if (objList != null && objList.size() > 0) {
            md = (CMetadata)objList.get(0);
        }
        return md;
    }

    @Override
    public AssociationList getAssociatedObjects(CMetadata object, String strAssociation, String strTemplate) throws MdException, RemoteException {
        return this.getAssociatedObjects(object, strAssociation, strTemplate, false);
    }

    @Override
    public AssociationList getAssociatedObjects(CMetadata object, String strAssociation, String strTemplate, boolean doNotOverrideAssocs) throws MdException, RemoteException {
        Node firstNode;
        if (this.m_factory.getParsingType() == 0) {
            return this.omi_wrapper.getAssociatedObjects(object, strAssociation, strTemplate, doNotOverrideAssocs);
        }
        ArrayList<String> inXMLComplex = new ArrayList<String>(1);
        inXMLComplex.add(strAssociation);
        int options = 2056;
        if (strTemplate != null && strTemplate.length() > 0) {
            options |= 4;
        }
        if (this.m_factory.getDebug()) {
            this.m_factory.getUtil().printOutputln("DEBUG NOTE: GetAssociatedObjects going to the server for association " + strAssociation + " (Object Type: " + object.getCMetadataType() + ")");
        }
        if (object == null || object.getFQID().indexOf(36) > -1 || !object.getObjectStore().isGoToServerForMetadata()) {
            this.m_Util.printOutputln(this.m_factory.getBundle().getString("MetadataUtil.getMetadataAllDepthsNotToServer.txt"));
            return object.getMdObjectAssociation(strAssociation);
        }
        String inXML = this.createGetXMLString(object.getCMetadataType(), object.getFQID(), null, inXMLComplex);
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        Document doc = this.getMetadata(inXML, strTemplate, options);
        if (object.getObjectStore() == null) {
            object = this.m_factory.createComplexMetadataObjectServerStoreOnly(object.getName(), object.getCMetadataType(), object.getFQID());
        }
        if ((object = this.populateObject(object, (firstNode = doc.getFirstChild()).getAttributes(), firstNode.getChildNodes(), doNotOverrideAssocs)).getObjectStore().getStoreType() == 0) {
            object.resetObject();
        }
        AssociationList associatedObjectList = null;
        NodeList nl = doc.getElementsByTagName(strAssociation);
        if (nl.getLength() == 0) {
            associatedObjectList = new AssociationList(strAssociation, this.m_factory.isRemoteEnvironment());
            associatedObjectList.setState(1);
            object.setMdObjectAssociation(associatedObjectList);
        } else {
            associatedObjectList = object.getMdObjectAssociation(strAssociation);
            if (object.getObjectStore().isGoToServerForMetadata()) {
                associatedObjectList.setState(1);
            }
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            StringBuffer sb = new StringBuffer();
            sb.append(Thread.currentThread().getName());
            sb.append(",GetMetadata Parsing Time,");
            sb.append(DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            this.m_factory.getUtil().printPerfln(sb.toString());
        }
        firstNode = null;
        doc = null;
        return associatedObjectList;
    }

    @Override
    public String getAttribute(String strAttribute, NamedNodeMap childNodeMap) throws RemoteException {
        String returnValue = null;
        try {
            returnValue = childNodeMap.getNamedItem(strAttribute).getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return returnValue;
    }

    @Override
    public Document parseXML(String strXML) throws MdException, RemoteException {
        StringReader strReader = new StringReader(strXML);
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder m_docBuilder = null;
        try {
            m_docBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MdException(e);
        }
        try {
            doc = m_docBuilder.parse(new InputSource(strReader));
        }
        catch (IOException ioe) {
            throw new MdException(ioe);
        }
        catch (SAXException e) {
            throw new MdException(e);
        }
        m_docBuilder = null;
        dbf = null;
        return doc;
    }

    public Document parseXML(String strXML, boolean ignoreWhitespace) throws MdException {
        StringReader strReader = new StringReader(strXML);
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        if (ignoreWhitespace) {
            dbf.setValidating(true);
            dbf.setIgnoringElementContentWhitespace(true);
        }
        DocumentBuilder m_docBuilder = null;
        try {
            m_docBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MdException(e);
        }
        try {
            doc = m_docBuilder.parse(new InputSource(strReader));
        }
        catch (IOException ioe) {
            throw new MdException(ioe);
        }
        catch (SAXException e) {
            throw new MdException(e);
        }
        m_docBuilder = null;
        dbf = null;
        return doc;
    }

    @Override
    public Document parseXML(URL xmlDocument) throws MdException, RemoteException {
        return this.parseXML(xmlDocument, null);
    }

    @Override
    public Document parseXML(URL xmlDocument, Map<String, Boolean> features) throws MdException, RemoteException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder m_docBuilder = null;
        try {
            if (features != null) {
                for (Map.Entry<String, Boolean> entry : features.entrySet()) {
                    dbf.setFeature(entry.getKey(), entry.getValue());
                }
            }
            m_docBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MdException(e);
        }
        Document doc = null;
        try {
            doc = m_docBuilder.parse(new InputSource(xmlDocument.openStream()));
        }
        catch (IOException ioe) {
            throw new MdException(ioe);
        }
        catch (SAXException e) {
            throw new MdException(e);
        }
        m_docBuilder = null;
        dbf = null;
        return doc;
    }

    @Override
    public String formatXML(String original) throws RemoteException {
        return XMLUtil.formatXML(original);
    }

    @Override
    public synchronized List<String> deleteMetadataObject(CMetadata inObject) throws MdException, RemoteException {
        return this.deleteMetadataObject(inObject.getCMetadataType(), inObject.getFQID());
    }

    @Override
    public synchronized List<String> deleteMetadataObject(CMetadata metadataObject, String template) throws MdException, RemoteException {
        return this.deleteMetadataObject(metadataObject.getCMetadataType(), metadataObject.getId(), template);
    }

    @Override
    public synchronized List<String> deleteMetadataObject(String objectType, String objectID) throws MdException, RemoteException {
        return this.deleteMetadataObject(objectType, objectID, null);
    }

    @Override
    public synchronized List<String> deleteMetadataObject(String objectType, String objectID, String template) throws MdException, RemoteException {
        StringBuffer inXML = new StringBuffer(40);
        inXML.append("<");
        inXML.append(objectType);
        inXML.append(" Id=\"");
        inXML.append(objectID);
        inXML.append("\"");
        if (template != null) {
            String nameAttr = "TemplateName";
            int index = template.indexOf("TemplateName");
            if (index < 0) {
                throw new IllegalArgumentException("Invalid template.  The TemplateName is required.");
            }
            int start = index + "TemplateName".length() + 2;
            String name = template.substring(start, template.indexOf("\"", start));
            inXML.append(" TemplateName=\"");
            inXML.append(name);
            inXML.append("\"");
        }
        inXML.append("/>");
        String templates = template == null ? null : "<Templates>" + template + "</Templates>";
        return this.deleteObjectsFromServer(inXML.toString(), templates);
    }

    @Override
    public synchronized List<String> deleteMetadataObjects(List<? extends CMetadata> inObjects) throws MdException, RemoteException {
        if (inObjects.isEmpty()) {
            return Collections.emptyList();
        }
        StringBuffer inXML = new StringBuffer();
        for (int i = 0; i < inObjects.size(); ++i) {
            CMetadata inObject = inObjects.get(i);
            inXML.append("<");
            inXML.append(inObject.getCMetadataType());
            inXML.append(" Id=\"");
            inXML.append(inObject.getFQID());
            inXML.append("\"/>");
        }
        return this.deleteObjectsFromServer(inXML.toString(), null);
    }

    @Override
    public synchronized List<String> deleteMetadataObjects(Map<String, String> inObjects) throws MdException, RemoteException {
        if (inObjects.isEmpty()) {
            return Collections.emptyList();
        }
        StringBuffer inXML = new StringBuffer();
        for (String id : inObjects.keySet()) {
            String type = inObjects.get(id);
            if (type == null) continue;
            inXML.append("<");
            inXML.append(type);
            inXML.append(" Id=\"");
            inXML.append(id);
            inXML.append("\"/>");
        }
        return this.deleteObjectsFromServer(inXML.toString(), null);
    }

    private synchronized List<String> deleteObjectsFromServer(String inXML, String templates) throws MdException, RemoteException {
        if (this.m_factory.getParsingType() == 0) {
            return this.omi_wrapper.deleteObjectsFromServer(inXML, templates);
        }
        Vector<String> idList = new Vector<String>(10);
        StringHolder outXML = new StringHolder();
        int flags = 0x10000000;
        flags ^= 0x400;
        flags ^= 0x8000000;
        if (templates != null) {
            flags |= 4;
        } else {
            templates = "";
        }
        if (this.m_factory.getLoggingEnabled()) {
            StringBuffer inputXML = new StringBuffer(105 + inXML.length());
            inputXML.append("<DeleteMetadata><Metadata>");
            inputXML.append(inXML);
            inputXML.append("</Metadata><NS>");
            inputXML.append(this.m_Namespace);
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags>");
            if (templates == null) {
                inputXML.append("<Options/>");
            } else {
                inputXML.append("<Options>");
                inputXML.append(templates);
                inputXML.append("</Options>");
            }
            inputXML.append("</DeleteMetadata>");
            this.m_Util.printLoglnClient(inputXML.toString());
        }
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            IOMI connectionHandle = this.m_connection.getCMRHandle();
            if (connectionHandle == null) {
                throw new IllegalStateException(this.m_factory.getBundle().getString("MdOMIUtil.NoServerConnection.txt"));
            }
            connectionHandle.DeleteMetadata(inXML, outXML, this.m_Namespace, flags, templates);
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this.m_factory, e)) {
                return this.deleteObjectsFromServer(inXML, templates);
            }
            throw new MdException(e);
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            this.m_Util.printPerfln(Thread.currentThread().getName() + ",DeleteMetadata," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        StringBuffer outStrings = new StringBuffer(33 + outXML.value.length());
        outStrings.append("<DeleteMetadata>");
        outStrings.append(outXML.value);
        outStrings.append("</DeleteMetadata>");
        this.m_Util.printLoglnServer(outStrings.toString());
        Document doc = this.parseXML(outStrings.toString());
        Node firstNode = doc.getFirstChild();
        NodeList typeNodeList = firstNode.getChildNodes();
        int length = typeNodeList.getLength();
        for (int index = 0; index < length; ++index) {
            NamedNodeMap nodeMap = typeNodeList.item(index).getAttributes();
            Node idNode = nodeMap.getNamedItem("Id");
            if (idNode == null) continue;
            idList.add(index, idNode.getNodeValue());
        }
        doc = null;
        return idList;
    }

    @Override
    public synchronized List unlockMetadataObjects(List inObjects) throws MdException, RemoteException {
        return this.unlockMetadataObjects(this.m_factory.getConnection().getCMRHandle(), inObjects);
    }

    public synchronized List unlockMetadataObjects(IOMI connectionHandle, List inObjects) throws MdException, RemoteException {
        Vector<String> idList = new Vector<String>(10);
        StringBuffer inXML = new StringBuffer("");
        if (inObjects.size() > 0) {
            for (int i = 0; i < inObjects.size(); ++i) {
                CMetadata inObject = (CMetadata)inObjects.get(i);
                inXML.append("<");
                inXML.append(inObject.getCMetadataType());
                inXML.append(" Id=\"");
                inXML.append(inObject.getFQID());
                inXML.append("\"/>");
            }
        } else {
            return idList;
        }
        StringHolder outXML = new StringHolder();
        int flags = 0x10000000;
        flags ^= 0x400;
        flags ^= 0x8000000;
        flags ^= 0x40000;
        String options = new String("");
        StringBuffer inputXML = new StringBuffer("<UpdateMetadata><Metadata>");
        inputXML.append(inXML);
        inputXML.append("</Metadata><NS>");
        inputXML.append(this.m_Namespace);
        inputXML.append("</NS><Flags>");
        inputXML.append(flags);
        inputXML.append("</Flags><Options/>");
        inputXML.append("</UpdateMetadata>");
        this.m_Util.printLoglnClient(inputXML.toString());
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            connectionHandle.UpdateMetadata(inXML.toString(), outXML, this.m_Namespace, flags, options);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            this.m_Util.printPerfln(Thread.currentThread().getName() + ",UpdateMetadata," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        StringBuffer outStrings = new StringBuffer("<UpdateMetadata>");
        outStrings.append(outXML.value);
        outStrings.append("</UpdateMetadata>");
        this.m_Util.printLoglnServer(outStrings.toString());
        Document doc = this.parseXML(outStrings.toString());
        Node firstNode = doc.getFirstChild();
        NodeList typeNodeList = firstNode.getChildNodes();
        int length = typeNodeList.getLength();
        for (int index = 0; index < length; ++index) {
            NamedNodeMap nodeMap = typeNodeList.item(index).getAttributes();
            Node idNode = nodeMap.getNamedItem("Id");
            if (idNode == null) continue;
            idList.add(index, idNode.getNodeValue());
        }
        doc = null;
        return idList;
    }

    @Override
    public synchronized Document ApplyXML(String inXML, String reposID) throws MdException, RemoteException {
        StringBuffer outputXML = new StringBuffer(130 + (inXML == null ? 0 : inXML.length()));
        outputXML.append("<AddMetadata><Metadata>");
        outputXML.append(inXML);
        outputXML.append("</Metadata><Reposid>");
        outputXML.append(reposID);
        outputXML.append("</Reposid><Ns>SAS</Ns>");
        outputXML.append("<Flags>268435456</Flags><Options/></AddMetadata>");
        this.m_Util.printLoglnClient(outputXML.toString());
        StringHolder outXML = new StringHolder();
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            this.m_connection.getCMRHandle().DoRequest(outputXML.toString(), outXML);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            this.m_Util.printPerfln(Thread.currentThread().getName() + ",DoRequest," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        String outXMLString = outXML.value;
        this.m_Util.printLoglnServer(outXMLString);
        return this.parseXML(outXMLString);
    }

    private String getMetadataFromServer(String inXML, int flags, String options) throws MdException, RemoteException {
        StringHolder outXML = new StringHolder();
        if (options == null) {
            options = "";
        }
        if (!this.m_factory.getUseServerFormattedDates()) {
            flags |= 0x4000000;
        }
        if (this.m_factory.getLoggingEnabled()) {
            StringBuffer inputXML = new StringBuffer(100 + inXML.length() + options.length());
            inputXML.append("<GetMetadata><Metadata>");
            inputXML.append(inXML);
            inputXML.append("</Metadata><NS>");
            inputXML.append(this.getNamespace());
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags><Options>");
            inputXML.append(options);
            inputXML.append("</Options></GetMetadata>");
            this.m_Util.printLoglnClient(inputXML.toString());
        }
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            IOMI connectionHandle = this.m_connection.getCMRHandle();
            if (connectionHandle == null) {
                throw new IllegalStateException(this.m_factory.getBundle().getString("MdOMIUtil.NoServerConnection.txt"));
            }
            connectionHandle.GetMetadata(inXML, outXML, this.getNamespace(), flags, options);
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this.m_factory, e)) {
                return this.getMetadataFromServer(inXML, flags, options);
            }
            throw new MdException(e);
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            StringBuffer sb = new StringBuffer();
            sb.append(Thread.currentThread().getName());
            sb.append(",GetMetadata,");
            sb.append(DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            this.m_Util.printPerfln(sb.toString());
        }
        this.m_Util.printLoglnServer(outXML.value);
        return outXML.value;
    }

    private String getMetadataObjectsFromServer(String reposID, String type, int flags, String options) throws MdException, RemoteException {
        StringHolder outXML = new StringHolder();
        if (options == null) {
            options = "";
        }
        if (!this.m_factory.getUseServerFormattedDates()) {
            flags |= 0x4000000;
        }
        if (this.m_factory.getLoggingEnabled()) {
            StringBuffer inputXML = new StringBuffer(155 + options.length());
            inputXML.append("<GetMetadataObjects><Reposid>");
            inputXML.append(reposID);
            inputXML.append("</Reposid><Type>");
            inputXML.append(type);
            inputXML.append("</Type><NS>");
            inputXML.append(this.getNamespace());
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags><Options>");
            inputXML.append(options);
            inputXML.append("</Options></GetMetadataObjects>");
            this.m_Util.printLoglnClient(inputXML.toString());
        }
        long t0 = 0L;
        long t1 = 0L;
        if (this.m_factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            IOMI connectionHandle = this.m_connection.getCMRHandle();
            if (connectionHandle == null) {
                throw new IllegalStateException(this.m_factory.getBundle().getString("MdOMIUtil.NoServerConnection.txt"));
            }
            connectionHandle.GetMetadataObjects(reposID, type, outXML, this.getNamespace(), flags, options);
        }
        catch (Exception e) {
            if (ConnectionUtil.shouldRetryFailedRequest(this.m_factory, e)) {
                return this.getMetadataObjectsFromServer(reposID, type, flags, options);
            }
            throw new MdException(e);
        }
        if (this.m_factory.getPerf()) {
            t1 = System.currentTimeMillis();
            StringBuffer sb = new StringBuffer();
            sb.append(Thread.currentThread().getName());
            sb.append(",GetMetadataObjects,");
            sb.append(DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            this.m_Util.printPerfln(sb.toString());
        }
        this.m_Util.printLoglnServer(outXML.value);
        return outXML.value;
    }

    @Override
    public Identity getIdentity(MdObjectStore store) throws MdException, RemoteException {
        ISecurity_1_1 iSec = null;
        try {
            iSec = this.m_factory.getConnection().MakeISecurityConnection();
        }
        catch (RemoteException exc) {
            throw new MdException(exc.getLocalizedMessage());
        }
        StringHolder returnStrHolder = new StringHolder();
        try {
            iSec.GetIdentity("", returnStrHolder);
        }
        catch (Exception exc) {
            throw new MdException(exc);
        }
        Identity iIdentity = null;
        String retValue = returnStrHolder.value;
        if (retValue != null && !retValue.startsWith("UNKNOWN:") && retValue.startsWith("OMSOBJ:")) {
            String objid = retValue.substring(retValue.lastIndexOf(47) + 1);
            String strType = retValue.substring(retValue.lastIndexOf(58) + 1, retValue.lastIndexOf(47));
            iIdentity = (Identity)this.m_factory.createComplexMetadataObject(store, null, "", strType, objid);
        }
        return iIdentity;
    }

    @Override
    public String getFoundationReposID() throws MdException, RemoteException {
        String repositoryID;
        block5: {
            MdOMIUtil util = this.m_factory.getOMIUtil();
            IOMI mdconn = this.m_factory.getConnection().getCMRHandle();
            repositoryID = "";
            StringHolder outXML = new StringHolder();
            String options = "<XMLSELECT search=\"@RepositoryType='FOUNDATION'\"/>";
            int flags = 392;
            try {
                mdconn.GetMetadataObjects("A0000001.A0000001", "RepositoryBase", outXML, "REPOS", flags, options);
                String outXMLString = outXML.value.toString();
                Document mainDoc = util.parseXML(outXMLString);
                if (mainDoc == null) break block5;
                Node firstNode = mainDoc.getFirstChild();
                NodeList nodeList = firstNode.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node currentNode = nodeList.item(i);
                    NamedNodeMap nodeMap = currentNode.getAttributes();
                    if (nodeMap.getNamedItem("Id") == null) continue;
                    repositoryID = nodeMap.getNamedItem("Id").getNodeValue();
                    break;
                }
            }
            catch (Exception e) {
                if (ConnectionUtil.shouldRetryFailedRequest(this.m_factory, e)) {
                    return this.getFoundationReposID();
                }
                throw new MdException(e);
            }
        }
        if (repositoryID.equals("")) {
            throw new MdException("Unable to find the Foundation repository");
        }
        return repositoryID;
    }
}

