/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.VariableArray2dOfAnyHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.ISecurityAdmin;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.remote.AccessControlTemplate;
import com.sas.metadata.remote.ActPermissionMapEntry;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.IdentityNameTypeEntry;
import com.sas.metadata.remote.MdAuthorizationExplainedInfo;
import com.sas.metadata.remote.MdAuthorizationExplainedInfoImpl;
import com.sas.metadata.remote.MdAuthorizationIdentityInfo;
import com.sas.metadata.remote.MdAuthorizationIdentityInfoImpl;
import com.sas.metadata.remote.MdAuthorizationInfo;
import com.sas.metadata.remote.MdAuthorizationInfoImpl;
import com.sas.metadata.remote.MdAuthorizationUtil;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdIndirectPermissionInfo;
import com.sas.metadata.remote.MdIndirectPermissionInfoImpl;
import com.sas.metadata.remote.MdInheritanceInfo;
import com.sas.metadata.remote.MdInheritanceInfoImpl;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdPermissionExplainedInfo;
import com.sas.metadata.remote.MdPermissionInfo;
import com.sas.metadata.remote.MdPermissionInfoImpl;
import com.sas.metadata.remote.MdStore;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.StringHolder;

@SASScope
public class MdAuthorizationUtilImpl
implements MdAuthorizationUtil,
Serializable {
    private static final long serialVersionUID = 8759511999143249531L;
    private CMetadata targetObject;
    private boolean actDef;
    private MdObjectStore store;
    private boolean commitOnUpdate = true;
    private MdFactory fact;
    private ISecurityAdmin iSecAdmin;
    private ISecurity_1_1 iSecurity;
    private MdOMRConnection conn;
    private String iSecTC = null;
    private String resourceSpec = "";
    private Map<String, MdAuthorizationIdentityInfo> localIdentityInfoMap = null;
    private boolean localIdentityInfoMapCurrent;
    private Map<String, MdAuthorizationInfo> localAuthCache = null;
    private boolean localAuthCacheCurrent;
    private Map<String, List<List<String>>> memberships = null;
    private boolean membershipsCurrent;
    private List<AccessControlTemplate> localACTCache = null;
    private boolean localACTCacheCurrent;
    private Map<String, List<ActPermissionMapEntry>> localACTAuthCache = null;
    private boolean localACTAuthCacheCurrent;
    private MdInheritanceInfo localInheritanceInfoCache = null;
    private boolean localInheritanceInfoCacheCurrent;
    private Map<String, MdAuthorizationUtilImpl> localInheritanceInfoAuthUtilImplMap = null;
    private IdentityGroup PUBLIC = null;
    private IdentityGroup SASUSERS = null;

    public MdAuthorizationUtilImpl(CMetadata obj, boolean actDef) throws IllegalArgumentException, RemoteException, MdException {
        if (obj == null) {
            throw new IllegalArgumentException("A valid object reference is required");
        }
        try {
            this.localIdentityInfoMap = new HashMap<String, MdAuthorizationIdentityInfo>();
            this.targetObject = obj;
            this.actDef = actDef;
            MdStore castStore = obj.getObjectStore();
            if (castStore instanceof MdObjectStore) {
                this.store = (MdObjectStore)castStore;
            }
            this.fact = this.store.getFactory();
            this.conn = this.fact.getConnection();
            String objId = obj.getId();
            if (objId.length() > 0 && objId.charAt(9) != '$') {
                this.resourceSpec = "OMSOBJ:" + obj.getCMetadataType() + "/" + objId;
            }
            if (this.fact.isRemoteEnvironment()) {
                UnicastRemoteObject.exportObject(this);
            }
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    @Override
    public boolean getCommitOnUpdate() throws MdException, RemoteException {
        return this.commitOnUpdate;
    }

    @Override
    public void setCommitOnUpdate(boolean commitOnUpdate) throws MdException, RemoteException {
        this.commitOnUpdate = commitOnUpdate;
    }

    @Override
    public List<String> getApplicablePermissions() throws MdException, RemoteException {
        ArrayList<String> applPerms = null;
        int flags = this.actDef ? 4 : 0;
        String[][] publicGroup = new String[1][2];
        publicGroup[0][0] = "IdentityGroup";
        publicGroup[0][1] = "PUBLIC";
        VariableArray2dOfAnyHolder authsFromServer = new VariableArray2dOfAnyHolder();
        String allPermissions = "";
        String trnsCtxt = this.getTransactionContext();
        try {
            this.iSecAdmin.GetAuthorizationsOnObj(trnsCtxt, "", flags, publicGroup, allPermissions, authsFromServer);
            applPerms = new ArrayList<String>(authsFromServer.value.length);
            for (int i = 0; i < authsFromServer.value.length; ++i) {
                applPerms.add(authsFromServer.value[i][3].extract_string());
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return applPerms;
    }

    @Override
    public List<MdAuthorizationIdentityInfo> getIdentityInfo() throws MdException, RemoteException {
        try {
            return new ArrayList<MdAuthorizationIdentityInfo>(this.getIdentityInfoUtil());
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    @Override
    public MdAuthorizationInfo getAuthorizations(Identity identity, List<String> permissions) throws IllegalArgumentException, MdException, RemoteException {
        if (identity == null) {
            throw new IllegalArgumentException("A valid Identity object reference is required");
        }
        if (permissions == null) {
            permissions = Collections.emptyList();
        }
        try {
            ArrayList<Identity> identities = new ArrayList<Identity>(1);
            identities.add(identity);
            Map<String, MdAuthorizationInfo> authsForIdentity = this.getAuthorizationsUtil(identities, permissions, false);
            return authsForIdentity.get(identity.getId());
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    @Override
    public List<MdAuthorizationInfo> getAuthorizations(List<Identity> identities, List<String> permissions) throws MdException, RemoteException {
        if (identities == null) {
            identities = Collections.emptyList();
        }
        if (permissions == null) {
            permissions = Collections.emptyList();
        }
        try {
            Map<String, MdAuthorizationInfo> authsForIdentities = this.getAuthorizationsUtil(identities, permissions, false);
            ArrayList<MdAuthorizationInfo> authorizations = new ArrayList<MdAuthorizationInfo>(authsForIdentities.size());
            Collection<MdAuthorizationInfo> mapValues = authsForIdentities.values();
            for (MdAuthorizationInfo authInfo : mapValues) {
                authorizations.add(authInfo);
            }
            return authorizations;
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    @Override
    public List<MdAuthorizationInfo> getAuthorizationsAll() throws MdException, RemoteException {
        try {
            return this.getAuthorizations(new ArrayList<Identity>(0), new ArrayList<String>(0));
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    @Override
    public MdInheritanceInfo getInheritanceInfo() throws MdException, RemoteException {
        return this.buildInheritanceInfo();
    }

    @Override
    public MdAuthorizationExplainedInfo getAuthorizationsExplained(Identity identity, List<String> permissions) throws IllegalArgumentException, MdException, RemoteException {
        if (identity == null) {
            throw new IllegalArgumentException("A valid Identity object reference is required");
        }
        if (permissions == null) {
            permissions = Collections.emptyList();
        }
        try {
            ArrayList<Identity> identities = new ArrayList<Identity>(1);
            identities.add(identity);
            List<MdAuthorizationExplainedInfo> authsExplainedForIdentity = this.getAuthorizationsExplainedUtil(identities, permissions, true);
            return authsExplainedForIdentity.size() > 0 ? authsExplainedForIdentity.get(0) : null;
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    @Override
    public List<MdAuthorizationExplainedInfo> getAuthorizationsExplained(List<Identity> identities, List<String> permissions) throws MdException, RemoteException {
        if (identities == null) {
            identities = Collections.emptyList();
        }
        if (permissions == null) {
            permissions = Collections.emptyList();
        }
        try {
            List<MdAuthorizationExplainedInfo> authsExplainedForIdentity = this.getAuthorizationsExplainedUtil(identities, permissions, true);
            return authsExplainedForIdentity;
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    @Override
    public List<MdAuthorizationExplainedInfo> getAuthorizationsExplainedAll() throws MdException, RemoteException {
        try {
            List<MdAuthorizationExplainedInfo> authsExplainedForIdentity = this.getAuthorizationsExplainedUtil(new ArrayList<Identity>(0), new ArrayList<String>(0), true);
            return authsExplainedForIdentity;
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    @Override
    public void setAuthorizations(Identity identity, List<MdPermissionInfo> permissionInfoList) throws IllegalArgumentException, MdException, RemoteException {
        if (identity == null) {
            throw new IllegalArgumentException("A valid Identity object reference is required");
        }
        if (permissionInfoList == null) {
            throw new IllegalArgumentException("A valid List object of MdPermissionInfo references is required");
        }
        try {
            this.localIdentityInfoMapCurrent = false;
            this.localAuthCacheCurrent = false;
            String trnsCtxt = this.getTransactionContext();
            int permCnt = permissionInfoList.size();
            if (permCnt > 0) {
                int i = 0;
                String[][] authsToSet = new String[permCnt][5];
                for (MdPermissionInfo permInfo : permissionInfoList) {
                    authsToSet[i][0] = identity.getCMetadataType();
                    authsToSet[i][1] = identity.getName();
                    switch (permInfo.getPermissionType()) {
                        case DENY: {
                            authsToSet[i][2] = "D";
                            break;
                        }
                        case GRANT: {
                            authsToSet[i][2] = "G";
                            break;
                        }
                        case REMOVE: {
                            authsToSet[i][2] = "R";
                        }
                    }
                    authsToSet[i][3] = permInfo.getPermission();
                    authsToSet[i][4] = permInfo.getPermissionCondition();
                    ++i;
                }
                int flags = this.actDef ? 4 : 0;
                this.iSecAdmin.SetAuthorizationsOnObj(trnsCtxt, "", flags, authsToSet);
            }
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    @Override
    public void setAuthorizations(List<MdAuthorizationInfo> authorizations) throws IllegalArgumentException, MdException, RemoteException {
        try {
            if (authorizations == null) {
                throw new IllegalArgumentException("A valid MdAuthorizationInfo object reference is required");
            }
            this.localIdentityInfoMapCurrent = false;
            this.localAuthCacheCurrent = false;
            String trnsCtxt = this.getTransactionContext();
            int authCnt = 0;
            for (MdAuthorizationInfo authInfo : authorizations) {
                authCnt += authInfo.getPermissionInfoList().size();
            }
            if (authCnt > 0) {
                String[][] authsToSet = new String[authCnt][5];
                int i = 0;
                for (MdAuthorizationInfo authInfo : authorizations) {
                    List<MdPermissionInfo> permissions = authInfo.getPermissionInfoList();
                    for (MdPermissionInfo permInfo : permissions) {
                        authsToSet[i][0] = authInfo.getIdentityInfo().getIdentity().getCMetadataType();
                        authsToSet[i][1] = authInfo.getIdentityInfo().getIdentity().getName();
                        switch (permInfo.getPermissionType()) {
                            case DENY: {
                                authsToSet[i][2] = "D";
                                break;
                            }
                            case GRANT: {
                                authsToSet[i][2] = "G";
                                break;
                            }
                            case REMOVE: {
                                authsToSet[i][2] = "R";
                            }
                        }
                        authsToSet[i][3] = permInfo.getPermission();
                        authsToSet[i][4] = permInfo.getPermissionCondition();
                        ++i;
                    }
                }
                int flags = this.actDef ? 4 : 0;
                this.iSecAdmin.SetAuthorizationsOnObj(trnsCtxt, "", flags, authsToSet);
            }
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    @Override
    public List<AccessControlTemplate> getACTs() throws MdException, RemoteException {
        try {
            return this.getACTsUtil(true);
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    @Override
    public void applyACT(AccessControlTemplate act) throws IllegalArgumentException, MdException, RemoteException {
        if (act == null) {
            throw new IllegalArgumentException("A valid AccessControlTemplate object reference is required");
        }
        try {
            this.localIdentityInfoMapCurrent = false;
            this.localAuthCacheCurrent = false;
            this.localACTCacheCurrent = false;
            this.localACTAuthCacheCurrent = false;
            String trnsCtxt = this.getTransactionContext();
            String ACTresourceSpec = "OMSOBJ:" + act.getCMetadataType() + "/" + act.getId();
            this.iSecAdmin.ApplyACTToObj(trnsCtxt, "", 0, ACTresourceSpec);
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    @Override
    public void removeACT(AccessControlTemplate act) throws IllegalArgumentException, MdException, RemoteException {
        if (act == null) {
            throw new IllegalArgumentException("A valid AccessControlTemplate object reference is required");
        }
        try {
            this.localIdentityInfoMapCurrent = false;
            this.localAuthCacheCurrent = false;
            this.localACTCacheCurrent = false;
            this.localACTAuthCacheCurrent = false;
            String trnsCtxt = this.getTransactionContext();
            String ACTresourceSpec = "OMSOBJ:" + act.getCMetadataType() + "/" + act.getId();
            this.iSecAdmin.RemoveACTFromObj(trnsCtxt, "", 0, ACTresourceSpec);
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    @Override
    public void commit() throws RemoteException, MdException {
        this.termTransactionContext(true);
    }

    @Override
    public void discard() throws RemoteException, MdException {
        this.termTransactionContext(false);
    }

    @Override
    public void dispose() throws RemoteException {
        this.discardParentAuths();
        if (this.fact.isRemoteEnvironment()) {
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        this.targetObject = null;
        this.store = null;
        this.fact = null;
        this.iSecAdmin = null;
        this.iSecurity = null;
        this.conn = null;
        this.iSecTC = null;
        this.resourceSpec = "";
        this.localIdentityInfoMap = null;
        this.localAuthCache = null;
        this.memberships = null;
        this.localACTCache = null;
        this.localACTAuthCache = null;
        this.localInheritanceInfoCache = null;
        this.localInheritanceInfoAuthUtilImplMap = null;
        this.PUBLIC = null;
        this.SASUSERS = null;
    }

    private void discardParentAuths() {
        if (this.localInheritanceInfoAuthUtilImplMap != null && !this.localInheritanceInfoAuthUtilImplMap.isEmpty()) {
            Collection<MdAuthorizationUtilImpl> parentAuthUtilImplList = this.localInheritanceInfoAuthUtilImplMap.values();
            for (MdAuthorizationUtilImpl parentAuthUtilImpl : parentAuthUtilImplList) {
                try {
                    parentAuthUtilImpl.discard();
                    parentAuthUtilImpl.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.localInheritanceInfoAuthUtilImplMap = null;
        }
    }

    private void termTransactionContext(boolean commit) throws MdException, RemoteException {
        if (this.iSecTC == null) {
            if (this.targetObject.getCMetadataType().equalsIgnoreCase("AccessControlTemplate")) {
                AccessControlTemplate act = (AccessControlTemplate)this.targetObject;
                MdAuthorizationUtilImpl actAuthDefinition = (MdAuthorizationUtilImpl)act.getAuthorizationDefinitionUtil();
                if (actAuthDefinition.iSecTC != null) {
                    actAuthDefinition.termTransactionContext(commit);
                }
            }
        } else {
            try {
                if (this.resourceSpec.length() == 0) {
                    this.resourceSpec = "OMSOBJ:" + this.targetObject.getCMetadataType() + "/" + this.targetObject.getId();
                }
                int flags = commit ? 1 : 2;
                this.iSecAdmin.EndTransactionContext(this.iSecTC, this.resourceSpec, flags);
            }
            catch (RemoteException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MdException(e);
            }
            finally {
                this.iSecTC = null;
                this.iSecAdmin = null;
            }
        }
    }

    private String getTransactionContext() throws MdException, RemoteException {
        if (this.iSecTC == null) {
            this.localIdentityInfoMapCurrent = false;
            this.localAuthCacheCurrent = false;
            this.localACTCacheCurrent = false;
            this.localACTAuthCacheCurrent = false;
            this.localInheritanceInfoCacheCurrent = false;
            this.discardParentAuths();
            try {
                this.iSecAdmin = this.conn.MakeISecurityAdminConnection(this.conn.getCMRHandle());
                StringHolder iSecTCholder = new StringHolder();
                this.iSecAdmin.BeginTransactionContext(this.resourceSpec, 0, iSecTCholder);
                this.iSecurity = this.conn.MakeISecurityConnection();
                this.iSecTC = iSecTCholder.value;
                this.store.addObjToAuthorizationTransContextList(this.targetObject);
            }
            catch (MdException e) {
                throw e;
            }
            catch (RemoteException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MdException(e);
            }
        }
        return this.iSecTC;
    }

    private List<MdAuthorizationIdentityInfo> getIdentityInfoUtil() throws MdException, RemoteException {
        try {
            String trnsCtxt = this.getTransactionContext();
            if (!this.localIdentityInfoMapCurrent) {
                this.localIdentityInfoMap.clear();
                boolean isDirect = false;
                boolean isInherited = false;
                boolean isInUnrestricedRole = false;
                boolean isInUserAdminsRole = false;
                boolean isInOperatorsRole = false;
                VariableArray2dOfStringHolder reqIdentities = new VariableArray2dOfStringHolder();
                int flags = this.actDef ? 4 : 0;
                this.iSecAdmin.GetIdentitiesOnObj(trnsCtxt, "", 864 + flags, reqIdentities);
                if (reqIdentities.value.length > 0) {
                    MdAuthorizationIdentityInfo authIdentityInfo;
                    IdentityNameTypeEntry identityNameType;
                    String identitySelect = "<XMLSelect search=\"*[";
                    for (int i = 0; i < reqIdentities.value.length; ++i) {
                        String type = reqIdentities.value[i][0];
                        String name = reqIdentities.value[i][1];
                        String string = reqIdentities.value[i][3];
                        String userClass = reqIdentities.value[i][4];
                        if (string.length() == 1) {
                            isDirect = string.equalsIgnoreCase("D");
                            isInherited = string.equalsIgnoreCase("I");
                        } else if (string.length() == 2 && string.equalsIgnoreCase("DI")) {
                            isDirect = true;
                            isInherited = true;
                        } else {
                            throw new RemoteException("ISecurityAdmin.GetIdentitiesOnObj() returned invalid identityOrigin: " + string);
                        }
                        isInUnrestricedRole = userClass.contains("Unrestricted");
                        isInUserAdminsRole = userClass.contains("IdentityAdmin");
                        isInOperatorsRole = userClass.contains("Operator");
                        identityNameType = new IdentityNameTypeEntry(name, type);
                        authIdentityInfo = new MdAuthorizationIdentityInfoImpl(null, false, isDirect, isInherited, isInUnrestricedRole, isInUserAdminsRole, isInOperatorsRole);
                        this.localIdentityInfoMap.put(identityNameType.getNameType(), authIdentityInfo);
                        if (i > 0) {
                            identitySelect = identitySelect + " OR ";
                        }
                        identitySelect = identitySelect + "@Name='" + name + "'";
                    }
                    identitySelect = identitySelect + "]\"/>";
                    List identities = this.fact.getOMIUtil().getMetadataObjectsSubset(this.store, this.fact.getOMIUtil().getFoundationReposID(), "Identity", 8600, identitySelect);
                    for (CMetadata object : identities) {
                        Identity identity = (Identity)object;
                        String identityType = identity.getCMetadataType();
                        identityNameType = new IdentityNameTypeEntry(identity.getName(), identityType);
                        authIdentityInfo = this.localIdentityInfoMap.get(identityNameType.getNameType());
                        if (authIdentityInfo == null) continue;
                        ((MdAuthorizationIdentityInfoImpl)authIdentityInfo).identity = identity;
                        if (!identityType.equalsIgnoreCase("IdentityGroup")) continue;
                        if (identity.getName().equalsIgnoreCase("SASUSERS")) {
                            this.SASUSERS = (IdentityGroup)identity;
                            continue;
                        }
                        if (!identity.getName().equalsIgnoreCase("PUBLIC")) continue;
                        this.PUBLIC = (IdentityGroup)identity;
                    }
                    HashSet<Map.Entry<String, MdAuthorizationIdentityInfo>> identityCheckSet = new HashSet<Map.Entry<String, MdAuthorizationIdentityInfo>>(this.localIdentityInfoMap.entrySet());
                    for (Map.Entry entry : identityCheckSet) {
                        MdAuthorizationIdentityInfo identityInfoCheck = (MdAuthorizationIdentityInfo)entry.getValue();
                        if (identityInfoCheck.getIdentity() != null) continue;
                        this.localIdentityInfoMap.remove(entry.getKey());
                    }
                }
                this.localIdentityInfoMapCurrent = true;
            }
            Collection<MdAuthorizationIdentityInfo> mapValues = this.localIdentityInfoMap.values();
            ArrayList<MdAuthorizationIdentityInfo> returnIdentities = new ArrayList<MdAuthorizationIdentityInfo>(mapValues.size());
            for (MdAuthorizationIdentityInfo authIdentityInfo : mapValues) {
                returnIdentities.add(authIdentityInfo);
            }
            return returnIdentities;
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, MdAuthorizationInfo> getAuthorizationsUtil(List<Identity> identitiesIn, List<String> permissions, boolean expPermConds) throws MdException, RemoteException {
        try {
            String trnsCtxt = this.getTransactionContext();
            this.getIdentityInfoUtil();
            int flags = 0;
            if (this.actDef) {
                flags = 4;
            } else if (expPermConds) {
                flags = 128;
            }
            Map<Object, Object> identitySpecificAuthorizations = null;
            ArrayList<MdAuthorizationIdentityInfo> adhocIdentityInfoList = new ArrayList<MdAuthorizationIdentityInfo>(identitiesIn.size());
            if (!this.localAuthCacheCurrent) {
                String[][] allIdentities = new String[0][0];
                VariableArray2dOfAnyHolder authsFromServer = new VariableArray2dOfAnyHolder();
                String allPermissions = "";
                this.iSecAdmin.GetAuthorizationsOnObj(trnsCtxt, "", 96 + flags, allIdentities, allPermissions, authsFromServer);
                this.localAuthCache = this.buildAuthorizationInfoMap(authsFromServer);
                this.localAuthCacheCurrent = true;
            }
            ArrayList<MdAuthorizationIdentityInfo> cachedAuthIdentityInfoList = new ArrayList<MdAuthorizationIdentityInfo>();
            for (Identity identityIn : identitiesIn) {
                IdentityNameTypeEntry identityNameTypeEntry;
                MdAuthorizationIdentityInfo authIdentityInfo;
                String string;
                String identityType = identityIn.getCMetadataType();
                String identityName = identityIn.getName();
                if (identityType.equalsIgnoreCase("IdentityGroup") && (string = identityIn.getPublicType()).equalsIgnoreCase("Role")) {
                    identityType = "Role";
                }
                if ((authIdentityInfo = this.localIdentityInfoMap.get((identityNameTypeEntry = new IdentityNameTypeEntry(identityName, identityType)).getNameType())) == null) {
                    boolean isInUnrestricedRole = false;
                    boolean isInUserAdminsRole = false;
                    boolean isInOperatorsRole = false;
                    String url = "OMSOBJ:" + identityIn.getCMetadataType() + "/" + identityIn.getId();
                    String[][] sOptions = new String[][]{{"ReturnUnrestrictedSource", ""}};
                    VariableArray2dOfStringHolder returnInfo = new VariableArray2dOfStringHolder();
                    this.iSecurity.GetInfo("GetIdentityInfo", url, sOptions, returnInfo);
                    for (int j = 0; j < returnInfo.value.length; ++j) {
                        if (!returnInfo.value[j][0].equals("UserClass")) continue;
                        if (returnInfo.value[j][1].contains("Unrestricted")) {
                            for (int k = j + 1; k < returnInfo.value.length; ++k) {
                                if (!returnInfo.value[k][0].equals("UnrestrictedSource") || !returnInfo.value[k][1].contains("Role")) continue;
                                isInUnrestricedRole = true;
                            }
                        }
                        if (returnInfo.value[j][1].contains("IdentityAdmin")) {
                            isInUserAdminsRole = true;
                        }
                        if (!returnInfo.value[j][1].contains("Operator")) break;
                        isInOperatorsRole = true;
                        break;
                    }
                    authIdentityInfo = new MdAuthorizationIdentityInfoImpl(identityIn, true, false, false, isInUnrestricedRole, isInUserAdminsRole, isInOperatorsRole);
                    this.localIdentityInfoMap.put(identityNameTypeEntry.getNameType(), authIdentityInfo);
                }
                if (!this.localAuthCache.containsKey(authIdentityInfo.getIdentity().getId()) && !adhocIdentityInfoList.contains(authIdentityInfo)) {
                    adhocIdentityInfoList.add(authIdentityInfo);
                    continue;
                }
                cachedAuthIdentityInfoList.add(authIdentityInfo);
            }
            if (adhocIdentityInfoList.size() > 0) {
                String requestedPermissions = "";
                String[][] adhocIdentities = new String[adhocIdentityInfoList.size()][2];
                int ndx = 0;
                for (MdAuthorizationIdentityInfo mdAuthorizationIdentityInfo : adhocIdentityInfoList) {
                    adhocIdentities[ndx][0] = mdAuthorizationIdentityInfo.getIdentity().getCMetadataType();
                    adhocIdentities[ndx][1] = mdAuthorizationIdentityInfo.getIdentity().getName();
                    ++ndx;
                }
                if (permissions != null && permissions.size() > 0) {
                    requestedPermissions = permissions.get(0);
                    for (int i = 1; i < permissions.size(); ++i) {
                        requestedPermissions = requestedPermissions + "," + permissions.get(i);
                    }
                }
                VariableArray2dOfAnyHolder authsFromServer = new VariableArray2dOfAnyHolder();
                this.iSecAdmin.GetAuthorizationsOnObj(trnsCtxt, "", 96 + flags, adhocIdentities, requestedPermissions, authsFromServer);
                if (authsFromServer.value.length > 0) {
                    identitySpecificAuthorizations = this.buildAuthorizationInfoMap(authsFromServer);
                } else {
                    identitySpecificAuthorizations = new HashMap(adhocIdentityInfoList.size());
                    for (MdAuthorizationIdentityInfo adhocIdentityInfo : adhocIdentityInfoList) {
                        identitySpecificAuthorizations.put(adhocIdentityInfo.getIdentity().getId(), new MdAuthorizationInfoImpl(adhocIdentityInfo, new ArrayList<MdPermissionInfo>(0)));
                    }
                }
            } else if (cachedAuthIdentityInfoList.size() > 0 && identitySpecificAuthorizations == null) {
                identitySpecificAuthorizations = new HashMap(cachedAuthIdentityInfoList.size());
            }
            for (MdAuthorizationIdentityInfo cachedAuthIdentityInfo : cachedAuthIdentityInfoList) {
                void var13_30;
                MdAuthorizationInfo authInfo = this.localAuthCache.get(cachedAuthIdentityInfo.getIdentity().getId());
                if (authInfo == null) continue;
                MdAuthorizationInfoImpl returnAuthInfo = new MdAuthorizationInfoImpl();
                if (permissions != null && permissions.size() > 0) {
                    List<MdPermissionInfo> permInfoList = authInfo.getPermissionInfoList();
                    ArrayList<MdPermissionInfo> arrayList = new ArrayList<MdPermissionInfo>();
                    block11: for (String permissionName : permissions) {
                        for (MdPermissionInfo permInfo : permInfoList) {
                            String permInfoPermission = permInfo.getPermission();
                            if (!permInfoPermission.equals(permissionName)) continue;
                            arrayList.add(permInfo);
                            continue block11;
                        }
                    }
                } else {
                    ArrayList<MdPermissionInfo> arrayList = new ArrayList<MdPermissionInfo>(authInfo.getPermissionInfoList());
                }
                returnAuthInfo.setIdentityInfo(cachedAuthIdentityInfo);
                returnAuthInfo.setPermissionInfoList((List<MdPermissionInfo>)var13_30);
                identitySpecificAuthorizations.put(cachedAuthIdentityInfo.getIdentity().getId(), returnAuthInfo);
            }
            return identitySpecificAuthorizations != null ? identitySpecificAuthorizations : this.localAuthCache;
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    private List<MdAuthorizationExplainedInfo> getAuthorizationsExplainedUtil(List<Identity> identitiesIn, List<String> permissions, boolean doInheritance) throws MdException, RemoteException {
        try {
            Map<String, MdAuthorizationInfo> authorizations = this.getAuthorizationsUtil(identitiesIn, permissions, true);
            ArrayList<MdAuthorizationExplainedInfo> authorizationsExplained = new ArrayList<MdAuthorizationExplainedInfo>(authorizations.size());
            if (authorizations.size() == 0) {
                return authorizationsExplained;
            }
            if (!this.membershipsCurrent) {
                List<MdAuthorizationIdentityInfo> identities = this.getIdentityInfoUtil();
                this.memberships = new HashMap<String, List<List<String>>>(identities.size());
                Iterator iterator = identities.iterator();
                while (iterator.hasNext()) {
                    MdAuthorizationIdentityInfo identityInfo = (MdAuthorizationIdentityInfo)iterator.next();
                    Identity identity = identityInfo.getIdentity();
                    List<List<String>> memberShipsForIdentity = this.getMemberships(identity);
                    if (memberShipsForIdentity.isEmpty()) continue;
                    this.memberships.put(identity.getId(), memberShipsForIdentity);
                }
                this.membershipsCurrent = true;
            }
            for (Identity identity : identitiesIn) {
                List<List<String>> memberShipsForIdentity;
                if (this.memberships.containsKey(identity.getId()) || (memberShipsForIdentity = this.getMemberships(identity)).isEmpty()) continue;
                this.memberships.put(identity.getId(), memberShipsForIdentity);
            }
            if (doInheritance && !this.localInheritanceInfoCacheCurrent) {
                this.localInheritanceInfoCache = this.buildInheritanceInfo();
                this.localInheritanceInfoCacheCurrent = true;
            }
            Map<String, List<ActPermissionMapEntry>> actAuthorizations = this.getACTAuthorizations();
            Collection<MdAuthorizationInfo> mapValues = authorizations.values();
            for (MdAuthorizationInfo authInfo : mapValues) {
                List<MdPermissionInfo> permInfoList = authInfo.getPermissionInfoList();
                int permissionCnt = permissions.size() > 0 ? permissions.size() : permInfoList.size();
                ArrayList<MdPermissionExplainedInfo> permissionsExplained = new ArrayList<MdPermissionExplainedInfo>(permissionCnt);
                MdAuthorizationExplainedInfoImpl authExplInfo = new MdAuthorizationExplainedInfoImpl(authInfo.getIdentityInfo(), permissionsExplained);
                authorizationsExplained.add(authExplInfo);
                block7: for (MdPermissionInfo permInfo : permInfoList) {
                    MdPermissionInfoImpl permInfoImpl;
                    if (permissions.size() > 0 && !permissions.contains(permInfo.getPermission())) continue;
                    MdPermissionInfoImpl permInfoExplained = permInfoImpl = (MdPermissionInfoImpl)permInfo;
                    permissionsExplained.add(permInfoExplained);
                    MdPermissionInfo.PermissionSource permSource = permInfo.getPermissionSource();
                    if (permSource == MdPermissionInfo.PermissionSource.ACT) {
                        List<ActPermissionMapEntry> actPermMapEntryList = actAuthorizations.get(authInfo.getIdentityInfo().getIdentity().getId());
                        for (ActPermissionMapEntry actPermMapEntry : actPermMapEntryList) {
                            if (!permInfo.getPermission().equalsIgnoreCase(actPermMapEntry.actPerm)) continue;
                            permInfoImpl.setIndirectPermissionInfo(actPermMapEntry.actPermInfo);
                            continue block7;
                        }
                        continue;
                    }
                    if (permSource != MdPermissionInfo.PermissionSource.INDIRECT) continue;
                    int currentDepth = 1;
                    ArrayList<MdIndirectPermissionInfo> ndirPermInfoList = new ArrayList<MdIndirectPermissionInfo>();
                    permInfoImpl.setIndirectPermissionInfo(ndirPermInfoList);
                    List<List<String>> membershipsForIdentity = this.memberships.get(authInfo.getIdentityInfo().getIdentity().getId());
                    if (membershipsForIdentity != null) {
                        int memberDepth = 1;
                        for (List<String> membershipAtLevel : membershipsForIdentity) {
                            if (ndirPermInfoList.size() > 0 && memberDepth > currentDepth) break;
                            currentDepth = memberDepth;
                            for (String groupObjId : membershipAtLevel) {
                                List<MdPermissionInfo> groupPermInfoList = null;
                                if (authorizations.containsKey(groupObjId)) {
                                    groupPermInfoList = authorizations.get(groupObjId).getPermissionInfoList();
                                } else if (this.localAuthCache.containsKey(groupObjId)) {
                                    groupPermInfoList = this.localAuthCache.get(groupObjId).getPermissionInfoList();
                                }
                                if (groupPermInfoList != null) {
                                    for (MdPermissionInfo groupPerm : groupPermInfoList) {
                                        List<ActPermissionMapEntry> actPermMapEntryList;
                                        if (!groupPerm.getPermission().equals(permInfo.getPermission())) continue;
                                        MdIndirectPermissionInfoImpl ndirPermInfoImpl = new MdIndirectPermissionInfoImpl();
                                        MdPermissionInfo.PermissionSource grpPermSource = groupPerm.getPermissionSource();
                                        if (grpPermSource != MdPermissionInfo.PermissionSource.EXPLICIT && grpPermSource != MdPermissionInfo.PermissionSource.ACT) continue;
                                        ndirPermInfoImpl.setIndirectPermissionSource(MdIndirectPermissionInfo.IndirectPermissionSource.GRPMBRSHIP);
                                        ndirPermInfoImpl.setIndirectObject(this.store.getObject(groupObjId));
                                        if (grpPermSource == MdPermissionInfo.PermissionSource.ACT && (actPermMapEntryList = actAuthorizations.get(groupObjId)) != null) {
                                            List<MdIndirectPermissionInfo> ndirActPermInfoList = ndirPermInfoImpl.getIndirectPermissionInfo();
                                            if (ndirActPermInfoList.isEmpty()) {
                                                ndirActPermInfoList = new ArrayList<MdIndirectPermissionInfo>();
                                                ndirPermInfoImpl.setIndirectPermissionInfo(ndirActPermInfoList);
                                            }
                                            for (ActPermissionMapEntry actPermMapEntry : actPermMapEntryList) {
                                                if (!groupPerm.getPermission().equals(actPermMapEntry.actPerm)) continue;
                                                for (MdIndirectPermissionInfo actPermInfo : actPermMapEntry.actPermInfo) {
                                                    MdIndirectPermissionInfoImpl actPermInfoImpl = (MdIndirectPermissionInfoImpl)actPermInfo;
                                                    ndirActPermInfoList.add((MdIndirectPermissionInfo)actPermInfoImpl.clone());
                                                }
                                            }
                                        }
                                        MdIndirectPermissionInfo.IndirectPermissionType ndirPermType = groupPerm.getPermissionType() == MdPermissionInfo.PermissionType.GRANT ? MdIndirectPermissionInfo.IndirectPermissionType.GRANT : MdIndirectPermissionInfo.IndirectPermissionType.DENY;
                                        ndirPermInfoImpl.setIndirectPermissionType(ndirPermType);
                                        if (ndirPermType == MdIndirectPermissionInfo.IndirectPermissionType.GRANT) {
                                            String ndirPermCond = groupPerm.getPermissionCondition();
                                            ndirPermInfoImpl.setIndirectPermissionCondition(ndirPermCond);
                                        }
                                        int entryNdx = ndirPermType == MdIndirectPermissionInfo.IndirectPermissionType.DENY ? 0 : ndirPermInfoList.size();
                                        ndirPermInfoList.add(entryNdx, ndirPermInfoImpl);
                                    }
                                }
                                ++memberDepth;
                            }
                        }
                    }
                    String thisPermission = permInfo.getPermission();
                    if (!ndirPermInfoList.isEmpty() || !doInheritance || "WriteMemberMetadata".equalsIgnoreCase(thisPermission) || "ManageMemberMetadata".equalsIgnoreCase(thisPermission) || "ManageCredentialsMetadata".equalsIgnoreCase(thisPermission)) continue;
                    Identity identity = authInfo.getIdentityInfo().getIdentity();
                    this.getInheritedPermission(this.targetObject, identity, permInfo, ndirPermInfoList, this.localInheritanceInfoCache.getNextLevelParents());
                }
            }
            return authorizationsExplained;
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    private Map<String, MdAuthorizationInfo> buildAuthorizationInfoMap(VariableArray2dOfAnyHolder authsFromServer) throws MdException, RemoteException {
        HashMap<String, MdAuthorizationInfo> authorizations = null;
        try {
            authorizations = new HashMap<String, MdAuthorizationInfo>();
            ArrayList<MdPermissionInfo> permInfoList = new ArrayList<MdPermissionInfo>();
            for (int i = 0; i < authsFromServer.value.length; ++i) {
                MdPermissionInfo.PermissionSource permSource;
                MdPermissionInfo.PermissionType permType;
                String identityType;
                String identityName = authsFromServer.value[i][1].extract_string();
                IdentityNameTypeEntry identityNameType = new IdentityNameTypeEntry(identityName, identityType = authsFromServer.value[i][0].extract_string());
                MdAuthorizationIdentityInfo authIdentitInfo = this.localIdentityInfoMap.get(identityNameType.getNameType());
                if (authIdentitInfo == null) continue;
                int iAuth = authsFromServer.value[i][2].extract_long();
                if ((iAuth & 3) > 0) {
                    permType = (iAuth & 2) > 0 ? MdPermissionInfo.PermissionType.GRANT : MdPermissionInfo.PermissionType.DENY;
                    permSource = MdPermissionInfo.PermissionSource.EXPLICIT;
                } else if ((iAuth & 0xC) > 0) {
                    permType = (iAuth & 8) > 0 ? MdPermissionInfo.PermissionType.GRANT : MdPermissionInfo.PermissionType.DENY;
                    permSource = MdPermissionInfo.PermissionSource.ACT;
                } else {
                    permType = (iAuth & 0x20) > 0 ? MdPermissionInfo.PermissionType.GRANT : MdPermissionInfo.PermissionType.DENY;
                    permSource = MdPermissionInfo.PermissionSource.INDIRECT;
                }
                String permission = authsFromServer.value[i][3].extract_string();
                String permissionCondition = authsFromServer.value[i][4].extract_string();
                if (permissionCondition.length() > 0 && (iAuth & 0x20) > 0 && permType == MdPermissionInfo.PermissionType.GRANT && permSource == MdPermissionInfo.PermissionSource.EXPLICIT) {
                    String[][] specIdentity = new String[1][2];
                    specIdentity[0][0] = identityType;
                    specIdentity[0][1] = identityName;
                    VariableArray2dOfAnyHolder authForSpecIdentity = new VariableArray2dOfAnyHolder();
                    this.iSecAdmin.GetAuthorizationsOnObj(this.getTransactionContext(), "", 0, specIdentity, permission, authForSpecIdentity);
                    permissionCondition = authForSpecIdentity.value[0][4].extract_string();
                }
                MdPermissionInfoImpl permInfoImpl = new MdPermissionInfoImpl(permType, permission);
                permInfoImpl.setPermissionCondition(permissionCondition);
                permInfoImpl.setPermissionSource(permSource);
                permInfoList.add(permInfoImpl);
                if (!authorizations.containsKey(authIdentitInfo.getIdentity().getId())) {
                    MdAuthorizationInfoImpl authInfo = new MdAuthorizationInfoImpl(authIdentitInfo, permInfoList);
                    authorizations.put(authIdentitInfo.getIdentity().getId(), authInfo);
                }
                if (i + 1 >= authsFromServer.value.length) continue;
                String nextRowIdentityName = authsFromServer.value[i + 1][1].extract_string();
                String nextRowIdentityType = authsFromServer.value[i + 1][0].extract_string();
                if (nextRowIdentityName.equalsIgnoreCase(identityName) && nextRowIdentityType.equalsIgnoreCase(identityType)) continue;
                permInfoList = new ArrayList();
            }
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return authorizations;
    }

    private List<AccessControlTemplate> getACTsUtil(boolean copyACTs) throws MdException, RemoteException {
        try {
            if (!this.localACTCacheCurrent) {
                String trnsCtxt = this.getTransactionContext();
                VariableArray2dOfStringHolder ACTs = new VariableArray2dOfStringHolder();
                this.iSecAdmin.GetACTsOnObj(trnsCtxt, "", 0, ACTs);
                this.localACTCache = new ArrayList<AccessControlTemplate>(ACTs.value.length);
                for (int i = 0; i < ACTs.value.length; ++i) {
                    String objId = ACTs.value[i][0];
                    String name = ACTs.value[i][1];
                    String desc = ACTs.value[i][2];
                    AccessControlTemplate act = (AccessControlTemplate)this.fact.createComplexMetadataObject(this.store, null, name, "AccessControlTemplate", objId);
                    act.setDesc(desc, 2);
                    this.localACTCache.add(act);
                }
                this.localACTCacheCurrent = true;
            }
            List<AccessControlTemplate> returnACTs = copyACTs ? new ArrayList<AccessControlTemplate>(this.localACTCache) : this.localACTCache;
            return returnACTs;
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    private Map<String, List<ActPermissionMapEntry>> getACTAuthorizations() throws MdException, RemoteException {
        if (this.actDef) {
            return Collections.emptyMap();
        }
        try {
            if (!this.localACTAuthCacheCurrent) {
                this.localACTAuthCache = new HashMap<String, List<ActPermissionMapEntry>>();
                List<AccessControlTemplate> actList = this.getACTsUtil(false);
                for (AccessControlTemplate act : actList) {
                    String actResourceSpec = "OMSOBJ:AccessControlTemplate/" + act.getId();
                    String[][] identities = new String[0][0];
                    VariableArray2dOfAnyHolder actAuthsFromServer = new VariableArray2dOfAnyHolder();
                    this.iSecAdmin.GetAuthorizationsOnObj("", actResourceSpec, 100, identities, "", actAuthsFromServer);
                    this.buildActAutorizationInfoMap(this.localACTAuthCache, actAuthsFromServer, act);
                }
                this.localACTAuthCacheCurrent = true;
            }
            return this.localACTAuthCache;
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    private void buildActAutorizationInfoMap(Map<String, List<ActPermissionMapEntry>> actAuthorizations, VariableArray2dOfAnyHolder authsFromServer, AccessControlTemplate act) throws RemoteException, MdException {
        try {
            for (int i = 0; i < authsFromServer.value.length; ++i) {
                int iAuth = authsFromServer.value[i][2].extract_long();
                if ((iAuth & 3) <= 0) continue;
                MdIndirectPermissionInfo.IndirectPermissionType ndirPermType = (iAuth & 2) > 0 ? MdIndirectPermissionInfo.IndirectPermissionType.GRANT : MdIndirectPermissionInfo.IndirectPermissionType.DENY;
                String permission = authsFromServer.value[i][3].extract_string();
                IdentityNameTypeEntry identityNameType = new IdentityNameTypeEntry(authsFromServer.value[i][1].extract_string(), authsFromServer.value[i][0].extract_string());
                MdAuthorizationIdentityInfo authIdentityInfo = this.localIdentityInfoMap.get(identityNameType.getNameType());
                List<ActPermissionMapEntry> actPermMapEntryList = actAuthorizations.get(authIdentityInfo.getIdentity().getId());
                if (actPermMapEntryList == null) {
                    actPermMapEntryList = new ArrayList<ActPermissionMapEntry>();
                    actAuthorizations.put(authIdentityInfo.getIdentity().getId(), actPermMapEntryList);
                }
                MdIndirectPermissionInfoImpl ndirActPermInfo = new MdIndirectPermissionInfoImpl();
                ndirActPermInfo.setIndirectObject(act);
                ndirActPermInfo.setIndirectPermissionSource(MdIndirectPermissionInfo.IndirectPermissionSource.ACTSPECIFICATION);
                ndirActPermInfo.setIndirectPermissionType(ndirPermType);
                ActPermissionMapEntry actPermMapEntry = null;
                for (ActPermissionMapEntry actPermMapEntryLoc : actPermMapEntryList) {
                    if (!permission.equalsIgnoreCase(actPermMapEntryLoc.actPerm)) continue;
                    actPermMapEntry = actPermMapEntryLoc;
                    break;
                }
                if (actPermMapEntry == null) {
                    actPermMapEntry = new ActPermissionMapEntry();
                    actPermMapEntry.actPerm = permission;
                    actPermMapEntry.actPermInfo = new ArrayList<MdIndirectPermissionInfo>();
                    actPermMapEntryList.add(actPermMapEntry);
                }
                int entryNdx = ndirPermType == MdIndirectPermissionInfo.IndirectPermissionType.DENY ? 0 : actPermMapEntry.actPermInfo.size();
                actPermMapEntry.actPermInfo.add(entryNdx, ndirActPermInfo);
            }
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    private List<List<String>> getMemberships(Identity identity) throws Exception {
        ArrayList<List<String>> memberships = new ArrayList<List<String>>();
        if (identity == null) {
            return memberships;
        }
        try {
            if (this.PUBLIC != null && !identity.getId().equalsIgnoreCase(this.PUBLIC.getId())) {
                if (this.SASUSERS != null && !identity.getId().equalsIgnoreCase(this.SASUSERS.getId())) {
                    List<IdentityGroup> firstLevelGroupList = this.getFirstLevelParentGroups(identity);
                    this.buildMemberships(memberships, firstLevelGroupList, 1);
                    ArrayList<String> SASUSERSgrpLvl = new ArrayList<String>(1);
                    SASUSERSgrpLvl.add(this.SASUSERS.getId());
                    memberships.add(memberships.size(), SASUSERSgrpLvl);
                }
                ArrayList<String> PUBLICgrpLvl = new ArrayList<String>(1);
                PUBLICgrpLvl.add(this.PUBLIC.getId());
                memberships.add(memberships.size(), PUBLICgrpLvl);
            }
            return memberships;
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    private void buildMemberships(List<List<String>> membershipAtLevel, List<IdentityGroup> groupList, int level) throws RemoteException, MdException {
        try {
            List<Object> groupsAtLevel;
            if (groupList.size() == 0) {
                return;
            }
            for (List<String> groupsAtLevel2 : membershipAtLevel) {
                for (String groupSpec : groupsAtLevel2) {
                    for (int i = groupList.size() - 1; i >= 0; --i) {
                        IdentityGroup member = groupList.get(i);
                        if (!member.getId().equals(groupSpec)) continue;
                        groupList.remove(member);
                    }
                }
            }
            if (level > membershipAtLevel.size()) {
                groupsAtLevel = new ArrayList(groupList.size());
                membershipAtLevel.add(groupsAtLevel);
            } else {
                groupsAtLevel = membershipAtLevel.get(level - 1);
            }
            for (IdentityGroup member : groupList) {
                groupsAtLevel.add(member.getId());
                AssociationList groupsNextLevel = member.getIdentityGroups();
                this.buildMemberships(membershipAtLevel, new ArrayList<IdentityGroup>(groupsNextLevel), level + 1);
            }
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    private List<IdentityGroup> getFirstLevelParentGroups(Identity identity) throws RemoteException, MdException {
        try {
            String strTemplate = "<TEMPLATES><Identity><IdentityGroups/></Identity></TEMPLATES>";
            int flags = 260;
            identity = (Identity)this.store.getFactory().getOMIUtil().getMetadataAllDepths(this.store, identity.getCMetadataType(), identity.getFQID(), null, null, strTemplate, flags);
            return identity.getIdentityGroups();
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    private MdInheritanceInfo buildInheritanceInfo() throws MdException {
        MdInheritanceInfoImpl returnInheritanceInfo = null;
        try {
            VariableArray2dOfStringHolder authsFromServer = new VariableArray2dOfStringHolder();
            if (this.iSecurity == null) {
                this.iSecurity = this.conn.MakeISecurityConnection();
            }
            this.iSecurity.GetAuthorizations("getInheritanceInfo", "", this.resourceSpec, "", authsFromServer);
            HashMap<String, MdInheritanceInfoImpl> objInheritanceInfo = new HashMap<String, MdInheritanceInfoImpl>(authsFromServer.value.length);
            block7: for (int i = 0; i < authsFromServer.value.length; ++i) {
                int recordType = Integer.valueOf(authsFromServer.value[i][0]);
                String childObjId = authsFromServer.value[i][1];
                String inheritanceRole = authsFromServer.value[i][2];
                switch (recordType) {
                    case 0: 
                    case 1: {
                        String objId = authsFromServer.value[i][3];
                        CMetadata obj = this.store.getObject(authsFromServer.value[i][2], false);
                        if (obj == null) {
                            String objName = authsFromServer.value[i][4];
                            String objType = authsFromServer.value[i][5];
                            obj = this.fact.createComplexMetadataObject(this.store, null, objName, objType, objId);
                        }
                        boolean directPerms = authsFromServer.value[i][6].equals("Y");
                        MdInheritanceInfoImpl inheritanceInfo = new MdInheritanceInfoImpl(false, obj, directPerms, inheritanceRole);
                        objInheritanceInfo.put(objId, inheritanceInfo);
                        if (recordType == 0) {
                            returnInheritanceInfo = inheritanceInfo;
                            continue block7;
                        }
                        MdInheritanceInfoImpl childInheritanceInfoImpl = (MdInheritanceInfoImpl)objInheritanceInfo.get(childObjId);
                        childInheritanceInfoImpl.nextLevelObjList.add(inheritanceInfo);
                        continue block7;
                    }
                    case 2: {
                        String hiddenObjId = authsFromServer.value[i][3];
                        boolean directPerms = authsFromServer.value[i][6].equals("Y");
                        MdInheritanceInfoImpl inheritanceInfo = new MdInheritanceInfoImpl(true, null, directPerms, inheritanceRole);
                        objInheritanceInfo.put(hiddenObjId, inheritanceInfo);
                        MdInheritanceInfoImpl childInheritanceInfoImpl = (MdInheritanceInfoImpl)objInheritanceInfo.get(childObjId);
                        childInheritanceInfoImpl.nextLevelObjList.add(inheritanceInfo);
                        continue block7;
                    }
                    case 3: {
                        MdInheritanceInfoImpl childInheritanceInfoImpl = (MdInheritanceInfoImpl)objInheritanceInfo.get(childObjId);
                        childInheritanceInfoImpl.inheritanceRules.add(inheritanceRole);
                        continue block7;
                    }
                }
            }
            if (returnInheritanceInfo == null) {
                returnInheritanceInfo = new MdInheritanceInfoImpl(false, null, false, "");
            }
            return returnInheritanceInfo;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    private void getInheritedPermission(CMetadata object, Identity identity, MdPermissionInfo permInfo, List<MdIndirectPermissionInfo> ndirPermInfoList, List<MdInheritanceInfo> inheritanceInfoList) throws Exception {
        MdIndirectPermissionInfo.IndirectPermissionType ndirPermTyp;
        String permission = permInfo.getPermission();
        if ("WriteMemberMetadata".equalsIgnoreCase(permission)) {
            permission = "WriteMetadata";
        }
        MdIndirectPermissionInfo.IndirectPermissionType indirectPermissionType = ndirPermTyp = permInfo.getPermissionType().equals((Object)MdPermissionInfo.PermissionType.GRANT) ? MdIndirectPermissionInfo.IndirectPermissionType.GRANT : MdIndirectPermissionInfo.IndirectPermissionType.DENY;
        if (inheritanceInfoList.isEmpty()) {
            MdPermissionExplainedInfo actPermExplInfo;
            AccessControlTemplate dfltACT = this.getDefaultACTForRepository(object.getRepositoryID());
            if (dfltACT != null && (actPermExplInfo = this.getDefaultACTPermissionExplained(dfltACT, identity, permission)) != null && permInfo.getPermissionType() == actPermExplInfo.getPermissionType()) {
                boolean defaultACTAlreadyOnList = false;
                for (MdIndirectPermissionInfo checkDupNdirPermInfo : ndirPermInfoList) {
                    if (!checkDupNdirPermInfo.getIndirectObject().getId().equals(dfltACT.getId())) continue;
                    defaultACTAlreadyOnList = true;
                    break;
                }
                if (!defaultACTAlreadyOnList) {
                    ndirPermInfoList.add(new MdIndirectPermissionInfoImpl(dfltACT, ndirPermTyp, MdIndirectPermissionInfo.IndirectPermissionSource.REPOSITORY_DEFAULT_ACT, actPermExplInfo.getPermissionCondition(), actPermExplInfo.getIndirectPermissionInfo()));
                }
            }
            return;
        }
        for (MdInheritanceInfo inheritanceInfo : inheritanceInfoList) {
            CMetadata InheritanceObject = inheritanceInfo.getObject();
            if (InheritanceObject == null) {
                ndirPermInfoList.add(new MdIndirectPermissionInfoImpl(null, ndirPermTyp, MdIndirectPermissionInfo.IndirectPermissionSource.HIDDEN_PARENT, "", null));
                continue;
            }
            MdAuthorizationUtilImpl authUtilImpl = this.getInheritanceAuthUtilImpl(InheritanceObject, false);
            ArrayList<Identity> idSpec = new ArrayList<Identity>(1);
            idSpec.add(identity);
            ArrayList<String> permSpec = new ArrayList<String>(1);
            permSpec.add(permission);
            List<MdAuthorizationExplainedInfo> authExplainedInfoioList = authUtilImpl.getAuthorizationsExplainedUtil(idSpec, permSpec, false);
            MdAuthorizationExplainedInfo authExplInfo = authExplainedInfoioList.get(0);
            if (authExplInfo.getPermissionExplainedInfoList().isEmpty()) continue;
            MdPermissionExplainedInfo permExplInfo = authExplInfo.getPermissionExplainedInfoList().get(0);
            if (permInfo.getPermissionType() != permExplInfo.getPermissionType()) continue;
            MdIndirectPermissionInfo.IndirectPermissionSource ndirPermSrc = null;
            block0 : switch (permExplInfo.getPermissionSource()) {
                case EXPLICIT: {
                    ndirPermSrc = MdIndirectPermissionInfo.IndirectPermissionSource.EXPLICT_ON_PARENT;
                    break;
                }
                case ACT: {
                    ndirPermSrc = MdIndirectPermissionInfo.IndirectPermissionSource.ACT_ON_PARENT;
                    break;
                }
                case INDIRECT: {
                    for (MdIndirectPermissionInfo parentNdirPermInfo : permExplInfo.getIndirectPermissionInfo()) {
                        if (parentNdirPermInfo.getIndirectPermissionSource() != MdIndirectPermissionInfo.IndirectPermissionSource.GRPMBRSHIP) continue;
                        ndirPermSrc = MdIndirectPermissionInfo.IndirectPermissionSource.GROUP_ON_PARENT;
                        break block0;
                    }
                    break;
                }
            }
            if (ndirPermSrc == null) {
                this.getInheritedPermission(object, identity, permInfo, ndirPermInfoList, inheritanceInfo.getNextLevelParents());
                continue;
            }
            if (ndirPermTyp == MdIndirectPermissionInfo.IndirectPermissionType.GRANT) {
                for (int i = ndirPermInfoList.size() - 1; i >= 0; --i) {
                    MdIndirectPermissionInfo tmpNdirPermInfo = ndirPermInfoList.get(i);
                    if (tmpNdirPermInfo.getIndirectPermissionType() != MdIndirectPermissionInfo.IndirectPermissionType.DENY) continue;
                    ndirPermInfoList.remove(i);
                }
            }
            boolean parentAlreadyOnList = false;
            for (MdIndirectPermissionInfo checkDupNdirPermInfo : ndirPermInfoList) {
                if (!checkDupNdirPermInfo.getIndirectObject().getId().equals(InheritanceObject.getId())) continue;
                parentAlreadyOnList = true;
                break;
            }
            if (parentAlreadyOnList) continue;
            ndirPermInfoList.add(new MdIndirectPermissionInfoImpl(InheritanceObject, ndirPermTyp, ndirPermSrc, permExplInfo.getPermissionCondition(), permExplInfo.getIndirectPermissionInfo()));
        }
    }

    private MdPermissionExplainedInfo getDefaultACTPermissionExplained(AccessControlTemplate DefaultACT, Identity identity, String permission) throws Exception {
        MdAuthorizationUtilImpl authUtilImpl = this.getInheritanceAuthUtilImpl(DefaultACT, true);
        ArrayList<Identity> idSpec = new ArrayList<Identity>(1);
        idSpec.add(identity);
        ArrayList<String> permSpec = new ArrayList<String>(1);
        permSpec.add(permission);
        List<MdAuthorizationExplainedInfo> actPermExplList = authUtilImpl.getAuthorizationsExplainedUtil(idSpec, permSpec, false);
        if (!actPermExplList.isEmpty() && !actPermExplList.get(0).getPermissionExplainedInfoList().isEmpty()) {
            return actPermExplList.get(0).getPermissionExplainedInfoList().get(0);
        }
        return null;
    }

    private AccessControlTemplate getDefaultACTForRepository(String reposId) throws Exception {
        String sOptions = "<XMLSELECT Search=\"@Use='REPOS'\"/>";
        List rslt = this.fact.getOMIUtil().getMetadataObjectsSubset(this.store, this.fact.getOMIUtil().getFoundationReposID(), "AccessControlTemplate", 392, sOptions);
        if (!rslt.isEmpty()) {
            return (AccessControlTemplate)rslt.get(0);
        }
        return null;
    }

    private MdAuthorizationUtilImpl getInheritanceAuthUtilImpl(CMetadata obj, boolean actDef) throws Exception {
        MdAuthorizationUtilImpl authUtilImpl;
        if (this.localInheritanceInfoAuthUtilImplMap == null) {
            this.localInheritanceInfoAuthUtilImplMap = new HashMap<String, MdAuthorizationUtilImpl>(0);
        }
        if ((authUtilImpl = this.localInheritanceInfoAuthUtilImplMap.get(obj.getId())) == null) {
            authUtilImpl = new MdAuthorizationUtilImpl(obj, actDef);
            this.localInheritanceInfoAuthUtilImplMap.put(obj.getId(), authUtilImpl);
        }
        return authUtilImpl;
    }
}

