/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AbstractPool;
import java.util.HashMap;
import java.util.Map;

@SASScope
public class MapPool
extends AbstractPool {
    public static final int MAX_SIZE = 50;
    private static MapPool _instance = new MapPool();
    private int _entriesCleared = 0;

    private MapPool() {
        super("MapPool");
        this.setMaxSize(50);
    }

    public static MapPool instance() {
        return _instance;
    }

    public static HashMap getMap() {
        return (HashMap)MapPool.instance().getObj();
    }

    public static void returnMap(Map map) {
        MapPool.instance().returnObj(map);
    }

    @Override
    protected void sanitize(Object obj) {
        Map m = (Map)obj;
        this._entriesCleared += m.size();
        m.clear();
    }

    @Override
    protected Object createNewObj() {
        return new HashMap(7);
    }

    @Override
    protected boolean isClassAcceptable(Object obj) {
        return obj != null && obj.getClass() == HashMap.class;
    }

    public void dispose() {
    }

    public void setMaxPoolSize(int size) {
    }

    @Override
    public String toString() {
        return super.toString() + ",\n\t Map entries cleared(" + this._entriesCleared + ").";
    }
}

