/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.jobexecution.client.impl;

import com.sas.svcs.jobexecution.client.JobExecutionType;
import com.sas.svcs.jobexecution.client.JobInterface;
import com.sas.svcs.jobexecution.client.JobPriorityType;
import com.sas.svcs.jobexecution.client.TaskInterface;
import com.sas.svcs.jobexecution.client.TaskType;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Job
implements JobInterface,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private String _name;
    private String _desc;
    private JobExecutionType _jobType = JobExecutionType.IMMEDIATE;
    private JobPriorityType _jobPriorityType = JobPriorityType.NORMAL;
    private final Set<String> _keywords = new HashSet<String>(5);
    private final List<TaskInterface> _tasks = new ArrayList<TaskInterface>(5);
    private boolean _reusingConnections = true;
    private long _maxQueuedTime;
    private long _maxQueuedTimeForTasks;
    private long _maxExecutionTime;
    private long _maxExecutionTimeForTasks;
    private int _numHistoryRecordsForScheduledTasks;
    private String _connectionKey;

    public Job() {
    }

    public Job(String name) {
        this.setName(name);
    }

    public Job(String name, String desc) {
        this.setName(name);
        this.setDescription(desc);
    }

    @Override
    public String getDescription() {
        return this._desc;
    }

    @Override
    public final void setDescription(String description) {
        this._desc = description;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public final void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("A job name must be specified.");
        }
        this._name = name;
    }

    @Override
    public Set<String> getKeywords() {
        HashSet<String> keywords = new HashSet<String>(this._keywords.size());
        keywords.addAll(this._keywords);
        return keywords;
    }

    @Override
    public void setKeywords(Set<String> keywords) {
        this._keywords.clear();
        this._keywords.addAll(keywords);
    }

    @Override
    public void addKeyword(String keyword) {
        this._keywords.add(keyword);
    }

    @Override
    public void removeKeyword(String keyword) {
        this._keywords.remove(keyword);
    }

    @Override
    public JobExecutionType getExecutionType() {
        return this._jobType;
    }

    @Override
    public void setExecutionType(JobExecutionType jobType) {
        if (jobType == null) {
            throw new IllegalArgumentException("A non-null JobType must be specified.");
        }
        this._jobType = jobType;
    }

    @Override
    public JobPriorityType getPriorityType() {
        return this._jobPriorityType;
    }

    @Override
    public void setPriorityType(JobPriorityType jobPriorityType) {
        if (jobPriorityType == null) {
            throw new IllegalArgumentException("A non-null JobPriorityType must be specified.");
        }
        this._jobPriorityType = jobPriorityType;
    }

    @Override
    public boolean isReusingConnections() {
        return this._reusingConnections;
    }

    @Override
    public void setReusingConnections(boolean reuse) {
        this._reusingConnections = reuse;
    }

    @Override
    public long getMaxQueuedTime() {
        return this._maxQueuedTime;
    }

    @Override
    public void setMaxQueuedTime(long maxQueuedTime) {
        if (maxQueuedTime < 0L) {
            throw new IllegalArgumentException("Invalid time duration was specified.");
        }
        this._maxQueuedTime = maxQueuedTime;
    }

    @Override
    public long getMaxExecutionTime() {
        return this._maxExecutionTime;
    }

    @Override
    public void setMaxExecutionTime(long maxExecutionTime) {
        if (maxExecutionTime < 0L) {
            throw new IllegalArgumentException("Invalid time duration was specified.");
        }
        this._maxExecutionTime = maxExecutionTime;
    }

    @Override
    public long getMaxQueuedTimeForTasks() {
        return this._maxQueuedTimeForTasks;
    }

    @Override
    public void setMaxQueuedTimeForTasks(long maxQueuedTimeForTasks) {
        if (maxQueuedTimeForTasks < 0L) {
            throw new IllegalArgumentException("Invalid max queued time was specified.");
        }
        this._maxQueuedTimeForTasks = maxQueuedTimeForTasks;
    }

    @Override
    public long getMaxExecutionTimeForTasks() {
        return this._maxExecutionTimeForTasks;
    }

    @Override
    public void setMaxExecutionTimeForTasks(long maxExecutionTimeForTasks) {
        if (maxExecutionTimeForTasks < 0L) {
            throw new IllegalArgumentException("Invalid time duration was specified.");
        }
        this._maxExecutionTimeForTasks = maxExecutionTimeForTasks;
    }

    @Override
    public int getNumHistoryRecordsForScheduledTasks() {
        return this._numHistoryRecordsForScheduledTasks;
    }

    @Override
    public void setNumHistoryRecordsForScheduledTasks(int numHistoryRecordsForScheduledTasks) {
        this._numHistoryRecordsForScheduledTasks = numHistoryRecordsForScheduledTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addTask(TaskInterface task) {
        this.validateTaskName(task.getName());
        List<TaskInterface> list = this._tasks;
        synchronized (list) {
            this._tasks.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTask(TaskInterface task, int index) {
        this.validateTaskName(task.getName());
        List<TaskInterface> list = this._tasks;
        synchronized (list) {
            this._tasks.add(index, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTask(TaskInterface task) {
        boolean wasRemoved = false;
        List<TaskInterface> list = this._tasks;
        synchronized (list) {
            wasRemoved = this._tasks.remove(task);
        }
        return wasRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskInterface> getTasks() {
        ArrayList<TaskInterface> tasks = null;
        List<TaskInterface> list = this._tasks;
        synchronized (list) {
            tasks = new ArrayList<TaskInterface>(this._tasks);
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskInterface getTask(String taskName) {
        if (taskName == null) {
            throw new IllegalArgumentException("A task name must be specified.");
        }
        TaskInterface matchingTask = null;
        ArrayList<TaskInterface> tasks = null;
        List<TaskInterface> list = this._tasks;
        synchronized (list) {
            tasks = new ArrayList<TaskInterface>(this._tasks);
        }
        for (TaskInterface task : tasks) {
            if (!task.getName().equals(taskName)) continue;
            matchingTask = task;
            break;
        }
        return matchingTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskInterface> getTasks(TaskType taskType) {
        if (taskType == null) {
            throw new IllegalArgumentException("A task type must be specified.");
        }
        ArrayList<TaskInterface> tasks = null;
        List<TaskInterface> list = this._tasks;
        synchronized (list) {
            tasks = new ArrayList<TaskInterface>(this._tasks);
        }
        ArrayList<TaskInterface> matchingTasks = new ArrayList<TaskInterface>(tasks.size());
        for (TaskInterface task : tasks) {
            if (!task.getType().equals((Object)taskType)) continue;
            matchingTasks.add(task);
        }
        return matchingTasks;
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object != null) {
            if (object == this) {
                isEqual = true;
            } else {
                try {
                    Job other = (Job)object;
                    isEqual = Strings.equal((String)this._name, (String)other.getName(), (boolean)false, (boolean)false) && Strings.equal((String)this._desc, (String)other.getDescription(), (boolean)false, (boolean)false) && this._jobType.equals((Object)other.getExecutionType()) && this._jobPriorityType.equals((Object)other.getPriorityType()) && this._reusingConnections == other.isReusingConnections() && this._keywords.equals(other.getKeywords()) && this._maxQueuedTime == other.getMaxQueuedTime() && this._maxExecutionTime == other.getMaxExecutionTime() && this._maxQueuedTimeForTasks == other.getMaxQueuedTimeForTasks() && this._maxExecutionTimeForTasks == other.getMaxExecutionTimeForTasks() && this._numHistoryRecordsForScheduledTasks == other.getNumHistoryRecordsForScheduledTasks() && this._tasks.equals(other._tasks);
                }
                catch (ClassCastException e) {
                    isEqual = false;
                }
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int primeNumber = 17;
        int hashCode = 17;
        if (this._name != null) {
            hashCode ^= this._name.hashCode();
        }
        if (this._desc != null) {
            hashCode ^= this._desc.hashCode();
        }
        hashCode ^= this._jobType.hashCode();
        hashCode ^= this._jobPriorityType.hashCode();
        hashCode ^= Boolean.valueOf(this._reusingConnections).hashCode();
        hashCode ^= this._keywords.hashCode();
        hashCode ^= Long.valueOf(this._maxQueuedTime).hashCode();
        hashCode ^= Long.valueOf(this._maxExecutionTime).hashCode();
        hashCode ^= Long.valueOf(this._maxQueuedTimeForTasks).hashCode();
        hashCode ^= Long.valueOf(this._maxExecutionTimeForTasks).hashCode();
        hashCode ^= Integer.valueOf(this._numHistoryRecordsForScheduledTasks).hashCode();
        return hashCode ^= this._tasks.hashCode();
    }

    @Override
    public void setTasks(List<TaskInterface> taskList) {
        this._tasks.clear();
        this._tasks.addAll(taskList);
    }

    @Override
    public String getConnectionKey() {
        return this._connectionKey;
    }

    @Override
    public void setConnectionKey(String connectionKey) {
        this._connectionKey = connectionKey;
    }

    private void validateTaskName(String taskName) {
        if (null == taskName || "".equals(taskName)) {
            throw new IllegalArgumentException("A non-null and non-empty task name must be specified when adding a task to job \"" + this.getName() + "\".");
        }
        if (null != this.getTask(taskName)) {
            throw new IllegalArgumentException("Unable to add task \"" + taskName + "\" since a task by that name has already been added to job \"" + this.getName() + "\".");
        }
    }
}

