/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.jobexecution.client;

public enum LogicalServerEnum {
    WORKSPACE("workspace", 1),
    STORED_PROCESS("storedprocess", 2),
    POOLED_WORKSPACE("pooledworkspace", 3);

    private final String _name;
    private final int _type;

    private LogicalServerEnum(String name, int type) {
        this._name = name;
        this._type = type;
    }

    public String getName() {
        return this._name;
    }

    public int getType() {
        return this._type;
    }

    public static LogicalServerEnum fromName(String name) {
        LogicalServerEnum value = null;
        for (LogicalServerEnum aState : LogicalServerEnum.values()) {
            if (!aState._name.equals(name)) continue;
            value = aState;
        }
        if (null == value) {
            throw new IllegalArgumentException("A logical server enum is not defined for '" + name + "'. Specify a value of workspace, storedprocess or pooledworkspace");
        }
        return value;
    }

    public static LogicalServerEnum fromType(int type) {
        LogicalServerEnum value = null;
        for (LogicalServerEnum aState : LogicalServerEnum.values()) {
            if (aState._type != type) continue;
            value = aState;
            break;
        }
        if (null == value) {
            throw new IllegalArgumentException("A logical server enum is not defined for '" + type + "'. Specify a value of 1 (workspace), 2 (storedprocess) or 3 (pooledworkspace).");
        }
        return value;
    }
}

